<?php
set_time_limit(0);
require_once("../pFuncoes1.php");   // se o processo for rodado do mehu de dentro da pasta de processos -> ../
require_once("../pPublics1.php");

list($iUsec, $iSec) = explode(' ', microtime());
$tScript_Start = (float) $iSec + (float) $iUsec;

$aTop      = faLoadAvgServer();
$nTopIni   = $aTop[0];
$tJobStart = time();
$sProc     = basename(__FILE__);

$sEcoTxt = "/qtux/www/FullPlat/processos/logs/".str_replace('.','_',$sProc)."-".time().".log";
$sEcoTxt = fsDirEcoTxt($sEcoTxt);
$iProcID = getmypid();
fpc($sEcoTxt,"sProc=$sProc, incio em " . date('d/m/Y H:i:s',$tJobStart));
$lOk = true;

//$sDSN = '/qtux/database/desenvolvimento/gps_01.gdb';
//$sDSN = '/qtux/database/tq/gps_01.gdb';
$sDSN = '192.168.1.109:/qtux/database/total/gps_02.gdb';   // caminho para o banco histrico/bi
$hDb  = fhDbConnect($sDSN);


$aTabs   = array();        // resetando o array - fundamental

$aTabs[] = 'NFCapa';                           //  1  
$aTabs[] = 'NFLinha';                          //  2
$aTabs[] = 'NFPrest';                          //  3
$aTabs[] = 'Ordens';                           //  4 
$aTabs[] = 'Ordens_Itens';                     //  5 
$aTabs[] = 'Ordens_Itens_Lotes';               //  6
$aTabs[] = 'Ordens_Item_CCusto';               //  7 
$aTabs[] = 'Ordens_Item_CContabil';            //  8 
$aTabs[] = 'Ordens_Itens_Corte';               //  9 
$aTabs[] = 'Ordens_Itens_CTR';                 // 10 
$aTabs[] = 'Ordens_PreOCa';                    // 11 
$aTabs[] = 'Ordens_FPgmto';                    // 12 
$aTabs[] = 'Ordens_MSG';                       // 13 
$aTabs[] = 'Ordens_Prest';                     // 14 
$aTabs[] = 'Ordens_PrestIFC';                  // 15 
$aTabs[] = 'Ordens_Prog_Datas';                // 16 
$aTabs[] = 'NA_Painel';                        // 17 
$aTabs[] = 'Ordens_Consolidar_Detalhamentos';  // 18
$aTabs[] = 'CTR_CC';                           // 19
$aTabs[] = 'FIN_Titulos';                      // 20
$aTabs[] = 'FIN_Detalhamento_Desc_Acresc';     // 21
$aTabs[] = 'FIN_Titulos_CContabil';            // 22
$aTabs[] = 'FIN_Titulos_CCusto';               // 23
$aTabs[] = 'CobCNAB_Titulos';                  // 24
$aTabs[] = 'PreNF';                            // 25
$aTabs[] = 'PreNF_Itens';                      // 26
$aTabs[] = 'PreNF_Item_CCusto';                // 27
$aTabs[] = 'PreNF_Item_CContabil';             // 28
$aTabs[] = 'PreNF_CC';                         // 29
$aTabs[] = 'PreNF_CCusto';                     // 30
$aTabs[] = 'PreNF_CContabil';                  // 31
$aTabs[] = 'PreNF_FPgmto';                     // 32
$aTabs[] = 'PreNF_Itens_CTR';                  // 33
$aTabs[] = 'PreNF_Prest';                      // 34
$aTabs[] = 'PreNF_PrestIFC';                   // 35
$aTabs[] = 'PreNF_RFis_Itens_Lotes';           // 36
$aTabs[] = 'OP';                               // 37
$aTabs[] = 'OP_BOM';                           // 38
$aTabs[] = 'OP_Espec';                         // 39
$aTabs[] = 'OP_Parcial';                       // 40
$aTabs[] = 'OP_POPs';                          // 41
$aTabs[] = 'EST_MovSaldos';                    // 42 
$aTabs[] = 'EST_LotesSaldos';                  // 43 
$aTabs[] = 'EST_Transf_Reservas';              // 44
$aTabs[] = 'MovCC';                            // 45 
$aTabs[] = 'MovCC_CUPOper';                    // 46
$aTabs[] = 'MovCC_CUPOper_Itens';              // 47
$aTabs[] = 'CISP_Linha';                       // 48
$aTabs[] = 'Itens_HistCustos';                 // 49
$aTabs[] = 'Ordens_Reservas';                  // 50
$aTabs[] = 'Itens_Reservas';                   // 51 
$aTabs[] = 'Ordens_Itens_SemRes';              // 52
$aTabs[] = 'Ordens_Reservas_Demandas';         // 53
$aTabs[] = 'Ordens_Grupo';                     // 54
$aTabs[] = 'OCa';                              // 55
$aTabs[] = 'OCa_Linhas';                       // 56
$aTabs[] = 'OCa_TransfCarga';                  // 57
$aTabs[] = 'OCa_TransfCarga_PreNF';            // 58
$aTabs[] = 'OPCapa';                           // 59
$aTabs[] = 'OPCapa_BOM';                       // 60
$aTabs[] = 'OPCapa_PrevOP';                    // 61
$aTabs[] = 'OPCapa_POPs';                      // 62
$aTabs[] = 'OPCapa_Espec';                     // 63
$aTabs[] = 'CISP';                             // 64

$iVez = 0;
$iTot = count($aTabs);
foreach ($aTabs as $sTab) {
   if ($lOk==true) {
      $iVez++;
      echo "$iVez/$iTot - $sTab, i0=".date('d/m/Y H:i:s');

      $sSql = "select first 1 pPId from $sTab where cast(tIn0 as date) > '$dCorte' order by pPId";
      fpc_append($sEcoTxt,"sSql=$sSql");
      $aDb  = faDbSelect($hDb,$sSql);
      $iDb  = count($aDb);
      fpc_append($sEcoTxt,"iDb=$iDb");
      echo ", f0=".date('d/m/Y H:i:s');
      if ($iDb>0) {
         $pCorte = $aDb[0][0];
         $sSql   = "delete from $sTab where pPId < $pCorte";
         fpc_append($sEcoTxt,"sSql=$sSql");
         echo ", i1=".date('d/m/Y H:i:s');
         $lOk = flDbDelete($hDb,$sSql);
         fpc_append($sEcoTxt,"lOk=$lOk");
         echo ", f1=".date('d/m/Y H:i:s').", lOk=$lOk";
         if ($lOk)  fpc_append($sEcoTxt,"commit");
         else       fpc_append($sEcoTxt,"rollback");
         flDbFimSessao($hDb,$lOk);   // commit tabela a tabela
         $lOk=true;
      }   // iDb>0
      echo chr(10);
   }   // lOk
}   // for



// 2 - Deleta a tabela toda
// ------------------------
$aTabs   = array();        // resetando o array - fundamental
$aTabs[] = 'LOG_CalcFrete_Previsoes';    // 1
$aTabs[] = 'OP_Processadas';             // 2
$aTabs[] = 'ORDENS_ITENS_CTR';           // 3
$aTabs[] = 'PRENF_CC';                   // 4
$aTabs[] = 'Ordens_Reservas_Demandas';   // 5
$aTabs[] = 'Ordens_ASC';                 // 6
$aTabs[] = 'Ordens_Itens_ASC';           // 7
$aTabs[] = 'OP_BOM_ASC';                 // 8

$iVez = 0;
$iTot = count($aTabs);
foreach ($aTabs as $sTab) {
   if ($lOk==true) {
      $iVez++;
      echo "$iVez/$iTot - $sTab, i0=".date('d/m/Y H:i:s');

      $sSql   = "delete from $sTab";   // generator to 0
      fpc_append($sEcoTxt,"sSql=$sSql");
      echo ", i1=".date('d/m/Y H:i:s');
      $lOk = flDbDelete($hDb,$sSql);
      fpc_append($sEcoTxt,"lOk=$lOk");
      echo ", f1=".date('d/m/Y H:i:s').", lOk=$lOk";
      if ($lOk)  fpc_append($sEcoTxt,"commit");
      else       fpc_append($sEcoTxt,"rollback");
      flDbFimSessao($hDb,$lOk);   // commit tabela a tabela
      $lOk=true;

      echo chr(10);
   }   // lOk
}   // for




// 3 - Data de corte 31/12/2022 - pCorte matado
// --------------------------------------------
$aTabs   = array();        // resetando o array - fundamental
$aTabs[] = array('LINCROS_CTE',                               164186); //  1
$aTabs[] = array('LINCROS_CTE_COMPONENTES',                   515894); //  2
$aTabs[] = array('LINCROS_CTE_NOTAS_IC',                      363597); //  3
$aTabs[] = array('LINCROS_CTE_NOTAS_PC',                       77564); //  4
$aTabs[] = array('LINCROS_EMBARQUES',                         431397); //  5
$aTabs[] = array('LINCROS_EMBARQUES_DOCSPRECONRED',        999999999); //  6   99999999, uma forma de deletar todos os registros
$aTabs[] = array('LINCROS_EMBARQUES_DOCUMENTOS',             1490220); //  7
$aTabs[] = array('LINCROS_EMBARQUES_MOVIMENTOS',             1465086); //  8
$aTabs[] = array('LINCROS_EMBARQUE_ORDENSCOLETA',          999999999); //  9
$aTabs[] = array('LINCROS_FATURAS_CTE',                       221582); // 10
$aTabs[] = array('LINCROS_FATURAS_CTE_NFE',                   285119); // 11
$aTabs[] = array('LINCROS_HISTEDIS',                           74683); // 12
$aTabs[] = array('LINCROS_OCORRENCIAS',                       289747); // 13
$aTabs[] = array('LINCROS_ORDENSCOLETA',                       40723); // 14
$aTabs[] = array('LINCROS_ORDENSCOLETA_CONDOCS',             1099005); // 15
$aTabs[] = array('LINCROS_ORDENSCOLETA_CONDOCSIC',         999999999); // 16
$aTabs[] = array('LINCROS_ORDENSCOLETA_CONDOCSPCI',        999999999); // 17
$aTabs[] = array('LINCROS_PEDIDOS',                           223051); // 18
$aTabs[] = array('LINCROS_WSIMPORTACAOXML',                   464431); // 19
$aTabs[] = array('LINCROS_CTE_NOTAS',                         190089); // 20
$aTabs[] = array('LINCROS_CTE_NOTAS_ITENS',                  2556062); // 21
$aTabs[] = array('LINCROS_CTE_NOTAS_PEDIDOS',              999999999); // 22
$aTabs[] = array('LINCROS_EMBARQUES_DOCSPRECONMOV',          5437374); // 23
$aTabs[] = array('LINCROS_EMBARQUES_DOCS_PRECON',            1489581); // 24
$aTabs[] = array('LINCROS_EMBARQUES_MOTORISTAS',           999999999); // 25
$aTabs[] = array('LINCROS_EMBARQUES_ORDENSCOLETA',         999999999); // 26
$aTabs[] = array('LINCROS_FATURAS',                            20951); // 27
$aTabs[] = array('LINCROS_FATURAS_CTE_CC',                 999999999); // 28
$aTabs[] = array('LINCROS_FATURAS_CTE_NFE_PC',                122255); // 29
$aTabs[] = array('LINCROS_HISTEDIS_LINHAS',                  2777656); // 30
$aTabs[] = array('LINCROS_OCORRENCIAS_ANEXOS',             999999999); // 31
$aTabs[] = array('LINCROS_ORDENSCOLETA_CON',                  487427); // 32
$aTabs[] = array('LINCROS_ORDENSCOLETA_CONDOCSI',          999999999); // 33
$aTabs[] = array('LINCROS_ORDENSCOLETA_CONDOCSPC',         999999999); // 34
$aTabs[] = array('LINCROS_ORDENSCOLETA_MOTORISTAS',        999999999); // 35
$aTabs[] = array('LINCROS_PEDIDOS_LINHAS',                   2775552); // 36
$aTabs[] = array('EST_MovSaldos',                           30822888); // 37
//$aTabs[] = array('EST_LotesSaldos',                        1112594); // 38 - 
$aTabs[] = array('Itens_Reservas',                          25233386); // 39
$aTabs[] = array('EST_RegDepSDO',                           23942864); // 40
$aTabs[] = array('EST_LotesSDO',                           245372613); // 41

$iVez = 0;
$iTot = count($aTabs);
foreach ($aTabs as $aTabDados) {
   if ($lOk==true) {
      $iVez++;
      echo "$iVez/$iTot - $sTab, i0=".date('d/m/Y H:i:s');

      $sTab   = $aTabDados[0];
      $pCorte = $aTabDados[1];

      $sSql   = "delete from $sTab where pPId < $pCorte";
      fpc_append($sEcoTxt,"sSql=$sSql");
      echo ", i1=".date('d/m/Y H:i:s');
      $lOk = flDbDelete($hDb,$sSql);
      fpc_append($sEcoTxt,"lOk=$lOk");
      echo ", f1=".date('d/m/Y H:i:s').", lOk=$lOk";
      if ($lOk)  fpc_append($sEcoTxt,"commit");
      else       fpc_append($sEcoTxt,"rollback");
      flDbFimSessao($hDb,$lOk);   // commit tabela a tabela
      $lOk=true;

      echo chr(10);
   }   // lOk
}   // for



flDbDisconnect($hDb);


$tJobEnd  = time();
$iJobElap = $tJobEnd-$tJobStart;

$aTop    = faLoadAvgServer();
$nTopFin = $aTop[0];

fpc_append($sEcoTxt,"iJobElap=$iJobElap");


/*
1  NFCapa                                          622189 2021-01-04 07:55:32.7800
2  NFLinha                                        6413909 2021-01-04 07:55:32.9460
3  NFPrest                                         660169 2021-01-04 07:55:32.8800
4  Ordens                                          619442 2021-01-02 11:55:55.6750
5  Ordens_Itens                                   6985658 2021-01-02 11:56:21.0980
6  Ordens_Itens_Lotes                                   1 2022-07-04 16:57:07.1530
7  Ordens_Item_CCusto                            11084404 2021-01-02 11:56:21.3190
8  Ordens_Item_CContabil                         11077186 2021-01-02 11:56:21.3620
9  Ordens_Itens_Corte                              138475 2021-01-04 10:00:58.8290
10 Ordens_Itens_CTR
11 Ordens_PreOCa                                  5875058 2021-01-04 09:21:40.2640
12 Ordens_FPgmto                                   613052 2021-01-02 11:55:55.9220
13 Ordens_MSG                                           1 2021-09-13 10:23:34.2860
14 Ordens_Prest                                   1717419 2021-01-04 07:01:24.2750
15 Ordens_PrestIFC                                      4 2023-02-09 14:37:30.0960
16 Ordens_Prog_Datas                                16163 2021-01-04 08:17:11.0360
17 NA_Painel                                       681728 2021-01-04 08:03:29.2670
18 Ordens_Consolidar_Detalhamentos                 892466 2021-01-06 01:19:04.1850
19 CTR_CC                                         6727428 2021-01-04 08:00:17.8200
20 FIN_Titulos                                      13610 2022-06-14 09:01:14.8910
21 FIN_Detalhamento_Desc_Acresc                    634903 2021-01-04 00:36:02.9500
22 FIN_Titulos_CContabil                          2125726 2021-01-04 07:32:45.1000
23 FIN_Titulos_CCusto                             2122890 2021-01-04 07:32:45.0630
24 CobCNAB_Titulos                                1435761 2021-01-04 08:17:44.1190
25 PreNF                                           623412 2021-01-04 06:47:39.1580
26 PreNF_Itens                                    6589178 2021-01-04 06:47:39.3930
27 PreNF_Item_CCusto                              6508641 2021-01-04 06:47:39.5110
28 PreNF_Item_CContabil                           6513426 2021-01-04 06:47:39.5450
29 PreNF_CC
30 PreNF_CCusto                                        22 2022-10-17 16:50:39.2340
31 PreNF_CContabil                                     70 2022-10-17 16:50:39.2810
32 PreNF_FPgmto                                    611966 2021-01-04 06:47:39.3300
33 PreNF_Itens_CTR                                4692682 2021-01-04 08:00:17.7000
34 PreNF_Prest                                    1472488 2021-01-04 07:04:38.0240
35 PreNF_PrestIFC                                       1 2023-02-09 15:56:54.9480
36 PreNF_RFis_Itens_Lotes                          129256 2021-01-04 07:56:45.2800
37 OP                                              325804 2021-01-03 19:52:39.2270
38 OP_BOM                                         3036877 2021-01-03 19:43:10.6080
39 OP_Espec                                        994049 2021-01-03 19:43:10.7680
40 OP_Parcial                                      140900 2021-01-04 07:25:48.7750
41 OP_POPs                                         107230 2021-01-03 19:43:10.8940


 1 LINCROS_CTE                                    164186 2023-01-09 15:35:02.5040
 2 LINCROS_CTE_COMPONENTES                        515894 2023-01-09 15:35:02.5210
 3 LINCROS_CTE_NOTAS_IC                           363597 2023-01-19 14:50:02.8920
 4 LINCROS_CTE_NOTAS_PC                            77564 2023-01-19 14:50:02.8810
 5 LINCROS_EMBARQUES                              431397 2023-01-02 12:10:03.0720
 6 LINCROS_EMBARQUES_DOCSPRECONRED
 7 LINCROS_EMBARQUES_DOCUMENTOS                  1490220 2023-01-02 12:10:03.1160
 8 LINCROS_EMBARQUES_MOVIMENTOS                  1465086 2023-01-02 12:10:03.0870
 9 LINCROS_EMBARQUE_ORDENSCOLETA
10 LINCROS_FATURAS_CTE                            221582 2023-01-02 08:20:02.3100
11 LINCROS_FATURAS_CTE_NFE                        285119 2023-01-02 08:20:02.3460
12 LINCROS_HISTEDIS                                74683 2023-01-02 12:05:45.8410
13 LINCROS_OCORRENCIAS                            289747 2023-01-01 15:05:02.9480
14 LINCROS_ORDENSCOLETA                            40723 2023-01-02 14:20:03.1380
15 LINCROS_ORDENSCOLETA_CONDOCS                  1099005 2023-01-02 14:20:03.2840
16 LINCROS_ORDENSCOLETA_CONDOCSIC
17 LINCROS_ORDENSCOLETA_CONDOCSPCI
18 LINCROS_PEDIDOS                                223051 2023-01-02 12:05:45.9050
19 LINCROS_WSIMPORTACAOXML                        464431 2023-01-02 09:40:03.1680
20 LINCROS_CTE_NOTAS                              190089 2023-01-19 14:50:02.2520
21 LINCROS_CTE_NOTAS_ITENS                       2556062 2023-01-19 14:50:02.2750
22 LINCROS_CTE_NOTAS_PEDIDOS
23 LINCROS_EMBARQUES_DOCSPRECONMOV               5437374 2023-01-02 12:10:03.1440
24 LINCROS_EMBARQUES_DOCS_PRECON                 1489581 2023-01-02 12:10:03.1350
25 LINCROS_EMBARQUES_MOTORISTAS
26 LINCROS_EMBARQUES_ORDENSCOLETA
27 LINCROS_FATURAS                                 20951 2023-01-02 08:20:02.2860
28 LINCROS_FATURAS_CTE_CC
29 LINCROS_FATURAS_CTE_NFE_PC                     122255 2023-01-02 08:20:02.3640
30 LINCROS_HISTEDIS_LINHAS                       2777656 2023-01-02 12:05:45.8740
31 LINCROS_OCORRENCIAS_ANEXOS
32 LINCROS_ORDENSCOLETA_CON                       487427 2023-01-02 14:20:03.1600
33 LINCROS_ORDENSCOLETA_CONDOCSI
34 LINCROS_ORDENSCOLETA_CONDOCSPC
35 LINCROS_ORDENSCOLETA_MOTORISTAS
36 LINCROS_PEDIDOS_LINHAS                        2775552 2023-01-02 12:05:45.9170


select first 1 pPId from NFCapa                          where cast(tIn0 as date) > '2020-12-31' order by pPId; 
select first 1 pPId from NFLinha                         where cast(tIn0 as date) > '2020-12-31' order by pPId; 
select first 1 pPId from NFPrest                         where cast(tIn0 as date) > '2020-12-31' order by pPId; 
select first 1 pPId from Ordens                          where cast(tIn0 as date) > '2020-12-31' order by pPId; 
select first 1 pPId from Ordens_Itens                    where cast(tIn0 as date) > '2020-12-31' order by pPId; 
select first 1 pPId from Ordens_Itens_Lotes              where cast(tIn0 as date) > '2020-12-31' order by pPId; 
select first 1 pPId from Ordens_Item_CCusto              where cast(tIn0 as date) > '2020-12-31' order by pPId; 
select first 1 pPId from Ordens_Item_CContabil           where cast(tIn0 as date) > '2020-12-31' order by pPId; 
select first 1 pPId from Ordens_Itens_Corte              where cast(tIn0 as date) > '2020-12-31' order by pPId; 
select first 1 pPId from Ordens_Itens_CTR                where cast(tIn0 as date) > '2020-12-31' order by pPId; 
select first 1 pPId from Ordens_PreOCa                   where cast(tIn0 as date) > '2020-12-31' order by pPId; 
select first 1 pPId from Ordens_FPgmto                   where cast(tIn0 as date) > '2020-12-31' order by pPId; 
select first 1 pPId from Ordens_MSG                      where cast(tIn0 as date) > '2020-12-31' order by pPId; 
select first 1 pPId from Ordens_Prest                    where cast(tIn0 as date) > '2020-12-31' order by pPId; 
select first 1 pPId from Ordens_PrestIFC                 where cast(tIn0 as date) > '2020-12-31' order by pPId; 
select first 1 pPId from Ordens_Prog_Datas               where cast(tIn0 as date) > '2020-12-31' order by pPId; 
select first 1 pPId from NA_Painel                       where cast(tIn0 as date) > '2020-12-31' order by pPId; 
select first 1 pPId from Ordens_Consolidar_Detalhamentos where cast(tIn0 as date) > '2020-12-31' order by pPId; 
select first 1 pPId from CTR_CC                          where cast(tIn0 as date) > '2020-12-31' order by pPId; 
select first 1 pPId from FIN_Titulos                     where cast(tIn0 as date) > '2020-12-31' order by pPId; 
select first 1 pPId from FIN_Detalhamento_Desc_Acresc    where cast(tIn0 as date) > '2020-12-31' order by pPId; 
select first 1 pPId from FIN_Titulos_CContabil           where cast(tIn0 as date) > '2020-12-31' order by pPId; 
select first 1 pPId from FIN_Titulos_CCusto              where cast(tIn0 as date) > '2020-12-31' order by pPId; 
select first 1 pPId from CobCNAB_Titulos                 where cast(tIn0 as date) > '2020-12-31' order by pPId; 
select first 1 pPId from PreNF                           where cast(tIn0 as date) > '2020-12-31' order by pPId; 
select first 1 pPId from PreNF_Itens                     where cast(tIn0 as date) > '2020-12-31' order by pPId; 
select first 1 pPId from PreNF_Item_CCusto               where cast(tIn0 as date) > '2020-12-31' order by pPId; 
select first 1 pPId from PreNF_Item_CContabil            where cast(tIn0 as date) > '2020-12-31' order by pPId; 
select first 1 pPId from PreNF_CC                        where cast(tIn0 as date) > '2020-12-31' order by pPId; 
select first 1 pPId from PreNF_CCusto                    where cast(tIn0 as date) > '2020-12-31' order by pPId; 
select first 1 pPId from PreNF_CContabil                 where cast(tIn0 as date) > '2020-12-31' order by pPId; 
select first 1 pPId from PreNF_FPgmto                    where cast(tIn0 as date) > '2020-12-31' order by pPId; 
select first 1 pPId from PreNF_Itens_CTR                 where cast(tIn0 as date) > '2020-12-31' order by pPId; 
select first 1 pPId from PreNF_Prest                     where cast(tIn0 as date) > '2020-12-31' order by pPId; 
select first 1 pPId from PreNF_PrestIFC                  where cast(tIn0 as date) > '2020-12-31' order by pPId; 
select first 1 pPId from PreNF_RFis_Itens_Lotes          where cast(tIn0 as date) > '2020-12-31' order by pPId; 
select first 1 pPId from OP                              where cast(tIn0 as date) > '2020-12-31' order by pPId; 
select first 1 pPId from OP_BOM                          where cast(tIn0 as date) > '2020-12-31' order by pPId; 
select first 1 pPId from OP_Espec                        where cast(tIn0 as date) > '2020-12-31' order by pPId; 
select first 1 pPId from OP_Parcial                      where cast(tIn0 as date) > '2020-12-31' order by pPId; 
select first 1 pPId from OP_POPs                         where cast(tIn0 as date) > '2020-12-31' order by pPId; 

//--

select first 1 pPId from EST_MovSaldos                   where cast(tIn0 as date) > '2020-12-31' order by pPId;
select first 1 pPId from EST_LotesSaldos                 where cast(tIn0 as date) > '2020-12-31' order by pPId;
select first 1 pPId from EST_Transf_Reservas             where cast(tIn0 as date) > '2020-12-31' order by pPId;
select first 1 pPId from MovCC                           where cast(tIn0 as date) > '2020-12-31' order by pPId;
select first 1 pPId from MovCC_CUPOper                   where cast(tIn0 as date) > '2020-12-31' order by pPId;
select first 1 pPId from MovCC_CUPOper_Itens             where cast(tIn0 as date) > '2020-12-31' order by pPId;
select first 1 pPId from CISP_Linha                      where cast(tIn0 as date) > '2020-12-31' order by pPId;
select first 1 pPId from Itens_HistCustos                where cast(tIn0 as date) > '2020-12-31' order by pPId;
select first 1 pPId from Ordens_Reservas                 where cast(tIn0 as date) > '2020-12-31' order by pPId;
select first 1 pPId from Itens_Reservas                  where cast(tIn0 as date) > '2020-12-31' order by pPId;
select first 1 pPId from Ordens_Itens_SemRes             where cast(tIn0 as date) > '2020-12-31' order by pPId;
select first 1 pPId from Ordens_Reservas_Demandas        where cast(tIn0 as date) > '2020-12-31' order by pPId;

select first 1 pPId from EST_RegDepSDO                   where cast(tIn0 as date) > '2022-12-31' order by pPId;   // dCort2
select first 1 pPId from EST_LotesSDO                    where cast(tIn0 as date) > '2022-12-31' order by pPId;   // dCort2

//--

select first 1 ' 1 LINCROS_CTE                    ',pPId,tIn0 from LINCROS_CTE                              where cast(tIn0 as date) > '2020-12-31' order by pPId;
select first 1 ' 2 LINCROS_CTE_COMPONENTES        ',pPId,tIn0 from LINCROS_CTE_COMPONENTES                  where cast(tIn0 as date) > '2020-12-31' order by pPId;
select first 1 ' 3 LINCROS_CTE_NOTAS_IC           ',pPId,tIn0 from LINCROS_CTE_NOTAS_IC                     where cast(tIn0 as date) > '2020-12-31' order by pPId;
select first 1 ' 4 LINCROS_CTE_NOTAS_PC           ',pPId,tIn0 from LINCROS_CTE_NOTAS_PC                     where cast(tIn0 as date) > '2020-12-31' order by pPId;
select first 1 ' 5 LINCROS_EMBARQUES              ',pPId,tIn0 from LINCROS_EMBARQUES                        where cast(tIn0 as date) > '2020-12-31' order by pPId;
select first 1 ' 6 LINCROS_EMBARQUES_DOCSPRECONRED',pPId,tIn0 from LINCROS_EMBARQUES_DOCSPRECONRED          where cast(tIn0 as date) > '2020-12-31' order by pPId;
select first 1 ' 7 LINCROS_EMBARQUES_DOCUMENTOS   ',pPId,tIn0 from LINCROS_EMBARQUES_DOCUMENTOS             where cast(tIn0 as date) > '2020-12-31' order by pPId;
select first 1 ' 8 LINCROS_EMBARQUES_MOVIMENTOS   ',pPId,tIn0 from LINCROS_EMBARQUES_MOVIMENTOS             where cast(tIn0 as date) > '2020-12-31' order by pPId;
select first 1 ' 9 LINCROS_EMBARQUE_ORDENSCOLETA  ',pPId,tIn0 from LINCROS_EMBARQUE_ORDENSCOLETA            where cast(tIn0 as date) > '2020-12-31' order by pPId;
select first 1 '10 LINCROS_FATURAS_CTE            ',pPId,tIn0 from LINCROS_FATURAS_CTE                      where cast(tIn0 as date) > '2020-12-31' order by pPId;
select first 1 '11 LINCROS_FATURAS_CTE_NFE        ',pPId,tIn0 from LINCROS_FATURAS_CTE_NFE                  where cast(tIn0 as date) > '2020-12-31' order by pPId;
select first 1 '12 LINCROS_HISTEDIS               ',pPId,tIn0 from LINCROS_HISTEDIS                         where cast(tIn0 as date) > '2020-12-31' order by pPId;
select first 1 '13 LINCROS_OCORRENCIAS            ',pPId,tIn0 from LINCROS_OCORRENCIAS                      where cast(tIn0 as date) > '2020-12-31' order by pPId;
select first 1 '14 LINCROS_ORDENSCOLETA           ',pPId,tIn0 from LINCROS_ORDENSCOLETA                     where cast(tIn0 as date) > '2020-12-31' order by pPId;
select first 1 '15 LINCROS_ORDENSCOLETA_CONDOCS   ',pPId,tIn0 from LINCROS_ORDENSCOLETA_CONDOCS             where cast(tIn0 as date) > '2020-12-31' order by pPId;
select first 1 '16 LINCROS_ORDENSCOLETA_CONDOCSIC ',pPId,tIn0 from LINCROS_ORDENSCOLETA_CONDOCSIC           where cast(tIn0 as date) > '2020-12-31' order by pPId;
select first 1 '17 LINCROS_ORDENSCOLETA_CONDOCSPCI',pPId,tIn0 from LINCROS_ORDENSCOLETA_CONDOCSPCI          where cast(tIn0 as date) > '2020-12-31' order by pPId;
select first 1 '18 LINCROS_PEDIDOS                ',pPId,tIn0 from LINCROS_PEDIDOS                          where cast(tIn0 as date) > '2020-12-31' order by pPId;
select first 1 '19 LINCROS_WSIMPORTACAOXML        ',pPId,tIn0 from LINCROS_WSIMPORTACAOXML                  where cast(tIn0 as date) > '2020-12-31' order by pPId;
select first 1 '20 LINCROS_CTE_NOTAS              ',pPId,tIn0 from LINCROS_CTE_NOTAS                        where cast(tIn0 as date) > '2020-12-31' order by pPId;
select first 1 '21 LINCROS_CTE_NOTAS_ITENS        ',pPId,tIn0 from LINCROS_CTE_NOTAS_ITENS                  where cast(tIn0 as date) > '2020-12-31' order by pPId;
select first 1 '22 LINCROS_CTE_NOTAS_PEDIDOS      ',pPId,tIn0 from LINCROS_CTE_NOTAS_PEDIDOS                where cast(tIn0 as date) > '2020-12-31' order by pPId;
select first 1 '23 LINCROS_EMBARQUES_DOCSPRECONMOV',pPId,tIn0 from LINCROS_EMBARQUES_DOCSPRECONMOV          where cast(tIn0 as date) > '2020-12-31' order by pPId;
select first 1 '24 LINCROS_EMBARQUES_DOCS_PRECON  ',pPId,tIn0 from LINCROS_EMBARQUES_DOCS_PRECON            where cast(tIn0 as date) > '2020-12-31' order by pPId; 
select first 1 '25 LINCROS_EMBARQUES_MOTORISTAS   ',pPId,tIn0 from LINCROS_EMBARQUES_MOTORISTAS             where cast(tIn0 as date) > '2020-12-31' order by pPId;
select first 1 '26 LINCROS_EMBARQUES_ORDENSCOLETA ',pPId,tIn0 from LINCROS_EMBARQUES_ORDENSCOLETA           where cast(tIn0 as date) > '2020-12-31' order by pPId;
select first 1 '27 LINCROS_FATURAS                ',pPId,tIn0 from LINCROS_FATURAS                          where cast(tIn0 as date) > '2020-12-31' order by pPId;
select first 1 '28 LINCROS_FATURAS_CTE_CC         ',pPId,tIn0 from LINCROS_FATURAS_CTE_CC                   where cast(tIn0 as date) > '2020-12-31' order by pPId;
select first 1 '29 LINCROS_FATURAS_CTE_NFE_PC     ',pPId,tIn0 from LINCROS_FATURAS_CTE_NFE_PC               where cast(tIn0 as date) > '2020-12-31' order by pPId;
select first 1 '30 LINCROS_HISTEDIS_LINHAS        ',pPId,tIn0 from LINCROS_HISTEDIS_LINHAS                  where cast(tIn0 as date) > '2020-12-31' order by pPId;
select first 1 '31 LINCROS_OCORRENCIAS_ANEXOS     ',pPId,tIn0 from LINCROS_OCORRENCIAS_ANEXOS               where cast(tIn0 as date) > '2020-12-31' order by pPId;
select first 1 '32 LINCROS_ORDENSCOLETA_CON       ',pPId,tIn0 from LINCROS_ORDENSCOLETA_CON                 where cast(tIn0 as date) > '2020-12-31' order by pPId;
select first 1 '33 LINCROS_ORDENSCOLETA_CONDOCSI  ',pPId,tIn0 from LINCROS_ORDENSCOLETA_CONDOCSI            where cast(tIn0 as date) > '2020-12-31' order by pPId;
select first 1 '34 LINCROS_ORDENSCOLETA_CONDOCSPC ',pPId,tIn0 from LINCROS_ORDENSCOLETA_CONDOCSPC           where cast(tIn0 as date) > '2020-12-31' order by pPId;
select first 1 '35 LINCROS_ORDENSCOLETA_MOTORISTAS',pPId,tIn0 from LINCROS_ORDENSCOLETA_MOTORISTAS          where cast(tIn0 as date) > '2020-12-31' order by pPId;
select first 1 '36 LINCROS_PEDIDOS_LINHAS         ',pPId,tIn0 from LINCROS_PEDIDOS_LINHAS                   where cast(tIn0 as date) > '2020-12-31' order by pPId;




delete from Ordens_Itens a where a.pPId in (select b.pCapa from Ordens b where b.pUNeg<>$pUNeg);
delete from Ordens_Itens a where exists (select 1 from Ordens b where a.pPId=b.pCapa and b.pUNeg<>$pUNeg);



$aTabs = array();
$aTabs[] = 'ASSESSMENT_EMPRESA              ';
$aTabs[] = 'BLOCOK                          ';
$aTabs[] = 'BOLETOS                         ';
$aTabs[] = 'CANALWEB_CONSOLIDADOS_1         ';
$aTabs[] = 'CC_CUPOPER                      ';
$aTabs[] = 'CHAMADO_CONSUMIDOR              ';
$aTabs[] = 'CHAMADO_OCORRENCIAS             ';
$aTabs[] = 'CLIENTE_UNEG                    ';
$aTabs[] = 'COBCNAB                         ';
$aTabs[] = 'COMISSAO_RANGE                  ';
$aTabs[] = 'COMIS_CC_CUPOPER                ';
$aTabs[] = 'COMIS_REL_CARTEIRA              ';
$aTabs[] = 'COMIS_REL_CARTEIRA_FIN          ';
$aTabs[] = 'COMIS_REL_CARTEIRA_MOV          ';
$aTabs[] = 'COM_PARAMETROS_UNEG_CC          ';
$aTabs[] = 'CORP_PLANO_V                    ';
$aTabs[] = 'COT                             ';
$aTabs[] = 'CTR                             ';
$aTabs[] = 'CTR_CC                          ';
$aTabs[] = 'CTR_PROCESSO                    ';
$aTabs[] = 'CUP                             ';
$aTabs[] = 'DIASENTPREV                     ';
$aTabs[] = 'EDI_FIN_BANCOS_UNEGCCCONV       ';
$aTabs[] = 'EDI_FIN_VINCULACAO              ';
$aTabs[] = 'EQ                              ';
$aTabs[] = 'ERP_FIN_RANGE_RELFINANCEIRO     ';
$aTabs[] = 'EST_COPIAREGDEP                 ';
$aTabs[] = 'EST_COPIAREGDEPINS              ';
$aTabs[] = 'EST_HIST_SALDOSCUSTOS_LINHA     ';
$aTabs[] = 'EST_RANGERELESTVAL              ';
$aTabs[] = 'EST_REQUISICOES                 ';
$aTabs[] = 'EXZ2_INCIDENCIA_COMISSAO        ';
$aTabs[] = 'FESTAS                          ';
$aTabs[] = 'FIN_ACORDOS_PARAMETROS_UNEG_CC  ';
$aTabs[] = 'FIN_BANCOS_EDI_RET              ';
$aTabs[] = 'FIN_BANCOS_EDI_RET_LINHAS       ';
$aTabs[] = 'FIN_BANCOS_EDI_RET_LOTES        ';
$aTabs[] = 'FIN_EDI_BANCOS_DDA              ';
$aTabs[] = 'FIN_RANGE_RELFINANCEIROS        ';
$aTabs[] = 'FIN_RFLUXOCAIXA                 ';
$aTabs[] = 'FIN_VERBAS_PARAMETROS_UNEG_CC   ';
$aTabs[] = 'GRUNEG_CAPA                     ';
$aTabs[] = 'GRUNEG_LINHA                    ';
$aTabs[] = 'HALLOS_TOKEN                    ';
$aTabs[] = 'HALLOS_USU_ACESSO               ';
$aTabs[] = 'HALLOS_USU_ACESSO_GERADO        ';
$aTabs[] = 'ITENS                           ';
$aTabs[] = 'ITENS_RANGEREL                  ';
$aTabs[] = 'ITENS_REXCMASSA                 ';
$aTabs[] = 'LJI_CATEGORIAS                  ';
$aTabs[] = 'LJI_MARCAS                      ';
$aTabs[] = 'LJI_UNEG_LOJA                   ';
$aTabs[] = 'LJI_UNEG_WEBHOOKPEDIDOS         ';
$aTabs[] = 'LJI_UNEG_WEBHOOKPRODUTOS        ';
$aTabs[] = 'LOG_FRETES_PARAMETROS_UNEG_CC   ';
$aTabs[] = 'MET_BONIF                       ';
$aTabs[] = 'MET_COTASUBGRUPO                ';
$aTabs[] = 'MET_VALORES                     ';
$aTabs[] = 'MPDE_MARGEM                     ';
$aTabs[] = 'MPDE_MOV                        ';
$aTabs[] = 'MPDE_UNEGS                      ';
$aTabs[] = 'MRPUNEG                         ';
$aTabs[] = 'MRP_ITENS                       ';
$aTabs[] = 'MRP_OSAI                        ';
$aTabs[] = 'NFCAPA                          ';
$aTabs[] = 'NFE_PARAMETROS                  ';
$aTabs[] = 'NFRANGE_REL                     ';
$aTabs[] = 'NF_IMPRESSOES                   ';
$aTabs[] = 'NF_INUTILIZAR                   ';
$aTabs[] = 'OOP                             ';
$aTabs[] = 'OP                              ';
$aTabs[] = 'OPCAPA                          ';
$aTabs[] = 'OP_PROCESSOS                    ';
$aTabs[] = 'OP_PRODUTPROCPROD               ';
$aTabs[] = 'OP_REL_CONSUMO                  ';
$aTabs[] = 'OP_SUGPRODREALIZADO             ';
$aTabs[] = 'ORCGRPUNEG_LINHA                ';
$aTabs[] = 'ORDENS                          ';
$aTabs[] = 'ORDENS_AGE_ACOMPANHAMENTO       ';
$aTabs[] = 'ORDENS_IMPTRANSFAUTO            ';
$aTabs[] = 'ORDENS_RETSDO                   ';
$aTabs[] = 'ORGANIZACAO                     ';
$aTabs[] = 'OSAIDA                          ';
$aTabs[] = 'OS_CONFIRMAR                    ';
$aTabs[] = 'PCADRANGECOMISSAO               ';
$aTabs[] = 'PFINHOLD_LINHA                  ';
$aTabs[] = 'PFLEX_CCREP_EXTSDO              ';
$aTabs[] = 'PRENF_CONTROL_SDOF              ';
$aTabs[] = 'PREPUNEG                        ';
$aTabs[] = 'PROJETOS                        ';
$aTabs[] = 'PTOPEDTEMP_FILTRAR_UNEG         ';
$aTabs[] = 'PTOPEDTEMP_FLTRAR_UNEG          ';
$aTabs[] = 'PTOPEDTEMP_ITEM_UNEG            ';
$aTabs[] = 'PTOPEDTEMP_UNEG                 ';
$aTabs[] = 'PTOPUNEG                        ';
$aTabs[] = 'PUNEGITEM_RLOTES                ';
$aTabs[] = 'RAC_USU_UNEG                    ';
$aTabs[] = 'RANGEREL_CONSUMOMOV             ';
$aTabs[] = 'RANGEREL_SALDOSMOV              ';
$aTabs[] = 'RAVANCPERDAS                    ';

$iLoop = 0;
$iTabs = count($aTabs);
foreach ($aTabs as $sTab) {
   $iLoop++;
   echo "$iLoop / $iTabs".chr(10);
   $sTab = trim($sTab);
   $sSql = "delete from $sTab where pUNeg<>$pSDBr
   fpc_append($sEcoTxt,"sSql=$sSql");
   $lOk  = flDbDelete($hDb,$sSql)
   if ($lOk==true) flDbCommit($hDb);
   else {
      flDbRollBack($hDb);
      fpc_append("rollback tabela $sTab");
      echo "rollback tabela $sTab".chr(10);
   }
}
--//--

$aTabs = array();
$aTabs[] = 'BLOCOK_PROCESSAMENTOS           ';
$aTabs[] = 'CADD_REGFISCAIS                 ';
$aTabs[] = 'COMIS_PEMI                      ';
$aTabs[] = 'COM_REGCOM                      ';
$aTabs[] = 'COM_REP                         ';
$aTabs[] = 'DIASENTPREV                     ';
$aTabs[] = 'EDI_ATACADAO                    ';
$aTabs[] = 'EDI_COBASI                      ';
$aTabs[] = 'EDI_FIN_VINCULACAO              ';
$aTabs[] = 'EDI_LOJINHA                     ';
$aTabs[] = 'EST_DEPOSITOS                   ';
$aTabs[] = 'EST_INVENTARIOS                 ';
$aTabs[] = 'EST_REGDEPOSITOS                ';
$aTabs[] = 'EST_RPROC_LOTESVENC             ';
$aTabs[] = 'EST_SOTRANSF                    ';
$aTabs[] = 'EST_TRANSF_ICOMP                ';
$aTabs[] = 'EST_TRANSF_ICOMPANY             ';
$aTabs[] = 'FINVERBAS                       ';
$aTabs[] = 'FIN_BANCOS_EDI                  ';
$aTabs[] = 'GRPPROMO                        ';
$aTabs[] = 'GRPPROMO_ITENS                  ';
$aTabs[] = 'IFC_ESTOQUE                     ';
$aTabs[] = 'IFC_LIM_CREDITO                 ';
$aTabs[] = 'IFC_ORDER                       ';
$aTabs[] = 'IFC_POLPRECOS                   ';
$aTabs[] = 'LIM_CREDITO                     ';
$aTabs[] = 'LINCROS_FATURAS                 ';
$aTabs[] = 'LINCROS_OCORRENCIAS             ';
$aTabs[] = 'LINCROS_WSIMPORTACAOXML         ';
$aTabs[] = 'LJI_PEDIDOS                     ';
$aTabs[] = 'LJI_UNEG                        ';
$aTabs[] = 'LJI_UNEG_ITENSENVIADOSCAPA      ';
$aTabs[] = 'MRP_OPPROG                      ';
$aTabs[] = 'NEGOCIACOES                     ';
$aTabs[] = 'NFCAPA                          ';
$aTabs[] = 'NRCAIXASPALLET_CLIENTESITENS    ';
$aTabs[] = 'OENT_COMPRASRANGE               ';
$aTabs[] = 'OENT_COMPRASRANGE_ITENS         ';
$aTabs[] = 'OENT_COMPRASRANGE_PREST         ';
$aTabs[] = 'OENT_ORDENSCOMPRASRANGE_ITENS   ';
$aTabs[] = 'OP                              ';
$aTabs[] = 'OPCAPA                          ';
$aTabs[] = 'OP_ASC                          ';
$aTabs[] = 'OP_RELRANGE_INSUMOS             ';
$aTabs[] = 'OP_REL_INSUMOS01                ';
$aTabs[] = 'OP_TRANSITOS                    ';
$aTabs[] = 'ORDENS                          ';
$aTabs[] = 'ORDENS_ASC                      ';
$aTabs[] = 'ORDENS_BAIXA                    ';
$aTabs[] = 'ORDENS_BONIFREG_IMP             ';
$aTabs[] = 'ORDENS_CONSOLIDAR               ';
$aTabs[] = 'ORDENS_CONSOLIDAR_EMIDIV        ';
$aTabs[] = 'ORDENS_CORTES_RANGE_UNEG        ';
$aTabs[] = 'ORDENS_DESRESERVA               ';
$aTabs[] = 'ORDENS_FATPARC_IMP              ';
$aTabs[] = 'ORDENS_LIBERACAO                ';
$aTabs[] = 'ORDENS_RELACAO_IMPRESSAO        ';
$aTabs[] = 'ORDENS_RELCTRLPRECO             ';
$aTabs[] = 'ORDENS_REL_DENTREGA             ';
$aTabs[] = 'ORDENS_REL_DENTREGA_UNEG        ';
$aTabs[] = 'ORDENS_REL_ITENS_CCONT          ';
$aTabs[] = 'ORDENS_RESERVAS                 ';
$aTabs[] = 'OTRANSF                         ';
$aTabs[] = 'PED                             ';
$aTabs[] = 'PED_CAPA                        ';
$aTabs[] = 'PERFILPED                       ';
$aTabs[] = 'PEST_SOTRANSF                   ';
$aTabs[] = 'PEST_TRANSF_ICOMP               ';
$aTabs[] = 'PFINVERBAS                      ';
$aTabs[] = 'PFLEX_MOVCCREP                  ';
$aTabs[] = 'PMREPUNEG_RORD                  ';
$aTabs[] = 'POLITICASROTINA_CAMPOS          ';
$aTabs[] = 'POLITICASROTINA_CAMPOSDETALHES  ';
$aTabs[] = 'POL_COPIAR                      ';
$aTabs[] = 'POL_COPIAR_REGFISCAIS           ';
$aTabs[] = 'POL_COPIAR_REGFISCAIS_EMISSOR   ';
$aTabs[] = 'POL_COPIAR_REGFISCAIS_NCM       ';
$aTabs[] = 'PREMRET                         ';
$aTabs[] = 'PRENF                           ';
$aTabs[] = 'PRENF_ABC                       ';
$aTabs[] = 'PRENF_COMPRASRANGE_ITENS        ';
$aTabs[] = 'PRENF_COMPRASRANGE_ITENS_TRANSP ';
$aTabs[] = 'PRENF_COMPRASRANGE_PREST        ';
$aTabs[] = 'PRENF_CONTROL_SDOF              ';
$aTabs[] = 'PRENF_OSA_CONSOLTRANSF          ';
$aTabs[] = 'PRENF_RELCOMP_ITENS_CCONT       ';
$aTabs[] = 'PREPUNEG                        ';
$aTabs[] = 'PREPUNEG_CAPA                   ';
$aTabs[] = 'PREVISAO_CONSUMO_CAPA           ';
$aTabs[] = 'PREVISAO_CONSUMO_CAPA_UNEG      ';
$aTabs[] = 'PROTINASC                       ';
$aTabs[] = 'PROTINASI                       ';
$aTabs[] = 'PTOPED                          ';
$aTabs[] = 'PTOPEDTEMP                      ';
$aTabs[] = 'PTOPEDTEMP_ATUALIZAR            ';
$aTabs[] = 'PTOPEDTEMP_FILTRAR              ';
$aTabs[] = 'PTOPEDTEMP_ITEM                 ';
$aTabs[] = 'PTOPED_CAMPOS                   ';
$aTabs[] = 'PTOPED_CAMPOS_DETALHAMENTO      ';
$aTabs[] = 'PTOPED_CAPA                     ';
$aTabs[] = 'PTOPED_ITEM                     ';
$aTabs[] = 'PTOPED_ITEM_CAPA                ';
$aTabs[] = 'PTOPED_ITEM_CAPAI               ';
$aTabs[] = 'PTOPE_GRPCUP                    ';
$aTabs[] = 'PVLMINIMO                       ';
$aTabs[] = 'PVLMINIMO_CPGMTO                ';
$aTabs[] = 'PVLMINIMO_EMI                   ';
$aTabs[] = 'RAVANCMODELOI                   ';
$aTabs[] = 'REGESPEC_CLIENTES               ';
$aTabs[] = 'REGESPEC_CLIENTESNCM            ';
$aTabs[] = 'REGESPEC_IPIUNITRIB             ';
$aTabs[] = 'REGESPEC_ITENSNCM               ';
$aTabs[] = 'REGFISCAIS                      ';
$aTabs[] = 'REGFISCAIS_TEMPLATES            ';
$aTabs[] = 'REL_COM_DIARIOEQUIPE            ';
$aTabs[] = 'REL_COM_DIARIOEQUIPE_EMI        ';
$aTabs[] = 'REL_NEGOCIACAO_ITENS            ';
$aTabs[] = 'REL_PED                         ';
$aTabs[] = 'REL_PERFORMANCE_ENTREGA_EMI     ';
$aTabs[] = 'REL_PERF_REPRESENTANTES_EMI     ';
$aTabs[] = 'REL_PREPUNEG                    ';
$aTabs[] = 'REL_PREPUNEG_EMI                ';
$aTabs[] = 'REL_REPRESPEDIDOS               ';
$aTabs[] = 'REL_RPERFORMANCEREGIAO          ';
$aTabs[] = 'ROPER                           ';
$aTabs[] = 'ROPER_EMIDEST                   ';
$aTabs[] = 'TABPRECOS                       ';
$aTabs[] = 'TOPER_CUP_FIN                   ';
$aTabs[] = 'TRADE_EMI                       ';
$aTabs[] = 'TRANSITOS                       ';
$aTabs[] = 'UFS_UNEG                        ';
$aTabs[] = 'VERBA                           ';
$aTabs[] = 'VERBAS                          ';
$aTabs[] = 'WNET_CAPAS                      ';
$aTabs[] = 'WNET_TABPRECO                   ';
$aTabs[] = 'WNET_ULTVENDA                   ';


$iLoop = 0;
$iTabs = count($aTabs);
foreach ($aTabs as $sTab) {
   $iLoop++;
   echo "$iLoop / $iTabs".chr(10);
   $sTab = trim($sTab);
   $sSql = "delete from $sTab where pEmi<>$pSDBr
   fpc_append($sEcoTxt,"sSql=$sSql");
   $lOk  = flDbDelete($hDb,$sSql)
   if ($lOk==true) flDbCommit($hDb);
   else {
      flDbRollBack($hDb);
      fpc_append("rollback tabela $sTab");
      echo "rollback tabela $sTab".chr(10);
   }
}

*/

?>