<?php
set_time_limit(7200);
date_default_timezone_set('America/Sao_Paulo');
require_once("/qtux/www/FullPlat/pFuncoes1.php");
require_once("/qtux/www/FullPlat/pPublics1.php");
require("/qtux/library/PHPMailer-master/PHPMailerAutoload.php");

list($iUsec, $iSec) = explode(' ', microtime());
$tScript_Start = (float) $iSec + (float) $iUsec;

$aTop      = faLoadAvgServer();
$nTopIni   = $aTop[0];
$tJobStart = time();
$sProc     = basename(__FILE__);
$lOk       = true;

$sHOST = exec('hostname');
if ($sHOST == 'qtuxap.sanol.com.br') {
   $sDSN = '192.168.1.109:/qtux/database/total/gps_01.gdb';
   $sCliPasta = 'total';
} else if ($sHOST=='homologqtuxweb.sanol.com.br') {
   $sDSN = 'localhost:/qtux/database/total/gps_01.gdb';
   $sCliPasta = 'total';
} else {
   $sDSN = 'localhost:/qtux/database/tq/gps_01.gdb';
   $sCliPasta = 'desenvolvimento';
}

$sEcoTxt = '/qtux/www/FullPlat/processos/logs/'.str_replace('.','_',$sProc).'-'.$tJobStart.'.log';
$sEcoTxt = fsDirEcoTxt($sEcoTxt);
$iProcID = getmypid();

$lDebug = false;

$lEmail = true;

fpc($sEcoTxt,'iProcID='.$iProcID);
fpc_append($sEcoTxt,'Incio em ' . date('d/m/Y H:i:s',$tJobStart));

$hDb = fhDbConnect($sDSN);

$lControlProc = flControlProc($hDb,$sProc);
$sLog .= "lControlProc=$lControlProc".chr(10);
if ($lControlProc==false) {
   $lOk = false;
   fpc_append($sEcoTxt,"J TEM UM PROCESSO RODANDO [ $sProc ] NO IR RODAR, ESPERE O PROCESSO TERMINAR PARA RODAR NOVAMENTE.");
} else {

   $aItensDb1 = array();
   $sSql1 = "select a.pItem,
                    c.sCodigo,
                    c.pUNeg,
                    cast(sum(a.nQtRes-a.nQtFat-a.nQtCanc) as numeric(12,2)),
                    cast(sum(a.nQtLib-a.nQtFat-a.nQtCanc) as numeric(12,2)),
                    cast(sum(a.nQtCanc) as numeric(12,2)),
                    (select cast(sum(aa.nRes) as numeric(12,2)) from EST_RegDepositos aa where aa.pItem=a.pItem and aa.iVer=aa.iVAt),
                    (select cast(sum(bb.nRes) as numeric(12,2)) from EST_RegDepositos ab join EST_LotesSaldos bb on bb.pRegDep=ab.pPId and bb.iVer=bb.iVAt and bb.nRes>0 where ab.pItem=a.pItem and ab.iVer=ab.iVAt),
                    0
               from Ordens_Itens  a join Ordens b on a.pOrdem=b.pPId and b.iVer=b.iVAt and b.tCanc is null and b.jFase<>8 and b.lExc=0
                                    join Itens  c on a.pItem =c.pPId and c.iVer=c.iVAt
              where a.lExc=0
                and a.iVer=a.iVAt
                and a.nQtRes-a.nQtFat-a.nQtCanc>0
              group by a.pItem,
                       c.sCodigo,
                       c.pUNeg
             having (   (sum(a.nQtRes-a.nQtFat-a.nQtCanc) <> (select sum(aa.nRes) from EST_RegDepositos aa where aa.pItem=a.pItem and aa.iVer=aa.iVAt))
                     or (sum(a.nQtLib-a.nQtFat-a.nQtCanc) <> (select sum(bb.nRes) from EST_RegDepositos ab join EST_LotesSaldos bb on ab.pItem=a.pItem and ab.iVer=ab.iVAt and bb.pRegDep=ab.pPId and bb.iVer=bb.iVAt and bb.nRes>0))
                    )";

   fpc_append($sEcoTxt,"sSql1=$sSql1");
   $aDb1  = faDbSelect($hDb,$sSql1);
   $iDb1  = count($aDb1);
   $iDb1A = $iDb1;
   fpc_append($sEcoTxt,"iDb1=$iDb1");
   foreach ($aDb1 as $aLin1) {
      $pItem   = $aLin1[0];
      $aItensDb1[] = $pItem;
   }

   $sSql3 = "select a.pItem,
                    b.sCodigo,
                    b.pUNeg,
                    cast(a.nRes as numeric(12,2))
             from EST_RegDepositos a left join Itens b on a.pItem=b.pPId and b.iVer=b.iVAt
             where a.nRes>0
               and a.lExc=0
               and a.iVer=a.iVAt
               and (select count(*)
                    from Ordens_Itens aa join Ordens bb on aa.pOrdem=bb.pPId and bb.iVer=bb.iVAt and bb.lExc=0 and bb.jFase<>8
                    where aa.lExc=0
                      and aa.iVer=aa.iVAt
                      and aa.pItem=a.pItem
                      and (aa.nQtRes-aa.nQtFat-aa.nQtCanc)>0)=0 
               and (select count(*)
                    from OP_BOM cc
                    where cc.iVer=cc.iVAt
                      and cc.lExc=0
                      and cc.pRegDep=a.pPId)=0   
            ";
   // Nao tem reserva das Ordens
   // Nao e reserva das OPs

   fpc_append($sEcoTxt,"sSql3=$sSql3");
   $aDb3  = faDbSelect($hDb,$sSql3);
   $iDb3  = count($aDb3);
   fpc_append($sEcoTxt,"iDb3=$iDb3");
   
   //var_dump($aDb3);

   foreach ($aDb3 as $aLin3) {
      $pItem  = $aLin3[0];
      $sCItem = $aLin3[1];
      $pUNeg  = $aLin3[2];
      $nRes   = $aLin3[3];
      fpc_append($sEcoTxt,"aDb3 -> pItem=$pItem, sCItem=$sCItem, pUNeg=$pUNeg, nRes=$nRes");
      if (in_array($pItem,$aItensDb1)==false) {   // essa qry nao eh um group by no item
         fpc_append($sEcoTxt,"aDb3 -> aDb1");
         $aDb1[] = array($pItem,$sCItem,$pUNeg,0,0,0,$nRes,0,1);
         $aItensDb1[] = $pItem;
         $iDb1++;
      }
   }
   fpc_append($sEcoTxt,"Novo iDb1=$iDb1");
   
   //

   $sSql2 = "select pItem,
                    sCodigo,
                    pUNeg,
                    cast(nSumQtRes as numeric(12,2)),
                    cast(nSumQtLib as numeric(12,2)),
                    cast(nSumQtCanc as numeric(12,2)),
                    cast(nSumRes1 as numeric(12,2)),
                    cast(nSumRes2 as numeric(12,2))
               from TMP_Analise_Ordens_Itens 
              where iVer = iVAt
                and lExc = 0";
   
   fpc_append($sEcoTxt,"sSql2=$sSql2");
   $aDb2 = faDbSelect($hDb,$sSql2);
   $iDb2 = count($aDb2);
   fpc_append($sEcoTxt,"iDb2=$iDb2");
   
   $aItens = array();
   if ($iDb1!=$iDb2) {
      fpc_append($sEcoTxt,"$iDb1!=$iDb2");
      $aArr_Insert = array();
      foreach ($aDb1 as $aLin1) {
         $pItem      = $aLin1[0];
         $sCodigo    = $aLin1[1];
         $pUNeg      = $aLin1[2];
         $nSumQtRes  = $aLin1[3];
         $nSumQtLib  = $aLin1[4];
         $nSumQtCanc = $aLin1[5];
         $nSumRes1   = $aLin1[6];
         $nSumRes2   = $aLin1[7]>0 ? $aLin1[7] : 0;
         fpc_append($sEcoTxt,"1.0) sKey=$pItem~$sCodigo~$pUNeg~$nSumQtRes~$nSumQtLib~$nSumQtCanc~$nSumRes1~$nSumRes2");
         
         if (in_array($pItem,$aArr_Insert)==false) {
            $aArr_Insert[] = $pItem;
            fpc_append($sEcoTxt,"1.1) sKey=$pItem~$sCodigo~$pUNeg~$nSumQtRes~$nSumQtLib~$nSumQtCanc~$nSumRes1~$nSumRes2");
         }
         if (isset($aItens[$pItem])==false) {
            $aItens[$pItem] = array($sCodigo,$pUNeg,$nSumQtRes,$nSumQtLib,$nSumQtCanc,$nSumRes1,$nSumRes2);
            fpc_append($sEcoTxt,"1.2) sKey=$pItem~$sCodigo~$pUNeg~$nSumQtRes~$nSumQtLib~$nSumQtCanc~$nSumRes1~$nSumRes2");
         }
      }
      $iCount_aArr_Insert = count($aArr_Insert);
      fpc_append($sEcoTxt,"iCount_aArr_Insert=$iCount_aArr_Insert");
      //fpc_append($sEcoTxt,implode(chr(10),$aArr_Insert));
   
      $aArr_Delete = array();
      foreach ($aDb2 as $aLin2) {
         $pItem      = $aLin2[0];
         $sCodigo    = $aLin2[1];
         $pUNeg      = $aLin2[2];
         $nSumQtRes  = $aLin2[3];
         $nSumQtLib  = $aLin2[4];
         $nSumQtCanc = $aLin2[5];
         $nSumRes1   = $aLin2[6];
         $nSumRes2   = $aLin2[7]>0 ? $aLin1[7] : 0;
         fpc_append($sEcoTxt,"2.0) sKey=$pItem~$sCodigo~$pUNeg~$nSumQtRes~$nSumQtLib~$nSumQtCanc~$nSumRes1~$nSumRes2");
         if (in_array($pItem,$aArr_Delete)==false) {
            $aArr_Delete[] = $pItem;
            fpc_append($sEcoTxt,"2.1) sKey=$pItem~$sCodigo~$pUNeg~$nSumQtRes~$nSumQtLib~$nSumQtCanc~$nSumRes1~$nSumRes2");
         }
         if (isset($aItens[$pItem])==false) {
            $aItens[$pItem] = array($sCodigo,$pUNeg,$nSumQtRes,$nSumQtLib,$nSumQtCanc,$nSumRes1,$nSumRes2);
            fpc_append($sEcoTxt,"2.2) sKey=$pItem~$sCodigo~$pUNeg~$nSumQtRes~$nSumQtLib~$nSumQtCanc~$nSumRes1~$nSumRes2");
         }
      }
      $iCount_aArr_Delete = count($aArr_Delete);
      fpc_append($sEcoTxt,"iCount_aArr_Delete=$iCount_aArr_Delete");
      //fpc_append($sEcoTxt,implode(chr(10),$aArr_Delete));
   
      // Insere na tabela Analise
      $sRegistros_Insert = '';
      $aDif_Insert = array_diff($aArr_Insert, $aArr_Delete);
      //$aDif_Insert = array_diff_key($aArr_Insert, $aArr_Delete);
   
      $iCount_aDif_Insert = count($aDif_Insert);
      fpc_append($sEcoTxt,"iCount_aDif_Insert=$iCount_aDif_Insert");
      if ($iCount_aDif_Insert>0) {
         
         foreach($aDif_Insert as $pItem) {
            $sCodigo    = $aItens[$pItem][0];
            $pUNeg      = $aItens[$pItem][1];
            $nSumQtRes  = $aItens[$pItem][2];
            $nSumQtLib  = $aItens[$pItem][3];
            $nSumQtCanc = $aItens[$pItem][4];
            $nSumRes1   = $aItens[$pItem][5];
            $nSumRes2   = $aItens[$pItem][6];

            fpc_append($sEcoTxt,"3.0) sKey=$pItem~$sCodigo~$pUNeg~$nSumQtRes~$nSumQtLib~$nSumQtCanc~$nSumRes1~$nSumRes2");

            
            $aIns = array();
            $aIns[] = array('pItem'     , $pItem     );
            $aIns[] = array('sCodigo'   , $sCodigo   );
            $aIns[] = array('pUNeg'     , $pUNeg     );
            $aIns[] = array('nSumQtRes' , $nSumQtRes );
            $aIns[] = array('nSumQtLib' , $nSumQtLib );
            $aIns[] = array('nSumQtCanc', $nSumQtCanc);
            $aIns[] = array('nSumRes1'  , $nSumRes1  );
            $aIns[] = array('nSumRes2'  , $nSumRes2  );
            
            $sSql = fsArrToInsert('TMP_Analise_Ordens_Itens',$aIns);
            fpc_append($sEcoTxt,"sSql=$sSql");
            $lOk  = flDbInsert($hDb,$sSql);
            fpc_append($sEcoTxt,"lOk=$lOk");
   
            if ($lOk==true) {
               $iKey = array_search($pItem, $aDif_Insert);
               fpc_append($sEcoTxt,"iKey=$iKey, pItem=$pItem");
               if($iKey!==false){
                  unset($aDif_Insert[$iKey]);
               }
               $sRegistros_Insert .= "<tr>";
               $sRegistros_Insert .= "<th style='border-bottom:1px dotted #BDB76B; background-color:#06334b; color:white; width:10%; padding:5px; border:0;'><img alt='INSERIDO' src='cid:my-attach-ok'></th>";
               $sRegistros_Insert .= "<th style='border-bottom:1px dotted #BDB76B; background-color:#06334b; color:white; width:90%; padding:5px; border:0;'>$pItem</th>";
               $sRegistros_Insert .= "<th style='border-bottom:1px dotted #BDB76B; background-color:#06334b; color:white; width:90%; padding:5px; border:0;'>$sCodigo</th>";
               $sRegistros_Insert .= "<th style='border-bottom:1px dotted #BDB76B; background-color:#06334b; color:white; width:90%; padding:5px; border:0;'>$pUNeg($aTQUNeg[$pUNeg])</th>";
               $sRegistros_Insert .= "<th style='border-bottom:1px dotted #BDB76B; background-color:#06334b; color:white; width:90%; padding:5px; border:0;'>$nSumQtRes</th>";
               $sRegistros_Insert .= "<th style='border-bottom:1px dotted #BDB76B; background-color:#06334b; color:white; width:90%; padding:5px; border:0;'>$nSumQtLib</th>";
               $sRegistros_Insert .= "<th style='border-bottom:1px dotted #BDB76B; background-color:#06334b; color:white; width:90%; padding:5px; border:0;'>$nSumQtCanc</th>";
               $sRegistros_Insert .= "<th style='border-bottom:1px dotted #BDB76B; background-color:#06334b; color:white; width:90%; padding:5px; border:0;'>$nSumRes1</th>";
               $sRegistros_Insert .= "<th style='border-bottom:1px dotted #BDB76B; background-color:#06334b; color:white; width:90%; padding:5px; border:0;'>$nSumRes2</th>";
               $sRegistros_Insert .= "</tr>";
            }
         }
      }
   
      $sRegistros_Delete = '';
      // Remove na tabela Analise
      $aDif_Delete = array_diff($aArr_Delete,$aArr_Insert);
      //$aDif_Delete = array_diff_key($aArr_Delete,$aArr_Insert);
      $iCount_aDif_Delete = count($aDif_Delete);
      fpc_append($sEcoTxt,"iCount_aDif_Delete=$iCount_aDif_Delete");
      if ($iCount_aDif_Delete>0) {

         foreach($aDif_Delete as $pItem) {
            $sCodigo    = $aItens[$pItem][0];
            $pUNeg      = $aItens[$pItem][1];
            $nSumQtRes  = $aItens[$pItem][2];
            $nSumQtLib  = $aItens[$pItem][3];
            $nSumQtCanc = $aItens[$pItem][4];
            $nSumRes1   = $aItens[$pItem][5];
            $nSumRes2   = $aItens[$pItem][6];

            fpc_append($sEcoTxt,"4.0) sKey=$pItem~$sCodigo~$pUNeg~$nSumQtRes~$nSumQtLib~$nSumQtCanc~$nSumRes1~$nSumRes2");
   
            $sSql = "delete from TMP_Analise_Ordens_Itens where pItem=$pItem";
            fpc_append($sEcoTxt,"sSql=$sSql");
            $lOk  = flDbDelete($hDb,$sSql);
            fpc_append($sEcoTxt,"lOk=$lOk");
   
            if ($lOk==true) {
               $sRegistros_Delete .= "<tr>";
               $sRegistros_Delete .= "<th style='border-bottom:1px dotted #BDB76B; background-color:#06334b; color:white; width:10%; padding:5px; border:0;'><img alt='EXCLUDO' src='cid:my-attach-error'></th>";
               $sRegistros_Delete .= "<th style='border-bottom:1px dotted #BDB76B; background-color:#06334b; color:white; width:90%; padding:5px; border:0;'>$pItem</th>";
               $sRegistros_Delete .= "<th style='border-bottom:1px dotted #BDB76B; background-color:#06334b; color:white; width:90%; padding:5px; border:0;'>$sCodigo</th>";
               $sRegistros_Delete .= "<th style='border-bottom:1px dotted #BDB76B; background-color:#06334b; color:white; width:90%; padding:5px; border:0;'>$pUNeg($aTQUNeg[$pUNeg])</th>";
               $sRegistros_Delete .= "<th style='border-bottom:1px dotted #BDB76B; background-color:#06334b; color:white; width:90%; padding:5px; border:0;'>$nSumQtRes</th>";
               $sRegistros_Delete .= "<th style='border-bottom:1px dotted #BDB76B; background-color:#06334b; color:white; width:90%; padding:5px; border:0;'>$nSumQtLib</th>";
               $sRegistros_Delete .= "<th style='border-bottom:1px dotted #BDB76B; background-color:#06334b; color:white; width:90%; padding:5px; border:0;'>$nSumQtCanc</th>";
               $sRegistros_Delete .= "<th style='border-bottom:1px dotted #BDB76B; background-color:#06334b; color:white; width:90%; padding:5px; border:0;'>$nSumRes1</th>";
               $sRegistros_Delete .= "<th style='border-bottom:1px dotted #BDB76B; background-color:#06334b; color:white; width:90%; padding:5px; border:0;'>$nSumRes2</th>";
               $sRegistros_Delete .= "</tr>";
            }
         }
      }
      $sRegistros_Restantes = '';
      $iRegistros_Restantes = 0;
      foreach ($aArr_Delete as $pItem) {
         if (!in_array($pItem,$aDif_Delete)) {
            $iRegistros_Restantes++;
   
            $sCodigo    = $aItens[$pItem][0];
            $pUNeg      = $aItens[$pItem][1];
            $nSumQtRes  = $aItens[$pItem][2];
            $nSumQtLib  = $aItens[$pItem][3];
            $nSumQtCanc = $aItens[$pItem][4];
            $nSumRes1   = $aItens[$pItem][5];
            $nSumRes2   = $aItens[$pItem][6];
   
            $sRegistros_Restantes .= "<tr>";
            $sRegistros_Restantes .= "<th style='border-bottom:1px dotted #BDB76B; background-color:#06334b; color:white; width:10%; padding:5px; border:0;'><img alt='RESTANTE' src='cid:my-attach-ok'></th>";
            $sRegistros_Restantes .= "<th style='border-bottom:1px dotted #BDB76B; background-color:#06334b; color:white; width:90%; padding:5px; border:0;'>$pItem</th>";
            $sRegistros_Restantes .= "<th style='border-bottom:1px dotted #BDB76B; background-color:#06334b; color:white; width:90%; padding:5px; border:0;'>$sCodigo</th>";
            $sRegistros_Restantes .= "<th style='border-bottom:1px dotted #BDB76B; background-color:#06334b; color:white; width:90%; padding:5px; border:0;'>$pUNeg($aTQUNeg[$pUNeg])</th>";
            $sRegistros_Restantes .= "<th style='border-bottom:1px dotted #BDB76B; background-color:#06334b; color:white; width:90%; padding:5px; border:0;'>$nSumQtRes</th>";
            $sRegistros_Restantes .= "<th style='border-bottom:1px dotted #BDB76B; background-color:#06334b; color:white; width:90%; padding:5px; border:0;'>$nSumQtLib</th>";
            $sRegistros_Restantes .= "<th style='border-bottom:1px dotted #BDB76B; background-color:#06334b; color:white; width:90%; padding:5px; border:0;'>$nSumQtCanc</th>";
            $sRegistros_Restantes .= "<th style='border-bottom:1px dotted #BDB76B; background-color:#06334b; color:white; width:90%; padding:5px; border:0;'>$nSumRes1</th>";
            $sRegistros_Restantes .= "<th style='border-bottom:1px dotted #BDB76B; background-color:#06334b; color:white; width:90%; padding:5px; border:0;'>$nSumRes2</th>";
            $sRegistros_Restantes .= "</tr>";
         }
      }
    //$lEmail=false;   // (*)
   } else {
      $lEmail=false;
   }   // ($iDb1!=$iDb2)

   // Salvando em Tabelas
   $sSql = 'select gen_id(ResLotOSa,0) from RDB$DATABASE';
   fpc_append($sEcoTxt,"sSql=$sSql");
   $aDb  = faDbSelect($hDb,$sSql);
   $pMax = $aDb[0][0];
   fpc_append($sEcoTxt,"pMax=$pMax");
   
   // Capa
   if ($lOk==true) {
      $sSql = "insert into ResLotOSa (pInc,iQry1,iQry2,iLinhas) values (1,$iDb1A,$iDb3,$iDb2)";
      fpc_append($sEcoTxt,"sSql=$sSql");
      $lOk = flDbInsert($hDb,$sSql);
      fpc_append($sEcoTxt,"lOk=$lOk");
   }

   if ($lOk==true) {
      $sSql = "select max(pPId) from ResLotOSa where pPId>$pMax";
      fpc_append($sEcoTxt,"sSql=$sSql");
      $aDb   = faDbSelect($hDb,$sSql);
      $pCapa = $aDb[0][0];
      fpc_append($sEcoTxt,"pCapa=$pCapa");
   }

   if ($lOk==true) {
      foreach ($aDb1 as $aLin1) {
         $pItem      = $aLin1[0];
         $sCodigo    = $aLin1[1];
         $pUNeg      = $aLin1[2];
         $nSumQtRes  = $aLin1[3];
         $nSumQtLib  = $aLin1[4];
         $nSumQtCanc = $aLin1[5];
         $nSumRes1   = $aLin1[6];
         $nSumRes2   = $aLin1[7]>0 ? $aLin1[7] : 0;
         $jOri       = $aLin1[8];
         $sSql = "insert into ResLotOSa_Itens (pInc,pCapa,pItem,jOri,nResOSa,nLibOSa,nCanOSa,nResDep,nResLot) values (1,$pCapa,$pItem,$jOri,$nSumQtRes,$nSumQtLib,$nSumQtCanc,$nSumRes1,$nSumRes2)";
         fpc_append($sEcoTxt,"sSql=$sSql");
         $lOk = flDbInsert($hDb,$sSql);
         fpc_append($sEcoTxt,"lOk=$lOk");
         if ($lOk==false) break;
      }
   }
   
   if ($lOk==true) {
      flDbCommit($hDb);
      fpc_append($sEcoTxt,'commit');
   } else {
      flDbRollBack($hDb);
      fpc_append($sEcoTxt,'rollback');
   }
   
   flDbDisconnect($hDb);
   
   //--> Envio Email
   fpc_append($sEcoTxt,"lOk=$lOk");
   fpc_append($sEcoTxt,"lEmail=$lEmail");
   if ($lEmail==true) {
   
      $sDateAnalise = date('d/m/Y H:i:s');
      fpc_append($sEcoTxt,"sDateAnalise=$sDateAnalise");
      $oMail = new PHPMailer();
      
      $oMail->IsSMTP(); 
      $oMail->Host       = 'smtp.gmail.com'; 
      $oMail->SMTPAuth   = true;
      $oMail->Username   = 'comercial@qtux.com.br';
      $oMail->Password   = 'qtux2486';
      $oMail->SMTPSecure = 'ssl';
      $oMail->Port       = '465';
      
      $oMail->From     = 'comercial@qtux.com.br';
      $oMail->Sender   = 'comercial@qtux.com.br';
      $oMail->FromName = 'QTUX';
      
      $oMail->AddAddress('ricardo@qtux.com.br','Ricardo');
      if($lDebug==false) $oMail->AddCC('fredy@qtux.com.br','Fredy');
      if($lDebug==false) $oMail->AddCC('henrique@qtux.com.br','Henrique');
      //if($lDebug==false) $oMail->AddCC('rafaelbmoreira@qtux.com.br','Rafael');
      
      $sMailTitle1  = "Analise automtica";
      $sMailTitle2  = "Inconsistncias no saldo dos itens";
      
      $oMail->IsHTML(true);
      
      //$sTit = "INCONSISTNCIAS NO SALDO DOS ITENS";
      $sTit = 'Boletim QTUX';
   
      $sHTML  = "<html><head>";
      $sHTML .= "<meta http-equiv='Content-Type' content='text/html; charset=ISO-8859-1' /></head>";
      $sHTML .= "<body style='background-color: #06334b;'>";
      $sHTML .= "<center>";
      $sHTML .= "<h2><b><font color='white'>$sMailTitle1</font></b></h2>";
      $sHTML .= "<h2><b><font color='white'>$sMailTitle2</font></b></h2>";
      $sHTML .= "</center>";
      $sHTML .= "<table style='background-color:#FFFFE0; border-collapse:collapse; color:#000; font-size:16px; width:100%; '>";
      
      $sHTML .= "<tr>
                  <th style='border-bottom:1px dotted #BDB76B; background-color:#06334b; color:white; padding:5px; border:0;'>
                     Anlise em : <font color='red'><b>$sDateAnalise</b></font><br>
                     <font color='red'>** ATENO ESSA ANLISE IR RODAR A CADA 15 MINUTOS**</font><br>
                     <font color='red'>** NECESSRIO ANALISAR AS LOGS NO PERIODO DO HORIO DESSA ANLISE**</font><br><br>
                  </th>
               </tr></table>";
   
      if ($iCount_aDif_Insert>0) {
         $sHTML .= "<br><table style='background-color:#FFFFE0; border-collapse:collapse; color:#000; font-size:16px; width:100%; '>";
         $sHTML .= "<tr>";
         $sHTML .= "<th style='background-color:#06334b; color:white; padding:5px; border:0;'>REGISTROS INLCUDOS NA ANLISE ($iCount_aDif_Insert)</th>";
         $sHTML .= "</tr>";
         $sHTML .= "</table>";
         $sHTML .= "<table style='background-color:#FFFFE0; border-collapse:collapse; color:#000; font-size:16px; width:100%; '>";
         $sHTML .= "<tr>";
         $sHTML .= "<th style='background-color:#BDB76B; color:white; padding:5px; border:0;'>###</th>";
         $sHTML .= "<th style='background-color:#BDB76B; color:white; padding:5px; border:0;'>PITEM</th>";
         $sHTML .= "<th style='background-color:#BDB76B; color:white; padding:5px; border:0;'>SCODIGO</th>";
         $sHTML .= "<th style='background-color:#BDB76B; color:white; padding:5px; border:0;'>PUNEG</th>";
         $sHTML .= "<th style='background-color:#BDB76B; color:white; padding:5px; border:0;'>NSUMQTRES</th>";
         $sHTML .= "<th style='background-color:#BDB76B; color:white; padding:5px; border:0;'>NSUMQTLIB</th>";
         $sHTML .= "<th style='background-color:#BDB76B; color:white; padding:5px; border:0;'>NSUMQTCANC</th>";
         $sHTML .= "<th style='background-color:#BDB76B; color:white; padding:5px; border:0;'>NSUMRES1</th>";
         $sHTML .= "<th style='background-color:#BDB76B; color:white; padding:5px; border:0;'>NSUMRES2</th>";
         $sHTML .= "</tr>";
         $sHTML .= $sRegistros_Insert;
         $sHTML .= "</table>";
      }
   
      if ($iCount_aDif_Delete>0) {
         $sHTML .= "<br><table style='background-color:#FFFFE0; border-collapse:collapse; color:#000; font-size:16px; width:100%; '>";
         $sHTML .= "<tr>";
         $sHTML .= "<th style='background-color:#06334b; color:white; padding:5px; border:0;'>REGISTROS EXCLUDOS DA ANLISE ($iCount_aDif_Delete)</th>";
         $sHTML .= "</tr>";
         $sHTML .= "</table>";
         $sHTML .= "<table style='background-color:#FFFFE0; border-collapse:collapse; color:#000; font-size:16px; width:100%; '>";
         $sHTML .= "<tr>";
         $sHTML .= "<th style='background-color:#BDB76B; color:white; padding:5px; border:0;'>###</th>";
         $sHTML .= "<th style='background-color:#BDB76B; color:white; padding:5px; border:0;'>PITEM</th>";
         $sHTML .= "<th style='background-color:#BDB76B; color:white; padding:5px; border:0;'>SCODIGO</th>";
         $sHTML .= "<th style='background-color:#BDB76B; color:white; padding:5px; border:0;'>PUNEG</th>";
         $sHTML .= "<th style='background-color:#BDB76B; color:white; padding:5px; border:0;'>NSUMQTRES</th>";
         $sHTML .= "<th style='background-color:#BDB76B; color:white; padding:5px; border:0;'>NSUMQTLIB</th>";
         $sHTML .= "<th style='background-color:#BDB76B; color:white; padding:5px; border:0;'>NSUMQTCANC</th>";
         $sHTML .= "<th style='background-color:#BDB76B; color:white; padding:5px; border:0;'>NSUMRES1</th>";
         $sHTML .= "<th style='background-color:#BDB76B; color:white; padding:5px; border:0;'>NSUMRES2</th>";
         $sHTML .= "</tr>";
         $sHTML .= $sRegistros_Delete;
         $sHTML .= "</table>";
      }
   
      if ($iRegistros_Restantes>0) {
         $sHTML .= "<br><table style='background-color:#FFFFE0; border-collapse:collapse; color:#000; font-size:16px; width:100%; '>";
         $sHTML .= "<tr>";
         $sHTML .= "<th style='background-color:#06334b; color:white; padding:5px; border:0;'>REGISTROS RESTANTES ($iRegistros_Restantes)</th>";
   
         $sHTML .= "<table style='background-color:#FFFFE0; border-collapse:collapse; color:#000; font-size:16px; width:100%; '>";
         $sHTML .= "<tr>";
         $sHTML .= "<th style='background-color:#BDB76B; color:white; padding:5px; border:0;'>###</th>";
         $sHTML .= "<th style='background-color:#BDB76B; color:white; padding:5px; border:0;'>PITEM</th>";
         $sHTML .= "<th style='background-color:#BDB76B; color:white; padding:5px; border:0;'>SCODIGO</th>";
         $sHTML .= "<th style='background-color:#BDB76B; color:white; padding:5px; border:0;'>PUNEG</th>";
         $sHTML .= "<th style='background-color:#BDB76B; color:white; padding:5px; border:0;'>NSUMQTRES</th>";
         $sHTML .= "<th style='background-color:#BDB76B; color:white; padding:5px; border:0;'>NSUMQTLIB</th>";
         $sHTML .= "<th style='background-color:#BDB76B; color:white; padding:5px; border:0;'>NSUMQTCANC</th>";
         $sHTML .= "<th style='background-color:#BDB76B; color:white; padding:5px; border:0;'>NSUMRES1</th>";
         $sHTML .= "<th style='background-color:#BDB76B; color:white; padding:5px; border:0;'>NSUMRES2</th>";
         $sHTML .= "</tr>";
   
         $sHTML .= $sRegistros_Restantes;
   
         $sHTML .= "</table>";
      }
   
      $sHTML .= "<center>";
      $sHTML .= "<font color='white'>Para maiores detalhes, por favor entre em contato com o Administrador de Sistemas.</font><br>";
      $sHTML .= "<img alt='QTUX' src='cid:my-attach-logo'><br>";
      //$sHTML .= "<font color='white'><b>&nbsp;Segue ao anexo as logs do processo</b></font>.";
      $sHTML .= "</center>";
      $sHTML .= "</body></html>";
   
      fpc_append($sEcoTxt,"$sHTML");
   
      $oMail->AddEmbeddedImage('/qtux/www/FullPlat/erpImages/logo-qtx-branco.png', 'my-attach-logo', 'logo-qtx-branco.png');
      
      if (strpos($sHTML,'my-attach-ok')) { // Para a imagem no ficar perdida nos anexos
         $oMail->AddEmbeddedImage('/qtux/www/FullPlat/erpImages/Email_Check_24x24.png', 'my-attach-ok', 'Email_Check_24x24.png');
      }
      if (strpos($sHTML,'my-attach-error')) { // Para a imagem no ficar perdida nos anexos
         $oMail->AddEmbeddedImage('/qtux/www/FullPlat/erpImages/Email_Error_24x24.png', 'my-attach-error', 'Email_Error_24x24.png');
      }
      
      $oMail->Subject = $sTit;
      $oMail->Body = $sHTML;
      //$oMail->AddAttachment("$sEcoTxt");
      
      $lEnviado = $oMail->Send();
      fpc_append($sEcoTxt,"lEnviado=$lEnviado");
   
      $oMail->ClearAllRecipients();
      $oMail->ClearAttachments();
      
      if ($lEnviado) {
         fpc_append($sEcoTxt,"E-mail enviado com sucesso!");
      } else {
         fpc_append($sEcoTxt,"No foi possvel enviar o e-mail.");
         fpc_append($sEcoTxt,"Informaes do erro: ".$oMail->ErrorInfo);
      }
   } // if ($lEmail==true)
   
//<--
} // if ($lControlProc==false)
   
$tJobEnd  = time();
$iJobElap = $tJobEnd-$tJobStart;
fpc_append($sEcoTxt,'Durao do processo em milisegundos: '.$iJobElap);
fpc_append($sEcoTxt,'Final: '.date('d/m/Y H:i:s',$tJobEnd));

$aTop    = faLoadAvgServer();
$nTopFin = $aTop[0];

list($iUsec, $iSec) = explode(' ', microtime());
$tScript_End = (float) $iSec + (float) $iUsec;

$tElapsed_Time = round($tScript_End - $tScript_Start, 5);
fpc_append($sEcoTxt,"Tempo Decorrido: ".gmdate("H:i:s", $tElapsed_Time).', Secs: '.$tElapsed_Time.". Memoria usada: ".round(((memory_get_peak_usage(true) / 1024) / 1024), 2)."Mb");
fpc_append($sEcoTxt,'----------------------------------------------------------------------------'.chr(10).chr(10));   