#!/bin/bash

:<<'DESCRICAO'
   Script criado por Ricardo Gomes Frana

   Script CriarEstrturaLogs.sh tem como finalidade a antecipao da criao dos diretorios das logs para o prximo ms,
   dessa forma evitando possiveis erros de permisses nos diretrios.

   O Script CriarEstrturaLogs.sh esta na crontab do linux, que ir rodar nos dias 28,29,30,31, mas s ir rodar de fato se o dia de amanh for 01.
   
   Segue o Comando que esta na cron:
      01 00 28-31 *    *  /qtux/www/FullPlat/processos/Sistema/crons/CriarEstrturaLogs.sh

   Nesse Script fao a primeira comparao para saber se o prximo dia  01, caso seja o script continua o curso para criar os diretorios.
   A variavel iMesAtual tem como referencia o ms atual, caso o a var iMesAtual seja 12, antecipo a Variavel sAno adicionando um ano, dessa forma, 
   caso o ano seja 2017 e o ms 12, a variavel sAno ir receber o ano de 2018
   A variavel iMes recebe o valor do proximo ms, fao a adio de 5 dias, dessa forma, fazendo com que o script saiba qual  o proximo ms e identifique nos ifs quantos dias tem o 
   prximo ms e adicionando o na variavel iDias a quantidade referente.
   Note que precisei fazer uma manobra no ms de fevereiro, essa manobra  para saber se o ano  bissexto ou no, se for bissexto a lgica adiciona 29 dias ao ms.
   Depois que o script ja sabe qual  o ano, ms e dias,  feito um lao de repetio para a criao dos diretorios e atribuir as permisses totais de escrita.
   A lgica serve para o diretorio das logs da plataforma/processos e para as logs do sistema.

DESCRICAO

if [ $(date +%d -d tomorrow) == 01 ]; then
   iMesAtual=$(date +'%m')

   if [ $iMesAtual == 12 ]; then
      sAno=$(date -d "+1 years" '+%Y')
   else
      sAno=$(date +"%Y")
   fi
   
   iMes=$(date -d "+5 day" '+%m') 
   
   if [ $iMes == 01 ]; then
      sMes=Janeiro
      iDias=31
   elif [ $iMes == 02 ]; then
      sMes=Fevereiro
      if [ \( $(expr "$sAno" % 4) -eq 0 -a $(expr "$sAno" % 100) -ne 0 \) -o \( $(expr "$sAno" % 400) -eq 0 \) ];then
         #echo "$sAno ano bissexto"
         iDias=29
      else
         #echo "$sAno ano normal"
         iDias=28
      fi
   elif [ $iMes == 03 ]; then
      sMes=Marco
      iDias=31
   elif [ $iMes == 04 ]; then
      sMes=Abril
      iDias=30
   elif [ $iMes == 05 ]; then
      sMes=Maio
      iDias=31
   elif [ $iMes == 06 ]; then
      sMes=Junho
      iDias=30
   elif [ $iMes == 07 ]; then
      sMes=Julho
      iDias=31
   elif [ $iMes == 08 ]; then
      sMes=Agosto
      iDias=31
   elif [ $iMes == 09 ]; then
      sMes=Setembro
      iDias=30
   elif [ $iMes == 10 ]; then
      sMes=Outubro
      iDias=31
   elif [ $iMes == 11 ]; then
      sMes=Novembro
      iDias=30
   elif [ $iMes == 12 ]; then
      sMes=Dezembro
      iDias=31
   fi
   
   #echo "iMes=$iMes | iDias=$iDias | sAno=$sAno"
   
   sDirMes=$iMes'_'$sMes'_'$sAno
   sDirDest=/qtux/www/FullPlat/processos/logs/$sDirMes
   
   if [ -d $sDirDest ]; then
      for i in `seq 1 $iDias`
      do
         if [ $i -lt 10 ]; then
            iDir=0$i
         else
            iDir=$i
         fi
      
         #echo $sDirDest/$iDir/
         mkdir $sDirDest/$iDir/
         chmod 777 $sDirDest/$iDir/
      done
   else
      mkdir $sDirDest
      chmod 777 $sDirDest
      if [ -d $sDirDest ]; then
         for i in `seq 1 $iDias`
         do
            if [ $i -lt 10 ]; then
               iDir=0$i
            else
               iDir=$i
            fi
         
            #echo $sDirDest/$iDir/
            mkdir $sDirDest/$iDir/
            chmod 777 $sDirDest/$iDir/
         done
      fi
   fi

   sDirDest=/qtux/www/FullPlat/processos/logs/$sDirMes/Sistema
   
   if [ -d $sDirDest ]; then
      for i in `seq 1 $iDias`
      do
         if [ $i -lt 10 ]; then
            iDir=0$i
         else
            iDir=$i
         fi
      
         #echo $sDirDest/$iDir/
         mkdir $sDirDest/$iDir/
         chmod 777 $sDirDest/$iDir/
      done
   else
      mkdir $sDirDest
      chmod 777 $sDirDest
      if [ -d $sDirDest ]; then
         for i in `seq 1 $iDias`
         do
            if [ $i -lt 10 ]; then
               iDir=0$i
            else
               iDir=$i
            fi
         
            #echo $sDirDest/$iDir/
            mkdir $sDirDest/$iDir/
            chmod 777 $sDirDest/$iDir/
         done
      fi
   fi

fi 