<?php
set_time_limit(300); 
require_once("/qtux/www/FullPlat/pFuncoes1.php");
require_once("/qtux/www/FullPlat/pPublics1.php");

list($iUsec, $iSec) = explode(' ', microtime());
$tScript_Start = (float) $iSec + (float) $iUsec;

$aTop      = faLoadAvgServer();
$nTopIni   = $aTop[0];
$tJobStart = time();
$sProc     = basename(__FILE__);
$lOk       = true;

$sHOST = exec('hostname');
if ($sHOST == 'qtuxap.sanol.com.br') {
   $sDSN = '192.168.1.109:/qtux/database/total/gps_01.gdb';
   $sCliPasta = 'total';
} else if ($sHOST=='homologqtuxweb.sanol.com.br') {
   $sDSN = 'localhost:/qtux/database/total/gps_01.gdb';
   $sCliPasta = 'total';
} else {
   $sDSN = 'localhost:/qtux/database/tq/gps_01.gdb';
   $sCliPasta = 'desenvolvimento';
}

$sEcoTxt = '/qtux/www/FullPlat/processos/logs/'.str_replace('.','_',$sProc).'-'.$tJobStart.'.log';
$sEcoTxt = fsDirEcoTxt($sEcoTxt);
$iProcID = getmypid();

fpc($sEcoTxt,'iProcID='.$iProcID);
fpc_append($sEcoTxt,'Incio em ' . date('d/m/Y H:i:s',$tJobStart));

$hDb = fhDbConnect($sDSN);

$sSql = "select count(*) from Ordens_PreOCa_Login where iVer = iVAt and cast(tIn0 as date) <= dateadd(day, -2, current_date)";
fpc_append($sEcoTxt,"sSql=$sSql");
$aDb = faDbSelect($hDb,$sSql);
$iDb = $aDb[0][0];
fpc_append($sEcoTxt,"iDb=$iDb");

if ($iDb>0) {
   $sSql = "delete from Ordens_PreOCa_Login where cast(tIn0 as date) <= dateadd(day, -2, current_date)";
   fpc_append($sEcoTxt,"sSql=$sSql");
   $lOk = flDbDelete($hDb,$sSql);
   fpc_append($sEcoTxt,"lOk=$lOk");
}

if ($lOk==true) {
   flDbCommit($hDb);
   fpc_append($sEcoTxt,'commit');
} else {
   flDbRollBack($hDb);
   fpc_append($sEcoTxt,'rollback');
}

flDbDisconnect($hDb);

$tJobEnd  = time();
$iJobElap = $tJobEnd-$tJobStart;
fpc_append($sEcoTxt,'Durao do processo em milisegundos: '.$iJobElap);
fpc_append($sEcoTxt,'Final: '.date('d/m/Y H:i:s',$tJobEnd));

$aTop    = faLoadAvgServer();
$nTopFin = $aTop[0];

list($iUsec, $iSec) = explode(' ', microtime());
$tScript_End = (float) $iSec + (float) $iUsec;

$tElapsed_Time = round($tScript_End - $tScript_Start, 5);
fpc_append($sEcoTxt,"Tempo Decorrido: ".gmdate("H:i:s", $tElapsed_Time).', Secs: '.$tElapsed_Time.". Memoria usada: ".round(((memory_get_peak_usage(true) / 1024) / 1024), 2)."Mb");
fpc_append($sEcoTxt,'----------------------------------------------------------------------------'.chr(10).chr(10));
