<?php
set_time_limit(7200);
date_default_timezone_set('America/Sao_Paulo');
require_once("/qtux/www/FullPlat/pFuncoes1.php");
require_once("/qtux/www/FullPlat/pPublics1.php");
require("/qtux/library/PHPMailer-master/PHPMailerAutoload.php");

list($iUsec, $iSec) = explode(' ', microtime());
$tScript_Start = (float) $iSec + (float) $iUsec;

$aTop      = faLoadAvgServer();
$nTopIni   = $aTop[0];
$tJobStart = time();
$sProc     = basename(__FILE__);
$lOk       = true;

$sHOST = exec('hostname');
if ($sHOST == 'qtuxap.sanol.com.br') {
   $sDSN = '192.168.1.109:/qtux/database/total/gps_01.gdb';
   $sCliPasta = 'total';
} else if ($sHOST=='homologqtuxweb.sanol.com.br') {
   $sDSN = 'localhost:/qtux/database/total/gps_01.gdb';
   $sCliPasta = 'total';
} else {
   $sDSN = 'localhost:/qtux/database/tq/gps_01.gdb';
   $sCliPasta = 'desenvolvimento';
}

$sEcoTxt = '/qtux/www/FullPlat/processos/logs/'.str_replace('.','_',$sProc).'-'.$tJobStart.'.log';
$sEcoTxt = fsDirEcoTxt($sEcoTxt);
$iProcID = getmypid();

$lDebug = true;
$lEmail = true;

fpc($sEcoTxt,'iProcID='.$iProcID);
fpc_append($sEcoTxt,'Incio em ' . date('d/m/Y H:i:s',$tJobStart));

$hDb = fhDbConnect($sDSN);

$sSql1 = "select a.pItem,
                 c.sCodigo,
                 c.pUNeg,
                 cast(sum(a.nQtRes) as numeric(12,2)),
                 cast(sum(a.nQtLib) as numeric(12,2)),
                 cast(sum(a.nQtCanc) as numeric(12,2)),
                 (select cast(sum(aa.nRes) as numeric(12,2)) from EST_RegDepositos aa where aa.pItem=a.pItem and aa.iVer=aa.iVAt),
                 (select cast(sum(bb.nRes) as numeric(12,2)) from EST_RegDepositos ab join EST_LotesSaldos bb on ab.pItem=a.pItem and ab.iVer=ab.iVAt and bb.pRegDep=ab.pPId and bb.iVer=bb.iVAt and bb.nRes>0)
            from Ordens_Itens  a      join Ordens b on a.pOrdem = b.pPId   and b.iVer = b.iVAt and b.tCanc is null and b.jFase<8
                                      join Itens  c on a.pItem  = c.pPId   and c.iVer = c.iVAt
                                 left join PreNF  d on a.pOrdem = d.pOrdem and d.iVer=d.iVAt and d.tNFCapaCanc is null
           where a.lExc = 0
             and b.lExc = 0
             and a.iVer = a.iVAt
             and a.nQtRes-a.nQtFat-a.nQtCanc>0
           group by a.pItem,
                    c.sCodigo,
                    c.pUNeg
          having     (sum(a.nQtRes) <> (select sum(aa.nRes) from EST_RegDepositos aa where aa.pItem=a.pItem and aa.iVer=aa.iVAt))
                  or (sum(a.nQtLib) <> (select sum(bb.nRes) from EST_RegDepositos ab join EST_LotesSaldos bb on ab.pItem=a.pItem and ab.iVer=ab.iVAt and bb.pRegDep=ab.pPId and bb.iVer=bb.iVAt and bb.nRes>0))";
fpc_append($sEcoTxt,"sSql1=$sSql1");
$aDb1 = faDbSelect($hDb,$sSql1);
$iDb1 = count($aDb1);
fpc_append($sEcoTxt,"iDb1=$iDb1");

//var_dump($aDb1);

$sSql2 = "select pItem,
                 sCodigo,
                 pUNeg,
                 cast(nSumQtRes as numeric(12,2)),
                 cast(nSumQtLib as numeric(12,2)),
                 cast(nSumQtCanc as numeric(12,2)),
                 cast(nSumRes1 as numeric(12,2)),
                 cast(nSumRes2 as numeric(12,2))
            from TMP_Analise_Ordens_Itens 
           where iVer = iVAt
             and lExc = 0";

fpc_append($sEcoTxt,"sSql2=$sSql2");
$aDb2 = faDbSelect($hDb,$sSql2);
$iDb2 = count($aDb2);
fpc_append($sEcoTxt,"iDb2=$iDb2");

if ($iDb1!=$iDb2) {
   fpc_append($sEcoTxt,"$iDb1!=$iDb2");
   $aArr_Insert = array();
   foreach ($aDb1 as $aLin1) {
      $pItem      = $aLin1[0];
      $sCodigo    = $aLin1[1];
      $pUNeg      = $aLin1[2];
      $nSumQtRes  = $aLin1[3];
      $nSumQtLib  = $aLin1[4];
      $nSumQtCanc = $aLin1[5];
      $nSumRes1   = $aLin1[6];
      $nSumRes2   = $aLin1[7];
      if (in_array("$pItem~$sCodigo~$pUNeg~$nSumQtRes~$nSumQtLib~$nSumQtCanc~$nSumRes1~$nSumRes2",$aArr_Insert)==false) $aArr_Insert[] = "$pItem~$sCodigo~$pUNeg~$nSumQtRes~$nSumQtLib~$nSumQtCanc~$nSumRes1~$nSumRes2";
   }
   $iCount_aArr_Insert = count($aArr_Insert);
   fpc_append($sEcoTxt,"iCount_aArr_Insert=$iCount_aArr_Insert");
   //fpc_append($sEcoTxt,implode(chr(10),$aArr_Insert));

   $aArr_Delete = array();
   foreach ($aDb2 as $aLin2) {
      $pItem      = $aLin2[0];
      $sCodigo    = $aLin2[1];
      $pUNeg      = $aLin2[2];
      $nSumQtRes  = $aLin2[3];
      $nSumQtLib  = $aLin2[4];
      $nSumQtCanc = $aLin2[5];
      $nSumRes1   = $aLin2[6];
      $nSumRes2   = $aLin2[7];
      if (in_array("$pItem~$sCodigo~$pUNeg~$nSumQtRes~$nSumQtLib~$nSumQtCanc~$nSumRes1~$nSumRes2",$aArr_Delete)==false) $aArr_Delete[] = "$pItem~$sCodigo~$pUNeg~$nSumQtRes~$nSumQtLib~$nSumQtCanc~$nSumRes1~$nSumRes2";
   }
   $iCount_aArr_Delete = count($aArr_Delete);
   fpc_append($sEcoTxt,"iCount_aArr_Delete=$iCount_aArr_Delete");
   //fpc_append($sEcoTxt,implode(chr(10),$aArr_Delete));
   


   // Insere na tabela Analise
   $sRegistros_Insert = '';
   $aDif_Insert = array_diff($aArr_Insert, $aArr_Delete);
   $iCount_aDif_Insert = count($aDif_Insert);
   fpc_append($sEcoTxt,"iCount_aDif_Insert=$iCount_aDif_Insert");
   if ($iCount_aDif_Insert>0) {
      
      foreach($aDif_Insert as $aLin) {
         $aLin = explode('~',$aLin);

         $aIns = array();
         $aIns[] = array('pItem'     , $aLin[0]);
         $aIns[] = array('sCodigo'   , $aLin[1]);
         $aIns[] = array('pUNeg'     , $aLin[2]);
         $aIns[] = array('nSumQtRes' , $aLin[3]);
         $aIns[] = array('nSumQtLib' , $aLin[4]);
         $aIns[] = array('nSumQtCanc', $aLin[5]);
         $aIns[] = array('nSumRes1'  , $aLin[6]);
         $aIns[] = array('nSumRes2'  , $aLin[7]);
         
         $sSql = fsArrToInsert('TMP_Analise_Ordens_Itens',$aIns);
         fpc_append($sEcoTxt,"sSql=$sSql");
         $lOk  = flDbInsert($hDb,$sSql);
         fpc_append($sEcoTxt,"lOk=$lOk");

         if ($lOk==true) {
            $sRegistros_Insert .= "<tr>";
            $sRegistros_Insert .= "<th style='border-bottom:1px dotted #BDB76B; background-color:#06334b; color:white; width:10%; padding:5px; border:0;'><img alt='INSERIDO' src='cid:my-attach-ok'></th>";
            $sRegistros_Insert .= "<th style='border-bottom:1px dotted #BDB76B; background-color:#06334b; color:white; width:90%; padding:5px; border:0;'>$pItem</th>";
            $sRegistros_Insert .= "<th style='border-bottom:1px dotted #BDB76B; background-color:#06334b; color:white; width:90%; padding:5px; border:0;'>$sCodigo</th>";
            $sRegistros_Insert .= "<th style='border-bottom:1px dotted #BDB76B; background-color:#06334b; color:white; width:90%; padding:5px; border:0;'>$pUNeg</th>";
            $sRegistros_Insert .= "<th style='border-bottom:1px dotted #BDB76B; background-color:#06334b; color:white; width:90%; padding:5px; border:0;'>$nSumQtRes</th>";
            $sRegistros_Insert .= "<th style='border-bottom:1px dotted #BDB76B; background-color:#06334b; color:white; width:90%; padding:5px; border:0;'>$nSumQtLib</th>";
            $sRegistros_Insert .= "<th style='border-bottom:1px dotted #BDB76B; background-color:#06334b; color:white; width:90%; padding:5px; border:0;'>$nSumQtCanc</th>";
            $sRegistros_Insert .= "<th style='border-bottom:1px dotted #BDB76B; background-color:#06334b; color:white; width:90%; padding:5px; border:0;'>$nSumRes1</th>";
            $sRegistros_Insert .= "<th style='border-bottom:1px dotted #BDB76B; background-color:#06334b; color:white; width:90%; padding:5px; border:0;'>$nSumRes2</th>";
            $sRegistros_Insert .= "</tr>";
         }
      }
   }

   $sRegistros_Delete = '';
   // Remove na tabela Analise
   $aDif_Delete = array_diff($aArr_Delete,$aArr_Insert);
   $iCount_aDif_Delete = count($aDif_Delete);
   fpc_append($sEcoTxt,"iCount_aDif_Delete=$iCount_aDif_Delete");
   if ($iCount_aDif_Delete>0) {
      foreach($aDif_Delete as $aLin) {
         $aLin = explode('~',$aLin);

         $pItem      = $aLin[0];
         $sCodigo    = $aLin[1];
         $pUNeg      = $aLin[2];
         $nSumQtRes  = $aLin[3];
         $nSumQtLib  = $aLin[4];
         $nSumQtCanc = $aLin[5];
         $nSumRes1   = $aLin[6];
         $nSumRes2   = $aLin[7];

         $sSql = "delete from TMP_Analise_Ordens_Itens where pItem=$pItem and sCodigo='$sCodigo' and pUNeg=$pUNeg and nSumQtRes=$nSumQtRes and nSumQtLib=$nSumQtLib and nSumQtCanc=$nSumQtCanc and nSumRes1=$nSumRes1 and nSumRes2=$nSumRes2";
         fpc_append($sEcoTxt,"sSql=$sSql");
         $lOk  = flDbDelete($hDb,$sSql);
         fpc_append($sEcoTxt,"lOk=$lOk");

         if ($lOk==true) {
            $sRegistros_Delete .= "<tr>";
            $sRegistros_Delete .= "<th style='border-bottom:1px dotted #BDB76B; background-color:#06334b; color:white; width:10%; padding:5px; border:0;'><img alt='EXCLUDO' src='cid:my-attach-error'></th>";
            $sRegistros_Delete .= "<th style='border-bottom:1px dotted #BDB76B; background-color:#06334b; color:white; width:90%; padding:5px; border:0;'>$pItem</th>";
            $sRegistros_Delete .= "<th style='border-bottom:1px dotted #BDB76B; background-color:#06334b; color:white; width:90%; padding:5px; border:0;'>$sCodigo</th>";
            $sRegistros_Delete .= "<th style='border-bottom:1px dotted #BDB76B; background-color:#06334b; color:white; width:90%; padding:5px; border:0;'>$pUNeg</th>";
            $sRegistros_Delete .= "<th style='border-bottom:1px dotted #BDB76B; background-color:#06334b; color:white; width:90%; padding:5px; border:0;'>$nSumQtRes</th>";
            $sRegistros_Delete .= "<th style='border-bottom:1px dotted #BDB76B; background-color:#06334b; color:white; width:90%; padding:5px; border:0;'>$nSumQtLib</th>";
            $sRegistros_Delete .= "<th style='border-bottom:1px dotted #BDB76B; background-color:#06334b; color:white; width:90%; padding:5px; border:0;'>$nSumQtCanc</th>";
            $sRegistros_Delete .= "<th style='border-bottom:1px dotted #BDB76B; background-color:#06334b; color:white; width:90%; padding:5px; border:0;'>$nSumRes1</th>";
            $sRegistros_Delete .= "<th style='border-bottom:1px dotted #BDB76B; background-color:#06334b; color:white; width:90%; padding:5px; border:0;'>$nSumRes2</th>";
            $sRegistros_Delete .= "</tr>";
         }
      }
   }
   $sRegistros_Restantes = '';
   foreach ($aArr_Delete as $aLin) {
      if (!in_array($aLin,$aDif_Delete)) {
         $aLin = explode('~',$aLin);

         $pItem      = $aLin[0];
         $sCodigo    = $aLin[1];
         $pUNeg      = $aLin[2];
         $nSumQtRes  = $aLin[3];
         $nSumQtLib  = $aLin[4];
         $nSumQtCanc = $aLin[5];
         $nSumRes1   = $aLin[6];
         $nSumRes2   = $aLin[7];

         $sRegistros_Restantes .= "<tr>";
         $sRegistros_Restantes .= "<th style='border-bottom:1px dotted #BDB76B; background-color:#06334b; color:white; width:10%; padding:5px; border:0;'><img alt='RESTANTE' src='cid:my-attach-ok'></th>";
         $sRegistros_Restantes .= "<th style='border-bottom:1px dotted #BDB76B; background-color:#06334b; color:white; width:90%; padding:5px; border:0;'>$pItem</th>";
         $sRegistros_Restantes .= "<th style='border-bottom:1px dotted #BDB76B; background-color:#06334b; color:white; width:90%; padding:5px; border:0;'>$sCodigo</th>";
         $sRegistros_Restantes .= "<th style='border-bottom:1px dotted #BDB76B; background-color:#06334b; color:white; width:90%; padding:5px; border:0;'>$pUNeg</th>";
         $sRegistros_Restantes .= "<th style='border-bottom:1px dotted #BDB76B; background-color:#06334b; color:white; width:90%; padding:5px; border:0;'>$nSumQtRes</th>";
         $sRegistros_Restantes .= "<th style='border-bottom:1px dotted #BDB76B; background-color:#06334b; color:white; width:90%; padding:5px; border:0;'>$nSumQtLib</th>";
         $sRegistros_Restantes .= "<th style='border-bottom:1px dotted #BDB76B; background-color:#06334b; color:white; width:90%; padding:5px; border:0;'>$nSumQtCanc</th>";
         $sRegistros_Restantes .= "<th style='border-bottom:1px dotted #BDB76B; background-color:#06334b; color:white; width:90%; padding:5px; border:0;'>$nSumRes1</th>";
         $sRegistros_Restantes .= "<th style='border-bottom:1px dotted #BDB76B; background-color:#06334b; color:white; width:90%; padding:5px; border:0;'>$nSumRes2</th>";
         $sRegistros_Restantes .= "</tr>";
      }
   }
} else {
   $lEmail=false;
}

if ($lOk==true) {
   flDbCommit($hDb);
   fpc_append($sEcoTxt,'commit');
} else {
   flDbRollBack($hDb);
   fpc_append($sEcoTxt,'rollback');
}

flDbDisconnect($hDb);

//--> Envio Email
fpc_append($sEcoTxt,"lOk = $lOk");
fpc_append($sEcoTxt,"-- Final ---");

if ($lEmail==true) {
   $sDateAnalise = date('d/m/Y H:i:s');
   $oMail = new PHPMailer();
   
   $oMail->IsSMTP(); 
   $oMail->Host       = 'smtp.gmail.com'; 
   $oMail->SMTPAuth   = true;
   $oMail->Username   = 'comercial@qtux.com.br';
   $oMail->Password   = 'qtux2486';
   $oMail->SMTPSecure = 'ssl';
   $oMail->Port       = '465';
   
   $oMail->From     = 'comercial@qtux.com.br';
   $oMail->Sender   = 'comercial@qtux.com.br';
   $oMail->FromName = 'QTUX';
   
   $oMail->AddAddress('ricardo@qtux.com.br','Ricardo');
   if($lDebug==false) $oMail->AddCC('fredy@qtux.com.br','Fredy');
   if($lDebug==false) $oMail->AddCC('henrique@qtux.com.br','Henrique');
   if($lDebug==false) $oMail->AddCC('rafaelbmoreira@qtux.com.br','Rafael');
   
   $sMailTitle1  = "Analise automtica";
   $sMailTitle2  = "Inconsistncias no saldo dos itens";
   
   $oMail->IsHTML(true);
   
   $sTit = "INCONSISTNCIAS NO SALDO DOS ITENS";

   $sHTML  = "<html><head>";
   $sHTML .= "<meta http-equiv='Content-Type' content='text/html; charset=ISO-8859-1' /></head>";
   $sHTML .= "<body style='background-color: #06334b;'>";
   $sHTML .= "<center>";
   $sHTML .= "<h2><b><font color='white'>$sMailTitle1</font></b></h2>";
   $sHTML .= "<h2><b><font color='white'>$sMailTitle2</font></b></h2>";
   $sHTML .= "</center>";
   $sHTML .= "<table style='background-color:#FFFFE0; border-collapse:collapse; color:#000; font-size:16px; width:100%; '>";
   
   $sHTML .= "<tr>
               <th style='border-bottom:1px dotted #BDB76B; background-color:#06334b; color:white; padding:5px; border:0;'>
                  Anlise em : <font color='red'><b>$sDateAnalise</b></font><br>
                  <font color='red'>** ATENO ESSA ANLISE IR RODAR DE HORA EM HORA**</font><br>
                  <font color='red'>** NECESSRIO ANALISAR AS LOGS NO PERIODO DE MENOS UM HORA DO HORIO DESSA ANLISE**</font><br><br>
               </th>
            </tr></table>";
   $sHTML .= "<br><table style='background-color:#FFFFE0; border-collapse:collapse; color:#000; font-size:16px; width:100%; '>";
   $sHTML .= "<tr>";
   if ($sRegistros_Delete<>'') {
      $sHTML .= "<th style='background-color:#06334b; color:white; padding:5px; border:0;'>REGISTROS EXCLUDOS </th>";
   }
   if ($sRegistros_Insert<>'') {
      $sHTML .= "<th style='background-color:#06334b; color:white; padding:5px; border:0;'>REGISTROS INLCUDOS</th>";
   }

   $sHTML .= "</tr>";
   $sHTML .= "</table>";
   $sHTML .= "<table style='background-color:#FFFFE0; border-collapse:collapse; color:#000; font-size:16px; width:100%; '>";
   $sHTML .= "<tr>";
   $sHTML .= "<th style='background-color:#BDB76B; color:white; padding:5px; border:0;'>###</th>";
   $sHTML .= "<th style='background-color:#BDB76B; color:white; padding:5px; border:0;'>PITEM</th>";
   $sHTML .= "<th style='background-color:#BDB76B; color:white; padding:5px; border:0;'>SCODIGO</th>";
   $sHTML .= "<th style='background-color:#BDB76B; color:white; padding:5px; border:0;'>PUNEG</th>";
   $sHTML .= "<th style='background-color:#BDB76B; color:white; padding:5px; border:0;'>NSUMQTRES</th>";
   $sHTML .= "<th style='background-color:#BDB76B; color:white; padding:5px; border:0;'>NSUMQTLIB</th>";
   $sHTML .= "<th style='background-color:#BDB76B; color:white; padding:5px; border:0;'>NSUMQTCANC</th>";
   $sHTML .= "<th style='background-color:#BDB76B; color:white; padding:5px; border:0;'>NSUMRES1</th>";
   $sHTML .= "<th style='background-color:#BDB76B; color:white; padding:5px; border:0;'>NSUMRES2</th>";
   $sHTML .= "</tr>";

   $sHTML .= $sRegistros_Delete;

   $sHTML .= $sRegistros_Insert;
   
   $sHTML .= "</table>";

   if ($sRegistros_Restantes<>'') {
      $sHTML .= "<br><table style='background-color:#FFFFE0; border-collapse:collapse; color:#000; font-size:16px; width:100%; '>";
      $sHTML .= "<tr>";
      $sHTML .= "<th style='background-color:#06334b; color:white; padding:5px; border:0;'>REGISTROS RESTANTES</th>";

      $sHTML .= "<table style='background-color:#FFFFE0; border-collapse:collapse; color:#000; font-size:16px; width:100%; '>";
      $sHTML .= "<tr>";
      $sHTML .= "<th style='background-color:#BDB76B; color:white; padding:5px; border:0;'>###</th>";
      $sHTML .= "<th style='background-color:#BDB76B; color:white; padding:5px; border:0;'>PITEM</th>";
      $sHTML .= "<th style='background-color:#BDB76B; color:white; padding:5px; border:0;'>SCODIGO</th>";
      $sHTML .= "<th style='background-color:#BDB76B; color:white; padding:5px; border:0;'>PUNEG</th>";
      $sHTML .= "<th style='background-color:#BDB76B; color:white; padding:5px; border:0;'>NSUMQTRES</th>";
      $sHTML .= "<th style='background-color:#BDB76B; color:white; padding:5px; border:0;'>NSUMQTLIB</th>";
      $sHTML .= "<th style='background-color:#BDB76B; color:white; padding:5px; border:0;'>NSUMQTCANC</th>";
      $sHTML .= "<th style='background-color:#BDB76B; color:white; padding:5px; border:0;'>NSUMRES1</th>";
      $sHTML .= "<th style='background-color:#BDB76B; color:white; padding:5px; border:0;'>NSUMRES2</th>";
      $sHTML .= "</tr>";

      $sHTML .= $sRegistros_Restantes;

      $sHTML .= "</table>";
   }

   $sHTML .= "<center>";
   $sHTML .= "<font color='white'>Para maiores detalhes, por favor entre em contato com o Administrador de Sistemas.</font><br>";
   $sHTML .= "<img alt='QTUX' src='cid:my-attach-logo'><br>";
//   $sHTML .= "<font color='white'><b>&nbsp;Segue ao anexo as logs do processo</b></font>.";
   $sHTML .= "</center>";
   $sHTML .= "</body></html>";

   fpc_append($sEcoTxt,"$sHTML");

   $oMail->AddEmbeddedImage('/home/qtux/www/FullPlat/erpImages/logo-qtx-branco.png', 'my-attach-logo', 'logo-qtx-branco.png');
   
   if (strpos($sHTML,'my-attach-ok')) { // Para a imagem no ficar perdida nos anexos
      $oMail->AddEmbeddedImage('/home/qtux/www/FullPlat/erpImages/Email_Check_24x24.png', 'my-attach-ok', 'Email_Check_24x24.png');
   }
   if (strpos($sHTML,'my-attach-error')) { // Para a imagem no ficar perdida nos anexos
      $oMail->AddEmbeddedImage('/home/qtux/www/FullPlat/erpImages/Email_Error_24x24.png', 'my-attach-error', 'Email_Error_24x24.png');
   }
   
   $oMail->Subject = $sTit;
   $oMail->Body = $sHTML;
//   $oMail->AddAttachment("$sEcoTxt");
   
   $lEnviado = $oMail->Send();
   
   $oMail->ClearAllRecipients();
   $oMail->ClearAttachments();
   
   if ($lEnviado) {
      echo "E-mail enviado com sucesso!";
      unlink($sEcoTxt);
   } else {
      echo "No foi possvel enviar o e-mail.";
      echo "Informaes do erro: " . $oMail->ErrorInfo;
   }
} // if ($lEmail==true)

//<--

$tJobEnd  = time();
$iJobElap = $tJobEnd-$tJobStart;
fpc_append($sEcoTxt,'Durao do processo em milisegundos: '.$iJobElap);
fpc_append($sEcoTxt,'Final: '.date('d/m/Y H:i:s',$tJobEnd));

$aTop    = faLoadAvgServer();
$nTopFin = $aTop[0];

list($iUsec, $iSec) = explode(' ', microtime());
$tScript_End = (float) $iSec + (float) $iUsec;

$tElapsed_Time = round($tScript_End - $tScript_Start, 5);
fpc_append($sEcoTxt,"Tempo Decorrido: ".gmdate("H:i:s", $tElapsed_Time).', Secs: '.$tElapsed_Time.". Memoria usada: ".round(((memory_get_peak_usage(true) / 1024) / 1024), 2)."Mb");
fpc_append($sEcoTxt,'----------------------------------------------------------------------------'.chr(10).chr(10));
