<?php
set_time_limit(300); 
require_once("/qtux/www/FullPlat/pFuncoes1.php");
require_once("/qtux/www/FullPlat/pPublics1.php");

list($iUsec, $iSec) = explode(' ', microtime());
$tScript_Start = (float) $iSec + (float) $iUsec;

$aTop      = faLoadAvgServer();
$nTopIni   = $aTop[0];
$tJobStart = time();
$sProc     = basename(__FILE__);
$lOk       = true;

$sHOST = exec('hostname');
if ($sHOST == 'qtuxap.sanol.com.br') {
   $sDSN = '192.168.1.109:/qtux/database/total/gps_01.gdb';
   $sCliPasta = 'total';
} else if ($sHOST=='homologqtuxweb.sanol.com.br') {
   $sDSN = 'localhost:/qtux/database/total/gps_01.gdb';
   $sCliPasta = 'total';
} else {
   $sDSN = 'localhost:/qtux/database/tq/gps_01.gdb';
   $sCliPasta = 'desenvolvimento';
}

$sEcoTxt = '/qtux/www/FullPlat/processos/logs/'.str_replace('.','_',$sProc).'-'.$tJobStart.'.log';
$sEcoTxt = fsDirEcoTxt($sEcoTxt);
$iProcID = getmypid();

fpc($sEcoTxt,'iProcID='.$iProcID);
fpc_append($sEcoTxt,'Incio em ' . date('d/m/Y H:i:s',$tJobStart));

$hDb = fhDbConnect($sDSN);

$sSql1 = "select a.pItem,
                 c.sCodigo,
                 c.pUNeg,
                 cast(sum(a.nQtRes) as numeric(12,2)),
                 cast(sum(a.nQtLib) as numeric(12,2)),
                 cast(sum(a.nQtCanc) as numeric(12,2)),
                 (select sum(aa.nRes) from EST_RegDepositos aa where aa.pItem=a.pItem and aa.iVer=aa.iVAt),
                 (select sum(bb.nRes) from EST_RegDepositos ab join EST_LotesSaldos bb on ab.pItem=a.pItem and ab.iVer=ab.iVAt and bb.pRegDep=ab.pPId and bb.iVer=bb.iVAt and bb.nRes>0)
            from Ordens_Itens  a      join Ordens b on a.pOrdem = b.pPId   and b.iVer = b.iVAt and b.tCanc is null and b.jFase<8
                                      join Itens  c on a.pItem  = c.pPId   and c.iVer = c.iVAt
                                 left join PreNF  d on a.pOrdem = d.pOrdem and d.iVer=d.iVAt and d.tNFCapaCanc is null
           where a.lExc = 0
             and b.lExc = 0
             and a.iVer = a.iVAt
             and a.nQtRes-a.nQtFat-a.nQtCanc>0
           group by a.pItem,
                    c.sCodigo,
                    c.pUNeg
          having     (sum(a.nQtRes) <> (select sum(aa.nRes) from EST_RegDepositos aa where aa.pItem=a.pItem and aa.iVer=aa.iVAt))
                  or (sum(a.nQtLib) <> (select sum(bb.nRes) from EST_RegDepositos ab join EST_LotesSaldos bb on ab.pItem=a.pItem and ab.iVer=ab.iVAt and bb.pRegDep=ab.pPId and bb.iVer=bb.iVAt and bb.nRes>0))";
fpc_append($sEcoTxt,"sSql1=$sSql1");
$aDb1 = faDbSelect($hDb,$sSql1);
$iDb1 = count($aDb1);
fpc_append($sEcoTxt,"iDb1=$iDb1");

$sSql2 = "select pItem,
                 sCodigo,
                 pUNeg,
                 nSumQtRes,
                 nSumQtLib,
                 nSumQtCanc,
                 nSumRes1,
                 nSumRes2
            from TMP_Analise_Ordens_Itens 
           where iVer = iVAt
             and lExc = 0";

fpc_append($sEcoTxt,"sSql2=$sSql2");
$aDb2 = faDbSelect($hDb,$sSql2);
$iDb2 = count($aDb2);
fpc_append($sEcoTxt,"iDb2=$iDb2");


if ($iDb1<>$iDb2) {
/*
   $aArr_Insert = array();
   foreach ($aDb1 as $aLin1) {
      $pItem      = $aLin1[0];
      $sCodigo    = $aLin1[1];
      $pUNeg      = $aLin1[2];
      $nSumQtRes  = $aLin1[3];
      $nSumQtLib  = $aLin1[4];
      $nSumQtCanc = $aLin1[5];
      $nSumRes1   = $aLin1[6];
      $nSumRes2   = $aLin1[7];
      if (in_array("$pItem~$sCodigo~$pUNeg~$nSumQtRes~$nSumQtLib~$nSumQtCanc~$nSumRes1~$nSumRes2",$aArr_Insert)==false) $aArr_Insert[] = "$pItem~$sCodigo~$pUNeg~$nSumQtRes~$nSumQtLib~$nSumQtCanc~$nSumRes1~$nSumRes2";

   }

   $aArr_Update = array();
   foreach ($aDb2 as $aLin2) {
      $pItem      = $aLin2[0];
      $sCodigo    = $aLin2[1];
      $pUNeg      = $aLin2[2];
      $nSumQtRes  = $aLin2[3];
      $nSumQtLib  = $aLin2[4];
      $nSumQtCanc = $aLin2[5];
      $nSumRes1   = $aLin2[6];
      $nSumRes2   = $aLin2[7];
      if (in_array("$pItem~$sCodigo~$pUNeg~$nSumQtRes~$nSumQtLib~$nSumQtCanc~$nSumRes1~$nSumRes2",$aArr_Update)==false) $aArr_Update[] = "$pItem~$sCodigo~$pUNeg~$nSumQtRes~$nSumQtLib~$nSumQtCanc~$nSumRes1~$nSumRes2";
   }
*/
   if ($iDb1>$iDb2) {
      // Insere na tabela Analise
      $aDif = array_diff($aDb1, $aDb2);
      foreach($aDif as $aLin) {
         $aIns = array();
         $aIns[] = array('pItem'     , $aLin[0]);
         $aIns[] = array('sCodigo'   , $aLin[1]);
         $aIns[] = array('pUNeg'     , $aLin[2]);
         $aIns[] = array('nSumQtRes' , $aLin[3]);
         $aIns[] = array('nSumQtLib' , $aLin[4]);
         $aIns[] = array('nSumQtCanc', $aLin[5]);
         $aIns[] = array('nSumRes1'  , $aLin[6]);
         $aIns[] = array('nSumRes2'  , $aLin[7]);
         
         $sSql = fsArrToInsert('TMP_Analise_Ordens_Itens',$aIns);
         fpc_append($sEcoTxt,"sSql=$sSql");
         $lOk  = flDbInsert($hDb,$sSql);
         fpc_append($sEcoTxt,"lOk=$lOk");
      }
   }

   if ($iDb1<$iDb2) {
      // Remove na tabela Analise
   }   
}

if ($iDb1==$iDb2) {
   $sSql = "select pPId,pItem,sCodigo,pUNeg,nSumQtRes,nSumQtLib,nSumQtCanc,nSumRes1,nSumRes2 from TMP_Analise_Ordens_Itens where iVer = iVAt and lExc = 0";
   fpc_append($sEcoTxt,"sSql=$sSql");
   $aDb = faDbSelect($hDb,$sSql);
   
   foreach($aDb as $aLin) {
      $pPId = $aLin[0];
      $aUpd = array();
      $aUpd[] = array('pItem'     , $aLin[1]);
      $aUpd[] = array('sCodigo'   , $aLin[2]);
      $aUpd[] = array('pUNeg'     , $aLin[3]);
      $aUpd[] = array('nSumQtRes' , $aLin[4]);
      $aUpd[] = array('nSumQtLib' , $aLin[5]);
      $aUpd[] = array('nSumQtCanc', $aLin[6]);
      $aUpd[] = array('nSumRes1'  , $aLin[7]);
      $aUpd[] = array('nSumRes2'  , $aLin[8]);

      fpc_append($sEcoTxt,'pPId='.$aLin[0]);
      $lOk = flNovaVersaoRegistro($hDb,'TMP_Analise_Ordens_Itens',$pPId);
      fpc_append($sEcoTxt,"lOk=$lOk");
      $sSql = fsArrToUpdate('TMP_Analise_Ordens_Itens',$aUpd,"iVer=iVAt and pPId=$pPId");
      fpc_append($sEcoTxt,"sSql=$sSql");
      $lOk = flDbUpdate($hDb,$sSql);
      fpc_append($sEcoTxt,"lOk=$lOk");
   }
   
}


if ($lOk==true) {
   flDbCommit($hDb);
   fpc_append($sEcoTxt,'commit');
} else {
   flDbRollBack($hDb);
   fpc_append($sEcoTxt,'rollback');
}

flDbDisconnect($hDb);

$tJobEnd  = time();
$iJobElap = $tJobEnd-$tJobStart;
fpc_append($sEcoTxt,'Durao do processo em milisegundos: '.$iJobElap);
fpc_append($sEcoTxt,'Final: '.date('d/m/Y H:i:s',$tJobEnd));

$aTop    = faLoadAvgServer();
$nTopFin = $aTop[0];

list($iUsec, $iSec) = explode(' ', microtime());
$tScript_End = (float) $iSec + (float) $iUsec;

$tElapsed_Time = round($tScript_End - $tScript_Start, 5);
fpc_append($sEcoTxt,"Tempo Decorrido: ".gmdate("H:i:s", $tElapsed_Time).', Secs: '.$tElapsed_Time.". Memoria usada: ".round(((memory_get_peak_usage(true) / 1024) / 1024), 2)."Mb");
fpc_append($sEcoTxt,'----------------------------------------------------------------------------'.chr(10).chr(10));
