 <?php

header('Content-Type: application/json');

// Verifica se o mtodo de requisio  POST
if ($_SERVER['REQUEST_METHOD'] != 'POST') {
    echo json_encode(0);
    exit;
}

// Captura os dados enviados
$aData     = json_decode(file_get_contents('php://input'), true);
$sCliPasta = $aData['sCliPasta'] ?? '';
$sLogin    = $aData['sLogin'] ?? '';
$aPedidos  = $aData['pedidos'] ?? [];

if (empty($sCliPasta) || empty($sLogin) || empty($aPedidos)) {
    echo json_encode(0);
    exit;
}

// Inclui o arquivo com as funes de conexo ao banco
include('../pFuncoes1.php');

try {
    $sHost     = 'localhost';
    $sDatabase = 'C:\\caminho\\para\\seu\\banco_de_dados.fdb';
    $sDSN      = $sHost . ':' . $sDatabase;

    $hDb = fhDbConnect($sDSN);

    foreach ($aPedidos as $aPedido) {
        // Inserir a capa
        $sSql    = 'insert into TabO (pEmi, pDest, pTOper, pPRepUNeg, pPTOpED) values (?, ?, ?, 0, 0) returning pPId';
        $hPrep   = ibase_prepare($hDb, $sSql);
        $hRes    = ibase_execute($hPrep, $aPedido['pEmi'], $aPedido['pDest'], $aPedido['pTOper']);
        $pCapaId = ibase_fetch_row($hRes)[0];

        if (!$hRes) {
            throw new Exception('Erro ao inserir a capa.');
        }

        // Inserir as linhas
        foreach ($aPedido['linhas'] as $aLinha) {
            $sSql    = 'insert into TabOI (pItem, iQt, nPr, pTabO, pPTOpEDI) values (?, ?, ?, ?, 0)';
            $hPrep   = ibase_prepare($hDb, $sSql);
            $hRes    = ibase_execute($hPrep, $aLinha['pItem'], $aLinha['iQt'], $aLinha['nPr'], $pCapaId);

            if (!$hRes) {
                throw new Exception('Erro ao inserir a linha.');
            }
        }
    }

    // Comita a transao e desconecta do banco
    flDbCommit($hDb);
    flDbDisconnect($hDb);

    echo json_encode(1);
} catch (Exception $oExcep) {
    // Rollback em caso de erro e desconecta do banco
    flDbRollBack($hDb);
    flDbDisconnect($hDb);
    echo json_encode(0);
}
