# -*- coding: iso-8859-1 -*-
import firebirdsql

# Parmetros de conexo
host = "localhost"
database = "/qtux/database/tq/gps_01.gdb"
user = "sysqtux"
password = "qtux201005"

# Funo para logs
def sLog(sMsg):
   with open("log_python.log", "a") as log_file:
      log_file.write(sMsg + "\n")

# Conexo ao Firebird
try:
   sLog("Conectando ao banco de dados...")
   oCon = firebirdsql.connect(
      host=host,
      database=database,
      user=user,
      password=password
   )
   fCursor = oCon.cursor()
   sLog("Conexo estabelecida com sucesso!")

   # Consulta SELECT
   sSQL = """select first 10 pPId, sCoringa, sEmail
           from CUP 
           where iVer = iVAt 
           order by pPId"""

   sLog("Consulta: {}".format(sSQL))

   fCursor.execute(sSQL)
   sLog("Consulta executada com sucesso!")

   # Processamento dos resultados
   while True:
      fAssoc = fCursor.fetchmany(100)
      if not fAssoc:
         break

      for aLinha in fAssoc:
         sLog("pPId: {}".format(aLinha[0]))
         sLog("sCoringa: {}".format(aLinha[1]))
         sLog("sEmail: {}".format(aLinha[2]))
         sLog("------------------")

except Exception as e:
   sLog("Erro ao executar a consulta: {}".format(e))

finally:
   # Fechamento do cursor e conexo
   if 'fCursor' in locals():
      fCursor.close()
      sLog("Cursor fechado.")
   if 'oCon' in locals():
      oCon.close()
      sLog("Conexo fechada.")
