SET SQL dialect 3;
--CONNECT 'localhost:/qtux/database/desenvolvimento/gps_01.gdb';
CONNECT 'localhost:/qtux/database/tq/gps_01.gdb';

DROP TABLE FIN_Bancos_EDI_Aprov;
CREATE TABLE FIN_Bancos_EDI_Aprov (
   PPID   decimal(18,0) default 0 not null,
   PPGM   decimal(18,0) default 0 not null,
   PCIA   decimal(18,0) default 0 not null,
   PIN0   decimal(18,0) default 1 not null,
   PINC   decimal(18,0) default 1 not null,
   TIN0   timestamp default 'now',
   TINC   timestamp default 'now',
   LEXC   smallint default 0 not null,
   IVER   decimal(7,0) default 1 not null,
   JVER   decimal(7,0) default 0 not null,
   SVER   varchar(5000) collate PT_BR,
   ILIDO   decimal(9,0) default 0 not null,
   TULTLIDO   timestamp,
   IVAT   decimal(7,0) default 1 not null,
   JFREV   decimal(3,0) default 0 not null,
   TPREV   timestamp,
   ISERIAL   decimal(18,0) default 0 not null,
   LRAC1   smallint default 0 not null,

   pAprov1 decimal(18,0) default 0 not null,
   tAprov1 timestamp,
   tReprov1 timestamp,
   pReprov1 decimal(18,0) default 0 not null,

   pAprov2 decimal(18,0) default 0 not null,
   tAprov2 timestamp,
   tReprov2 timestamp,
   pReprov2 decimal(18,0) default 0 not null,

   pMont decimal(18,0) default 0 not null,
   fMont decimal(7,0) default 0 not null,

   jFPgmtoCUP decimal(3,0) default 0 not null,

   jDataPgmtoEletronica decimal(3,0) default 0 not null,
   tDataPgmtoEletronica timestamp,

   primary key ( pPId , iVer )
);

DROP GENERATOR FIN_Bancos_EDI_Aprov;
COMMIT;

CREATE GENERATOR FIN_Bancos_EDI_Aprov;
SET GENERATOR FIN_Bancos_EDI_Aprov to 0;

SET TERM !! ;
CREATE TRIGGER FIN_Bancos_EDI_Aprov FOR FIN_Bancos_EDI_Aprov
BEFORE INSERT AS
BEGIN
   if ((new.iVer>0) and (new.iVer= new.iVAt)) then new.pPId  = GEN_ID(FIN_Bancos_EDI_Aprov, 1);
   if ((new.iVer>0) and (new.iVer= new.iVAt)) then new.pIn0  = new.pInc;
   if ((new.iVer>0) and (new.iVer= new.iVAt)) then new.tIn0  = new.tInc;
   if ((new.iVer>0) and (new.iVer<>new.iVAt)) then new.iVer  = new.iVAt;
END !!
SET TERM ; !!

create index FIN_Bancos_EDI_Aprov_01 on FIN_Bancos_EDI_Aprov (pAprov1,pAprov2,pMont,fMont);