﻿jQuery.validator.addMethod("validarCPF", function (value, element) {
    value = value.replace('.', '');
    value = value.replace('.', '');
    cpf = value.replace('-', '');
    while (cpf.length < 11) cpf = "0" + cpf;
    var expReg = /^0+$|^1+$|^2+$|^3+$|^4+$|^5+$|^6+$|^7+$|^8+$|^9+$/;
    var a = [];
    var b = new Number;
    var c = 11;
    for (i = 0; i < 11; i++) {
        a[i] = cpf.charAt(i);
        if (i < 9) b += (a[i] * --c);
    }
    if ((x = b % 11) < 2) { a[9] = 0 } else { a[9] = 11 - x }
    b = 0;
    c = 11;
    for (y = 0; y < 10; y++) b += (a[y] * c--);
    if ((x = b % 11) < 2) { a[10] = 0; } else { a[10] = 11 - x; }
    if ((cpf.charAt(9) != a[9]) || (cpf.charAt(10) != a[10]) || cpf.match(expReg)) return false;
    return true;
}, "Informe um CPF válido.");

jQuery.validator.addMethod("validarCNPJ", function (value, element) {
    var cnpj = '';

    for (i = 0; i < value.length; i++) {
        if (!isNaN(value.charAt(i)))
            cnpj += value.charAt(i);
    }

    if ((cnpj.length != 14) ||
         (cnpj == "00000000000000") || (cnpj == "11111111111111") ||
         (cnpj == "22222222222222") || (cnpj == "33333333333333") ||
         (cnpj == "44444444444444") || (cnpj == "55555555555555") ||
         (cnpj == "66666666666666") || (cnpj == "77777777777777") ||
         (cnpj == "88888888888888") || (cnpj == "99999999999999")) {
        return false;
    }

    var nonNumbers = /\D/;
    if (nonNumbers.test(cnpj)) return false;

    var a = [];
    var b = new Number;
    var c = [6, 5, 4, 3, 2, 9, 8, 7, 6, 5, 4, 3, 2];
    for (i = 0; i < 12; i++) {
        a[i] = cnpj.charAt(i);
        b += a[i] * c[i + 1];
    }
    if ((x = b % 11) < 2) {
        a[12] = 0
    }
    else {
        a[12] = 11 - x
    }
    b = 0;
    for (y = 0; y < 13; y++) {
        b += (a[y] * c[y]);
    }
    if ((x = b % 11) < 2) {
        a[13] = 0;
    }
    else {
        a[13] = 11 - x;
    }
    if ((cnpj.charAt(12) != a[12]) || (cnpj.charAt(13) != a[13])) {
        return false;
    }
    return true;
}, "Informe um CNPJ válido.");

jQuery.validator.addMethod("validarTelefone", function (value, element) {
    var isTel = function () {
    	
    	if($(this).hasClass('required')) {
    		return /^\(\d{2}\)\d{4}-\d{4}$/.test(value);
    	}
		else{
			if(value != '')
	    		return /^\(\d{2}\)\d{4}-\d{4}$/.test(value);
    		else
    			return true;	    			
		}		
    };
    return isTel();
}, "Número de telefone inválido.");