<h2 class="titulo">
	<img class="logo" src="webroot/img/logo.jpg" alt="" title=""/>
	<span>Detalhes da Rota (Atendimento - {$chamado})</span>
</h2>

<fieldset>
	<legend>Dados do Atendimento</legend>
	
	<table>
		<tr>
			<td colspan="2"><b>Cliente:</b> {$CLIENTE}</td>
		</tr>
		<tr>
			<td><b>Data da solicita&ccedil;&atilde;o:</b> {$DATA_CH}</td>
			<td><b>Solicitante:</b> {$SOLICITANTE}</td>
		</tr>
		<tr>
			<td colspan="2"><b>Servi&ccedil;o:</b> {$DESCRICAO_SERVICO}</td>
		</tr>
		<tr>
			<td><b>Equipamento:</b> {$EQUIPAMENTO}</td>
			<td><b>Modelo / S&eacute;rie:</b> {$MODELO} / {$NRSERIE}</td>
		</tr>
		<tr>
			<td><b>Respons&aacute;vel:</b> {$TECNICO}</td>
			<td>
				<b>Situa&ccedil;&atilde;o:</b>				
	   			{if $STATUS == 0}
	   				Em aberto
	   			{elseif $STATUS == 1}
	   				Em transito
	   			{elseif $STATUS == 2}
	   				Em andamento
	   			{else}
	   				Finalizado	   			
	   			{/if} 
			</td>
		</tr>
		
	</table>	
</fieldset>

<div id="tabs">
	<ul>
		<li><a href="#tabs-1">Rota Sugerida (Google)</a></li>
		<li><a href="#tabs-2">Rota Tra&ccedil;ada</a></li>
	</ul>
	<div id="tabs-1">
		<form method="post" action="#">
    		<table cellpadding="4" cellspacing="4">
    			<tr>
    				<td><label for="destino">Destino: </label></td>
    				<td><input type="text" name="destino" disabled="disabled" id="destino" value="{$endereco}" style="width: 500px"></td>    			    				
    			</tr>   				
    		</table>
    	</form><br />    	
    	<div id="map1"></div>		
		<div id="route1"></div>
	</div>
	<div id="tabs-2">
		<form method="post" action="#">
    		<table cellpadding="4" cellspacing="4">
    			<tr>
    				<td><label for="km">Dist&acirc;ncia percorrida: </label></td>
    				<td><input type="text" name="km" disabled="disabled" id="km" style="width: 250px" /></td>    			    				
    				<td><label for="nValKm">Valor KM</label></td>
    				<td><input type="text" name="nValKm" id="nValKm" disabled="disabled" style:"width: 250px" /></td>
    			</tr>   				
    		</table>
    	</form><br />      	
		<div id="map2"></div><br />
		<h2 class="titulo">Trajeto marcado pelo Google</h2>		
		<div id="route2"></div>	
	</div>	
</div>

<script type="text/javascript" src="https://maps.googleapis.com/maps/api/js?sensor=false"></script>
<script src="http://maps.google.com/maps?file=api&amp;v=3&amp;key=AIzaSyBEDAxTCEKkbcTvzR3eLyoy8e3og5J9zw8&amp;" type="text/javascript"></script>
<script type="text/javascript">
var lat = {$lat_ini};
var lon = {$lon_ini};
var json_coor = {$json_coor};
var map, map2 = null;
var strLatLon = '{$lat_ini}, {$lon_ini}';
var marker = null;
var distance = 0;
{literal}
try{
	if(lat == 0 && json_coor.length > 0)
		lat = json_coor[0].LAT;

	if(lon == 0 && json_coor.length > 0)
		lon = json_coor[0].LON;
	
	var LatLon = new GLatLng(lat, lon);
	var strLatLon = '"'+ lat + ',' + '"' + lon+'"';
}catch(e){
	var LatLon = new GLatLng(0, 0);
	var strLatLon = '0, 0';
}

window.onload = function() {
	rotasugerida();
    rotatracada();
} 
window.unload = function(){
	GUnload();
}

$(function(){
	$('#tabs').tabs();
});

function rotasugerida(){
	try{
		var opts = {
			size: new GSize(960,450),
			mapTypeId: google.maps.MapTypeId.G_PHYSICAL_MAP
	    };

	 	map = new GMap2(document.getElementById('map1'), opts);
	 	map.addControl(new GLargeMapControl());
	    //map.addControl(new GMapTypeControl());
	 	map.setCenter(LatLon, 17);
	 	map.setUIToDefault();
		map.setMapType();	

		var directionsPanel = document.getElementById('route1');
		var directions = new GDirections(map, directionsPanel);

		var fromAddress = LatLon;
	    var toAddress = document.getElementById('destino').value;
			
	    directions.load(fromAddress + " to " + toAddress, {"locale":"pt_BR"});
	}
	catch(e){}
}

function rotatracada(){	
	try{
		var opts2 = {
			size: new GSize(960,450),
			mapTypeId: google.maps.MapTypeId.G_PHYSICAL_MAP
	    };
	    
		map2 = new GMap2(document.getElementById('map2'), opts2);
	 	map2.addControl(new GLargeMapControl());
	 	map2.setCenter(LatLon, 17);
	 	map2.setUIToDefault();
		map2.setMapType();	
		
		var origem = new GLatLng(json_coor[0].LAT, json_coor[0].LON);
		var destino =  new GLatLng(json_coor[json_coor.length - 1].LAT, json_coor[json_coor.length -1].LON);
			
		var fromAddress = origem;
	    var toAddress = destino;
	
	    var directionsPanel = document.getElementById('route2');
	
		var tam_pag = 25;
	
		distance = 0;
		
		for(var pages=0; pages <  Math.ceil(json_coor.length / tam_pag); pages++){
	 		var directions = new GDirections(map2, directionsPanel);
	 		 
			var locais = Array();
			var idx = pages * tam_pag; 		
			var cnt = 0;
	 		
	 		if(json_coor.length >= (idx+cnt)){ 
	 	 		while(cnt < tam_pag){					
					if(json_coor[idx+cnt]){
						var local;						
						local = new GLatLng(json_coor[idx+cnt].LAT, json_coor[idx+cnt].LON);
						distance += local.distanceFrom(new GLatLng(json_coor[0].LAT, json_coor[0].LON));
						locais.push(local);
					}						 					 	
					cnt++;		 		
				}
	
				if(locais.length > 1){
					var request = {
						origin:origem,
						destination:destino,
						travelMode: google.maps.DirectionsTravelMode.DRIVING,
						waypoints: locais
					}; 
					
					directions.loadFromWaypoints(locais);
				}
				else{
			       	directions.load(json_coor[0].ENDERECO + " to " + json_coor[0].ENDERECO, {"locale":"pt_BR"});
				}
	 		}
		}
	}
	catch(e){}
	var km = Math.ceil(distance / 1000);

    $('#km').val(km);	
}
{/literal}
</script>

