<?php
include 'libs/config.php';

$data_dia = date('Y-m-d');

$qry_tec = "SELECT
				DISTINCT cc.pPId
		    FROM
			 	AGPACK_CHAMADOS_LOC acl
				INNER JOIN AGPACK_CHAMADOS ac ON ac.PPID = acl.ID_CHAMADO
				LEFT JOIN OOp       bb  ON ac.pTEC_OOp = bb.pPid  AND bb.iVer=bb.iVAt
				LEFT JOIN CUP cc ON bb.pUsu    = cc.pPid  AND cc.iVer=cc.iVAt
			WHERE
				acl.D_ENVIO = ?"; 

$rs_tec = $adodb->GetAll($qry_tec, $data_dia);

$ids = array();

$rs = array();

if($rs_tec){
	foreach ($rs_tec as $item){		
		if($item['PPID'] > 0){
			$ids[] = $item['PPID'];
			
			$qry_tecnicos = "SELECT FIRST 1
								cc.PPID,
						     	cc.sCoringa Tecnico,
							    (CASE ac.jTEC_StatusCel
							            WHEN 0 THEN 'Em aberto'
							            WHEN 1 THEN 'Em transito'
							            WHEN 2 THEN 'Em atendimento'
							            WHEN 3 THEN 'Cancelado'
							            WHEN 4 THEN 'Pendente'
							            WHEN 5 THEN 'Finalizado'							            
							            ELSE 'Disponivel'
						       	END) Status,
						        acl.LAT,
						        acl.LON
							 FROM
							  	AGPACK_CHAMADOS_LOC acl
								INNER JOIN AGPACK_CHAMADOS ac ON ac.PPID = acl.ID_CHAMADO
								LEFT JOIN OOp       bb  ON ac.pTEC_OOp = bb.pPid  AND bb.iVer=bb.iVAt
								LEFT JOIN CUP cc ON bb.pUsu    = cc.pPid  AND cc.iVer=cc.iVAt
							WHERE
							    cc.pPId = ? AND acl.D_ENVIO = ?
						    ORDER BY
			                    acl.ID_LOC DESC";
	
			$data = $adodb->GetRow($qry_tecnicos, array($item['PPID'], $data_dia));
			$data['STATUS'] = trim($data['STATUS']);
			
			$rs[] = $data;
		}
	}	
}

$qry_pto_ref = "SELECT
					DISTINCT (SELECT FIRST 1 sCoringa FROM CUP WHERE sTel21 = apr.IMEI_PTO_REF) Tecnico,
					apr.LAT_PTO_REF LAT,
					apr.LON_PTO_REF LON
				FROM
    				AGPACK_CHAMADOS_PTO_REF apr,
    				CUP cc
					WHERE
					    ".(count($ids) > 0 ? "cc.pPId NOT IN(".implode(',', $ids).") AND" : "")." 
					    apr.D_PTO_REF = ?
				    	AND cc.sTel21 = apr.IMEI_PTO_REF";
	
$rs_pto_ref = $adodb->GetAll($qry_pto_ref, array($data_dia));

if($rs_pto_ref){
	foreach ($rs_pto_ref as $item_ref){
		$item_ref['STATUS'] = 'Disponivel';
		$rs[] = $item_ref;
	}
}

$smart->assign('json_coor', json_encode($rs));

$smart->assign('page', 'painel_atendimento');
$smart->display('layout.html');