<?php
require_once('/qtux/www/FullPlat/lib/stripe-php-7.89.0/init.php');

// Set with a valid test API key.
$stripe = new \Stripe\StripeClient('sk_test_51JCvpAJGAfmAGipWjiwy5hJGPH8TDXsYgfxdDGHZPSsckuw7uL7Vxr3vr9bAkfrJ4uFrNkxETma63LuaEp5tmUB900jpxFdPpq');

// Create customer without an API version set, this will use the account's default version.
echo "Customer created wtihout setting an API version:".chr(10);
echo $stripe->customers->create([
   'email' => 'ricardo@qtux.com.br', 
   'description' => 'customer created using default account API version'
]).chr(10);

// Set the API version globally for all requests.
// Set with a valid test API key.
$stripeWithGlobalAPIVersionSet = new \Stripe\StripeClient([
   'api_key' => 'sk_test_51JCvpAJGAfmAGipWjiwy5hJGPH8TDXsYgfxdDGHZPSsckuw7uL7Vxr3vr9bAkfrJ4uFrNkxETma63LuaEp5tmUB900jpxFdPpq',
   'stripe_version' => '2020-08-27'
]).chr(10);
echo chr(10)."Customer created with global API version:".chr(10);

echo $stripeWithGlobalAPIVersionSet->customers->create([
   'email' => 'ricardo@qtux.com.br', 
   'description' => 'customer created global API version set'
]).chr(10);

// Set API version per request.
echo chr(10)."Customer created with API version set on the request:".chr(10);
echo $stripe->customers->create([
   'email' => 'ricardo@qtux.com.br', 
   'description' => 'customer created with API version set on request'], 
   ['stripe_version' => '2020-08-27'
]).chr(10);

// Retrieve the customer.created event or look at it in the Dashboard: https://dashboard.stripe.com/test/events 
// In this case example we're making the assumption the last event was the one we wanted. 
// The customer object in the event payload will be based off of the API version your
// account is set to. 
// Be sure to watch the pagination video to learn more about listing objects :)     
$events = $stripe->events->all(['limit' => 1]);
echo chr(10)."customer created event :".chr(10);
echo $events->data[0].chr(10);

// Create a webhook endpoint and set its API version.
$stripe->webhookEndpoints->create([
   'api_version' => '2020-08-27',
   'url' => 'https://example.com/my/webhook/endpoint',
   'enabled_events' => [
                        'customer.created'
                       ],
]);

// Create a new customer to see an event sent to the endpoint.
$stripe->customers->create([
   'email' => 'ricardo@qtux.com.br', 
   'description' => 'customer created to see webhook event']
);

// Visit the Dashboard page for the endpoint you just created:
// https://dashboard.stripe.com/test/webhooks/we_XXX  
// Under "Webhook Attempts" you'll see the event data Stripe has sent to the endpoint 
// for the customer that was just created. 
// Since we created the endpoint using the  2020-08-27 API version, the customer object 
// in the payload is using that version and not the version used to create the customer. 
echo "\nAll done, visit https://dashboard.stripe.com/test/webhooks to see what was sent to the endpoint".chr(10);