<?php
require_once('/qtux/www/FullPlat/lib/stripe-php-7.89.0/init.php');

// Set with a valid test API key.
$stripe = new \Stripe\StripeClient('sk_test_51JCvpAJGAfmAGipWjiwy5hJGPH8TDXsYgfxdDGHZPSsckuw7uL7Vxr3vr9bAkfrJ4uFrNkxETma63LuaEp5tmUB900jpxFdPpq');

// BAD: n+1 api calls
// $session = $stripe->checkout->sessions->retrieve(
//   'cs_test_a1pUINkydm5WgmgCwbpuQnx1mHO6oKLNRGd8Mk7GMprg9rK10yGe41qxwq'
// );

// $customer = $stripe->customers->retrieve($session->customer);
// $payment_method = $stripe->paymentMethods->retrieve($customer->invoice_settings->default_payment_method);

// echo($customer);
// echo($payment_method);

// GOOD: expand multiple related objects
// $session = $stripe->checkout->sessions->retrieve(
//   'cs_test_a1pUINkydm5WgmgCwbpuQnx1mHO6oKLNRGd8Mk7GMprg9rK10yGe41qxwq',
//   [
//     'expand' => ['customer', 'payment_intent'],
//   ],
// );

// $customer = $session->customer;
// $payment_intent = $session->payment_intent;

// echo($customer);
// echo($payment_intent);

// BAD: n+1 api calls for deeply nested objects
// $session = $stripe->checkout->sessions->retrieve(
//   'cs_test_a1pUINkydm5WgmgCwbpuQnx1mHO6oKLNRGd8Mk7GMprg9rK10yGe41qxwq',
//   [
//     'expand' => ['payment_intent'],
//   ],
// );
// $payment_method = $stripe->paymentMethods->retrieve($session->payment_intent->payment_method);

// echo($payment_method);

// GOOD: expand deeply nested objects
// $session = $stripe->checkout->sessions->retrieve(
//   'cs_test_a1pUINkydm5WgmgCwbpuQnx1mHO6oKLNRGd8Mk7GMprg9rK10yGe41qxwq',
//   [
//     'expand' => ['payment_intent.payment_method'],
//   ],
// );
// $payment_method = $session->payment_intent->payment_method;
// echo($payment_method);

// BAD: slow n+1 calls for fetching related objects in a list
// $payment_intents = $stripe->paymentIntents->all(
//   [
//     'customer' => 'cus_JAVFtGaSDwpot5',
//   ],
// );

// foreach($payment_intents->data as $payment_intent) {
//   $payment_method = $stripe->paymentMethods->retrieve($payment_intent->payment_method);
//   echo($payment_method);
// }

// GOOD: expand objects in lists
// $payment_intents = $stripe->paymentIntents->all([
//   'customer' => 'cus_JAVFtGaSDwpot5',
//   'expand' => ['data.payment_method'],
// ]);

// foreach($payment_intents->data as $payment_intent) {
//   $payment_method = $payment_intent->payment_method;
//   echo($payment_method);
// }

// GOOD: include non-included attributes using expand
// $session = $stripe->checkout->sessions->retrieve(
//   'cs_test_a1pUINkydm5WgmgCwbpuQnx1mHO6oKLNRGd8Mk7GMprg9rK10yGe41qxwq',
//   [
//     'expand' => ['line_items'],
//   ],
// );

// echo($session->line_items);

// GOOD: expansion works with create and udpate requests
// $payment_intent = $stripe->paymentIntents->create([
//   'amount' => 2000,
//   'currency' => 'eur',
//   'confirm' => true,
//   'customer' => 'cus_JBKhuBgMcG9Bn9',
//   'payment_method' => 'pm_card_visa',
//   'expand' => ['customer'],
// ]);

// echo($payment_intent->customer);