<?php
/* Processo tem como objetivo cancelar a nota fical eletronica em questo
 * Script criado por Ricardo Gomes Frana com auxilio de Fredy
 * Para cancelar a nota fical eletronica  necessrio escrever o motivo do cancelamento para o site da receita federal
 * O script  chamado pela funo OnSave referencia 10019 dentro de pFuncoes1.php
 * No  necessrio declarar as variaveis pelos mtodos GET ou POST 
 * Exemplo:
 * $psCliPasta = nome da pasta da CIA que esta chamando o processo
 * $psId       = ID do registro em questo
 * $psLogin    = ID do usurio que chamou o processo
**/

set_time_limit(300);

$iTimeOutRecep = 5;
$aTop      = faLoadAvgServer();
$nTopIni   = $aTop[0];
$tJobStart = time();
$sProc     = basename(__FILE__);
$sEcoTxt   = "/qtux/www/FullPlat/processos/logs/".str_replace('.','_',$sProc)."_nf$pDoc-".time().".log";
$sEcoTxt = fsDirEcoTxt($sEcoTxt);
fpc($sEcoTxt,'Incio em ' . date('d/m/Y h:i:s',$tJobStart));
$lLigaQry = true;
$aUserLog  = array();

fpc_append($sEcoTxt,"psCliPasta = $psCliPasta");
fpc_append($sEcoTxt,"psLogin = $psLogin");
fpc_append($sEcoTxt,"pDoc = $psId");

$sFileConfig = "../$psCliPasta/dd_files/Business.ddini";
fpc_append($sEcoTxt,"Arquivo ddini ($sFileConfig)");
if (file_exists($sFileConfig)) {
   // Lendo parametros do arquivo de config
   $sTxt = fsTXTFiltrar($sFileConfig);
   $aArr = explode(chr(10),$sTxt);
   foreach ($aArr as $sLin) {
      $aLin = explode('//',$sLin);
      $sLin = trim($aLin[0]);
      if (strlen($sLin)>0) {
         $aLin = explode('=',$sLin);
         $s1 = trim($aLin[0]);
         if (count($aLin)>1) $s2 = trim($aLin[1]);
         else                $s2 = '';
         $s  = '$'.$s1." = '".$s2."';";
         eval($s);   // criando uma var
         $sVarsTxt .= $s . chr(10);
      }
   }
   $lGo       = true;
   $iOk       = 1;
   $lOk       = true;
   $sDSN      = "$sHost:$sPathDB/$sDB";
   $sPathFS   = $sPathFileSys;

   $dData     = date('Ym');

//   $hDb  = fhDbConnect($sDSN);

   $sSql = "select sINFNFE_ID,
                   sMotivoCan,
                   pCia,
                   tXMLEnviar,
                   sEmit_CNPJ,
                   jIde_cUF,
                   sResp,
                   iIde_NNF
                
                   from NFCAPA
                  where pPId = $psId
                    and iVer = iVAt
           ";
   $aNF        = faDBSelect($phDb,$sSql);
   $sAcesso    = trim($aNF[0][0]);
   $sMotivoCan = trim($aNF[0][1]);
   $pCia       = trim($aNF[0][2]);
   $tEnviado   = trim($aNF[0][3]);
   $sEmit_CNPJ = trim($aNF[0][4]);
   $jIde_cUF   = trim($aNF[0][5]);
   $sResp      = trim($aNF[0][6]);
fpc_append($sEcoTxt,"sAcesso = $sAcesso");
fpc_append($sEcoTxt,"sMotivoCan = $sMotivoCan");
fpc_append($sEcoTxt,"pCia = $pCia");
fpc_append($sEcoTxt,"tEnviado = $tEnviado");
   $sPathCia   = $sCanalACBR.'_'.$pCia;
fpc_append($sEcoTxt,"sPathCia = $sPathCia");
   $sPathQtuxOrig = $sPathQtux;
   $sPathACBROrig = $sPathACBR;
   $sPathQtux    = str_replace('<sPathCia>',$sPathCia,$sPathQtuxOrig);
   $sPathACBR    = str_replace('<sPathCia>',$sPathCia,$sPathACBROrig);
   $sPathEnv     = str_replace('<sPathCia>',$sPathCia,$sPathEnv);
   $sPathCanDesc = str_replace('<sPathCia>',$sPathCia,$sPathCanDesc);
   
   $tEnviado   = strtotime($tEnviado);
   $tDataAgora = date('Y-m-d h:i:s');
   $tDataAgora = strtotime($tDataAgora);
   $iValorData = $tDataAgora - $tEnviado; 
fpc_append($sEcoTxt,"iValorData = $iValorData");
   $i24Horas_Sec = (24*60)*60;
fpc_append($sEcoTxt,"i24Horas_Sec = $i24Horas_Sec");
   if ($iValorData <= $i24Horas_Sec) {

      $aTmp    = explode('NProt=',$sResp);
      $sTmp    = $aTmp[1];
      $aTmp    = explode(chr(10),$sTmp);
      $sNRec   = $aTmp[0];

      $sCmdACBR = 'NFE.ENVIAREVENTO("[EVENTO]
                                     idLote='.$iIde_NNF.'
                                     [EVENTO001]
                                     chNFe='.$sAcesso.'
                                     cOrgao='.$a_cUF_Cancelar[$jIde_cUF].'
                                     CNPJ='.$sEmit_CNPJ.'
                                     dhEvento='.date('d/m/y G:i:s').'
                                     tpEvento=110111
                                     nProt='.$sNRec.'
                                     xJust='.$sMotivoCan.'")';

//      $sCmdACBR = 'NFe.CancelarNFe("'.$sAcesso.'","'.$sMotivoCan.'")';
      $sFileEnt = $sPathQtux."ENTNFE$sAcesso.txt";
      $sFileSa1 = $sPathQtux."SAINFE$sAcesso.txt";
      $sFileSa2 = $sPathQtux."sainfe$sAcesso.txt";
      fpc($sFileEnt,$sCmdACBR);   // SALVANDO NO ARQUIVO QUE O ACBR VAI LER
fpc_append($sEcoTxt,"sFileEnt = $sFileEnt");
fpc_append($sEcoTxt,"sCmdACBR = $sCmdACBR");
//      sleep(1);
      if ($lOk==true) {  // aqui - NFeSN_RecepcaoACBR.php
fpc_append($sEcoTxt,"salvou arquivo para ACBR - $sFileEnt, $sCmdACBR");
         $iSleep=0;
         $iInoperante=0;
         while (true) {   // loop cron temporal
            sleep($iTimeSleep);
fpc_append($sEcoTxt,"recepo - esperando $sFileSa1 ou $sFileSa2");
fpc_append($sEcoTxt,"recepo - file_exists($sFileSa1) = ". file_exists($sFileSa1).", file_exists($sFileSa2)=".file_exists($sFileSa2));
            if ((file_exists($sFileSa1)) || (file_exists($sFileSa2))) {
               $sFileSai = file_exists($sFileSa1)==true ? $sFileSa1 : $sFileSa2;
fpc_append($sEcoTxt,"recepo - localizou $sFileSai");
               $sResp    = str_replace(chr(13),'',fgc($sFileSai));
               $sResp    = str_replace("'",'',$sResp);
fpc_append($sEcoTxt,"sResp = $sResp");
               $sMotivo  = '';
               $jResp    = fjNFeInterpretaACBRRespostaCancelamento($sResp,$sMotivo);
fpc_append($sEcoTxt,"recepo - jResp = $jResp");
               if(($jResp==0) && (strpos(strtoupper($sResp),strtoupper('Inativo ou Inoperante tente novamente'))!==false)) {   // esta inativo / inoperante
fpc_append($sEcoTxt,"Inativo ou Inoperante tente novamente");
                  $iInoperante++;
                  fpc($sFileEnt,$sCmdACBR);
                  unlink($sFileSai);
               }
               if ($jResp == 1) {
                  $sSql = "update NFCapa 
                              set pCan            = $psLogin, 
                                  tCancelaNFe     = 'now', 
                                  sRespostaCan    = '$sResp', 
                                  jStatusProcesso = 5
                            where pPId = $psId 
                              and jStatusProcesso <> 5
                              and iVer = iVAt";
fpc_append($sEcoTxt,"sSql  = $sSql");
                  $lOk      = flDbUpdate($phDb,$sSql);
fpc_append($sEcoTxt,"lOk=$lOk");
                  if ($lOk==true) flDbCommit($phDb);
                  else            flDbRollBack($phDb);
               } else if ($jResp == 2) {
                  $sSql = "update NFCapa
                              set pCan            = $psLogin,
                                  tCancelaNFe     = 'now',
                                  sRespostaCan    = '$sResp',
                                  jStatusProcesso = 6
                            where pPId = $psId
                              and jStatusProcesso <> 5
                              and iVer = iVAt";
fpc_append($sEcoTxt,"sSql  = $sSql");
                  $lOk      = flDbUpdate($phDb,$sSql);
fpc_append($sEcoTxt,"lOk=$lOk");
                  if ($lOk==true) flDbCommit($phDb);
                  else            flDbRollBack($phDb);
               } else if ($jResp == 3) {
                  $sSql = "update NFCapa
                              set pCan            = $psLogin,
                                  tCancelaNFe     = 'now',
                                  sRespostaCan    = '$sResp',
                                  jStatusProcesso = 7
                            where pPId = $psId
                              and jStatusProcesso <> 5
                              and iVer = iVAt";
fpc_append($sEcoTxt,"sSql  = $sSql");
                  $lOk      = flDbUpdate($phDb,$sSql);
fpc_append($sEcoTxt,"lOk=$lOk");
                  if ($lOk==true) flDbCommit($phDb);
                  else            flDbRollBack($phDb);
               }
//               if (file_exists($sPathQtux.$sAcesso.'-ProcCancNFe.xml')) rename($sPathQtux.$sAcesso.'-ProcCancNFe.xml',$sPathCanDesc.$sAcesso.'-ProcCancNFe.xml');
               if (file_exists($sPathQtux.$sAcesso.'1101111-procEventoNFe.xml')) rename($sPathQtux.$sAcesso.'1101111-procEventoNFe.xml',$sPathCanDesc.$sAcesso.'1101111-procEventoNFe.xml');
               if (file_exists($sPathQtux.$sAcesso.'-can.xml'))           rename($sPathQtux.$sAcesso.'-can.xml',$sPathCanDesc.$sAcesso.'-can.xml');
               if (file_exists($sPathQtux.$sAcesso.'-ped-can.xml'))       rename($sPathQtux.$sAcesso.'-ped-can.xml',$sPathCanDesc.$sAcesso.'-ped-can.xml');
               if (file_exists($sPathQtux.$sAcesso.'-ped-sit.xml'))       rename($sPathQtux.$sAcesso.'-ped-sit.xml',$sPathCanDesc.$sAcesso.'-ped-sit.xml');
               if (file_exists($sPathQtux.$sAcesso.'-sit.xml'))           rename($sPathQtux.$sAcesso.'-sit.xml',$sPathCanDesc.$sAcesso.'-sit.xml');
//               unlink($sFileSai);
            }
            if ($iInoperante<>1) {
               break;
            }
            $iInoperante++;
            if (($iSleep++)>$iTimeOutRecep) break;
         }
      }
   }

   flDbDisconnect($phDb);

   fpc_append($sEcoTxt,"--//--");
   fpc_append($sEcoTxt,"Log do usurio");
   fpc_append($sEcoTxt,"$sUserLog");
   $tJobEnd  = time();
   $iJobElap = $tJobEnd-$tJobStart;
   fpc_append($sEcoTxt,'Durao do processo em milisegundos: '.$iJobElap);
   fpc_append($sEcoTxt,'Mensagem do processo: '.$sUserLog);
   fpc_append($sEcoTxt,'Final: '.date('d/m/Y G:i:s',$tJobEnd));
   fpc_append($sEcoTxt,'----------------------------------------------------------------------------'.chr(10).chr(10));
   $aTop    = faLoadAvgServer();
   $nTopFin = $aTop[0];
   $sBDCentral = '/qtux/database/gps_producao/gps_01.gdb';

   $flSysJobs = flSysJobs($sProc,$nTopIni,$nTopFin,$tJobStart,$tJobEnd,$iJobElap,$psCliPasta,$psLogin);

} else {
   echo 'Arquivo de configurao no foi encontrado.';
}
//
// fim
//
//////////////////////////
//
// funcoes complementares
//
//
//
function fjNFeInterpretaACBRRespostaCancelamento($psResp,&$psMotivo) {
/////////////////////////////////////////////////////////
   $jRet      = 0;
//   $sAceitou  = 'Evento registrado e vinculado a NF-e';
   $sAceitou  = 'Cancelamento registrado';
//   $sAceitou2 = 'Consumo Indevido';
//   $aTmp      = explode('XMotivo=',$psResp);
   $aTmp      = explode('xEvento=',$psResp);
   $sTmp      = $aTmp[count($aTmp)-1];
   $aTmp      = explode(chr(10),$sTmp);
   $psMotivo  = $aTmp[0];   // passada por referencia
   if (strtoupper(substr($psMotivo,0,strlen($sAceitou))) == strtoupper($sAceitou)) $jRet = 1;
//   if (strtoupper(substr($psMotivo,0,strlen($sAceitou2))) == strtoupper($sAceitou2)) $jRet = 1;
   if ($jRet==0) {
      $sAceitou = 'Cancelamento de NF-e homologado fora de prazo';
      if (strtoupper(substr($psMotivo,0,strlen($sAceitou)))==strtoupper($sAceitou)) $jRet = 2;
      $sAceitou2 = 'ERRO: A Justificativa para Cancelamento da Nota Fiscal Eletronica deve ter no minimo 15 caracteres';
      if (strtoupper(substr($psResp,0,strlen($sAceitou2)))==strtoupper($sAceitou2)) $jRet = 3;
   }
   return $jRet;
}
?>