<?php
set_time_limit(300);
//error_reporting(E_ALL);
require_once("../pFuncoes1.php");
require_once("../pPublics1.php");	

list($iUsec, $iSec) = explode(' ', microtime());
$tScript_Start = (float) $iSec + (float) $iUsec;

$psCliPasta = fsCliPasta();

$aTop      = faLoadAvgServer();
$nTopIni   = $aTop[0];
$tJobStart = time();
$sProc     = basename(__FILE__);

$sEcoNome  = str_replace('.','_',$sProc).'-'.$tJobStart.'.log';
$sEcoTxt = "/qtux/www/FullPlat/processos/logs/$sEcoNome";
$sEcoTxt = fsDirEcoTxt($sEcoTxt);

$iProcID              = getmypid();
$lProducao            = true;
$aUserLog             = array();
$iCount_oOrdensColeta = 0;

fpc($sEcoTxt,'Incio em ' . date('d/m/Y H:i:s',$tJobStart));
fpc_append($sEcoTxt,'iProcID='.$iProcID);
fpc_append($sEcoTxt,"lProducao=$lProducao");
fpc_append($sEcoTxt,"psCliPasta=$psCliPasta");

$sFileConfig = "../../$psCliPasta/dd_files/Business.ddini";
fpc_append($sEcoTxt,"sFileConfig=$sFileConfig");

if (file_exists($sFileConfig)) {

   $sTxt = fsTXTFiltrar($sFileConfig);
   $aArr = explode(chr(10),$sTxt);
   $sVarsTxt = '';
   foreach ($aArr as $sLin) {
      $aLin = explode('//',$sLin);
      $sLin = trim($aLin[0]);
      $iLen = strlen($sLin);
      if ($iLen>0) {
         $aLin = explode('=',$sLin);
         $s1 = trim($aLin[0]);
         $iCountaLin = count($aLin);
         if ($iCountaLin>1) $s2 = trim($aLin[1]);
         else               $s2 = '';
         $s  = '$'.$s1." = '".$s2."';";
         eval($s);
         $sVarsTxt .= $s . chr(10);
      }
   }

   $lGo      = true;
   $lOk      = true;
   $lLigaQry = true;

   $psLogin = 1;

   $sDSN    = "$sHost:$sPathDB/$sDB";
   $sPathFS = $sPathFileSys;

   fpc_append($sEcoTxt,"sDSN = $sDSN, sPathFS = $sPathFS");

   $hDb = fhDbConnect($sDSN);

   //$lControlProc = flControlProc($hDb,$sProc);
   $lControlProc = flControlProcLinux($sProc);
   fpc_append($sEcoTxt,"lControlProc=$lControlProc");
   if ($lControlProc==false) {
      $lOk = false;
      fpc_append($sEcoTxt,"J TEM UM PROCESSO RODANDO [ $sProc ] NO IR RODAR, ESPERE O PROCESSO TERMINAR PARA RODAR NOVAMENTE.");
   } else {

      // $sUrlIntegracao = 'https://api.awsli.com.br/webhooks/v1/pedido'; 
      fpc_append($sEcoTxt,"sUrlIntegracao=$sUrlIntegracao");
      
      $oRet = foGETLojaIntegrada(); // requisio da API loja integrada

      if ( ($lOk==true) && $oRet!='null') {

         $aSql = array();
         $aIns = array();

         if (isset($oRet->token)) { // "token": "user-id-abc",
            $sToken = utf8_decode($oRet->token);
            fpc_append($sEcoTxt, "sToken=$sToken");
            $aIns[] = array("sToken", $sToken);
         } // if (isset($oRet->token))
         
         if (isset($oRet->tipo)) { // "tipo": "pedido_venda",
            $sTipo = utf8_decode($oRet->tipo);
            fpc_append($sEcoTxt, "sTipo=$sTipo");
            $aIns[] = array("sTipo", $sTipo);
         } // if (isset($oRet->tipo))
         
         if (isset($oRet->id)) { // "id": 753077,
            $sId = utf8_decode($oRet->id);
            fpc_append($sEcoTxt, "sId=$sId");
            $aIns[] = array("sId", $sId);
         } // if (isset($oRet->id))

         if (isset($oRet->id_externo)) { // "id_externo": null,
            $sId_externo = utf8_decode($oRet->id_externo);
            fpc_append($sEcoTxt, "sId_externo=$sId_externo");
            $aIns[] = array("sId_externo", $sId_externo);
         } // if (isset($oRet->id_externo))
         
         if (isset($oRet->numero)) { // "numero": 7,
            $sNumero = utf8_decode($oRet->numero);
            fpc_append($sEcoTxt, "sNumero=$sNumero");
            $aIns[] = array("sNumero", $sNumero);
         } // if (isset($oRet->numero))
         
         if (isset($oRet->valor_desconto)) { // "valor_desconto": 0,
            $sValor_desconto = utf8_decode($oRet->valor_desconto);
            fpc_append($sEcoTxt, "sValor_desconto=$sValor_desconto");
            $aIns[] = array("sValor_desconto", $sValor_desconto);
         } // if (isset($oRet->valor_desconto))
         
         if (isset($oRet->valor_envio)) { // "valor_envio": 0,
            $sValor_envio = utf8_decode($oRet->valor_envio);
            fpc_append($sEcoTxt, "sValor_envio=$sValor_envio");
            $aIns[] = array("sValor_envio", $sValor_envio);
         } // if (isset($oRet->valor_envio))
         
         if (isset($oRet->valor_subtotal)) { // "valor_subtotal": 169.41,
            $sValor_subtotal = utf8_decode($oRet->valor_subtotal);
            fpc_append($sEcoTxt, "sValor_subtotal=$sValor_subtotal");
            $aIns[] = array("sValor_subtotal", $sValor_subtotal);
         } // if (isset($oRet->valor_subtotal))

         if (isset($oRet->valor_total)) { // "valor_total": 169.41,
            $sValor_total = utf8_decode($oRet->valor_total);
            fpc_append($sEcoTxt, "sValor_total=$sValor_total");
            $aIns[] = array("sValor_total", $sValor_total);
         } // if (isset($oRet->valor_total))
         
         if (isset($oRet->utm_campaign)) { // "utm_campaign": null,
            $sUtm_campaign = utf8_decode($oRet->utm_campaign);
            fpc_append($sEcoTxt, "sUtm_campaign=$sUtm_campaign");
            $aIns[] = array("sUtm_campaign", $sUtm_campaign);
         } // if (isset($oRet->utm_campaign))
         
         if (isset($oRet->peso_real)) { // "peso_real": 0.6,
            $sPeso_real = utf8_decode($oRet->peso_real);
            fpc_append($sEcoTxt, "sPeso_real=$sPeso_real");
            $aIns[] = array("sPeso_real", $sPeso_real);
         } // if (isset($oRet->peso_real))
         
         if (isset($oRet->cliente_obs)) { // "cliente_obs": null,
            $sCliente_obs = utf8_decode($oRet->cliente_obs);
            fpc_append($sEcoTxt, "sCliente_obs=$sCliente_obs");
            $aIns[] = array("sCliente_obs", $sCliente_obs);
         } // if (isset($oRet->cliente_obs))
         
         if (isset($oRet->id_anymarket)) { // "id_anymarket": null,
            $sId_anymarket = utf8_decode($oRet->id_anymarket);
            fpc_append($sEcoTxt, "sId_anymarket=$sId_anymarket");
            $aIns[] = array("sId_anymarket", $sId_anymarket);
         } // if (isset($oRet->id_anymarket))
         
         if (isset($oRet->data_criacao)) { // "data_criacao": "2023-03-23T22:48:05.582Z",
            $sData_criacao = utf8_decode($oRet->data_criacao);
            fpc_append($sEcoTxt, "sData_criacao=$sData_criacao");
            $aIns[] = array("sData_criacao", $sData_criacao);
         } // if (isset($oRet->data_criacao))
         
         if (isset($oRet->data_modificacao)) { // "data_modificacao": "2023-03-23T22:48:39.301Z",
            $sData_modificacao = utf8_decode($oRet->data_modificacao);
            fpc_append($sEcoTxt, "sData_modificacao=$sData_modificacao");
            $aIns[] = array("sData_modificacao", $sData_modificacao);
         } // if (isset($oRet->data_modificacao))
         
         if (isset($oRet->data_expiracao)) { // "data_expiracao": "2023-03-29T22:48:05.665Z",
            $sData_expiracao = utf8_decode($oRet->data_expiracao);
            fpc_append($sEcoTxt, "sData_expiracao=$sData_expiracao");
            $aIns[] = array("sData_expiracao", $sData_expiracao);
         } // if (isset($oRet->data_expiracao))

         if (isset($oRet->cliente)) { // "cliente": {
            $oClientes = $oRet->cliente;
            $aInsCli = array();

          
            if (isset($oCliente->id)) { // "id": 56827792,
               $sId = utf8_decode($oCliente->id);
               fpc_append($sEcoTxt, "sId=$sId");
               $aInsCli[] = array("sId", $sId);
            } // if (isset($oCliente->id))

            if (isset($oCliente->email)) { // "email": "teste123@gmail.com",
               $sEmail = utf8_decode($oCliente->email);
               fpc_append($sEcoTxt, "sEmail=$sEmail");
               $aInsCli[] = array("sEmail", $sEmail);
            } // if (isset($oCliente->email))

            if (isset($oCliente->nome)) { // "nome": "teste aa dddd",
               $sNome = utf8_decode($oCliente->nome);
               fpc_append($sEcoTxt, "sNome=$sNome");
               $aInsCli[] = array("sNome", $sNome);
            } // if (isset($oCliente->nome))

            if (isset($oCliente->telefone_celular)) { // "telefone_celular": "31338893773",
               $sTelefone_celular = utf8_decode($oCliente->telefone_celular);
               fpc_append($sEcoTxt, "sTelefone_celular=$sTelefone_celular");
               $aInsCli[] = array("sTelefone_celular", $sTelefone_celular);
            } // if (isset($oCliente->telefone_celular))

            if (isset($oCliente->telefone_comercial)) { // "telefone_comercial": null,
               $sTelefone_comercial = utf8_decode($oCliente->telefone_comercial);
               fpc_append($sEcoTxt, "sTelefone_comercial=$sTelefone_comercial");
               $aInsCli[] = array("sTelefone_comercial", $sTelefone_comercial);
            } // if (isset($oCliente->telefone_comercial))

            if (isset($oCliente->telefone_principal)) { // "telefone_principal": "31938873772",
               $sTelefone_principal = utf8_decode($oCliente->telefone_principal);
               fpc_append($sEcoTxt, "sTelefone_principal=$sTelefone_principal");
               $aInsCli[] = array("sTelefone_principal", $sTelefone_principal);
            } // if (isset($oCliente->telefone_principal))

            if (isset($oCliente->situacao)) { // "situacao": "pendente",
               $sSituacao = utf8_decode($oCliente->situacao);
               fpc_append($sEcoTxt, "sSituacao=$sSituacao");
               $aInsCli[] = array("sSituacao", $sSituacao);
            } // if (isset($oCliente->situacao))

            if (isset($oCliente->data_nascimento)) { // "data_nascimento": "1990-12-12",
               $sData_nascimento = utf8_decode($oCliente->data_nascimento);
               fpc_append($sEcoTxt, "sData_nascimento=$sData_nascimento");
               $aInsCli[] = array("sData_nascimento", $sData_nascimento);
            } // if (isset($oCliente->data_nascimento))

            if (isset($oCliente->sexo)) { // "sexo": "m",
               $sSexo = utf8_decode($oCliente->sexo);
               fpc_append($sEcoTxt, "sSexo=$sSexo");
               $aInsCli[] = array("sSexo", $sSexo);
            } // if (isset($oCliente->sexo))

            if (isset($oCliente->data_criacao)) { // "data_criacao": "2023-03-22T20:03:57.838283-03:00",
               $sData_criacao = utf8_decode($oCliente->data_criacao);
               fpc_append($sEcoTxt, "sData_criacao=$sData_criacao");
               $aInsCli[] = array("sData_criacao", $sData_criacao);
            } // if (isset($oCliente->data_criacao))

            if (isset($oCliente->data_modificacao)) { // "data_modificacao": "2023-03-22T20:03:57.838298-03:00"
               $sData_modificacao = utf8_decode($oCliente->data_modificacao);
               fpc_append($sEcoTxt, "sData_modificacao=$sData_modificacao");
               $aInsCli[] = array("sData_modificacao", $sData_modificacao);
            } // if (isset($oCliente->data_modificacao))
         } // foreach ($oClientes as $oCliente)
      } // if (isset($oRet->cliente))

      if (isset($oRet->cupom_desconto)) { // "cupom_desconto": {
         $oCupons = $oRet->cupom_desconto
         $aInsCupom[] = array();

         if (isset($oCupons->id)) { // "id": null,
            $sId = utf8_decode($oCupons->id);
            fpc_append($sEcoTxt, "sId=$sId");
            $aInsCupom = array("sId", $sId);
         } // if (isset($oCupons->id))
         
         if (isset($oCupons->codigo)) { // "codigo": null,
            $sCodigo = utf8_decode($oCupons->codigo);
            fpc_append($sEcoTxt, "sCodigo=$sCodigo");
            $aInsCupom = array("sCodigo", $sCodigo);
         } // if (isset($oCupons->codigo))
         
         if (isset($oCupons->tipo)) { // "tipo": null
            $sTipo = utf8_decode($oCupons->tipo);
            fpc_append($sEcoTxt, "sTipo=$sTipo");
            $aInsCupom = array("sTipo", $sTipo);
         } // if (isset($oCupons->tipo))

      } // if (isset($oRet->cupom_desconto))

      if (isset($oRet->endereco_entrega)) {  // "endereco_entrega": {
         $oEndEntrega = $oRet->endereco_entrega;
         $aInsEndEnt = array();

         if (isset($oEndEntrega->id)) { // "id": 63198643,
            $sId = utf8_decode($oEndEntrega->id);
            fpc_append($sEcoTxt, "sId=$sId");
            $aInsEndEnt[] = array("sId", $sId);
         } // if (isset($oEndEntrega->id))
         
         if (isset($oEndEntrega->tipo)) { // "tipo": "PF",
            $sTipo = utf8_decode($oEndEntrega->tipo);
            fpc_append($sEcoTxt, "sTipo=$sTipo");
            $aInsEndEnt[] = array("sTipo", $sTipo);
         } // if (isset($oEndEntrega->tipo))
         
         if (isset($oEndEntrega->ie)) { // "ie": null,
            $sIE = utf8_decode($oEndEntrega->ie);
            fpc_append($sEcoTxt, "sIE=$sIE");
            $aInsEndEnt[] = array("sIE", $sIE);
         } // if (isset($oEndEntrega->ie))
         
         if (isset($oEndEntrega->cnpj)) { // "cnpj": null,
            $sCNPJ = utf8_decode($oEndEntrega->cnpj);
            fpc_append($sEcoTxt, "sCNPJ=$sCNPJ");
            $aInsEndEnt[] = array("sCNPJ", $sCNPJ);
         } // if (isset($oEndEntrega->cnpj))
         
         if (isset($oEndEntrega->cpf)) { // "cpf": "12345678901",
            $sCPF = utf8_decode($oEndEntrega->cpf);
            fpc_append($sEcoTxt, "sCPF=$sCPF");
            $aInsEndEnt[] = array("sCPF", $sCPF);
         } // if (isset($oEndEntrega->cpf))
         
         if (isset($oEndEntrega->rg)) { // "rg": null,
            $sRG = utf8_decode($oEndEntrega->rg);
            fpc_append($sEcoTxt, "sRG=$sRG");
            $aInsEndEnt[] = array("sRG", $sRG);
         } // if (isset($oEndEntrega->rg))
         
         if (isset($oEndEntrega->nome)) { // "nome": "teste aa dddd",
            $sNome = utf8_decode($oEndEntrega->nome);
            fpc_append($sEcoTxt, "sNome=$sNome");
            $aInsEndEnt[] = array("sNome", $sNome);
         } // if (isset($oEndEntrega->nome))
         
         if (isset($oEndEntrega->razao_social)) { // "razao_social": null,
            $sRazao_social = utf8_decode($oEndEntrega->razao_social);
            fpc_append($sEcoTxt, "sRazao_social=$sRazao_social");
            $aInsEndEnt[] = array("sRazao_social", $sRazao_social);
         } // if (isset($oEndEntrega->razao_social))
         
         if (isset($oEndEntrega->endereco)) { // "endereco": "Rua Escocia",
            $sEndereco = utf8_decode($oEndEntrega->endereco);
            fpc_append($sEcoTxt, "sEndereco=$sEndereco");
            $aInsEndEnt[] = array("sEndereco", $sEndereco);
         } // if (isset($oEndEntrega->endereco))
         
         if (isset($oEndEntrega->numero)) { // "numero": "22",
            $sNumero = utf8_decode($oEndEntrega->numero);
            fpc_append($sEcoTxt, "sNumero=$sNumero");
            $aInsEndEnt[] = array("sNumero", $sNumero);
         } // if (isset($oEndEntrega->numero))
         
         if (isset($oEndEntrega->complemento)) { // "complemento": "complemento",
            $sComplemento = utf8_decode($oEndEntrega->complemento);
            fpc_append($sEcoTxt, "sComplemento=$sComplemento");
            $aInsEndEnt[] = array("sComplemento", $sComplemento);
         } // if (isset($oEndEntrega->complemento))
         
         if (isset($oEndEntrega->referencia)) { // "referencia": "referencia",
            $sReferencia = utf8_decode($oEndEntrega->referencia);
            fpc_append($sEcoTxt, "sReferencia=$sReferencia");
            $aInsEndEnt[] = array("sReferencia", $sReferencia);
         } // if (isset($oEndEntrega->referencia))
         
         if (isset($oEndEntrega->bairro)) { // "bairro": "Jardim Europa",
            $sBairro = utf8_decode($oEndEntrega->bairro);
            fpc_append($sEcoTxt, "sBairro=$sBairro");
            $aInsEndEnt[] = array("sBairro", $sBairro);
         } // if (isset($oEndEntrega->bairro))
         
         if (isset($oEndEntrega->cidade)) { // "cidade": "Sao Paulo",
            $sCidade = utf8_decode($oEndEntrega->cidade);
            fpc_append($sEcoTxt, "sCidade=$sCidade");
            $aInsEndEnt[] = array("sCidade", $sCidade);
         } // if (isset($oEndEntrega->cidade))
         
         if (isset($oEndEntrega->estado)) { // "estado": "SP",
            $sEstado = utf8_decode($oEndEntrega->estado);
            fpc_append($sEcoTxt, "sEstado=$sEstado");
            $aInsEndEnt[] = array("sEstado", $sEstado);
         } // if (isset($oEndEntrega->estado))
         
         if (isset($oEndEntrega->cep)) { // "cep": "01450000",
            $sCEP = utf8_decode($oEndEntrega->cep);
            fpc_append($sEcoTxt, "sCEP=$sCEP");
            $aInsEndEnt[] = array("sCEP", $sCEP);
         } // if (isset($oEndEntrega->cep))
         
         if (isset($oEndEntrega->pais)) { // "pais": "Brasil"
            $sPais = utf8_decode($oEndEntrega->pais);
            fpc_append($sEcoTxt, "sPais=$sPais");
            $aInsEndEnt[] = array("sPais", $sPais);
         } // if (isset($oEndEntrega->pais))

      } // if (isset($oRet->endereco_entrega))

         if (isset($oRet->endereco_pagamento)) { // "endereco_pagamento": {
            $oEndPgmto = $oRet->endereco_pagamento;
            $aInsEndPgmto = array();

            if (isset($oEndPgmto->id)) { // "id": 63198644,
               $sId = utf8_decode($oEndPgmto->id);
               fpc_append($sEcoTxt, "sId=$sId");
               $aInsEndPgmto[] = array("sId", $sId);
            } // if (isset($oEndPgmto->id))
            
            if (isset($oEndPgmto->tipo)) { // "tipo": null,
               $sTipo = utf8_decode($oEndPgmto->tipo);
               fpc_append($sEcoTxt, "sTipo=$sTipo");
               $aInsEndPgmto[] = array("sTipo", $sTipo);
            } // if (isset($oEndPgmto->tipo))
            
            if (isset($oEndPgmto->ie)) { // "ie": null,
               $sIE = utf8_decode($oEndPgmto->ie);
               fpc_append($sEcoTxt, "sIE=$sIE");
               $aInsEndPgmto[] = array("sIE", $sIE);
            } // if (isset($oEndPgmto->ie))
            
            if (isset($oEndPgmto->cnpj)) { // "cnpj": null,
               $sCNPJ = utf8_decode($oEndPgmto->cnpj);
               fpc_append($sEcoTxt, "sCNPJ=$sCNPJ");
               $aInsEndPgmto[] = array("sCNPJ", $sCNPJ);
            } // if (isset($oEndPgmto->cnpj))
            
            if (isset($oEndPgmto->rg)) { // "rg": null,
               $sRG = utf8_decode($oEndPgmto->rg);
               fpc_append($sEcoTxt, "sRG=$sRG");
               $aInsEndPgmto[] = array("sRG", $sRG);
            } // if (isset($oEndPgmto->rg))
            
            if (isset($oEndPgmto->nome)) { // "nome": "teste aa dddd",
               $sNome = utf8_decode($oEndPgmto->nome);
               fpc_append($sEcoTxt, "sNome=$sNome");
               $aInsEndPgmto[] = array("sNome", $sNome);
            } // if (isset($oEndPgmto->nome))
            
            if (isset($oEndPgmto->razao_social)) { // "razao_social": null,
               $sRazao_social = utf8_decode($oEndPgmto->razao_social);
               fpc_append($sEcoTxt, "sRazao_social=$sRazao_social");
               $aInsEndPgmto[] = array("sRazao_social", $sRazao_social);
            } // if (isset($oEndPgmto->razao_social))

            if (isset($oEndPgmto->endereco)) { // "endereco": "Rua dos Caquizeiros",
               $sEndereco = utf8_decode($oEndPgmto->endereco);
               fpc_append($sEcoTxt, "sEndereco=$sEndereco");
               $aInsEndPgmto[] = array("sEndereco", $sEndereco);
            } // if (isset($oEndPgmto->endereco))
            
            if (isset($oEndPgmto->numero)) { // "numero": "22",
               $sNumero = utf8_decode($oEndPgmto->numero);
               fpc_append($sEcoTxt, "sNumero=$sNumero");
               $aInsEndPgmto[] = array("sNumero", $sNumero);
            } // if (isset($oEndPgmto->numero))
            
            if (isset($oEndPgmto->complemento)) { // "complemento": "complemento",
               $sComplemento = utf8_decode($oEndPgmto->complemento);
               fpc_append($sEcoTxt, "sComplemento=$sComplemento");
               $aInsEndPgmto[] = array("sComplemento", $sComplemento);
            } // if (isset($oEndPgmto->complemento))
            
            if (isset($oEndPgmto->referencia)) { // "referencia": "referencia",
               $sReferencia = utf8_decode($oEndPgmto->referencia);
               fpc_append($sEcoTxt, "sReferencia=$sReferencia");
               $aInsEndPgmto[] = array("sReferencia", $sReferencia);
            } // if (isset($oEndPgmto->referencia))
            
            if (isset($oEndPgmto->bairro)) { // "bairro": "Jardim Celeste",
               $sBairro = utf8_decode($oEndPgmto->bairro);
               fpc_append($sEcoTxt, "sBairro=$sBairro");
               $aInsEndPgmto[] = array("sBairro", $sBairro);
            } // if (isset($oEndPgmto->bairro))
            
            if (isset($oEndPgmto->cidade)) { // "cidade": "Sinop",
               $sCidade = utf8_decode($oEndPgmto->cidade);
               fpc_append($sEcoTxt, "sCidade=$sCidade");
               $aInsEndPgmto[] = array("sCidade", $sCidade);
            } // if (isset($oEndPgmto->cidade))
            
            if (isset($oEndPgmto->estado)) { // "estado": "MT",
               $sEstado = utf8_decode($oEndPgmto->estado);
               fpc_append($sEcoTxt, "sEstado=$sEstado");
               $aInsEndPgmto[] = array("sEstado", $sEstado);
            } // if (isset($oEndPgmto->estado))
            
            if (isset($oEndPgmto->pais)) { // "pais": "Brasil"
               $sPais = utf8_decode($oEndPgmto->pais);
               fpc_append($sEcoTxt, "sPais=$sPais");
               $aInsEndPgmto[] = array("sPais", $sPais);
            } // if (isset($oEndPgmto->pais))

         } // if (isset($oRet->endereco_pagamento))

         if (isset($oRet->envios)) { // "envios": [{
            $oEnvios = $oRet->envios;
            $aInsEnv = array();

            foreach ($oEnvios as $oEnv) {

            if (isset($oEnv->id)) // "id": 75213630,
               $sId = utf8_decode($oEnv->id);
               fpc_append($sEcoTxt, "sId=$sId");
               $aInsEnv[] = array("sId", $sId);
            } // if (isset($oEnv->id))
         
            if (isset($oEnv->objeto)) // "objeto": null,
               $sObjeto = utf8_decode($oEnv->objeto);
               fpc_append($sEcoTxt, "sObjeto=$sObjeto");
               $aInsEnv[] = array("sObjeto", $sObjeto);
            } // if (isset($oEnv->objeto))
         
            if (isset($oEnv->prazo)) // "prazo": 1,
               $sPrazo = utf8_decode($oEnv->prazo);
               fpc_append($sEcoTxt, "sPrazo=$sPrazo");
               $aInsEnv[] = array("sPrazo", $sPrazo);
            } // if (isset($oEnv->prazo))
         
            if (isset($oEnv->valor)) // "valor": null,
               $sValor = utf8_decode($oEnv->valor);
               fpc_append($sEcoTxt, "sValor=$sValor");
               $aInsEnv[] = array("sValor", $sValor);
            } // if (isset($oEnv->valor))
         
            if (isset($oEnv->data_criacao)) // "data_criacao": "2023-03-23T19:48:05.600305-03:00",
               $sData_criacao = utf8_decode($oEnv->data_criacao);
               fpc_append($sEcoTxt, "sData_criacao=$sData_criacao");
               $aInsEnv[] = array("sData_criacao", $sData_criacao);
            } // if (isset($oEnv->data_criacao))
         
            if (isset($oEnv->data_modificacao)) // "data_modificacao": "2023-03-23T19:48:05.600325-03:00",
               $sData_modificacao = utf8_decode($oEnv->data_modificacao);
               fpc_append($sEcoTxt, "sData_modificacao=$sData_modificacao");
               $aInsEnv[] = array("sData_modificacao", $sData_modificacao);
            } // if (isset($oEnv->data_modificacao))
            
            if (isset($oEnv->forma_envio)) { // "forma_envio": {
               $oFormaEnv = $oEnv->forma_envio;

               if (isset($oFormaEnv->id)) { // "id": 12015,
                  $sId = utf8_decode($oFormaEnv->id);
                  fpc_append($sEcoTxt, "sId=$sId");
                  $aInsEnv[] = array("sId", $sId);
               } // if (isset($oFormaEnv->id))

               if (isset($oFormaEnv->codigo)) { // "codigo": "retirar_pessoalmente",
                  $sCodigo = utf8_decode($oFormaEnv->codigo);
                  fpc_append($sEcoTxt, "sCodigo=$sCodigo");
                  $aInsEnv[] = array("sCodigo", $sCodigo);
               } // if (isset($oFormaEnv->codigo))
         
               if (isset($oFormaEnv->nome)) { // "nome": "Retirar pessoalmente"
                  $sNome = utf8_decode($oFormaEnv->nome);
                  fpc_append($sEcoTxt, "sNome=$sNome");
                  $aInsEnv[] = array("sNome", $sNome);
               } // if (isset($oFormaEnv->nome))

            } // foreach ($oEnvios as $oEnv)
         } // if (isset($oRet->envios))

         if (isset($oRet->pagamentos)) { // "pagamentos": [{
            $oPagamentos = $oRet->pagamentos;
            $aInsPgmto = array();

            foreach ($oPagamentos as $oPgmto) {

               if (isset($oPgmto->id)) { // "id": 75213751,
                  $sId = utf8_decode($oPgmto->id);
                  fpc_append($sEcoTxt, "sId=$sId");
                  $aInsPgmto[] = array("sId", $sId);
               } // if (isset($oPgmto->id))
         
               if (isset($oPgmto->identificador_id)) { // "identificador_id": null,
                  $sIdentificador_id = utf8_decode($oPgmto->identificador_id);
                  fpc_append($sEcoTxt, "sIdentificador_id=$sIdentificador_id");
                  $aInsPgmto[] = array("sIdentificador_id", $sIdentificador_id);
               } // if (isset($oPgmto->identificador_id))
         
               if (isset($oPgmto->authorization_code)) { // "authorization_code": null,
                  $sAuthorization_code = utf8_decode($oPgmto->authorization_code);
                  fpc_append($sEcoTxt, "sAuthorization_code=$sAuthorization_code");
                  $aInsPgmto[] = array("sAuthorization_code", $sAuthorization_code);
               } // if (isset($oPgmto->authorization_code))
         
               if (isset($oPgmto->bandeira)) { // "bandeira": null,
                  $sBandeira = utf8_decode($oPgmto->bandeira);
                  fpc_append($sEcoTxt, "sBandeira=$sBandeira");
                  $aInsPgmto[] = array("sBandeira", $sBandeira);
               } // if (isset($oPgmto->bandeira))

               if (isset($oPgmto->mensagem_gateway)) { // "mensagem_gateway": null,
                  $sMensagem_gateway = utf8_decode($oPgmto->mensagem_gateway);
                  fpc_append($sEcoTxt, "sMensagem_gateway=$sMensagem_gateway");
                  $aInsPgmto[] = array("sMensagem_gateway", $sMensagem_gateway);
               } // if (isset($oPgmto->mensagem_gateway))
         
               if (isset($oPgmto->codigo_retorno_gateway)) { // "codigo_retorno_gateway": null,
                  $sCodigo_retorno_gateway = utf8_decode($oPgmto->codigo_retorno_gateway);
                  fpc_append($sEcoTxt, "sCodigo_retorno_gateway=$sCodigo_retorno_gateway");
                  $aInsPgmto[] = array("sCodigo_retorno_gateway", $sCodigo_retorno_gateway);
               } // if (isset($oPgmto->codigo_retorno_gateway))
         
               if (isset($oPgmto->transacao_id)) { // "transacao_id": null,
                  $sTransacao_id = utf8_decode($oPgmto->transacao_id);
                  fpc_append($sEcoTxt, "sTransacao_id=$sTransacao_id");
                  $aInsPgmto[] = array("sTransacao_id", $sTransacao_id);
               } // if (isset($oPgmto->transacao_id))
         
               if (isset($oPgmto->valor)) { // "valor": 169.41,
                  $sValor = utf8_decode($oPgmto->valor);
                  fpc_append($sEcoTxt, "sValor=$sValor");
                  $aInsPgmto[] = array("sValor", $sValor);
               } // if (isset($oPgmto->valor))
         
               if (isset($oPgmto->valor_pago)) { // "valor_pago": 169.41,
                  $sValor_pago = utf8_decode($oPgmto->valor_pago);
                  fpc_append($sEcoTxt, "sValor_pago=$sValor_pago");
                  $aInsPgmto[] = array("sValor_pago", $sValor_pago);
               } // if (isset($oPgmto->valor_pago))
         
               if (isset($oPgmto->data_criacao)) { // "data_criacao": "2023-03-23T19:48:05.594093-03:00",
                  $sData_criacao = utf8_decode($oPgmto->data_criacao);
                  fpc_append($sEcoTxt, "sData_criacao=$sData_criacao");
                  $aInsPgmto[] = array("sData_criacao", $sData_criacao);
               } // if (isset($oPgmto->data_criacao))

               if (isset($oPgmto->data_modificacao)) { // "data_modificacao": "2023-03-23T19:48:20.088216-03:00",
                  $sData_modificacao = utf8_decode($oPgmto->data_modificacao);
                  fpc_append($sEcoTxt, "sData_modificacao=$sData_modificacao");
                  $aInsPgmto[] = array("sData_modificacao", $sData_modificacao);
               } // if (isset($oPgmto->data_modificacao))

               if (isset($oPgmto->forma_pagamento)) { // "forma_pagamento": {
                  $oFormaPgmto = $oPgmto->forma_pagamento;

                  if (isset($oFormaPgmto->id)) { // "id": 13,
                     $sId = utf8_decode($oFormaPgmto->id);
                     fpc_append($sEcoTxt, "sId=$sId");
                     $aInsPgmto[] = array("sId", $sId);
                  } // if (isset($oFormaPgmto->id))
         
                  if (isset($oFormaPgmto->codigo)) { // "codigo": "entrega",
                     $sCodigo = utf8_decode($oFormaPgmto->codigo);
                     fpc_append($sEcoTxt, "sCodigo=$sCodigo");
                     $aInsPgmto[] = array("sCodigo", $sCodigo);
                  } // if (isset($oFormaPgmto->codigo))
         
                  if (isset($oFormaPgmto->nome)) { // "nome": "Pagamento na entrega"
                     $sNome = utf8_decode($oFormaPgmto->nome);
                     fpc_append($sEcoTxt, "sNome=$sNome");
                     $aInsPgmto[] = array("sNome", $sNome);
                  } // if (isset($oFormaPgmto->nome))
               } // if (isset($oPgmto->forma_pagamento))

            } // foreach ($oPagamentos as $oPgmto)
         } // if (isset($oRet->pagamentos))

         if (isset($oRet->situacao)) { // "situacao": {
            $oSitu = $oRet->situacao;

            if (isset($oSitu->id)) { // "id": 3,
               $sId = utf8_decode($oSitu->id);
               fpc_append($sEcoTxt, "sId=$sId");
               $aIns[] = array("sId", $sId);
            } // if (isset($oSitu->id))

            if (isset($oSitu->codigo)) { // "codigo": "pagamento_em_analise",
               $sCodigo = utf8_decode($oSitu->codigo);
               fpc_append($sEcoTxt, "sCodigo=$sCodigo");
               $aIns[] = array("sCodigo", $sCodigo);
            } // if (isset($oSitu->codigo))
         
            if (isset($oSitu->nome)) { // "nome": "Pagamento em anlise",
               $sNome = utf8_decode($oSitu->nome);
               fpc_append($sEcoTxt, "sNome=$sNome");
               $aIns[] = array("sNome", $sNome);
            } // if (isset($oSitu->nome))
         
            if (isset($oSitu->aprovado)) { // "aprovado": false,
               $sAprovado = utf8_decode($oSitu->aprovado);
               $sAprovado = $sAprovado=='' ? 0 : 1;
               fpc_append($sEcoTxt, "sAprovado=$sAprovado");
               $aIns[] = array("sAprovado", $sAprovado);
            } // if (isset($oSitu->aprovado))
         
            if (isset($oSitu->cancelado)) { // "cancelado": false,
               $sCancelado = utf8_decode($oSitu->cancelado);
               $sCancelado = $sCancelado=='' ? 0 : 1;
               fpc_append($sEcoTxt, "sCancelado=$sCancelado");
               $aIns[] = array("sCancelado", $sCancelado);
            } // if (isset($oSitu->cancelado))
         
            if (isset($oSitu->final)) { // "final": false,
               $sFinal = utf8_decode($oSitu->final);
               $sFinal = $sFinal=='' ? 0 : 1;
               fpc_append($sEcoTxt, "sFinal=$sFinal");
               $aIns[] = array("sFinal", $sFinal);
            } // if (isset($oSitu->final))
         
            if (isset($oSitu->notificar_comprador)) { // "notificar_comprador": true,
               $sNotificar_comprador = utf8_decode($oSitu->notificar_comprador);
               $sNotificar_comprador = $sNotificar_comprador=='' ? 0 : 1;
               fpc_append($sEcoTxt, "sNotificar_comprador=$sNotificar_comprador");
               $aIns[] = array("sNotificar_comprador", $sNotificar_comprador);
            } // if (isset($oSitu->notificar_comprador))
         
            if (isset($oSitu->padrao)) { // "padrao": false,
               $sPadrao = utf8_decode($oSitu->padrao);
               $sPadrao = $sPadrao=='' ? 0 : 1;
               fpc_append($sEcoTxt, "sPadrao=$sPadrao");
               $aIns[] = array("sPadrao", $sPadrao);
            } // if (isset($oSitu->padrao))
         
            if (isset($oSitu->situacao_alterada)) { // "situacao_alterada": true
               $sSituacao_alterada = utf8_decode($oSitu->situacao_alterada);
               $sSituacao_alterada = $sSituacao_alterada=='' ? 0 : 1;
               fpc_append($sEcoTxt, "sSituacao_alterada=$sSituacao_alterada");
               $aIns[] = array("sSituacao_alterada", $sSituacao_alterada);
            } // if (isset($oSitu->situacao_alterada))

         } // if (isset($oRet->situacao))

         if (isset($oRet->itens)) { // "itens": [
            $oItens = $oRet->itens;
            $aInsItens = array();

            foreach ($oItens as $oItem) { 

               if (isset($oItem->linha)) { // "linha": 1,
                  $sLinha = utf8_decode($oItem->linha);
                  fpc_append($sEcoTxt, "sLinha=$sLinha");
                  $aInsItens[] = array("sLinha", $sLinha);
               } // if (isset($oItem->linha))
         
               if (isset($oItem->id)) { // "id": 170235106,
                  $sId = utf8_decode($oItem->id);
                  fpc_append($sEcoTxt, "sId=$sId");
                  $aInsItens[] = array("sId", $sId);
               } // if (isset($oItem->id))
         
               if (isset($oItem->produto_id)) { // "produto_id": 209615743,
                  $sProduto_id = utf8_decode($oItem->produto_id);
                  fpc_append($sEcoTxt, "sProduto_id=$sProduto_id");
                  $aInsItens[] = array("sProduto_id", $sProduto_id);
               } // if (isset($oItem->produto_id))
         
               if (isset($oItem->produto_id_pai)) { // "produto_id_pai": 209615737,
                  $sProduto_id_pai = utf8_decode($oItem->produto_id_pai);
                  fpc_append($sEcoTxt, "sProduto_id_pai=$sProduto_id_pai");
                  $aInsItens[] = array("sProduto_id_pai", $sProduto_id_pai);
               } // if (isset($oItem->produto_id_pai))
         
               if (isset($oItem->sku)) { // "sku": "912321123",
                  $sSku = utf8_decode($oItem->sku);
                  fpc_append($sEcoTxt, "sSku=$sSku");
                  $aInsItens[] = array("sSku", $sSku);
               } // if (isset($oItem->sku))
         
               if (isset($oItem->nome)) { // "nome": "Produto teste abc",
                  $sNome = utf8_decode($oItem->nome);
                  fpc_append($sEcoTxt, "sNome=$sNome");
                  $aInsItens[] = array("sNome", $sNome);
               } // if (isset($oItem->nome))
         
               if (isset($oItem->tipo)) { // "tipo": "atributo_opcao",
                  $sTipo = utf8_decode($oItem->tipo);
                  fpc_append($sEcoTxt, "sTipo=$sTipo");
                  $aInsItens[] = array("sTipo", $sTipo);
               } // if (isset($oItem->tipo))
         
               if (isset($oItem->quantidade)) { // "quantidade": 1,
                  $sQuantidade = utf8_decode($oItem->quantidade);
                  fpc_append($sEcoTxt, "sQuantidade=$sQuantidade");
                  $aInsItens[] = array("sQuantidade", $sQuantidade);
               } // if (isset($oItem->quantidade))
         
               if (isset($oItem->preco_cheio)) { // "preco_cheio": 169.41,
                  $sPreco_cheio = utf8_decode($oItem->preco_cheio);
                  fpc_append($sEcoTxt, "sPreco_cheio=$sPreco_cheio");
                  $aInsItens[] = array("sPreco_cheio", $sPreco_cheio);
               } // if (isset($oItem->preco_cheio))
         
               if (isset($oItem->preco_custo)) { // "preco_custo": null,
                  $sPreco_custo = utf8_decode($oItem->preco_custo);
                  fpc_append($sEcoTxt, "sPreco_custo=$sPreco_custo");
                  $aInsItens[] = array("sPreco_custo", $sPreco_custo);
               } // if (isset($oItem->preco_custo))
         
               if (isset($oItem->preco_venda)) { // "preco_venda": 169.41,
                  $sPreco_custo = utf8_decode($oItem->preco_venda);
                  fpc_append($sEcoTxt, "sPreco_custo=$sPreco_custo");
                  $aInsItens[] = array("sPreco_custo", $sPreco_custo);
               } // if (isset($oItem->preco_venda))
         
               if (isset($oItem->preco_subtotal)) { // "preco_subtotal": 169.41
                  $sPreco_subtotal = utf8_decode($oItem->preco_subtotal);
                  fpc_append($sEcoTxt, "sPreco_subtotal=$sPreco_subtotal");
                  $aInsItens[] = array("sPreco_subtotal", $sPreco_subtotal);
               } // if (isset($oItem->preco_subtotal))
            } // foreach ($oItens as $oItem) {
         } // if (isset($oRet->itens))

         $iIns = count($aIns);
         if ($iIns>0) {
            $sSql = fsArrToInsert('LJI_Marca',$aIns);
            fpc_append($sEcoTxt,"sSql=$sSql");
            $aSql[] = $sSql;
         } // if ($aIns>0)

         foreach ($aSql as $sSql) {
            // insert real
         } // foreach ($aSql as $sSql)

      } // ($lOk==true)
   } // if ($lControlProc==false)

   if ($lOk==true) {
      fpc_append($sEcoTxt,"commit");
      flDBCommit($hDb);
   } else {
      $sRollback = fsDBRollBack($hDb);
      fpc_append($sEcoTxt,"Rollback");
      fpc_append($sEcoTxt,"$sRollback");
   } // if ($lOk==true)
      
   $tJobEnd  = time();
   $iJobElap = $tJobEnd-$tJobStart;

   $aTop    = faLoadAvgServer();
   $nTopFin = $aTop[0];

   list($iUsec, $iSec) = explode(' ', microtime());
   $tScript_End = (float) $iSec + (float) $iUsec;

   $tElapsed_Time = round($tScript_End - $tScript_Start, 5);
   fpc_append($sEcoTxt,'Encerrado em '.date('d/m/Y H:i:s',$tJobEnd));

   fpc_append($sEcoTxt,"Tempo Decorrido: ".gmdate("H:i:s", $tElapsed_Time).', Secs: '.$tElapsed_Time.". Memoria usada: ".round(((memory_get_peak_usage(true) / 1024) / 1024), 2)."Mb");

   flDbDisconnect($hDb);

} else {
   echo 'Arquivo de configurao no foi encontrado.';
}

$aTop    = faLoadAvgServer();
$nTopFin = $aTop[0];

$flSysJobs = flSysJobs($sProc,$nTopIni,$nTopFin,$tJobStart,$tJobEnd,$iJobElap,$psCliPasta,$psLogin);
