<?php
set_time_limit(300);
//error_reporting(E_ALL);
require_once("../pFuncoes1.php");
require_once("../pPublics1.php");	

list($iUsec, $iSec) = explode(' ', microtime());
$tScript_Start = (float) $iSec + (float) $iUsec;

$psCliPasta = fsCliPasta();

$aTop      = faLoadAvgServer();
$nTopIni   = $aTop[0];
$tJobStart = time();
$sProc     = basename(__FILE__);

$sEcoNome  = str_replace('.','_',$sProc).'-'.$tJobStart.'.log';
$sEcoTxt = "/qtux/www/FullPlat/processos/logs/$sEcoNome";
$sEcoTxt = fsDirEcoTxt($sEcoTxt);

$iProcID              = getmypid();
$lProducao            = true;
$aUserLog             = array();
$iCount_oOrdensColeta = 0;

fpc($sEcoTxt,'Incio em ' . date('d/m/Y H:i:s',$tJobStart));
fpc_append($sEcoTxt,'iProcID='.$iProcID);
fpc_append($sEcoTxt,"lProducao=$lProducao");
fpc_append($sEcoTxt,"psCliPasta=$psCliPasta");

$sFileConfig = "../../$psCliPasta/dd_files/Business.ddini";
fpc_append($sEcoTxt,"sFileConfig=$sFileConfig");

if (file_exists($sFileConfig)) {

   $sTxt = fsTXTFiltrar($sFileConfig);
   $aArr = explode(chr(10),$sTxt);
   $sVarsTxt = '';
   foreach ($aArr as $sLin) {
      $aLin = explode('//',$sLin);
      $sLin = trim($aLin[0]);
      $iLen = strlen($sLin);
      if ($iLen>0) {
         $aLin = explode('=',$sLin);
         $s1 = trim($aLin[0]);
         $iCountaLin = count($aLin);
         if ($iCountaLin>1) $s2 = trim($aLin[1]);
         else               $s2 = '';
         $s  = '$'.$s1." = '".$s2."';";
         eval($s);
         $sVarsTxt .= $s . chr(10);
      }
   }

   $lGo      = true;
   $lOk      = true;
   $lLigaQry = true;

   $psLogin = 1;

   $sDSN    = "$sHost:$sPathDB/$sDB";
   $sPathFS = $sPathFileSys;

   fpc_append($sEcoTxt,"sDSN = $sDSN, sPathFS = $sPathFS");

   $hDb = fhDbConnect($sDSN);

   //$lControlProc = flControlProc($hDb,$sProc);
   $lControlProc = flControlProcLinux($sProc);
   fpc_append($sEcoTxt,"lControlProc=$lControlProc");
   if ($lControlProc==false) {
      $lOk = false;
      fpc_append($sEcoTxt,"J TEM UM PROCESSO RODANDO [ $sProc ] NO IR RODAR, ESPERE O PROCESSO TERMINAR PARA RODAR NOVAMENTE.");
   } else {

      $sUrlIntegracao = 'https://api.awsli.com.br/v1/produto'; // /api/v1/produto?limit=20&offset=20
      fpc_append($sEcoTxt,"sUrlIntegracao=$sUrlIntegracao");
      
      $oRet = foGETLojaIntegrada(); // requisio da API loja integrada

      if ( ($lOk==true) && $oRet!='null') {

         $oMeta = isset($oRet->meta) ? $oRet->meta : 'null';

         foreach($oMeta as $sKey => $sValue) {
            if ((!is_array($sValue)) || (!is_object($sValue)) ) {
               fpc_append($sEcoTxt,"$sKey => $sValue");
               $aIns[] = array('s'.ucfirst($sKey),$sValue);
            }
         } // foreach($oRet as $sKey => $sValue)

         $aSql = array();

         $oObjects = isset($oRet->objects) ? $oRet->objects : 'null';
         foreach ($oObjects as $oObject) {

            $aIns = array();

            if (isset($oObject->apelido)) { // "apelido": "produto-teste-novo-2023-02-10-10-10-48",
               $sApelido = utf8_decode($oObject->apelido);
               fpc_append($sEcoTxt, "sApelido=$sApelido");
               $aIns[] = array("sApelido", $sApelido);
            } // if (isset($oObject->apelido))
            
            if (isset($oObject->ativo)) { // "ativo": false,
               $sAtivo = utf8_decode($oObject->ativo);
               $sAtivo = $sAtivo=='' ? 0 : 1;
               fpc_append($sEcoTxt, "sAtivo=$sAtivo");
               $aIns[] = array("sAtivo", $sAtivo);
            } // if (isset($oObject->ativo))
            
            if (isset($oObject->bloqueado)) { // "bloqueado": false,
               $sBloqueado = utf8_decode($oObject->bloqueado);
               $sBloqueado = $sBloqueado=='' ? 0 : 1;
               fpc_append($sEcoTxt, "sBloqueado=$sBloqueado");
               $aIns[] = array("sBloqueado", $sBloqueado);
            } // if (isset($oObject->bloqueado))

            if (isset($oObject->categorias)) { // "categorias": ["/api/v1/categoria/15246059"]",
               $aInsCat = array();
               $oObjectCat = $oObject->categorias;

               foreach ($oObjectCat as $sCat) {
                  fpc_append($sEcoTxt,"sCat=$sCat");
                  $aInsCat[] = array("sCat", $sCat);
               } // foreach ($oObjectCat as $sCat)
            } // if (isset($oObject->categorias))
            
            if (isset($oObject->descricao_completa)) { // "descricao_completa": "<strong>Desctio HTML do produto</strong>",
               $sDescricao_completa = utf8_decode($oObject->descricao_completa);
               fpc_append($sEcoTxt, "sDescricao_completa=$sDescricao_completa");
               $aIns[] = array("sDescricao_completa", $sDescricao_completa);
            } // if (isset($oObject->descricao_completa))
            
            if (isset($oObject->grades)) { // "grades": [],
               $aInsGra = array();
               $oObjectGra = $oObject->grades;

               foreach ($oObjectGra as $sGra) {
                  fpc_append($sEcoTxt, "sGra=$sGra");
                  $aInsGra[] = array("sGra", $sGra);
               } // foreach ($oObjectGra as $sGra)
            } // if (isset($oObject->grades))
            
            if (isset($oObject->gtin)) { // "gtin": null,
               $sGtin = utf8_decode($oObject->gtin);
               fpc_append($sEcoTxt, "sGtin=$sGtin");
               $aIns[] = array("sGtin", $sGtin);
            } // if (isset($oObject->gtin))
            
            if (isset($oObject->id)) { // "id": 202591789,
               $sId = utf8_decode($oObject->id);
               fpc_append($sEcoTxt, "sId=$sId");
               $aIns[] = array("sId", $sId);
            } // if (isset($oObject->id))
            
            if (isset($oObject->id_externo)) { // "id_externo": null,
               $sId_externo = utf8_decode($oObject->id_externo);
               fpc_append($sEcoTxt, "sId_externo=$sId_externo");
               $aIns[] = array("sId_externo", $sId_externo);
            } // if (isset($oObject->id_externo))
            
            if (isset($oObject->mpn)) { // "mpn": null,
               $sMpn = utf8_decode($oObject->mpn);
               fpc_append($sEcoTxt, "sMpn=$sMpn");
               $aIns[] = array("sMpn", $sMpn);
            } // if (isset($oObject->mpn))
            
            if (isset($oObject->ncm)) { // "ncm": null,
               $sNcm = utf8_decode($oObject->ncm);
               fpc_append($sEcoTxt, "sNcm=$sNcm");
               $aIns[] = array("sNcm", $sNcm);
            } // if (isset($oObject->ncm))
            
            if (isset($oObject->nome)) { // "nome": "Produto teste novo",
               $sNome = utf8_decode($oObject->nome);
               fpc_append($sEcoTxt, "sNome=$sNome");
               $aIns[] = array("sNome", $sNome);
            } // if (isset($oObject->nome))
            
            if (isset($oObject->removido)) { // "removido": false,
               $sRemovido = utf8_decode($oObject->removido);
               $sRemovido = $sRemovido=='' ? 0 : 1;
               fpc_append($sEcoTxt, "sRemovido=$sRemovido");
               $aIns[] = array("sRemovido", $sRemovido);
            } // if (isset($oObject->removido))
            
            if (isset($oObject->resource_uri)) { // "resource_uri": "/api/v1/produto/202591789",
               $sResource_uri = utf8_decode($oObject->resource_uri);
               fpc_append($sEcoTxt, "sResource_uri=$sResource_uri");
               $aIns[] = array("sResource_uri", $sResource_uri);
            } // if (isset($oObject->resource_uri))
            
            if (isset($oObject->seo)) { // "seo": "/api/v1/seo/88217435",
               $sSeo = utf8_decode($oObject->seo);
               fpc_append($sEcoTxt, "sSeo=$sSeo");
               $aIns[] = array("sSeo", $sSeo);
            } // if (isset($oObject->seo))
            
            if (isset($oObject->sku)) { // "sku": "prod-009",
               $sSku = utf8_decode($oObject->sku);
               fpc_append($sEcoTxt, "sSku=$sSku");
               $aIns[] = array("sSku", $sSku);
            } // if (isset($oObject->sku))
            
            if (isset($oObject->tipo)) { // "tipo": "normal",
               $sTipo = utf8_decode($oObject->tipo);
               fpc_append($sEcoTxt, "sTipo=$sTipo");
               $aIns[] = array("sTipo", $sTipo);
            } // if (isset($oObject->tipo))
            
            if (isset($oObject->url)) { // "url": "https://loja-exemplo.lojaintegrada.com.br/produto/produto-teste-novo-2023-02-10-10-10-48.html",
               $sUrl = utf8_decode($oObject->url);
               fpc_append($sEcoTxt, "sUrl=$sUrl");
               $aIns[] = array("sUrl", $sUrl);
            } // if (isset($oObject->url))
            
            if (isset($oObject->url_video_youtube)) { // "url_video_youtube": null,
               $sUrl_video_youtube = utf8_decode($oObject->url_video_youtube);
               fpc_append($sEcoTxt, "sUrl_video_youtube=$sUrl_video_youtube");
               $aIns[] = array("sUrl_video_youtube", $sUrl_video_youtube);
            } // if (isset($oObject->url_video_youtube))
            
            if (isset($oObject->variacoes)) { // "variacoes": []
               $aInsVar = array();
               $oObjectVar = $oObject->variacoes;
               foreach ($oObjectVar as $sVar) {
                  fpc_append($sEcoTxt, "sVar=$sVar");
                  $aInsVar[] = array("sVar", $sVar);
               } // foreach ($oObjectVar as $sVar)
            } // if (isset($oObject->variacoes))
            
            $iIns = count($aIns);
            if ($iIns>0) {
               $sSql = fsArrToInsert('LJI_Produto',$aIns);
               fpc_append($sEcoTxt,"sSql=$sSql");
               $aSql[] = $sSql;
            } // if ($iIns>0)

         } // foreach ($oObjects as $oObject)

         foreach ($aSql as $sSql) {
            // insert real
         } // foreach ($aSql as $sSql)

      } // ($lOk==true)
   } // if ($lControlProc==false)

   if ($lOk==true) {
      fpc_append($sEcoTxt, "commit");
      flDBCommit($hDb);
   } else {
      $sRollback = fsDBRollBack($hDb);
      fpc_append($sEcoTxt, "Rollback");
      fpc_append($sEcoTxt, "$sRollback");
   } // if ($lOk==true)
      
   $tJobEnd  = time();
   $iJobElap = $tJobEnd-$tJobStart;

   $aTop    = faLoadAvgServer();
   $nTopFin = $aTop[0];

   list($iUsec, $iSec) = explode(' ', microtime());
   $tScript_End = (float) $iSec + (float) $iUsec;

   $tElapsed_Time = round($tScript_End - $tScript_Start, 5);
   fpc_append($sEcoTxt,'Encerrado em '.date('d/m/Y H:i:s',$tJobEnd));

   fpc_append($sEcoTxt,"Tempo Decorrido: ".gmdate("H:i:s", $tElapsed_Time).', Secs: '.$tElapsed_Time.". Memoria usada: ".round(((memory_get_peak_usage(true) / 1024) / 1024), 2)."Mb");

   flDbDisconnect($hDb);

} else {
   echo 'Arquivo de configurao no foi encontrado.';
}

$aTop    = faLoadAvgServer();
$nTopFin = $aTop[0];

$flSysJobs = flSysJobs($sProc,$nTopIni,$nTopFin,$tJobStart,$tJobEnd,$iJobElap,$psCliPasta,$psLogin);
