<?php
set_time_limit(300);
//error_reporting(E_ALL);
require_once("../pFuncoes1.php");
require_once("../pPublics1.php");	

list($iUsec, $iSec) = explode(' ', microtime());
$tScript_Start = (float) $iSec + (float) $iUsec;

$psCliPasta = fsCliPasta();

$aTop      = faLoadAvgServer();
$nTopIni   = $aTop[0];
$tJobStart = time();
$sProc     = basename(__FILE__);

$sEcoNome  = str_replace('.','_',$sProc).'-'.$tJobStart.'.log';
$sEcoTxt = "/qtux/www/FullPlat/processos/logs/$sEcoNome";
$sEcoTxt = fsDirEcoTxt($sEcoTxt);

$iProcID              = getmypid();
$lProducao            = true;
$aUserLog             = array();
$iCount_oOrdensColeta = 0;

fpc($sEcoTxt,'Incio em ' . date('d/m/Y H:i:s',$tJobStart));
fpc_append($sEcoTxt,'iProcID='.$iProcID);
fpc_append($sEcoTxt,"lProducao=$lProducao");
fpc_append($sEcoTxt,"psCliPasta=$psCliPasta");

$sFileConfig = "../../$psCliPasta/dd_files/Business.ddini";
fpc_append($sEcoTxt,"sFileConfig=$sFileConfig");

if (file_exists($sFileConfig)) {

   $sTxt = fsTXTFiltrar($sFileConfig);
   $aArr = explode(chr(10),$sTxt);
   $sVarsTxt = '';
   foreach ($aArr as $sLin) {
      $aLin = explode('//',$sLin);
      $sLin = trim($aLin[0]);
      $iLen = strlen($sLin);
      if ($iLen>0) {
         $aLin = explode('=',$sLin);
         $s1 = trim($aLin[0]);
         $iCountaLin = count($aLin);
         if ($iCountaLin>1) $s2 = trim($aLin[1]);
         else               $s2 = '';
         $s  = '$'.$s1." = '".$s2."';";
         eval($s);
         $sVarsTxt .= $s . chr(10);
      }
   }

   $lGo      = true;
   $lOk      = true;
   $lLigaQry = true;

   $psLogin = 1;

   $sDSN    = "$sHost:$sPathDB/$sDB";
   $sPathFS = $sPathFileSys;

   fpc_append($sEcoTxt,"sDSN = $sDSN, sPathFS = $sPathFS");

   $hDb = fhDbConnect($sDSN);

   //$lControlProc = flControlProc($hDb,$sProc);
   $lControlProc = flControlProcLinux($sProc);
   fpc_append($sEcoTxt,"lControlProc=$lControlProc");
   if ($lControlProc==false) {
      $lOk = false;
      fpc_append($sEcoTxt,"J TEM UM PROCESSO RODANDO [ $sProc ] NO IR RODAR, ESPERE O PROCESSO TERMINAR PARA RODAR NOVAMENTE.");
   } else {

      $sUrlIntegracao = 'https://api.awsli.com.br/v1/pedido/165';
      fpc_append($sEcoTxt,"sUrlIntegracao=$sUrlIntegracao");
      
      $oRet = foGETLojaIntegrada(); // requisio da API loja integrada

      if ( ($lOk==true) && $oRet!='null') {

         $aSql = array();
         $aIns = array(); 
           
         if (isset($oRet->cliente)) { // "cliente": {
            $oCliente = $oRet->cliente;

            $aInsCli[] = array();

            if (isset($oCliente->cnpj)) { // "cnpj": null,
               $sCNPJ = utf8_decode($oCliente->cnpj);
               fpc_append($sEcoTxt, "sCNPJ=$sCNPJ");
               $aInsCli[] = array("sCNPJ", $sCNPJ);
            } // if (isset($oCliente->cnpj))

            if (isset($oCliente->cpf)) { // "cpf": "14093771723"
               $sCPF = utf8_decode($oCliente->cpf);
               fpc_append($sEcoTxt, "sCPF=$sCPF");
               $aInsCli[] = array("sCPF", $sCPF);
            } // if (isset($oCliente->cpf))

            if (isset($oCliente->data_nascimento)) { // "data_nascimento": null,
               $sData_nascimento = utf8_decode($oCliente->data_nascimento);
               fpc_append($sEcoTxt, "sData_nascimento=$sData_nascimento");
               $aInsCli[] = array("sData_nascimento", $sData_nascimento);
            } // if (isset($oCliente->data_nascimento))

            if (isset($oCliente->email)) { // "email": "teste@lojateste.com.br",
               $sEmail = utf8_decode($oCliente->email);
               fpc_append($sEcoTxt, "sEmail=$sEmail");
               $aInsCli[] = array("sEmail", $sEmail);
            } // if (isset($oCliente->email))

            if (isset($oCliente->id)) { // "id": 34220641,
               $sId = utf8_decode($oCliente->id);
               fpc_append($sEcoTxt, "sId=$sId");
               $aInsCli[] = array("sId", $sId);
            } // if (isset($oCliente->id))

            if (isset($oCliente->nome)) { // "nome": "CLiente Teste",
               $sNome = utf8_decode($oCliente->nome);
               fpc_append($sEcoTxt, "sNome=$sNome");
               $aInsCli[] = array("sNome", $sNome);
            } // if (isset($oCliente->nome))

            if (isset($oCliente->razao_social)) { // "razao_social": null,
               $sRazao_social = utf8_decode($oCliente->razao_social);
               fpc_append($sEcoTxt, "sRazao_social=$sRazao_social");
               $aInsCli[] = array("sRazao_social", $sRazao_social);
            } // if (isset($oCliente->razao_social))

            if (isset($oCliente->resource_uri)) { // "resource_uri": "/api/v1/cliente/34220641",
               $sResource_uri = utf8_decode($oCliente->resource_uri);
               fpc_append($sEcoTxt, "sResource_uri=$sResource_uri");
               $aInsCli[] = array("sResource_uri", $sResource_uri);
            } // if (isset($oCliente->resource_uri))

            if (isset($oCliente->sexo)) { // "sexo": "",
               $sSexo = utf8_decode($oCliente->sexo);
               fpc_append($sEcoTxt, "sSexo=$sSexo");
               $aInsCli[] = array("sSexo", $sSexo);
            } // if (isset($oCliente->sexo))

            if (isset($oCliente->telefone_celular)) { // "telefone_celular": "21111111111",
               $sTelefone_celular = utf8_decode($oCliente->telefone_celular);
               fpc_append($sEcoTxt, "sTelefone_celular=$sTelefone_celular");
               $aInsCli[] = array("sTelefone_celular", $sTelefone_celular);
            } // if (isset($oCliente->telefone_celular))

            if (isset($oCliente->telefone_principal)) { // "telefone_principal": null
               $sTelefone_principal = utf8_decode($oCliente->telefone_principal);
               fpc_append($sEcoTxt, "sTelefone_principal=$sTelefone_principal");
               $aInsCli[] = array("sTelefone_principal", $sTelefone_principal);
            } // if (isset($oCliente->telefone_principal))

         } // if (isset($oRet->cliente))

         if (isset($oRet->cliente_obs)) { // "cliente_obs": null,
            $sCliente_obs = utf8_decode($oRet->cliente_obs);
            fpc_append($sEcoTxt, "sCliente_obs=$sCliente_obs");
            $aIns[] = array("sCliente_obs", $sCliente_obs);
         } // if (isset($oRet->cliente_obs))

         if (isset($oRet->cupom_desconto)) { // "cupom_desconto": null,
            $sCupom_desconto = utf8_decode($oRet->cupom_desconto);
            fpc_append($sEcoTxt, "sCupom_desconto=$sCupom_desconto");
            $aIns[] = array("sCupom_desconto", $sCupom_desconto);
         } // if (isset($oRet->cupom_desconto))

         if (isset($oRet->data_criacao)) { // "data_criacao": "2022-10-31T12:28:05.704751",
            $sData_criacao = utf8_decode($oRet->data_criacao);
            fpc_append($sEcoTxt, "sData_criacao=$sData_criacao");
            $aIns[] = array("sData_criacao", $sData_criacao);
         } // if (isset($oRet->data_criacao))

         if (isset($oRet->data_expiracao)) { // "data_expiracao": "2022-11-06T12:28:05.782308",
            $sData_expiracao = utf8_decode($oRet->data_expiracao);
            fpc_append($sEcoTxt, "sData_expiracao=$sData_expiracao");
            $aIns[] = array("sData_expiracao", $sData_expiracao);
         } // if (isset($oRet->data_expiracao))

         if (isset($oRet->data_modificacao)) { // "data_modificacao": "2022-10-31T12:28:12.653648",
            $sData_modificacao = utf8_decode($oRet->data_modificacao);
            fpc_append($sEcoTxt, "sData_modificacao=$sData_modificacao");
            $aIns[] = array("sData_modificacao", $sData_modificacao);
         } // if (isset($oRet->data_modificacao))

         if (isset($oRet->endereco_entrega)) { // "endereco_entrega": {
            $oEndereco_entrega = $oRet->endereco_entrega;
            $aInsEnd = array();

            if (isset($oEndereco_entrega->bairro)) { // "bairro": "Bonsucesso",
               $sBairro = utf8_decode($oEndereco_entrega->bairro);
               fpc_append($sEcoTxt, "sBairro=$sBairro");
               $aInsEnd[] = array("sBairro", $sBairro);
            } // if (isset($oEndereco_entrega->bairro))

            if (isset($oEndereco_entrega->cep)) { // "cep": "21041040",
               $sCEP = utf8_decode($oEndereco_entrega->cep);
               fpc_append($sEcoTxt, "sCEP=$sCEP");
               $aInsEnd[] = array("sCEP", $sCEP);
            } // if (isset($oEndereco_entrega->cep))

            if (isset($oEndereco_entrega->cidade)) { // "cidade": "Rio de Janeiro",
               $sCidade = utf8_decode($oEndereco_entrega->cidade);
               fpc_append($sEcoTxt, "sCidade=$sCidade");
               $aInsEnd[] = array("sCidade", $sCidade);
            } // if (isset($oEndereco_entrega->cidade))

            if (isset($oEndereco_entrega->cnpj)) { // "cnpj": null,
               $sCNPJ = utf8_decode($oEndereco_entrega->cnpj);
               fpc_append($sEcoTxt, "sCNPJ=$sCNPJ");
               $aInsEnd[] = array("sCNPJ", $sCNPJ);
            } // if (isset($oEndereco_entrega->cnpj))

            if (isset($oEndereco_entrega->complemento)) { // "complemento": null,
               $sComplemento = utf8_decode($oEndereco_entrega->complemento);
               fpc_append($sEcoTxt, "sComplemento=$sComplemento");
               $aInsEnd[] = array("sComplemento", $sComplemento);
            } // if (isset($oEndereco_entrega->complemento))

            if (isset($oEndereco_entrega->cpf)) { // "cpf": "14093771723",
               $sCPF = utf8_decode($oEndereco_entrega->cpf);
               fpc_append($sEcoTxt, "sCPF=$sCPF");
               $aInsEnd[] = array("sCPF", $sCPF);
            } // if (isset($oEndereco_entrega->cpf))

            if (isset($oEndereco_entrega->endereco)) { // "endereco": "Avenida Nova York",
               $sEndereco = utf8_decode($oEndereco_entrega->endereco);
               fpc_append($sEcoTxt, "sEndereco=$sEndereco");
               $aInsEnd[] = array("sEndereco", $sEndereco);
            } // if (isset($oEndereco_entrega->endereco))

            if (isset($oEndereco_entrega->estado)) { // "estado": "RJ",
               $sEstado = utf8_decode($oEndereco_entrega->estado);
               fpc_append($sEcoTxt, "sEstado=$sEstado");
               $aInsEnd[] = array("sEstado", $sEstado);
            } // if (isset($oEndereco_entrega->estado))

            if (isset($oEndereco_entrega->id)) { // "id": 51870053,
               $sId = utf8_decode($oEndereco_entrega->id);
               fpc_append($sEcoTxt, "sId=$sId");
               $aInsEnd[] = array("sId", $sId);
            } // if (isset($oEndereco_entrega->id))

            if (isset($oEndereco_entrega->ie)) { // "ie": "isento",
               $sIE = utf8_decode($oEndereco_entrega->ie);
               fpc_append($sEcoTxt, "sIE=$sIE");
               $aInsEnd[] = array("sIE", $sIE);
            } // if (isset($oEndereco_entrega->ie))

            if (isset($oEndereco_entrega->nome)) { // "nome": "CLiente Teste",
               $sNome = utf8_decode($oEndereco_entrega->nome);
               fpc_append($sEcoTxt, "sNome=$sNome");
               $aInsEnd[] = array("sNome", $sNome);
            } // if (isset($oEndereco_entrega->nome))

            if (isset($oEndereco_entrega->numero)) { // "numero": "1",
               $sNumero = utf8_decode($oEndereco_entrega->numero);
               fpc_append($sEcoTxt, "sNumero=$sNumero");
               $aInsEnd[] = array("sNumero", $sNumero);
            } // if (isset($oEndereco_entrega->numero))

            if (isset($oEndereco_entrega->pais)) { // "pais": "Brasil",
               $sPais = utf8_decode($oEndereco_entrega->pais);
               fpc_append($sEcoTxt, "sPais=$sPais");
               $aInsEnd[] = array("sPais", $sPais);
            } // if (isset($oEndereco_entrega->pais))

            if (isset($oEndereco_entrega->razao_social)) { // "razao_social": null,
               $sRazao_social = utf8_decode($oEndereco_entrega->razao_social);
               fpc_append($sEcoTxt, "sRazao_social=$sRazao_social");
               $aInsEnd[] = array("sRazao_social", $sRazao_social);
            } // if (isset($oEndereco_entrega->razao_social))

            if (isset($oEndereco_entrega->razao_social)) { // "referencia": null,
               $sReferencia = utf8_decode($oEndereco_entrega->razao_social);
               fpc_append($sEcoTxt, "sReferencia=$sReferencia");
               $aInsEnd[] = array("sReferencia", $sReferencia);
            } // if (isset($oEndereco_entrega->razao_social))

            if (isset($oEndereco_entrega->rg)) { // "rg": null,
               $sRG = utf8_decode($oEndereco_entrega->rg);
               fpc_append($sEcoTxt, "sRG=$sRG");
               $aInsEnd[] = array("sRG", $sRG);
            } // if (isset($oEndereco_entrega->rg))

            if (isset($oEndereco_entrega->tipo)) { // "tipo": "PF"
               $sTipo = utf8_decode($oEndereco_entrega->tipo);
               fpc_append($sEcoTxt, "sTipo=$sTipo");
               $aInsEnd[] = array("sTipo", $sTipo);
            } // if (isset($oEndereco_entrega->tipo))

         } // if (isset($oRet->endereco_entrega))

         if (isset($oRet->envios)) { // "envios": [

            $aInsEnv = array();

            foreach ($oEnvios as $oEnvio) {

               if (isset($oEnvio->data_criacao)) { // "data_criacao": "2022-10-31T12:28:05.722569",
                  $sData_criacao = utf8_decode($oEnvio->data_criacao);
                  fpc_append($sEcoTxt, "sData_criacao=$sData_criacao");
                  $aInsEnv[] = array("sData_criacao", $sData_criacao);
               } // if (isset($oEnvio->data_criacao))

               if (isset($oEnvio->data_modificacao)) { // "data_modificacao": "2022-10-31T12:28:05.722584",
                  $sData_modificacao = utf8_decode($oEnvio->data_modificacao);
                  fpc_append($sEcoTxt, "sData_modificacao=$sData_modificacao");
                  $aInsEnv[] = array("sData_modificacao", $sData_modificacao);
               } // if (isset($oEnvio->data_modificacao))

               if (isset($oEnvio->envios)) {
                  $oFormaEnv = $oEnvio->forma_envio;

                  if (isset($oFormaEnv->code)) {  // "code": "PAC",
                     $sCode = utf8_decode($oFormaEnv->code);
                     fpc_append($sEcoTxt, "sCode=$sCode");
                     $aInsEnv[] = array("sCode", $sCode);
                  } // if (isset($oFormaEnv->code))

                  if (isset($oFormaEnv->id)) { // "id": 141909,
                     $sId = utf8_decode($oFormaEnv->id);
                     fpc_append($sEcoTxt, "sId=$sId");
                     $aInsEnv[] = array("sId", $sId);
                  } // if (isset($oFormaEnv->id))

                  if (isset($oFormaEnv->nome)) { // "nome": "Enviali",
                     $sNome = utf8_decode($oFormaEnv->nome);
                     fpc_append($sEcoTxt, "sNome=$sNome");
                     $aInsEnv[] = array("sNome", $sNome);
                  } // if (isset($oFormaEnv->nome))

                  if (isset($oFormaEnv->tipo)) { // "tipo": "PAC "
                     $sTipo = utf8_decode($oFormaEnv->tipo);
                     fpc_append($sEcoTxt, "sTipo=$sTipo");
                     $aInsEnv[] = array("sTipo", $sTipo);
                  } // if (isset($oFormaEnv->tipo))

               } // if (isset($oEnvio->envios))

               if (isset($oEnvio->id)) { // "id": 69291055,
                  $sId = utf8_decode($oEnvio->id);
                  fpc_append($sEcoTxt, "sId=$sId");
                  $aInsEnv[] = array("sId", $sId);
               } // if (isset($oEnvio->id))

               if (isset($oEnvio->objeto)) { // "objeto": null,
                  $sObjeto = utf8_decode($oEnvio->objeto);
                  fpc_append($sEcoTxt, "sObjeto=$sObjeto");
                  $aInsEnv[] = array("sObjeto", $sObjeto);
               } // if (isset($oEnvio->objeto))

               if (isset($oEnvio->prazo)) { // "prazo": 7,
                  $sPrazo = utf8_decode($oEnvio->prazo);
                  fpc_append($sEcoTxt, "sPrazo=$sPrazo");
                  $aInsEnv[] = array("sPrazo", $sPrazo);
               } // if (isset($oEnvio->prazo))

               if (isset($oEnvio->valor)) { // "valor": "21.38"
                  $sValor = utf8_decode($oEnvio->valor);
                  fpc_append($sEcoTxt, "sValor=$sValor");
                  $aInsEnv[] = array("sValor", $sValor);
               } // if (isset($oEnvio->valor))

            } // foreach ($oEnvios as $oEnvio)
         } // if (isset($oRet->envios))

         if(isset($oRet->id_anymarket)) { // "id_anymarket": null,
            $sId_anymarket = utf8_decode($oRet->id_anymarket);
            fpc_append($sEcoTxt, "sId_anymarket=$sId_anymarket");
            $aIns[] = array("sId_anymarket", $sId_anymarket);
         } // if(isset($oRet->id_anymarket))

         if(isset($oRet->id_externo)) { // "id_externo": null,
            $sId_externo = utf8_decode($oRet->id_externo);
            fpc_append($sEcoTxt, "sId_externo=$sId_externo");
            $aIns[] = array("sId_externo", $sId_externo);
         } // if(isset($oRet->id_externo))

         if (isset($oRet->itens)) { // "itens": [

            $aInsItens = array();

            foreach ($oItens as $oItem) {

               if (isset($oItem->altura)) { // "altura": 2,
                  $sAltura = utf8_decode($oItem->altura);
                  fpc_append($sEcoTxt, "sAltura=$sAltura");
                  $aInsItens[] = array("sAltura", $sAltura);
               } // if (isset($oItem->altura))

               if (isset($oItem->disponibilidade)) { // "disponibilidade": 0,
                  $sDisponibilidade = utf8_decode($oItem->disponibilidade);
                  fpc_append($sEcoTxt, "sDisponibilidade=$sDisponibilidade");
                  $aInsItens[] = array("sDisponibilidade", $sDisponibilidade);
               } // if (isset($oItem->disponibilidade))

               if (isset($oItem->id)) { // "id": 156487061,
                  $sId = utf8_decode($oItem->id);
                  fpc_append($sEcoTxt, "sId=$sId");
                  $aInsItens[] = array("sId", $sId);
               } // if (isset($oItem->id))

               if (isset($oItem->largura)) { // "largura": 12,
                  $sLargura = utf8_decode($oItem->largura);
                  fpc_append($sEcoTxt, "sLargura=$sLargura");
                  $aInsItens[] = array("sLargura", $sLargura);
               } // if (isset($oItem->largura))

               if (isset($oItem->linha)) { // "linha": 1,
                  $sLinha = utf8_decode($oItem->linha);
                  fpc_append($sEcoTxt, "sLinha=$sLinha");
                  $aInsItens[] = array("sLinha", $sLinha);
               } // if (isset($oItem->linha))

               if (isset($oItem->nome)) { // "nome": "Casaco infantil",
                  $sNome = utf8_decode($oItem->nome);
                  fpc_append($sEcoTxt, "sNome=$sNome");
                  $aInsItens[] = array("sNome", $sNome);
               } // if (isset($oItem->nome))

               if (isset($oItem->pedido)) { // "pedido": "/api/v1/pedido/165",
                  $sPedido = utf8_decode($oItem->pedido);
                  fpc_append($sEcoTxt, "sPedido=$sPedido");
                  $aInsItens[] = array("sPedido", $sPedido);
               } // if (isset($oItem->pedido))

               if (isset($oItem->peso)) { // "peso": "0.450",
                  $sPeso = utf8_decode($oItem->peso);
                  fpc_append($sEcoTxt, "sPeso=$sPeso");
                  $aInsItens[] = array("sPeso", $sPeso);
               } // if (isset($oItem->peso))

               if (isset($oItem->preco_cheio)) { // "preco_cheio": "12.0000",
                  $sPreco_cheio = utf8_decode($oItem->preco_cheio);
                  fpc_append($sEcoTxt, "sPreco_cheio=$sPreco_cheio");
                  $aInsItens[] = array("sPreco_cheio", $sPreco_cheio);
               } // if (isset($oItem->preco_cheio))

               if (isset($oItem->preco_custo)) { // "preco_custo": null,
                  $sPreco_custo = utf8_decode($oItem->preco_custo);
                  fpc_append($sEcoTxt, "sPreco_custo=$sPreco_custo");
                  $aInsItens[] = array("sPreco_custo", $sPreco_custo);
               } // if (isset($oItem->preco_custo))

               if (isset($oItem->preco_promocional)) { // "preco_promocional": "11.1000",
                  $sPreco_promocional = utf8_decode($oItem->preco_promocional);
                  fpc_append($sEcoTxt, "sPreco_promocional=$sPreco_promocional");
                  $aInsItens[] = array("sPreco_promocional", $sPreco_promocional);
               } // if (isset($oItem->preco_promocional))

               if (isset($oItem->preco_subtotal)) { // "preco_subtotal": "11.1000",
                  $sPreco_subtotal = utf8_decode($oItem->preco_subtotal);
                  fpc_append($sEcoTxt, "sPreco_subtotal=$sPreco_subtotal");
                  $aInsItens[] = array("sPreco_subtotal", $sPreco_subtotal);
               } // if (isset($oItem->preco_subtotal))

               if (isset($oItem->preco_venda)) { // "preco_venda": "11.1000",
                  $sPreco_venda = utf8_decode($oItem->preco_venda);
                  fpc_append($sEcoTxt, "sPreco_venda=$sPreco_venda");
                  $aInsItens[] = array("sPreco_venda", $sPreco_venda);
               } // if (isset($oItem->preco_venda))

               if (isset($oItem->produto)) { 
                  $oProduto = $oItem->forma_envio;

                     if (isset($oProduto->id_externo)) { // "id_externo": 88568855,
                        $sId_externo = utf8_decode($oProduto->id_externo);
                        fpc_append($sEcoTxt, "sId_externo=$sId_externo");
                        $aInsItens[] = array("sId_externo", $sId_externo);
                     } // if (isset($oProduto->id_externo))

                     if (isset($oProduto->resource_uri)) { // "resource_uri": "/api/v1/produto/88568855?id_externo=1"
                        $sResource_uri = utf8_decode($oProduto->resource_uri);
                        fpc_append($sEcoTxt, "sResource_uri=$sResource_uri");
                        $aInsItens[] = array("sResource_uri", $sResource_uri);
                     } // if (isset($oProduto->resource_uri))

                  } // if (isset($oItem->produto))

               if (isset($oProduto->produto_pai)) { // "produto_pai": "/api/v1/produto/182904918",
                  $sProduto_pai = utf8_decode($oProduto->produto_pai);
                  fpc_append($sEcoTxt, "sProduto_pai=$sProduto_pai");
                  $aInsItens[] = array("sProduto_pai", $sProduto_pai);
               } // if (isset($oProduto->produto_pai))

               if (isset($oProduto->profundidade)) { // "profundidade": 6,
                  $sProfundidade = utf8_decode($oProduto->profundidade);
                  fpc_append($sEcoTxt, "sProfundidade=$sProfundidade");
                  $aInsItens[] = array("sProfundidade", $sProfundidade);
               } // if (isset($oProduto->profundidade))

               if (isset($oProduto->quantidade)) { // "quantidade": "1.000",
                  $sQuantidade = utf8_decode($oProduto->quantidade);
                  fpc_append($sEcoTxt, "sQuantidade=$sQuantidade");
                  $aInsItens[] = array("sQuantidade", $sQuantidade);
               } // if (isset($oProduto->quantidade))

               if (isset($oProduto->sku)) { // "sku": "casaco-azul-tam-m666",
                  $sSku = utf8_decode($oProduto->sku);
                  fpc_append($sEcoTxt, "sSku=$sSku");
                  $aInsItens[] = array("sSku", $sSku);
               } // if (isset($oProduto->sku))

               if (isset($oProduto->tipo)) { // "tipo": "atributo_opcao"
                  $sTipo = utf8_decode($oProduto->tipo);
                  fpc_append($sEcoTxt, "sTipo=$sTipo");
                  $aInsItens[] = array("sTipo", $sTipo);
               } // if (isset($oProduto->tipo))

            } // foreach ($oItens as $oItem)
         } // if (isset($oRet->itens))

         if (isset($oRet->numero)) { // "numero": 165,
            $sNumero = utf8_decode($oRet->numero);
            fpc_append($sEcoTxt, "sNumero=$sNumero");
            $aIns[] = array("sNumero", $sNumero);
         } // if (isset($oRet->numero))

         if (isset($oRet->pagamentos)) { // "pagamentos": [

            $aInsPgmto = array();

            foreach ($oPgmtos as $oPgmto) {

               if (isset($oPgmto->authorization_code)) { // "authorization_code": null,
                  $sAuthorization_code = utf8_decode($oPgmto->authorization_code);
                  fpc_append($sEcoTxt, "sAuthorization_code=$sAuthorization_code");
                  $aInsPgmto[] = array("sAuthorization_code", $sAuthorization_code);
               } // if (isset($oPgmto->authorization_code))

               if (isset($oPgmto->banco)) { // "banco": null,
                  $sBanco = utf8_decode($oPgmto->banco);
                  fpc_append($sEcoTxt, "sBanco=$sBanco");
                  $aInsPgmto[] = array("sBanco", $sBanco);
               } // if (isset($oPgmto->banco))

               if (isset($oPgmto->bandeira)) { // "bandeira": "Mastercard",
                  $sBandeira = utf8_decode($oPgmto->bandeira);
                  fpc_append($sEcoTxt, "sBandeira=$sBandeira");
                  $aInsPgmto[] = array("sBandeira", $sBandeira);
               } // if (isset($oPgmto->bandeira))

               if (isset($oPgmto->codigo_retorno_gateway)) { // "codigo_retorno_gateway": null,
                  $sCodigo_retorno_gateway = utf8_decode($oPgmto->codigo_retorno_gateway);
                  fpc_append($sEcoTxt, "sCodigo_retorno_gateway=$sCodigo_retorno_gateway");
                  $aInsPgmto[] = array("sCodigo_retorno_gateway", $sCodigo_retorno_gateway);
               } // if (isset($oPgmto->codigo_retorno_gateway))

               if (isset($oPgmto->pagamentos)) { // "forma_pagamento": {
                  $oFormaPgmto = $oPgmto->forma_pagamento;

                  if (isset($oFormaPgmto->codigo)) { // "codigo": "pagsegurov2",
                     $sCodigo = utf8_decode($oFormaPgmto->codigo);
                     fpc_append($sEcoTxt, "sCodigo=$sCodigo");
                     $aInsPgmto[] = array("sCodigo", $sCodigo);
                  } // if (isset($oFormaPgmto->codigo))

                  if (isset($oFormaPgmto->configuracoes)) { // "configuracoes": {
                     $oConfig = $oFormaPgmto->configuracoes;

                     if (isset($oConfig->ativo)) { // "ativo": true,
                        $sAtivo = utf8_decode($oConfig->ativo);
                        $sAtivo = $sAtivo=='' ? 0 : 1;
                        fpc_append($sEcoTxt, "sAtivo=$sAtivo");
                        $aInsPgmto[] = array("sAtivo", $sAtivo);
                     } // if (isset($oPgmto->ativo))

                     if (isset($oConfig->disponivel)) { // "disponivel": true
                        $sDisponivel = utf8_decode($oConfig->disponivel);
                        $sDisponivel = $sDisponivel=='' ? 0 : 1;
                        fpc_append($sEcoTxt, "sDisponivel=$sDisponivel");
                        $aInsPgmto[] = array("sDisponivel", $sDisponivel);
                     } // if (isset($oConfig->disponivel))

                  } // if (isset($oFormaPgmto->configuracoes))

                  if (isset($oFormaPgmto->id)) { // "id": 24,
                     $sId = utf8_decode($oFormaPgmto->id);
                     fpc_append($sEcoTxt, "sId=$sId");
                     $aInsPgmto[] = array("sId", $sId);
                  } // if (isset($oFormaPgmto->id))

                  if (isset($oFormaPgmto->imagem)) { // "imagem": "https://cdn.awsli.com.br/production/static/painel/img/formas-de-pagamento/pagsegurov2-logo.png",
                     $sImagem = utf8_decode($oFormaPgmto->imagem);
                     fpc_append($sEcoTxt, "sImagem=$sImagem");
                     $aInsPgmto[] = array("sImagem", $sImagem);
                  } // if (isset($oFormaPgmto->imagem))

                  if (isset($oFormaPgmto->nome)) { // "nome": "PagSeguro V2",
                     $sNome = utf8_decode($oFormaPgmto->nome);
                     fpc_append($sEcoTxt, "sNome=$sNome");
                     $aInsPgmto[] = array("sNome", $sNome);
                  } // if (isset($oFormaPgmto->nome))

                  if (isset($oFormaPgmto->resource_uri)) { // "resource_uri": "/api/v1/pagamento/24"
                     $sResource_uri = utf8_decode($oFormaPgmto->resource_uri);
                     fpc_append($sEcoTxt, "sResource_uri=$sResource_uri");
                     $aInsPgmto[] = array("sResource_uri", $sResource_uri);
                  } // if (isset($oFormaPgmto->resource_uri))

               } // if (isset($oPgmto->pagamentos))

               if (isset($oPgmto->id)) { // "id": 69291176,
                  $sId = utf8_decode($oPgmto->id);
                  fpc_append($sEcoTxt, "sId=$sId");
                  $aInsPgmto[] = array("sId", $sId);
               } // if (isset($oFormaPgmto->id))

               if (isset($oPgmto->identificador_id)) { // "identificador_id": null,
                  $sIdentificador_id = utf8_decode($oPgmto->identificador_id);
                  fpc_append($sEcoTxt, "sIdentificador_id=$sIdentificador_id");
                  $aInsPgmto[] = array("sIdentificador_id", $sIdentificador_id);
               } // if (isset($oFormaPgmto->identificador_id))

               if (isset($oPgmto->mensagem_gateway)) { // "mensagem_gateway": null,
                  $sMensagem_gateway = utf8_decode($oPgmto->mensagem_gateway);
                  fpc_append($sEcoTxt, "sMensagem_gateway=$sMensagem_gateway");
                  $aInsPgmto[] = array("sMensagem_gateway", $sMensagem_gateway);
               } // if (isset($oFormaPgmto->mensagem_gateway))

               if (isset($oPgmto->pagamento_tipo)) { // "pagamento_tipo": "creditCard"
                  $sPagamento_tipo = utf8_decode($oPgmto->pagamento_tipo);
                  fpc_append($sEcoTxt, "sPagamento_tipo=$sPagamento_tipo");
                  $aInsPgmto[] = array("sPagamento_tipo", $sPagamento_tipo);
               } // if (isset($oFormaPgmto->pagamento_tipo))

               if (isset($oPgmto->pagamentos)) {
                  $oParce = $oPgmto->parcelamento;

                  if (isset($oParce->numero_parcelas)) { // "numero_parcelas": 1,
                     $sNumero_parcelas = utf8_decode($oParce->numero_parcelas);
                     fpc_append($sEcoTxt, "sNumero_parcelas=$sNumero_parcelas");
                     $aInsPgmto[] = array("sNumero_parcelas", $sNumero_parcelas);
                  } // if (isset($oParce->numero_parcelas))

                  if (isset($oParce->valor_parcela)) { // "valor_parcela": 32.48
                     $sValor_parcela = utf8_decode($oParce->valor_parcela);
                     fpc_append($sEcoTxt, "sValor_parcela=$sValor_parcela");
                     $aInsPgmto[] = array("sValor_parcela", $sValor_parcela);
                  } // if (isset($oParce->valor_parcela))

               } // if (isset($oPgmto->parcelamento))

               if (isset($oPgmto->transacao_id)) { // "transacao_id": null,
                  $sTransacao_id = utf8_decode($oPgmto->transacao_id);
                  fpc_append($sEcoTxt, "sTransacao_id=$sTransacao_id");
                  $aInsPgmto[] = array("sTransacao_id", $sTransacao_id);
               } // if (isset($oPgmto->transacao_id))

               if (isset($oPgmto->valor)) { // "valor": "32.48",
                  $sValor = utf8_decode($oPgmto->valor);
                  fpc_append($sEcoTxt, "sValor=$sValor");
                  $aInsPgmto[] = array("sValor", $sValor);
               } // if (isset($oPgmto->valor))

               if (isset($oPgmto->valor_pago)) { // "valor_pago": "32.48"
                  $sValor_pago = utf8_decode($oPgmto->valor_pago);
                  fpc_append($sEcoTxt, "sValor_pago=$sValor_pago");
                  $aInsPgmto[] = array("sValor_pago", $sValor_pago);
               } // if (isset($oPgmto->valor_pago))

            } // foreach ($oPgmtos as $oPgmto)
         } // if (isset($oRet->pagamentos))

         if (isset($oRet->peso_real)) { // "peso_real": "0.450",
            $sPeso_real = utf8_decode($oRet->peso_real);
            fpc_append($sEcoTxt, "sPeso_real=$sPeso_real");
            $aIns[] = array("sPeso_real", $sPeso_real);
         } // if (isset($oRet->peso_real))

         if (isset($oRet->resource_uri)) { // "resource_uri": "/api/v1/pedido/165",
            $sResource_uri = utf8_decode($oRet->resource_uri);
            fpc_append($sEcoTxt, "sResource_uri=$sResource_uri");
            $aIns[] = array("sResource_uri", $sResource_uri);
         } // if (isset($oRet->resource_uri))

         if (isset($oRet->situacao)) { // "situacao": {
            $oSituacao = $oRet->situacao;
            $aInsSituacao = array();

            if (isset($oSituacao->aprovado)) { // "aprovado": false,
               $sAprovado = utf8_decode($oSituacao->aprovado);
               $sAprovado = $sAprovado=='' ? 0 : 1;
               fpc_append($sEcoTxt, "sAprovado=$sAprovado");
               $aInsSituacao[] = array("sAprovado", $sAprovado);
            } // if (isset($oSituacao->aprovado))

            if (isset($oSituacao->cancelado)) { // "cancelado": true,
               $sCancelado = utf8_decode($oSituacao->cancelado);
               $sCancelado = $sCancelado=='' ? 0 : 1;
               fpc_append($sEcoTxt, "sCancelado=$sCancelado");
               $aInsSituacao[] = array("sCancelado", $sCancelado);
            } // if (isset($oSituacao->cancelado))

            if (isset($oSituacao->codigo)) { // "codigo": "pedido_cancelado",
               $sCodigo = utf8_decode($oSituacao->codigo);
               fpc_append($sEcoTxt, "sCodigo=$sCodigo");
               $aInsSituacao[] = array("sCodigo", $sCodigo);
            } // if (isset($oSituacao->codigo))

            if (isset($oSituacao->final)) { // "final": true,
               $sFinal = utf8_decode($oSituacao->final);
               $sFinal = $sFinal=='' ? 0 : 1;
               fpc_append($sEcoTxt, "sFinal=$sFinal");
               $aInsSituacao[] = array("sFinal", $sFinal);
            } // if (isset($oSituacao->final))

            if (isset($oSituacao->id)) { // "id": 8,
               $sId = utf8_decode($oSituacao->id);
               fpc_append($sEcoTxt, "sId=$sId");
               $aInsSituacao[] = array("sId", $sId);
            } // if (isset($oSituacao->id))

            if (isset($oSituacao->nome)) { // "nome": "Pedido Cancelado",
               $sNome = utf8_decode($oSituacao->nome);
               fpc_append($sEcoTxt, "sNome=$sNome");
               $aInsSituacao[] = array("sNome", $sNome);
            } // if (isset($oSituacao->nome))

            if (isset($oSituacao->notificar_comprador)) { // "notificar_comprador": true,
               $sNotificar_comprador = utf8_decode($oSituacao->notificar_comprador);
               $sNotificar_comprador = $sNotificar_comprador=='' ? 0 : 1;
               fpc_append($sEcoTxt, "sNotificar_comprador=$sNotificar_comprador");
               $aInsSituacao[] = array("sNotificar_comprador", $sNotificar_comprador);
            } // if (isset($oSituacao->notificar_comprador))

            if (isset($oSituacao->padrao)) { // "padrao": false,
               $sPadrao = utf8_decode($oSituacao->padrao);
               $sPadrao = $sPadrao=='' ? 0 : 1;
               fpc_append($sEcoTxt, "sPadrao=$sPadrao");
               $aInsSituacao[] = array("sPadrao", $sPadrao);
            } // if (isset($oSituacao->padrao))

            if (isset($oSituacao->resource_uri)) { // "resource_uri": "/api/v1/situacao/8"
               $sResource_uri = utf8_decode($oSituacao->resource_uri);
               fpc_append($sEcoTxt, "sResource_uri=$sResource_uri");
               $aInsSituacao[] = array("sResource_uri", $sResource_uri);
            } // if (isset($oSituacao->resource_uri))

         } // if (isset($oRet->situacao))

         if (isset($oRet->utm_campaign)) { // "utm_campaign": null,
            $sUtm_campaign = utf8_decode($oRet->utm_campaign);
            fpc_append($sEcoTxt, "sUtm_campaign=$sUtm_campaign");
            $aIns[] = array("sUtm_campaign", $sUtm_campaign);
         } // if (isset($oRet->utm_campaign))

         if (isset($oRet->valor_desconto)) { // "valor_desconto": "0.00",
            $sValor_desconto = utf8_decode($oRet->valor_desconto);
            fpc_append($sEcoTxt, "sValor_desconto=$sValor_desconto");
            $aIns[] = array("sValor_desconto", $sValor_desconto);
         } // if (isset($oRet->valor_desconto))

         if (isset($oRet->valor_envio)) { // "valor_envio": "21.38",
            $sValor_envio = utf8_decode($oRet->valor_envio);
            fpc_append($sEcoTxt, "sValor_envio=$sValor_envio");
            $aIns[] = array("sValor_envio", $sValor_envio);
         } // if (isset($oRet->valor_envio))

         if (isset($oRet->valor_subtotal)) { // "valor_subtotal": "11.10",
            $sValor_subtotal = utf8_decode($oRet->valor_subtotal);
            fpc_append($sEcoTxt, "sValor_subtotal=$sValor_subtotal");
            $aIns[] = array("sValor_subtotal", $sValor_subtotal);
         } // if (isset($oRet->valor_subtotal))

         if (isset($oRet->valor_total)) { // "valor_total": "32.48"
            $sValor_total = utf8_decode($oRet->valor_total);
            fpc_append($sEcoTxt, "sValor_total=$sValor_total");
            $aIns[] = array("sValor_total", $sValor_total);
         } // if (isset($oRet->valor_total))

         $iIns = count($aIns);
         if ($iIns>0) {
            $sSql = fsArrToInsert('LJI_Pedido',$aIns);
            fpc_append($sEcoTxt,"sSql=$sSql");
            $aSql[] = $sSql;
         } // if ($aIns>0)

         foreach ($aSql as $sSql) {
            // insert real
         } // foreach ($aSql as $sSql)

      } // ($lOk==true)
   } // if ($lControlProc==false)

   if ($lOk==true) {
      fpc_append($sEcoTxt, "commit");
      flDBCommit($hDb);
   } else {
      $sRollback = fsDBRollBack($hDb);
      fpc_append($sEcoTxt, "Rollback");
      fpc_append($sEcoTxt, "$sRollback");
   } // if ($lOk==true)
      
   $tJobEnd  = time();
   $iJobElap = $tJobEnd-$tJobStart;

   $aTop    = faLoadAvgServer();
   $nTopFin = $aTop[0];

   list($iUsec, $iSec) = explode(' ', microtime());
   $tScript_End = (float) $iSec + (float) $iUsec;

   $tElapsed_Time = round($tScript_End - $tScript_Start, 5);
   fpc_append($sEcoTxt,'Encerrado em '.date('d/m/Y H:i:s',$tJobEnd));

   fpc_append($sEcoTxt,"Tempo Decorrido: ".gmdate("H:i:s", $tElapsed_Time).', Secs: '.$tElapsed_Time.". Memoria usada: ".round(((memory_get_peak_usage(true) / 1024) / 1024), 2)."Mb");

   flDbDisconnect($hDb);

} else {
   echo 'Arquivo de configurao no foi encontrado.';
}

$aTop    = faLoadAvgServer();
$nTopFin = $aTop[0];

$flSysJobs = flSysJobs($sProc,$nTopIni,$nTopFin,$tJobStart,$tJobEnd,$iJobElap,$psCliPasta,$psLogin);
