<?php
set_time_limit(300);
//error_reporting(E_ALL);
require_once("../pFuncoes1.php");
require_once("../pPublics1.php");	

list($iUsec, $iSec) = explode(' ', microtime());
$tScript_Start = (float) $iSec + (float) $iUsec;

$psCliPasta = fsCliPasta();

$aTop      = faLoadAvgServer();
$nTopIni   = $aTop[0];
$tJobStart = time();
$sProc     = basename(__FILE__);

$sEcoNome  = str_replace('.','_',$sProc).'-'.$tJobStart.'.log';
$sEcoTxt = "/qtux/www/FullPlat/processos/logs/$sEcoNome";
$sEcoTxt = fsDirEcoTxt($sEcoTxt);

$iProcID              = getmypid();
$lProducao            = true;
$aUserLog             = array();
$iCount_oOrdensColeta = 0;

fpc($sEcoTxt,'Incio em ' . date('d/m/Y H:i:s',$tJobStart));
fpc_append($sEcoTxt,'iProcID='.$iProcID);
fpc_append($sEcoTxt,"lProducao=$lProducao");
fpc_append($sEcoTxt,"psCliPasta=$psCliPasta");

$sFileConfig = "../../$psCliPasta/dd_files/Business.ddini";
fpc_append($sEcoTxt,"sFileConfig=$sFileConfig");

if (file_exists($sFileConfig)) {

   $sTxt = fsTXTFiltrar($sFileConfig);
   $aArr = explode(chr(10),$sTxt);
   $sVarsTxt = '';
   foreach ($aArr as $sLin) {
      $aLin = explode('//',$sLin);
      $sLin = trim($aLin[0]);
      $iLen = strlen($sLin);
      if ($iLen>0) {
         $aLin = explode('=',$sLin);
         $s1 = trim($aLin[0]);
         $iCountaLin = count($aLin);
         if ($iCountaLin>1) $s2 = trim($aLin[1]);
         else               $s2 = '';
         $s  = '$'.$s1." = '".$s2."';";
         eval($s);
         $sVarsTxt .= $s . chr(10);
      }
   }

   $lGo      = true;
   $lOk      = true;
   $lLigaQry = true;

   $psLogin = 1;

   $sDSN    = "$sHost:$sPathDB/$sDB";
   $sPathFS = $sPathFileSys;

   fpc_append($sEcoTxt,"sDSN = $sDSN, sPathFS = $sPathFS");

   $hDb = fhDbConnect($sDSN);

   //$lControlProc = flControlProc($hDb,$sProc);
   $lControlProc = flControlProcLinux($sProc);
   fpc_append($sEcoTxt,"lControlProc=$lControlProc");
   if ($lControlProc==false) {
      $lOk = false;
      fpc_append($sEcoTxt,"J TEM UM PROCESSO RODANDO [ $sProc ] NO IR RODAR, ESPERE O PROCESSO TERMINAR PARA RODAR NOVAMENTE.");
   } else {

      $sUrlIntegracao = 'https://api.awsli.com.br/v1/pedido/search/?since_numero=135&situacao_id=8&pagamento_id=24&limit=15'; // /api/v1/produto_estoque?limit=20&offset=20
      fpc_append($sEcoTxt,"sUrlIntegracao=$sUrlIntegracao");
      
      $oRet = foGETLojaIntegrada(); // requisio da API loja integrada

      if ( ($lOk==true) && $oRet!='null') {

         $oMeta = isset($oRet->meta) ? $oRet->meta : 'null';

         foreach($oMeta as $sKey => $sValue) {
            if ((!is_array($sValue)) || (!is_object($sValue)) ) {
               fpc_append($sEcoTxt,"$sKey => $sValue");
               $aIns[] = array('s'.ucfirst($sKey),$sValue);
            }
         } // foreach($oRet as $sKey => $sValue)

         $aSql = array();

         $oObjects = isset($oRet->objects) ? $oRet->objects : 'null';
         foreach ($oObjects as $oObject) {

            $aIns = array(); 
            
            if (isset($oObject->cliente)) { // "cliente": "/api/v1/cliente/34220641",
               $sCliente = utf8_decode($oObject->cliente);
               fpc_append($sEcoTxt, "sCliente=$sCliente");
               $aIns[] = array("sCliente", $sCliente);
            } // if (isset($oObject->cliente))
            
            if (isset($oObject->data_criacao)) { // "data_criacao": "2022-10-31T12:17:51.633657",
               $sData_criacao = utf8_decode($oObject->data_criacao);
               fpc_append($sEcoTxt, "sData_criacao=$sData_criacao");
               $aIns[] = array("sData_criacao", $sData_criacao);
            } // if (isset($oObject->data_criacao))
            
            if (isset($oObject->data_expiracao)) { // "data_expiracao": "2022-11-06T12:17:51.733114",
               $sData_expiracao = utf8_decode($oObject->data_expiracao);
               fpc_append($sEcoTxt, "sData_expiracao=$sData_expiracao");
               $aIns[] = array("sData_expiracao", $sData_expiracao);
            } // if (isset($oObject->data_expiracao))
            
            if (isset($oObject->data_modificacao)) { // "data_modificacao": "2022-10-31T12:17:58.949670",
               $sData_modificacao = utf8_decode($oObject->data_modificacao);
               fpc_append($sEcoTxt, "sData_modificacao=$sData_modificacao");
               $aIns[] = array("sData_modificacao", $sData_modificacao);
            } // if (isset($oObject->data_modificacao))
            
            if (isset($oObject->id_anymarket)) { // "id_anymarket": null,
               $sId_anymarket = utf8_decode($oObject->id_anymarket);
               fpc_append($sEcoTxt, "sId_anymarket=$sId_anymarket");
               $aIns[] = array("sId_anymarket", $sId_anymarket);
            } // if (isset($oObject->id_anymarket))
            
            if (isset($oObject->id_externo)) { // "id_externo": null,
               $sId_externo = utf8_decode($oObject->id_externo);
               fpc_append($sEcoTxt, "sId_externo=$sId_externo");
               $aIns[] = array("sId_externo", $sId_externo);
            } // if (isset($oObject->id_externo))
            
            if (isset($oObject->numero)) { // "numero": 164,
               $sNumero = utf8_decode($oObject->numero);
               fpc_append($sEcoTxt, "sNumero=$sNumero");
               $aIns[] = array("sNumero", $sNumero);
            } // if (isset($oObject->numero))
            
            if (isset($oObject->peso_real)) { // "peso_real": "0.170",
               $sPeso_real = utf8_decode($oObject->peso_real);
               fpc_append($sEcoTxt, "sPeso_real=$sPeso_real");
               $aIns[] = array("sPeso_real", $sPeso_real);
            } // if (isset($oObject->peso_real))
            
            if (isset($oObject->resource_uri)) { // "resource_uri": "/api/v1/pedido/164",
               $sResource_uri = utf8_decode($oObject->resource_uri);
               fpc_append($sEcoTxt, "sResource_uri=$sResource_uri");
               $aIns[] = array("sResource_uri", $sResource_uri);
            } // if (isset($oObject->resource_uri))

            if (isset($oObject->situacao)) { // "situacao": {
               $oSituacao = $oObject->situacao;
               $aInsPed = array();

               if (isset($oSituacao->aprovado)) { // "aprovado": false,
                  $sAprovado = utf8_decode($oSituacao->aprovado);
                  $sAprovado = $sAprovado=='' ? 0 : 1;
                  fpc_append($sEcoTxt, "sAprovado=$sAprovado");
                  $aInsPed[] = array("sAprovado", $sAprovado);
               } // if (isset(aprovado))

               if (isset($oSituacao->cancelado)) { // "cancelado": true,
                  $sCancelado = utf8_decode($oSituacao->cancelado);
                  $sCancelado = $sCancelado=='' ? 0 : 1;
                  fpc_append($sEcoTxt, "sCancelado=$sCancelado");
                  $aInsPed[] = array("sCancelado", $sCancelado);
               } // if (isset(cancelado))

               if (isset($oSituacao->codigo)) { // "codigo": "pedido_cancelado",
                  $sCodigo = utf8_decode($oSituacao->codigo);
                  fpc_append($sEcoTxt, "sCodigo=$sCodigo");
                  $aInsPed[] = array("sCodigo", $sCodigo);
               } // if (isset(codigo))

               if (isset($oSituacao->final)) { // "final": true,
                  $sFinal = utf8_decode($oSituacao->final);
                  $sFinal = $sFinal=='' ? 0 : 1;
                  fpc_append($sEcoTxt, "sFinal=$sFinal");
                  $aInsPed[] = array("sFinal", $sFinal);
               } // if (isset(final))

               if (isset($oSituacao->id)) { // "id": 8,
                  $sId = utf8_decode($oSituacao->id);
                  $sId = $sId=='' ? 0 : 1;
                  fpc_append($sEcoTxt, "sId=$sId");
                  $aInsPed[] = array("sId", $sId);
               } // if (isset(id))

               if (isset($oSituacao->nome)) { // "nome": "Pedido Cancelado",
                  $sNome = utf8_decode($oSituacao->nome);
                  fpc_append($sEcoTxt, "sNome=$sNome");
                  $aInsPed[] = array("sNome", $sNome);
               } // if (isset(nome))

               if (isset($oSituacao->notificar_comprador)) { // "notificar_comprador": true,
                  $sNotificar_comprador = utf8_decode($oSituacao->notificar_comprador);
                  $sNotificar_comprador = $sNotificar_comprador=='' ? 0 : 1;
                  fpc_append($sEcoTxt, "sNotificar_comprador=$sNotificar_comprador");
                  $aInsPed[] = array("sNotificar_comprador", $sNotificar_comprador);
               } // if (isset(notificar_comprador))

               if (isset($oSituacao->padrao)) { // "padrao": false,
                  $sPadrao = utf8_decode($oSituacao->padrao);
                  $sPadrao = $sPadrao=='' ? 0 : 1;
                  fpc_append($sEcoTxt, "sPadrao=$sPadrao");
                  $aInsPed[] = array("sPadrao", $sPadrao);
               } // if (isset(padrao))

               if (isset($oSituacao->resource_uri)) { // "resource_uri": "/api/v1/situacao/8"
                  $sResource_uri = utf8_decode($oSituacao->resource_uri);
                  fpc_append($sEcoTxt, "sResource_uri=$sResource_uri");
                  $aInsPed[] = array("sResource_uri", $sResource_uri);
               } // if (isset(resource_uri))

            } // if (isset($oObject->situacao))

            if (isset($oObject->utm_campaign)) { // "utm_campaign": null,
               $sUtm_campaign = utf8_decode($oObject->utm_campaign);
               fpc_append($sEcoTxt, "sUtm_campaign=$sUtm_campaign");
               $aIns[] = array("sUtm_campaign", $sUtm_campaign);
            } // if (isset($oObject->utm_campaign))
            
            if (isset($oObject->valor_desconto)) { // "valor_desconto": "0.00",
               $sValor_desconto = utf8_decode($oObject->valor_desconto);
               fpc_append($sEcoTxt, "sValor_desconto=$sValor_desconto");
               $aIns[] = array("sValor_desconto", $sValor_desconto);
            } // if (isset($oObject->valor_desconto))
            
            if (isset($oObject->valor_envio)) { // "valor_envio": "21.38",
               $sValor_envio = utf8_decode($oObject->valor_envio);
               fpc_append($sEcoTxt, "sValor_envio=$sValor_envio");
               $aIns[] = array("sValor_envio", $sValor_envio);
            } // if (isset($oObject->valor_envio))
            
            if (isset($oObject->valor_subtotal)) { // "valor_subtotal": "85.00",
               $sValor_subtotal = utf8_decode($oObject->valor_subtotal);
               fpc_append($sEcoTxt, "sValor_subtotal=$sValor_subtotal");
               $aIns[] = array("sValor_subtotal", $sValor_subtotal);
            } // if (isset($oObject->valor_subtotal))
            
            if (isset($oObject->valor_total)) { // "valor_total": "106.38"
               $sValor_total = utf8_decode($oObject->valor_total);
               fpc_append($sEcoTxt, "sValor_total=$sValor_total");
               $aIns[] = array("sValor_total", $sValor_total);
            } // if (isset($oObject->valor_total))

            $iIns = count($aIns);
            if ($iIns>0) {
               $sSql = fsArrToInsert('LJI_Pedido',$aIns);
               fpc_append($sEcoTxt,"sSql=$sSql");
               $aSql[] = $sSql;
            } // if ($aIns>0)

         } // foreach ($oObjects as $sKey => $sValue)

         foreach ($aSql as $sSql) {
            // insert real
         } // foreach ($aSql as $sSql)

      } // ($lOk==true)
   } // if ($lControlProc==false)

   if ($lOk==true) {
      fpc_append($sEcoTxt, "commit");
      flDBCommit($hDb);
   } else {
      $sRollback = fsDBRollBack($hDb);
      fpc_append($sEcoTxt, "Rollback");
      fpc_append($sEcoTxt, "$sRollback");
   } // if ($lOk==true)
      
   $tJobEnd  = time();
   $iJobElap = $tJobEnd-$tJobStart;

   $aTop    = faLoadAvgServer();
   $nTopFin = $aTop[0];

   list($iUsec, $iSec) = explode(' ', microtime());
   $tScript_End = (float) $iSec + (float) $iUsec;

   $tElapsed_Time = round($tScript_End - $tScript_Start, 5);
   fpc_append($sEcoTxt,'Encerrado em '.date('d/m/Y H:i:s',$tJobEnd));

   fpc_append($sEcoTxt,"Tempo Decorrido: ".gmdate("H:i:s", $tElapsed_Time).', Secs: '.$tElapsed_Time.". Memoria usada: ".round(((memory_get_peak_usage(true) / 1024) / 1024), 2)."Mb");

   flDbDisconnect($hDb);

} else {
   echo 'Arquivo de configurao no foi encontrado.';
}

$aTop    = faLoadAvgServer();
$nTopFin = $aTop[0];

$flSysJobs = flSysJobs($sProc,$nTopIni,$nTopFin,$tJobStart,$tJobEnd,$iJobElap,$psCliPasta,$psLogin);
