<?php
set_time_limit(300);
//error_reporting(E_ALL);
require_once("../pFuncoes1.php");
require_once("../pPublics1.php");	

list($iUsec, $iSec) = explode(' ', microtime());
$tScript_Start = (float) $iSec + (float) $iUsec;

$psCliPasta = fsCliPasta();

$aTop      = faLoadAvgServer();
$nTopIni   = $aTop[0];
$tJobStart = time();
$sProc     = basename(__FILE__);

$sEcoNome  = str_replace('.','_',$sProc).'-'.$tJobStart.'.log';
$sEcoTxt = "/qtux/www/FullPlat/processos/logs/$sEcoNome";
$sEcoTxt = fsDirEcoTxt($sEcoTxt);

$iProcID              = getmypid();
$lProducao            = true;
$aUserLog             = array();
$iCount_oOrdensColeta = 0;

fpc($sEcoTxt,'Incio em ' . date('d/m/Y H:i:s',$tJobStart));
fpc_append($sEcoTxt,'iProcID='.$iProcID);
fpc_append($sEcoTxt,"lProducao=$lProducao");
fpc_append($sEcoTxt,"psCliPasta=$psCliPasta");

$sFileConfig = "../../$psCliPasta/dd_files/Business.ddini";
fpc_append($sEcoTxt,"sFileConfig=$sFileConfig");

if (file_exists($sFileConfig)) {

   $sTxt = fsTXTFiltrar($sFileConfig);
   $aArr = explode(chr(10),$sTxt);
   $sVarsTxt = '';
   foreach ($aArr as $sLin) {
      $aLin = explode('//',$sLin);
      $sLin = trim($aLin[0]);
      $iLen = strlen($sLin);
      if ($iLen>0) {
         $aLin = explode('=',$sLin);
         $s1 = trim($aLin[0]);
         $iCountaLin = count($aLin);
         if ($iCountaLin>1) $s2 = trim($aLin[1]);
         else               $s2 = '';
         $s  = '$'.$s1." = '".$s2."';";
         eval($s);
         $sVarsTxt .= $s . chr(10);
      }
   }

   $lGo      = true;
   $lOk      = true;
   $lLigaQry = true;

   $psLogin = 1;

   $sDSN    = "$sHost:$sPathDB/$sDB";
   $sPathFS = $sPathFileSys;

   fpc_append($sEcoTxt,"sDSN = $sDSN, sPathFS = $sPathFS");

   $hDb = fhDbConnect($sDSN);

   //$lControlProc = flControlProc($hDb,$sProc);
   $lControlProc = flControlProcLinux($sProc);
   fpc_append($sEcoTxt,"lControlProc=$lControlProc");
   if ($lControlProc==false) {
      $lOk = false;
      fpc_append($sEcoTxt,"J TEM UM PROCESSO RODANDO [ $sProc ] NO IR RODAR, ESPERE O PROCESSO TERMINAR PARA RODAR NOVAMENTE.");
   } else {

      $iIdProd = 259228364;

      $sUrlIntegracao = "https://api.awsli.com.br/v1/produto_imagem/?produto=$iIdProd"; // /api/v1/categoria?limit=20&offset=0
      fpc_append($sEcoTxt,"sUrlIntegracao=$sUrlIntegracao");
      
      $oRet = foGETLojaIntegrada(); // requisio da API loja integrada

      if ( ($lOk==true) && $oRet!='null') {

         $oMeta = isset($oRet->meta) ? $oRet->meta : 'null';

         foreach($oMeta as $sKey => $sValue) {
            if ((!is_array($sValue)) || (!is_object($sValue)) ) {
               fpc_append($sEcoTxt,"$sKey => $sValue");
               $aIns[] = array('s'.ucfirst($sKey),$sValue);
            }
         } // foreach($oRet as $sKey => $sValue)

         $aSql = array();

         $oObjects = isset($oRet->objects) ? $oRet->objects : 'null';
         foreach ($oObjects as $oObject) {

            $aIns = array(); // inicio array insert

            if (isset($oObject->caminho)) { // "caminho": "1736/1736356/produto/166737173/camiseta-vamos-defumar-o-mundo-7da63f05.jpg",
               $sCaminho = utf8_decode($oObject->caminho);
               fpc_append($sEcoTxt,"sCaminho=$sCaminho");
               $aIns[] = array("sCaminho", $sCaminho);
            } // if (isset($oObject->caminho))
            
            if (isset($oObject->id)) { // "id": 108287406,
               $sId = utf8_decode($oObject->id);
               fpc_append($sEcoTxt,"sId=$sId");
               $aIns[] = array("sId", $sId);
            } // if (isset($oObject->id))
            
            if (isset($oObject->id_anymarket)) { // "id_anymarket": null,
               $sId_anymarket = utf8_decode($oObject->id_anymarket);
               fpc_append($sEcoTxt,"sId_anymarket=$sId_anymarket");
               $aIns[] = array("sId_anymarket", $sId_anymarket);
            } // if (isset($oObject->id_anymarket))
            
            if (isset($oObject->mime)) { // "mime": null,
               $sMime = utf8_decode($oObject->mime);
               fpc_append($sEcoTxt,"sMime=$sMime");
               $aIns[] = array("sMime", $sMime);
            } // if (isset($oObject->mime))
            
            if (isset($oObject->posicao)) { // "posicao": null,
               $sPosicao = utf8_decode($oObject->posicao);
               fpc_append($sEcoTxt,"sPosicao=$sPosicao");
               $aIns[] = array("sPosicao", $sPosicao);
            } // if (isset($oObject->posicao))
            
            if (isset($oObject->principal)) { // "principal": false,
               $sPrincipal = utf8_decode($oObject->principal);
               $sPrincipal = $sPrincipal=='' ? 0 : 1;
               fpc_append($sEcoTxt,"sPrincipal=$sPrincipal");
               $aIns[] = array("sPrincipal", $sPrincipal);
            } // if (isset($oObject->principal))
            
            if (isset($oObject->produto)) { // "produto": "/api/v1/produto/166737173",
               $sProduto = utf8_decode($oObject->produto);
               fpc_append($sEcoTxt,"sProduto=$sProduto");
               $aIns[] = array("sProduto", $sProduto);
            } // if (isset($oObject->produto))
            
            if (isset($oObject->resource_uri)) { // "resource_uri": "/api/v1/produto_imagem/108287406"
               $sResource_uri = utf8_decode($oObject->resource_uri);
               fpc_append($sEcoTxt,"sResource_uri=$sResource_uri");
               $aIns[] = array("sResource_uri", $sResource_uri);
            } // if (isset($oObject->resource_uri))

            $iIns = count($aIns);
            if ($iIns>0) {
               $sSql = fsArrToInsert('LJI_Imagem_Produto',$aIns);
               fpc_append($sEcoTxt,"sSql=$sSql");
               $aSql[] = $sSql;
            } // if ($aIns>0)

         } // foreach ($oObjects as $oObject)

         foreach ($aSql as $sSql) {
            // insert real
         } // foreach ($aSql as $sSql)

      } // ($lOk==true)
   } // if ($lControlProc==false)

   if ($lOk==true) {
      fpc_append($sEcoTxt, "commit");
      flDBCommit($hDb);
   } else {
      $sRollback = fsDBRollBack($hDb);
      fpc_append($sEcoTxt, "Rollback");
      fpc_append($sEcoTxt, "$sRollback");
   } // if ($lOk==true)
      
   $tJobEnd  = time();
   $iJobElap = $tJobEnd-$tJobStart;

   $aTop    = faLoadAvgServer();
   $nTopFin = $aTop[0];

   list($iUsec, $iSec) = explode(' ', microtime());
   $tScript_End = (float) $iSec + (float) $iUsec;

   $tElapsed_Time = round($tScript_End - $tScript_Start, 5);
   fpc_append($sEcoTxt,'Encerrado em '.date('d/m/Y H:i:s',$tJobEnd));

   fpc_append($sEcoTxt,"Tempo Decorrido: ".gmdate("H:i:s", $tElapsed_Time).', Secs: '.$tElapsed_Time.". Memoria usada: ".round(((memory_get_peak_usage(true) / 1024) / 1024), 2)."Mb");

   flDbDisconnect($hDb);

} else {
   echo 'Arquivo de configurao no foi encontrado.';
}

$aTop    = faLoadAvgServer();
$nTopFin = $aTop[0];

$flSysJobs = flSysJobs($sProc,$nTopIni,$nTopFin,$tJobStart,$tJobEnd,$iJobElap,$psCliPasta,$psLogin);
