<?php
set_time_limit(300);
//error_reporting(E_ALL);
require_once("../pFuncoes1.php");
require_once("../pPublics1.php");	

list($iUsec, $iSec) = explode(' ', microtime());
$tScript_Start = (float) $iSec + (float) $iUsec;

$psCliPasta = fsCliPasta();

$aTop      = faLoadAvgServer();
$nTopIni   = $aTop[0];
$tJobStart = time();
$sProc     = basename(__FILE__);

$sEcoNome  = str_replace('.','_',$sProc).'-'.$tJobStart.'.log';
$sEcoTxt = "/qtux/www/FullPlat/processos/logs/$sEcoNome";
$sEcoTxt = fsDirEcoTxt($sEcoTxt);

$iProcID              = getmypid();
$lProducao            = true;
$aUserLog             = array();
$iCount_oOrdensColeta = 0;

fpc($sEcoTxt,'Incio em ' . date('d/m/Y H:i:s',$tJobStart));
fpc_append($sEcoTxt,'iProcID='.$iProcID);
fpc_append($sEcoTxt,"lProducao=$lProducao");
fpc_append($sEcoTxt,"psCliPasta=$psCliPasta");

$sFileConfig = "../../$psCliPasta/dd_files/Business.ddini";
fpc_append($sEcoTxt,"sFileConfig=$sFileConfig");

if (file_exists($sFileConfig)) {

   $sTxt = fsTXTFiltrar($sFileConfig);
   $aArr = explode(chr(10),$sTxt);
   $sVarsTxt = '';
   foreach ($aArr as $sLin) {
      $aLin = explode('//',$sLin);
      $sLin = trim($aLin[0]);
      $iLen = strlen($sLin);
      if ($iLen>0) {
         $aLin = explode('=',$sLin);
         $s1 = trim($aLin[0]);
         $iCountaLin = count($aLin);
         if ($iCountaLin>1) $s2 = trim($aLin[1]);
         else               $s2 = '';
         $s  = '$'.$s1." = '".$s2."';";
         eval($s);
         $sVarsTxt .= $s . chr(10);
      }
   }

   $lGo      = true;
   $lOk      = true;
   $lLigaQry = true;

   $psLogin = 1;

   $sDSN    = "$sHost:$sPathDB/$sDB";
   $sPathFS = $sPathFileSys;

   fpc_append($sEcoTxt,"sDSN = $sDSN, sPathFS = $sPathFS");

   $hDb = fhDbConnect($sDSN);

   //$lControlProc = flControlProc($hDb,$sProc);
   $lControlProc = flControlProcLinux($sProc);
   fpc_append($sEcoTxt,"lControlProc=$lControlProc");
   if ($lControlProc==false) {
      $lOk = false;
      fpc_append($sEcoTxt,"J TEM UM PROCESSO RODANDO [ $sProc ] NO IR RODAR, ESPERE O PROCESSO TERMINAR PARA RODAR NOVAMENTE.");
   } else {

      $iEstoque = 259228364; // -> 259228364 -> ID PRODUTO LOJA INTEGRADA
      $sUrlIntegracao = "https://api.awsli.com.br/v1/produto_estoque/$iEstoque";
      fpc_append($sEcoTxt,"sUrlIntegracao=$sUrlIntegracao");
      
      $oRet = foGETLojaIntegrada(); // requisio da API loja integrada

      if ( ($lOk==true) && $oRet!='null') {

         $aSql = array();
         $aIns = array();

         if (isset($oRet->gerenciado)) { // "gerenciado": true,
            $sGerenciado = utf8_decode($oRet->gerenciado);
            $sGerenciado = $sGerenciado=='' ? 0 : 1;
            fpc_append($sEcoTxt, "sGerenciado=$sGerenciado");
            $aIns[] = array("sGerenciado", $sGerenciado);
         } // if (isset($oRet->gerenciado))
            
         if (isset($oRet->id)) { // "id": 109877209,
            $sId = utf8_decode($oRet->id);
            fpc_append($sEcoTxt, "sId=$sId");
            $aIns[] = array("sId", $sId);
         } // if (isset($oRet->id))
            
         if (isset($oRet->produto)) { // "produto": "/api/v1/produto/174389010",
            $sProduto = utf8_decode($oRet->produto);
            fpc_append($sEcoTxt, "sProduto=$sProduto");
            $aIns[] = array("sProduto", $sProduto);
         } // if (isset($oRet->produto))
            
         if (isset($oRet->quantidade)) { // "quantidade": 10,
            $sQuantidade = utf8_decode($oRet->quantidade);
            fpc_append($sEcoTxt, "sQuantidade=$sQuantidade");
            $aIns[] = array("sQuantidade", $sQuantidade);
         } // if (isset($oRet->quantidade))
            
         if (isset($oRet->quantidade_disponivel)) { // "quantidade_disponivel": 10,
            $sQuantidade_disponivel = utf8_decode($oRet->quantidade_disponivel);
            fpc_append($sEcoTxt, "sQuantidade_disponivel=$sQuantidade_disponivel");
            $aIns[] = array("sQuantidade_disponivel", $sQuantidade_disponivel);
         } // if (isset($oRet->quantidade_disponivel))

         if (isset($oRet->quantidade_reservada)) { // "quantidade_reservada": 0,
            $sQuantidade_reservada = utf8_decode($oRet->quantidade_reservada);
            fpc_append($sEcoTxt, "sQuantidade_reservada=$sQuantidade_reservada");
            $aIns[] = array("sQuantidade_reservada", $sQuantidade_reservada);
         } // if (isset($oRet->quantidade_reservada))

         if (isset($oRet->resource_uri)) { // "resource_uri": "/api/v1/produto_estoque/174389010",
            $sResource_uri = utf8_decode($oRet->resource_uri);
            fpc_append($sEcoTxt, "sResource_uri=$sResource_uri");
            $aIns[] = array("sResource_uri", $sResource_uri);
         } // if (isset($oRet->resource_uri))

         if (isset($oRet->situacao_em_estoque)) { // "situacao_em_estoque": 0,
            $sSituacao_em_estoque = utf8_decode($oRet->situacao_em_estoque);
            fpc_append($sEcoTxt, "sSituacao_em_estoque=$sSituacao_em_estoque");
            $aIns[] = array("sSituacao_em_estoque", $sSituacao_em_estoque);
         } // if (isset($oRet->situacao_em_estoque))

         if (isset($oRet->situacao_sem_estoque)) { // "situacao_sem_estoque": -1
            $sSituacao_sem_estoque = utf8_decode($oRet->situacao_sem_estoque);
            fpc_append($sEcoTxt, "sSituacao_sem_estoque=$sSituacao_sem_estoque");
            $aIns[] = array("sSituacao_sem_estoque", $sSituacao_sem_estoque);
         } // if (isset($oRet->situacao_sem_estoque))

         $iIns = count($aIns);
         if ($iIns>0) {
            $sSql = fsArrToInsert('LJI_Estoque',$aIns);
            fpc_append($sEcoTxt,"sSql=$sSql");
            $aSql[] = $sSql;
         } // if ($iIns>0)

         foreach ($aSql as $sSql) {
            // insert real
         } // foreach ($aSql as $sSql)

      } // ($lOk==true)
   } // if ($lControlProc==false)

   if ($lOk==true) {
      fpc_append($sEcoTxt, "commit");
      flDBCommit($hDb);
   } else {
      $sRollback = fsDBRollBack($hDb);
      fpc_append($sEcoTxt, "Rollback");
      fpc_append($sEcoTxt, "$sRollback");
   } // if ($lOk==true)
      
   $tJobEnd  = time();
   $iJobElap = $tJobEnd-$tJobStart;

   $aTop    = faLoadAvgServer();
   $nTopFin = $aTop[0];

   list($iUsec, $iSec) = explode(' ', microtime());
   $tScript_End = (float) $iSec + (float) $iUsec;

   $tElapsed_Time = round($tScript_End - $tScript_Start, 5);
   fpc_append($sEcoTxt,'Encerrado em '.date('d/m/Y H:i:s',$tJobEnd));

   fpc_append($sEcoTxt,"Tempo Decorrido: ".gmdate("H:i:s", $tElapsed_Time).', Secs: '.$tElapsed_Time.". Memoria usada: ".round(((memory_get_peak_usage(true) / 1024) / 1024), 2)."Mb");

   flDbDisconnect($hDb);

} else {
   echo 'Arquivo de configurao no foi encontrado.';
}

$aTop    = faLoadAvgServer();
$nTopFin = $aTop[0];

$flSysJobs = flSysJobs($sProc,$nTopIni,$nTopFin,$tJobStart,$tJobEnd,$iJobElap,$psCliPasta,$psLogin);
