<?php
set_time_limit(300);
//error_reporting(E_ALL);
require_once("../pFuncoes1.php");
require_once("../pPublics1.php");	

list($iUsec, $iSec) = explode(' ', microtime());
$tScript_Start = (float) $iSec + (float) $iUsec;

$psCliPasta = fsCliPasta();

$aTop      = faLoadAvgServer();
$nTopIni   = $aTop[0];
$tJobStart = time();
$sProc     = basename(__FILE__);

$sEcoNome  = str_replace('.','_',$sProc).'-'.$tJobStart.'.log';
$sEcoTxt = "/qtux/www/FullPlat/processos/logs/$sEcoNome";
$sEcoTxt = fsDirEcoTxt($sEcoTxt);

$iProcID              = getmypid();
$lProducao            = true;
$aUserLog             = array();
$iCount_oOrdensColeta = 0;

fpc($sEcoTxt,'Incio em ' . date('d/m/Y H:i:s',$tJobStart));
fpc_append($sEcoTxt,'iProcID='.$iProcID);
fpc_append($sEcoTxt,"lProducao=$lProducao");
fpc_append($sEcoTxt,"psCliPasta=$psCliPasta");

$sFileConfig = "../../$psCliPasta/dd_files/Business.ddini";
fpc_append($sEcoTxt,"sFileConfig=$sFileConfig");

if (file_exists($sFileConfig)) {

   $sTxt = fsTXTFiltrar($sFileConfig);
   $aArr = explode(chr(10),$sTxt);
   $sVarsTxt = '';
   foreach ($aArr as $sLin) {
      $aLin = explode('//',$sLin);
      $sLin = trim($aLin[0]);
      $iLen = strlen($sLin);
      if ($iLen>0) {
         $aLin = explode('=',$sLin);
         $s1 = trim($aLin[0]);
         $iCountaLin = count($aLin);
         if ($iCountaLin>1) $s2 = trim($aLin[1]);
         else               $s2 = '';
         $s  = '$'.$s1." = '".$s2."';";
         eval($s);
         $sVarsTxt .= $s . chr(10);
      }
   }

   $lGo      = true;
   $lOk      = true;
   $lLigaQry = true;

   $psLogin = 1;

   $sDSN    = "$sHost:$sPathDB/$sDB";
   $sPathFS = $sPathFileSys;

   fpc_append($sEcoTxt,"sDSN = $sDSN, sPathFS = $sPathFS");

   $hDb = fhDbConnect($sDSN);

   //$lControlProc = flControlProc($hDb,$sProc);
   $lControlProc = flControlProcLinux($sProc);
   fpc_append($sEcoTxt,"lControlProc=$lControlProc");
   if ($lControlProc==false) {
      $lOk = false;
      fpc_append($sEcoTxt,"J TEM UM PROCESSO RODANDO [ $sProc ] NO IR RODAR, ESPERE O PROCESSO TERMINAR PARA RODAR NOVAMENTE.");
   } else {

      $iCupom = 2614409;

      $sUrlIntegracao = "https://api.awsli.com.br/v1/cupom/$iCupom";
      fpc_append($sEcoTxt,"sUrlIntegracao=$sUrlIntegracao");
      
      $oRet = foGETLojaIntegrada(); // requisio da API loja integrada

      if ( ($lOk==true) && $oRet!='null') {

         $aSql = array();
         $aIns = array(); 
            
         if (isset($oRet->aplicar_no_total)) { // "aplicar_no_total": false,
            $sAplicar_no_total = utf8_decode($oRet->aplicar_no_total);
            $sAplicar_no_total = $sAplicar_no_total=='' ? 0 : 1;
            fpc_append($sEcoTxt,"sAplicar_no_total=$sAplicar_no_total");
            $aIns[] = array("sAplicar_no_total", $sAplicar_no_total);
         } // if (isset($oRet->aplicar_no_total))
         
         if (isset($oRet->ativo)) { // "ativo": true,
            $sAtivo = utf8_decode($oRet->ativo);
            $sAtivo = $sAtivo=='' ? 0 : 1;
            fpc_append($sEcoTxt,"sAtivo=$sAtivo");
            $aIns[] = array("sAtivo", $sAtivo);
         } // if (isset($oRet->ativo))
         
         if (isset($oRet->categorias)) { // "categorias": [],
            $aInsCat = array();
            $oCategorias = $oRet->categorias;

            foreach ($oCategorias as $sCategoria) {
               fpc_append($sEcoTxt,"sCategoria=$sCategoria");
               $aInsCat = array("sCategoria", $sCategoria);
            } // foreach ($oCategorias as $sCategoria)
         } // if (isset($oRet->categorias))
         
         if (isset($oRet->clientes)) { // "clientes": [],
            $aInsCli = array();
            $oClientes = $oRet->clientes;

            foreach ($oClientes as $sCliente) {
               fpc_append($sEcoTxt,"sCliente");
               $aInsCli = array("sCliente", $sCliente);
            } // foreach ($oClientes as $sCliente)
         } // if (isset($oRet->clientes))
         
         if (isset($oRet->codigo)) { // "codigo": "CUPOM15OFF",
            $sCodigo = utf8_decode($oRet->codigo);
            fpc_append($sEcoTxt,"sCodigo=$sCodigo");
            $aIns[] = array("sCodigo", $sCodigo);
         } // if (isset($oRet->codigo))
         
         if (isset($oRet->condicao_cliente)) { // "condicao_cliente": "grupos_selecionados",
            $sCondicao_cliente = utf8_decode($oRet->condicao_cliente);
            fpc_append($sEcoTxt,"sCondicao_cliente=$sCondicao_cliente");
            $aIns[] = array("sCondicao_cliente", $sCondicao_cliente);
         } // if (isset($oRet->condicao_cliente))
         
         if (isset($oRet->condicao_cliente)) { // "condicao_produto": "produtos_selecionados",
            $sCondicao_produto = utf8_decode($oRet->condicao_cliente);
            fpc_append($sEcoTxt,"sCondicao_produto=$sCondicao_produto");
            $aIns[] = array("sCondicao_produto", $sCondicao_produto);
         } // if (isset($oRet->condicao_cliente))
         
         if (isset($oRet->cumulativo)) { // "cumulativo": false,
            $sCumulativo = utf8_decode($oRet->cumulativo);
            $sCumulativo = $sCumulativo=='' ? 0 : 1;
            fpc_append($sEcoTxt,"sCumulativo=$sCumulativo");
            $aIns[] = array("sCumulativo", $sCumulativo);
         } // if (isset($oRet->cumulativo))
         
         if (isset($oRet->data_criacao)) { // "data_criacao": "2022-11-09T15:44:47.289328",
            $sData_criacao = utf8_decode($oRet->data_criacao);
            fpc_append($sEcoTxt,"sData_criacao=$sData_criacao");
            $aIns[] = array("sData_criacao", $sData_criacao);
         } // if (isset($oRet->data_criacao))
         
         if (isset($oRet->data_modificacao)) { // "data_modificacao": "2022-11-09T15:44:47.289341",
            $sData_modificacao = utf8_decode($oRet->data_modificacao);
            fpc_append($sEcoTxt,"sData_modificacao=$sData_modificacao");
            $aIns[] = array("sData_modificacao", $sData_modificacao);
         } // if (isset($oRet->data_modificacao))
         
         if (isset($oRet->descricao)) { // "descricao": "Desconto percentual 02",
            $sDescricao = utf8_decode($oRet->descricao);
            fpc_append($sEcoTxt,"sDescricao=$sDescricao");
            $aIns[] = array("sDescricao", $sDescricao);
         } // if (isset($oRet->descricao))

         if (isset($oRet->grupos)) { // "grupos": [1],
            $aInsGrupo = array();
            $oGrupos = $oRet->grupos;

            foreach ($oGrupos as $sGrupo) {
               fpc_append($sEcoTxt, "sGrupo=$sGrupo");
               $aInsGrupo[] = array("sGrupo", $sGrupo);
            } // foreach ($oGrupos as $sGrupo)
         } // if (isset($oRet->grupos))

         if (isset($oRet->id)) { // "id": 1469590,
            $sId = utf8_decode($oRet->id);
            fpc_append($sEcoTxt, "sId=$sId");
            $aIns[] = array("sId", $sId);
         } // if (isset($oRet->id))
         
         if (isset($oRet->id_externo)) { // "id_externo": null,
            $sId_externo = utf8_decode($oRet->id_externo);
            fpc_append($sEcoTxt, "sId_externo=$sId_externo");
            $aIns[] = array("sId_externo", $sId_externo);
         } // if (isset($oRet->id_externo))

         if (isset($oRet->produtos)) { // "produtos": [183623529,183610329],
            $aInsProd  = array();
            $oProdutos = $oRet->produtos;

            foreach($oProdutos as $sProduto) {
               fpc_append($sEcoTxt, "sProduto=$sProduto");
               $aInsProd[] = array("sProduto", $sProduto);
            } // foreach($oProdutos as $sProduto)
         } // if (isset($oRet->produtos))
         
         if (isset($oRet->quantidade)) { // "quantidade": 100,
            $sQuantidade = utf8_decode($oRet->quantidade);
            fpc_append($sEcoTxt, "sQuantidade=$sQuantidade");
            $aIns[] = array("sQuantidade", $sQuantidade);
         } // if (isset($oRet->quantidade))
         
         if (isset($oRet->quantidade_por_cliente)) { // "quantidade_por_cliente": 1,
            $sQuantidade_por_cliente = utf8_decode($oRet->quantidade_por_cliente);
            fpc_append($sEcoTxt, "sQuantidade_por_cliente=$sQuantidade_por_cliente");
            $aIns[] = array("sQuantidade_por_cliente", $sQuantidade_por_cliente);
         } // if (isset($oRet->quantidade_por_cliente))
         
         if (isset($oRet->quantidade_usada)) { // "quantidade_usada": 0,
            $sQuantidade_usada = utf8_decode($oRet->quantidade_usada);
            fpc_append($sEcoTxt, "sQuantidade_usada=$sQuantidade_usada");
            $aIns[] = array("sQuantidade_usada", $sQuantidade_usada);
         } // if (isset($oRet->quantidade_usada))
         
         if (isset($oRet->resource_uri)) { // "resource_uri": "/api/v1/cupom/1469590",
            $sResource_uri = utf8_decode($oRet->resource_uri);
            fpc_append($sEcoTxt, "sResource_uri=$sResource_uri");
            $aIns[] = array("sResource_uri", $sResource_uri);
         } // if (isset($oRet->resource_uri))
         
         if (isset($oRet->tipo)) { // "tipo": "porcentagem",
            $sTipo = utf8_decode($oRet->tipo);
            fpc_append($sEcoTxt, "sTipo=$sTipo");
            $aIns[] = array("sTipo", $sTipo);
         } // if (isset($oRet->tipo))
         
         if (isset($oRet->tipo)) { // "validade": "2022-02-12T00:00:00",
            $sValidade = utf8_decode($oRet->tipo);
            fpc_append($sEcoTxt, "sValidade=$sValidade");
            $aIns[] = array("sValidade", $sValidade);
         } // if (isset($oRet->tipo))
         
         if (isset($oRet->valor)) { // "valor": "15.00",
            $sValor = utf8_decode($oRet->valor);
            fpc_append($sEcoTxt, "sValor=$sValor");
            $aIns[] = array("sValor", $sValor);
         } // if (isset($oRet->valor))
         
         if (isset($oRet->valor_minimo)) { // "valor_minimo": "500.00"
            $sValor_minimo = utf8_decode($oRet->valor_minimo);
            fpc_append($sEcoTxt, "sValor_minimo=$sValor_minimo");
            $aIns[] = array("sValor_minimo", $sValor_minimo);
         } // if (isset($oRet->valor_minimo))

            $iIns = count($aIns);
            if ($iIns>0) {
               $sSql = fsArrToInsert('LJI_Cupom',$aIns);
               fpc_append($sEcoTxt,"sSql=$sSql");
               $aSql[] = $sSql;
            } // if ($aIns>0)

         foreach ($aSql as $sSql) {
            // insert real
         } // foreach ($aSql as $sSql)

      } // ($lOk==true)
   } // if ($lControlProc==false)

   if ($lOk==true) {
      fpc_append($sEcoTxt, "commit");
      flDBCommit($hDb);
   } else {
      $sRollback = fsDBRollBack($hDb);
      fpc_append($sEcoTxt, "Rollback");
      fpc_append($sEcoTxt, "$sRollback");
   } // if ($lOk==true)
      
   $tJobEnd  = time();
   $iJobElap = $tJobEnd-$tJobStart;

   $aTop    = faLoadAvgServer();
   $nTopFin = $aTop[0];

   list($iUsec, $iSec) = explode(' ', microtime());
   $tScript_End = (float) $iSec + (float) $iUsec;

   $tElapsed_Time = round($tScript_End - $tScript_Start, 5);
   fpc_append($sEcoTxt,'Encerrado em '.date('d/m/Y H:i:s',$tJobEnd));

   fpc_append($sEcoTxt,"Tempo Decorrido: ".gmdate("H:i:s", $tElapsed_Time).', Secs: '.$tElapsed_Time.". Memoria usada: ".round(((memory_get_peak_usage(true) / 1024) / 1024), 2)."Mb");

   flDbDisconnect($hDb);

} else {
   echo 'Arquivo de configurao no foi encontrado.';
}

$aTop    = faLoadAvgServer();
$nTopFin = $aTop[0];

$flSysJobs = flSysJobs($sProc,$nTopIni,$nTopFin,$tJobStart,$tJobEnd,$iJobElap,$psCliPasta,$psLogin);
