<?php
set_time_limit(300);
//error_reporting(E_ALL);
require_once("../pFuncoes1.php");
require_once("../pPublics1.php");	

list($iUsec, $iSec) = explode(' ', microtime());
$tScript_Start = (float) $iSec + (float) $iUsec;

$psCliPasta = fsCliPasta();

$aTop      = faLoadAvgServer();
$nTopIni   = $aTop[0];
$tJobStart = time();
$sProc     = basename(__FILE__);

$sEcoNome  = str_replace('.','_',$sProc).'-'.$tJobStart.'.log';
$sEcoTxt = "/qtux/www/FullPlat/processos/logs/$sEcoNome";
$sEcoTxt = fsDirEcoTxt($sEcoTxt);

$iProcID              = getmypid();
$lProducao            = true;
$aUserLog             = array();
$iCount_oOrdensColeta = 0;

fpc($sEcoTxt,'Incio em ' . date('d/m/Y H:i:s',$tJobStart));
fpc_append($sEcoTxt,'iProcID='.$iProcID);
fpc_append($sEcoTxt,"lProducao=$lProducao");
fpc_append($sEcoTxt,"psCliPasta=$psCliPasta");

$sFileConfig = "../../$psCliPasta/dd_files/Business.ddini";
fpc_append($sEcoTxt,"sFileConfig=$sFileConfig");

if (file_exists($sFileConfig)) {

   $sTxt = fsTXTFiltrar($sFileConfig);
   $aArr = explode(chr(10),$sTxt);
   $sVarsTxt = '';
   foreach ($aArr as $sLin) {
      $aLin = explode('//',$sLin);
      $sLin = trim($aLin[0]);
      $iLen = strlen($sLin);
      if ($iLen>0) {
         $aLin = explode('=',$sLin);
         $s1 = trim($aLin[0]);
         $iCountaLin = count($aLin);
         if ($iCountaLin>1) $s2 = trim($aLin[1]);
         else               $s2 = '';
         $s  = '$'.$s1." = '".$s2."';";
         eval($s);
         $sVarsTxt .= $s . chr(10);
      }
   }

   $lGo      = true;
   $lOk      = true;
   $lLigaQry = true;

   $psLogin = 1;

   $sDSN    = "$sHost:$sPathDB/$sDB";
   $sPathFS = $sPathFileSys;

   fpc_append($sEcoTxt,"sDSN = $sDSN, sPathFS = $sPathFS");

   $hDb = fhDbConnect($sDSN);

   //$lControlProc = flControlProc($hDb,$sProc);
   $lControlProc = flControlProcLinux($sProc);
   fpc_append($sEcoTxt,"lControlProc=$lControlProc");
   if ($lControlProc==false) {
      $lOk = false;
      fpc_append($sEcoTxt,"J TEM UM PROCESSO RODANDO [ $sProc ] NO IR RODAR, ESPERE O PROCESSO TERMINAR PARA RODAR NOVAMENTE.");
   } else {

      $sUrlIntegracao = 'https://api.awsli.com.br/v1/cupom/';
      fpc_append($sEcoTxt,"sUrlIntegracao=$sUrlIntegracao");
      
      $oRet = foGETLojaIntegrada(); // requisio da API loja integrada

      if ( ($lOk==true) && $oRet!='null') {

         $oMeta = isset($oRet->meta) ? $oRet->meta : 'null';

         foreach($oMeta as $sKey => $sValue) {
            if ((!is_array($sValue)) || (!is_object($sValue)) ) {
               fpc_append($sEcoTxt,"$sKey => $sValue");
               $aIns[] = array('s'.ucfirst($sKey),$sValue);
            }
         } // foreach($oRet as $sKey => $sValue)

         $aSql = array();

         $oObjects = isset($oRet->objects) ? $oRet->objects : 'null';
         foreach ($oObjects as $oObject) {

            $aIns = array();

            if (isset($oObject->aplicar_no_total)) { // "aplicar_no_total": false,
               $sAplicar_no_total = utf8_decode($oObject->aplicar_no_total);
               $sAplicar_no_total = $sAplicar_no_total=='' ? 0 : 1;
               fpc_append($sEcoTxt,"sAplicar_no_total=$sAplicar_no_total");
               $aIns[] = array("sAplicar_no_total", $sAplicar_no_total);
            } // if (isset($oObject->aplicar_no_total))
            
            if (isset($oObject->ativo)) { // "ativo": true,
               $sAtivo = utf8_decode($oObject->ativo);
               $sAtivo = $sAtivo=='' ? 0 : 1;
               fpc_append($sEcoTxt,"sAtivo=$sAtivo");
               $aIns[] = array("sAtivo", $sAtivo);
            } // if (isset($oObject->ativo))
            
            if (isset($oObject->codigo)) { // "codigo": "02022022",
               $sCodigo = utf8_decode($oObject->codigo);
               fpc_append($sEcoTxt,"sCodigo=$sCodigo");
               $aIns[] = array("sCodigo", $sCodigo);
            } // if (isset($oObject->codigo))
            
            if (isset($oObject->condicao_cliente)) { // "condicao_cliente": "todos_clientes",
               $sCondicao_cliente = utf8_decode($oObject->condicao_cliente);
               fpc_append($sEcoTxt,"sCondicao_cliente=$sCondicao_cliente");
               $aIns[] = array("sCondicao_cliente", $sCondicao_cliente);
            } // if (isset($oObject->condicao_cliente))
            
            if (isset($oObject->condicao_produto)) { // "condicao_produto": "todos_produtos",
               $sCondicao_produto = utf8_decode($oObject->condicao_produto);
               fpc_append($sEcoTxt,"sCondicao_produto=$sCondicao_produto");
               $aIns[] = array("sCondicao_produto", $sCondicao_produto);
            } // if (isset($oObject->condicao_produto))
            
            if (isset($oObject->cumulativo)) { // "cumulativo": false,
               $sCumulativo = utf8_decode($oObject->cumulativo);
               $sCumulativo = $sCumulativo=='' ? 0 : 1;
               fpc_append($sEcoTxt,"sCumulativo=$sCumulativo");
               $aIns[] = array("sCumulativo", $sCumulativo);
            } // if (isset($oObject->cumulativo))
            
            if (isset($oObject->data_criacao)) { // "data_criacao": "2022-02-02T12:02:05.739664",
               $sData_criacao = utf8_decode($oObject->data_criacao);
               fpc_append($sEcoTxt,"sData_criacao=$sData_criacao");
               $aIns[] = array("sData_criacao", $sData_criacao);
            } // if (isset($oObject->data_criacao))
            
            if (isset($oObject->data_modificacao)) { // "data_modificacao": "2022-02-02T13:07:54.275577",
               $sData_modificacao = utf8_decode($oObject->data_modificacao);
               fpc_append($sEcoTxt,"sData_modificacao=$sData_modificacao");
               $aIns[] = array("sData_modificacao", $sData_modificacao);
            } // if (isset($oObject->data_modificacao))
            
            if (isset($oObject->descricao)) { // "descricao": "cupom02-02-2022",
               $sDescricao = utf8_decode($oObject->descricao);
               fpc_append($sEcoTxt,"sDescricao=$sDescricao");
               $aIns[] = array("sDescricao", $sDescricao);
            } // if (isset($oObject->descricao))
            
            if (isset($oObject->id)) { // "id": 1178843,
               $sId = utf8_decode($oObject->id);
               fpc_append($sEcoTxt,"sId=$sId");
               $aIns[] = array("sId", $sId);
            } // if (isset($oObject->id))
            
            if (isset($oObject->id_externo)) { // "id_externo": null,
               $sId_externo = utf8_decode($oObject->id_externo);
               fpc_append($sEcoTxt,"sId_externo=$sId_externo");
               $aIns[] = array("sId_externo", $sId_externo);
            } // if (isset($oObject->id_externo))
            
            if (isset($oObject->quantidade)) { // "quantidade": 99,
               $sQuantidade = utf8_decode($oObject->quantidade);
               fpc_append($sEcoTxt,"sQuantidade=$sQuantidade");
               $aIns[] = array("sQuantidade", $sQuantidade);
            } // if (isset($oObject->quantidade))
            
            if (isset($oObject->quantidade_por_cliente)) { // "quantidade_por_cliente": 1,
               $sQuantidade_por_cliente = utf8_decode($oObject->quantidade_por_cliente);
               fpc_append($sEcoTxt,"sQuantidade_por_cliente=$sQuantidade_por_cliente");
               $aIns[] = array("sQuantidade_por_cliente", $sQuantidade_por_cliente);
            } // if (isset($oObject->quantidade_por_cliente))
            
            if (isset($oObject->quantidade_usada)) { // "quantidade_usada": 1,
               $sQuantidade_usada = utf8_decode($oObject->quantidade_usada);
               fpc_append($sEcoTxt,"sQuantidade_usada=$sQuantidade_usada");
               $aIns[] = array("sQuantidade_usada", $sQuantidade_usada);
            } // if (isset($oObject->quantidade_usada))
            
            if (isset($oObject->resource_uri)) { // "resource_uri": "/api/v1/cupom/1178843",
               $sResource_uri = utf8_decode($oObject->resource_uri);
               fpc_append($sEcoTxt,"sResource_uri=$sResource_uri");
               $aIns[] = array("sResource_uri", $sResource_uri);
            } // if (isset($oObject->resource_uri))
            
            if (isset($oObject->tipo)) { // "tipo": "porcentagem",
               $sTipo = utf8_decode($oObject->tipo);
               fpc_append($sEcoTxt,"sTipo=$sTipo");
               $aIns[] = array("sTipo", $sTipo);
            } // if (isset($oObject->tipo))
            
            if (isset($oObject->validade)) { // "validade": "2022-02-02T00:00:00",
               $sValidade = utf8_decode($oObject->validade);
               fpc_append($sEcoTxt,"sValidade=$sValidade");
               $aIns[] = array("sValidade", $sValidade);
            } // if (isset($oObject->validade))
            
            if (isset($oObject->valor)) { // "valor": "10.00",
               $sValor = utf8_decode($oObject->valor);
               fpc_append($sEcoTxt,"sValor=$sValor");
               $aIns[] = array("sValor", $sValor);
            } // if (isset($oObject->valor))
            
            if (isset($oObject->valor_minimo)) { // "valor_minimo": null
               $sValor_minimo = utf8_decode($oObject->valor_minimo);
               fpc_append($sEcoTxt,"sValor_minimo=$sValor_minimo");
               $aIns[] = array("sValor_minimo", $sValor_minimo);
            } // if (isset($oObject->valor_minimo))

            $iIns = count($aIns);
            if ($iIns>0) {
               $sSql = fsArrToInsert('LJI_Cupom',$aIns);
               fpc_append($sEcoTxt,"sSql=$sSql");
               $aSql[] = $sSql;
            } // if ($aIns>0)

         } // foreach ($oObjects as $oObject)

         foreach ($aSql as $sSql) {
            // insert real
         }

      } // ($lOk==true)
   } // if ($lControlProc==false)

   if ($lOk==true) {
      fpc_append($sEcoTxt, "commit");
      flDBCommit($hDb);
   } else {
      $sRollback = fsDBRollBack($hDb);
      fpc_append($sEcoTxt, "Rollback");
      fpc_append($sEcoTxt, "$sRollback");
   } // if ($lOk==true)
      
   $tJobEnd  = time();
   $iJobElap = $tJobEnd-$tJobStart;

   $aTop    = faLoadAvgServer();
   $nTopFin = $aTop[0];

   list($iUsec, $iSec) = explode(' ', microtime());
   $tScript_End = (float) $iSec + (float) $iUsec;

   $tElapsed_Time = round($tScript_End - $tScript_Start, 5);
   fpc_append($sEcoTxt,'Encerrado em '.date('d/m/Y H:i:s',$tJobEnd));

   fpc_append($sEcoTxt,"Tempo Decorrido: ".gmdate("H:i:s", $tElapsed_Time).', Secs: '.$tElapsed_Time.". Memoria usada: ".round(((memory_get_peak_usage(true) / 1024) / 1024), 2)."Mb");

   flDbDisconnect($hDb);

} else {
   echo 'Arquivo de configurao no foi encontrado.';
}

$aTop    = faLoadAvgServer();
$nTopFin = $aTop[0];

$flSysJobs = flSysJobs($sProc,$nTopIni,$nTopFin,$tJobStart,$tJobEnd,$iJobElap,$psCliPasta,$psLogin);
