<?php
set_time_limit(0);

list($iUsec, $iSec) = explode(' ', microtime());
$tScript_Start = (float) $iSec + (float) $iUsec;

require_once('/qtux/www/FullPlat/pFuncoes1.php');
$tJobStart = date('d/m/Y H:i:s', time());
echo "Processo ".basename(__FILE__)." Iniciado \n";

$sEcoTxt     = str_replace('.','_',basename(__FILE__)).'_'.time().'.log';
fpc($sEcoTxt,'Incio em ' . $tJobStart);

$sHOST = exec('hostname');
if ($sHOST=='qtuxap.sanol.com.br') {
   $sDSN = '192.168.1.109:/qtux/database/total/gps_01.gdb';
} else if ($sHOST=='homologqtuxweb.sanol.com.br') {
   $sDSN = 'localhost:/qtux/database/total/gps_01.gdb';
} else {
   $sDSN = 'localhost:/qtux/database/tq/gps_01.gdb';
}

$hDb    = fhDbConnect($sDSN);

$aPlanilhas = array();
$aPlanilhas[] = array('ItensCollie.csv'  ,2,3050);
$aPlanilhas[] = array('ItensV8.csv'      ,3,3050);
$aPlanilhas[] = array('ItensSanolDog.csv',4,3050);

$iFases = count($aPlanilhas);
$iFase  = 0;
foreach ($aPlanilhas as $aLin) {
   $iFase++;
   $sPlanilha = $aLin[0];
   $pLoja     = $aLin[1];
   $pUNeg     = $aLin[2];

   $sData = date('Ymd');
   $sDados = str_replace(chr(13),'',file_get_contents('/qtux/www/FullPlat/processos/LGI/'.$sPlanilha));

   $sDados = str_replace('"','',$sDados);
   $sDados = str_replace("'",'',$sDados);
   $aDados = explode(chr(10),$sDados);

   $sFileInsert = str_replace('.csv','',$sPlanilha).'_'.time().'.sql';

   fpc($sFileInsert,'set sql dialect 3;');
   fpc_append($sFileInsert,"CONNECT '$sDSN';");

   $lDb = false; // TRUE = FAZ UPDATE E INSERT PELAS FUNES, FALSE = FAZ O UPDATE E INSERT VIA SCRIPT
   $iCM   = 0;
   $iRB   = 0;
   $iCont = 0;
   $iTot  = count($aDados);
   foreach ($aDados as $sLin) {
      if ($sLin!='') {
         ++$iCont;
         echo "Fase $iFase/$iFases - $iCont de $iTot ".round($iCont*100/$iTot,2)." %".chr(10);
         $aLin       = explode(';',$sLin);
         $sCodigo    = trim(strtoupper($aLin[0]));		
         $sDescricao = trim(strtoupper($aLin[1]));
   
         if ($sCodigo!='') {
            $sSql = "select pPId,sDescricao from Itens where sCodigo='$sCodigo' and pUNeg=$pUNeg and iVer=iVAt";
            $aDb  = faDbSelect($hDb,$sSql);
            fpc_append($sEcoTxt,"$iCont) sSql=$sSql");
            if (isset($aDb[0][0])) {
               $pItem      = $aDb[0][0];
               $sDescricao = trim($aDb[0][1]);
               ++$iCM;
               $sSql = "insert into LGI_UNeg_Itens (pInc,pCapa,pItem,sReference,sName) values (1,$pLoja,$pItem,'$sCodigo','$sDescricao')";
               if ($lDb==false) fpc_append($sFileInsert,$sSql.';');
               else {
                  if ($lOk==true) {
                     $lOk  = flDbInsert($hDb,$sSql);
                     fpc_append($sEcoTxt,"$iCont) lOk=$lOk, sSql=$sSql");
                  }
                  if ($lOk==false) {
                     fpc_append($sEcoTxt,"$iCont) ERRO: sSql=$sSql");
                     echo "ERRO: sSql=$sSql".chr(10);
                  }
               } 
            } else {
               fpc_append($sEcoTxt,"ITEM $sCodigo -> $sDescricao NO ENCONTRADO NA UNEG $pUNeg");
            } // if (isset($aDb[0][0]))
   
            if ($lDb==true) {
               if ($lOk==true) {
                  flDbCommit($hDb);
                  fpc_append($sEcoTxt,"$iCont) commit");
               } else {
                  ++$iRB;
                  flDbRollBack($hDb);
                  fpc_append($sEcoTxt,"$iCont) rollback");
               }
            } // if ($lDb==true)
            fpc_append($sEcoTxt,'---------------------------------------------');
         } else {
           ++$iRB;
           echo "$iCont) CDIGO EST VAZIO, sCodigo=$sCodigo, sDescricao=$sDescricao".chr(10);
           fpc_append($sEcoTxt,"$iCont) CDIGO EST VAZIO, sCodigo=$sCodigo, sDescricao=$sDescricao");
         }
      } // if(alin
   } // foreach
   fpc_append($sFileInsert,'commit;');
   echo "Fase $iFase/$iFases\n";
   echo "$iCM Registros relacionados\n";
   fpc_append($sEcoTxt,"$iCM Registros relacionados");
   echo "$iRB Registros sem relao\n";
   fpc_append($sEcoTxt,"$iRB Registros sem relao");

} // foreach ($aPlanilhas as $aLin)

//$sCMD = "/opt/firebird/bin/isql -pass qtux201005 -user SYSQTUX -i /qtux/www/FullPlat/processos/Migracao/PlaConta/$sFileInsert";
//shell_exec($sCMD);


$tJobEnd = date('d/m/Y H:i:s', time());
fpc_append($sEcoTxt,'Trmino em ' . $tJobEnd);
echo"Processo ".basename(__FILE__)." Concluido \n";

list($iUsec, $iSec) = explode(' ', microtime());
$tScript_End = (float) $iSec + (float) $iUsec;

$tElapsed_Time = round($tScript_End - $tScript_Start, 5);
$sMsg = "Tempo Decorrido: ".gmdate("H:i:s", $tElapsed_Time).', Secs: '.$tElapsed_Time.". Memoria usada: ".round(((memory_get_peak_usage(true) / 1024) / 1024), 2)."Mb";
fpc_append($sEcoTxt,$sMsg);
echo $sMsg.chr(10);