<?php
set_time_limit(300);
require_once("../pFuncoes1.php");
require_once("../pPublics1.php");

list($iUsec, $iSec) = explode(' ', microtime());
$tScript_Start = (float) $iSec + (float) $iUsec;

$aTop      = faLoadAvgServer();
$nTopIni   = $aTop[0];
$tJobStart = time();
$sProc     = basename(__FILE__);

$psCliPasta  = 'desenvolvimento';

$sEcoNome  = str_replace('.','_',$sProc).'-'.$tJobStart.'.log';
$sEcoTxt = "/qtux/www/FullPlat/processos/logs/$sEcoNome";
$sEcoTxt = fsDirEcoTxt($sEcoTxt);

$iProcID = getmypid();

fpc($sEcoTxt,'iProcID='.$iProcID);
fpc_append($sEcoTxt,'Incio em ' . date('d/m/Y H:i:s',$tJobStart));
fpc_append($sEcoTxt,"psCliPasta=$psCliPasta");

$lLigaQry = true;
$aUserLog = array();

$sFileConfig = "../../$psCliPasta/dd_files/Business.ddini";
fpc_append($sEcoTxt,'Cliente: '.$psCliPasta);
fpc_append($sEcoTxt,"Arquivo ddini ($sFileConfig)");

if (file_exists($sFileConfig)) {

   $sTxt = fsTXTFiltrar($sFileConfig);
   $aArr = explode(chr(10),$sTxt);

   $sVarsTxt = '';
   foreach ($aArr as $sLin) {
      $aLin = explode('//',$sLin);
      $sLin = trim($aLin[0]);
      $iLensLin = strlen($sLin);
      if ($iLensLin>0) {
         $aLin = explode('=',$sLin);
         $s1 = trim($aLin[0]);
         $iCountaLin = count($aLin);
         if ($iCountaLin>1) $s2 = trim($aLin[1]);
         else               $s2 = '';
         $s  = '$'.$s1." = '".$s2."';";
         eval($s);   // criando uma var
         $sVarsTxt .= $s . chr(10);
      }
   }

   $iOk       = 1;
   $lOk       = true;
   $sDSN      = "$sHost:$sPathDB/$sDB";
   $sPathFS   = $sPathFileSys;

   $hDb     = fhDbConnect($sDSN);

   // Grfico Barras
   $aGrafBarras = array();
   $aGrafBarras['$schema'] = 'https://vega.github.io/schema/vega/v5.json'; // "$schema": "https://vega.github.io/schema/vega/v5.json",
   $aGrafBarras['description'] = utf8_encode('Grfico barras'); // "description": "A basic donut chart example.",
   $aGrafBarras['width']   = 400; // "width": 400,
   $aGrafBarras['height']  = 200; // "height": 200,
   $aGrafBarras['padding'] = 5;   // "padding": 5,

   // Incio data
   $aData = array();
   $aData['name'] = 'table'; // "name": "table",
   
   $aValues = array();
   $aValues[] = array('category' => 'A', 'amount' => 28); // {"category": "A", "amount": 28},
   $aValues[] = array('category' => 'B', 'amount' => 55); // {"category": "B", "amount": 55},
   $aValues[] = array('category' => 'C', 'amount' => 43); // {"category": "C", "amount": 43},
   $aValues[] = array('category' => 'D', 'amount' => 91); // {"category": "D", "amount": 91},
   $aValues[] = array('category' => 'E', 'amount' => 81); // {"category": "E", "amount": 81},
   $aValues[] = array('category' => 'F', 'amount' => 53); // {"category": "F", "amount": 53},
   $aValues[] = array('category' => 'G', 'amount' => 19); // {"category": "G", "amount": 19},
   $aValues[] = array('category' => 'H', 'amount' => 87); // {"category": "H", "amount": 87}

   $aData['values'] = $aValues; // "values": [

   $aGrafBarras['data'][] = $aData; // "data": [
   // Fim data

   // Inicio Signals
   $aSignals = array();
   $aSignals['name']  = 'tooltip'; // "name": "tooltip",
   $aSignals['value'] = array();      // "value": {},
   
   $aOn = array();
   $aOn[] = array('events' => 'rect:mouseover', 'update' => 'datum'); // {"events": "rect:mouseover", "update": "datum"},
   $aOn[] = array('events' => 'rect:mouseout' , 'update' => '{}');    // {"events": "rect:mouseout",  "update": "{}"}
   
   $aSignals['on'] = $aOn;
   
   $aGrafBarras['signals'][] = $aSignals;
   // Fim Signals

   // Inicio Scales
   $aScales1 = array();
   $aScales1['name']    = 'xscale'; // "name": "xscale",
   $aScales1['type']    = 'band';   // "type": "band",
   $aScales1['domain']  = array('data' => 'table', 'field' => 'category'); // "domain": {"data": "table", "field": "category"},
   $aScales1['range']   = 'width'; // "range": "width",
   $aScales1['padding'] = 0.05; // "padding": 0.05,
   $aScales1['round']   = true; // "round": true

   $aScales2 = array();
   $aScales2['name']    = 'yscale'; // "name": "yscale",
   $aScales2['domain']  = array('data' => 'table', 'field' => 'amount'); // "domain": {"data": "table", "field": "amount"},
   $aScales2['nice']    = true; // "nice": true,
   $aScales2['range']   = 'height'; // "range": "height"

   $aGrafBarras['scales'] = array($aScales1,$aScales2);
   // Fim Scales

   // Inicio Axes
   $aAxes = array();
   $aAxes[] = array('orient' => 'bottom', 'scale' => 'xscale'); // { 'orient': 'bottom', 'scale': 'xscale' },
   $aAxes[] = array('orient' => 'left'  , 'scale' => 'yscale'); // { 'orient': 'left', 'scale': 'yscale' }
   
   $aGrafBarras['axes'] = $aAxes;
   // Fim Axes

   // Inicio Marks
   $aMarks1 = array();
   // Inicio 1
   $aMarks1['type'] = 'rect'; // 'type': 'rect',
   $aMarks1['from'] = array('data' => 'table'); // {'data':'table'},

   $aEncode1 = array();
   $aEncode1['enter']['x']     = array('scale' => 'xscale', 'field' => 'category'); // 'scale': 'xscale', 'field': 'category'
   $aEncode1['enter']['width'] = array('scale' => 'xscale', 'band'  =>  1); // 'width': {'scale': 'xscale', 'band': 1},
   $aEncode1['enter']['y']     = array('scale' => 'yscale', 'field' =>  'amount'); // 'y': {'scale': 'yscale', 'field': 'amount'},
   $aEncode1['enter']['y2']    = array('scale' => 'yscale', 'value' =>  0); // 'y2': {'scale': 'yscale', 'value': 0}

   $aEncode1['update']['fill']  = array('value' => 'steelblue'); // 'fill': {'value': 'steelblue'}
   $aEncode1['hover']['fill']  = array('value' => 'red'); // 'fill': {'value': 'red'}

   $aMarks1['encode'] = $aEncode1;
   // Fim 1

   // Inicio 2
   $aMarks2 = array();
   $aMarks2['type'] = 'text'; // 'type': 'text',

   $aEncode2 = array();
   $aEncode2['enter']['align']    = array('value' => 'center'); // 'align': {'value': 'center'},
   $aEncode2['enter']['baseline'] = array('value' => 'bottom'); // 'baseline': {'value': 'bottom'},
   $aEncode2['enter']['fill']     = array('value' => '#333');   // 'fill': {'value': '#333'}

   $aEncode2['update']['x']     = array('scale' => 'xscale', 'signal' => 'tooltip.category', 'band' => 0.5); // 'x': {'scale': 'xscale', 'signal': 'tooltip.category', 'band': 0.5},
   $aEncode2['update']['y']     = array('scale' => 'yscale', 'signal' => 'tooltip.amount', 'offset' => -2); // 'y': {'scale': 'yscale', 'signal': 'tooltip.amount', 'offset': -2},
   $aEncode2['update']['text']  = array('signal' => 'tooltip.amount'); // 'text': {'signal': 'tooltip.amount'},
   $aEncode2['update']['fillOpacity'][] = array('test' => 'isNaN(tooltip.amount)', 'value' => 0); // {'test': 'isNaN(tooltip.amount)', 'value': 0},
   $aEncode2['update']['fillOpacity'][] = array('value'=> 1); // {'value': 1}

   $aMarks2['encode'] = $aEncode2;
   // Fim 2

   $aGrafBarras['marks'] = array($aMarks1,$aMarks2);
   // Fim Marks

   // Pesquisar mais sobre actions
   //actions: {
   // export: ...,
   // source: ...,
   // compiled: ...,
   // editor: ...
   //},

   $json_sRetJson = json_encode($aGrafBarras,JSON_PRETTY_PRINT);
   fpc_append($sEcoTxt,$json_sRetJson);

   $sFile_Json_Barras = './Graf_Json/Barras_'.strtotime('now').'.json';
   fpc($sFile_Json_Barras,$json_sRetJson);

   //echo $json_sRetJson;
   // FIM Grfico Barras

   // Grfico DonutPizza
   $aGrafDonutPizza = array();
   $aGrafDonutPizza['$schema']  = 'https://vega.github.io/schema/vega/v5.json'; // "$schema": "https://vega.github.io/schema/vega/v5.json",
   $aGrafBarras['description']  = utf8_encode('Grfico Donut/Pizza'); // "description": "A basic donut chart example.",
   $aGrafDonutPizza['width']    = 200; // "width": 400,
   $aGrafDonutPizza['height']   = 200; // "height": 200,
   $aGrafDonutPizza['autosize'] = 'none'; // "autosize": "none",
   
   // Inicio Signals
   $aSignals = array();
   $aSignals[0]['name'] = 'startAngle'; // 'name': 'startAngle', 
   $aSignals[0]['value'] = 0; // 'name': 'startAngle', 'value': 0,
   $aSignals[0]['bind'] = array('input' => 'range', 'min' => -6.29, 'max' => 6.29, 'step' => 0.01); // 'bind': {'input': 'range', 'min': 0, 'max': 6.29, 'step': 0.01}

   $aSignals[1]['name'] = 'endAngle'; // 'name': 'endAngle',
   $aSignals[1]['value'] = 6.29; // 'value': 6.29,
   $aSignals[1]['bind'] = array('input' => 'range', 'min' => -6.29, 'max' => 6.29, 'step' => 0.01); // 'bind': {'input': 'range', 'min': 0, 'max': 6.29, 'step': 0.01}

   $aSignals[2]['name'] = 'padAngle'; // 'name': 'padAngle'
   $aSignals[2]['value'] = 0; //  'value': 0,
   $aSignals[2]['bind'] = array('input' => 'range', 'min' => 0, 'max' => 0.1); // 'bind': {'input': 'range', 'min': 0, 'max': 0.1}

   $aSignals[3]['name'] = 'innerRadius'; // 'name': 'innerRadius'
   $aSignals[3]['value'] = 60; //  'value': 60,
   $aSignals[3]['bind'] = array('input' => 'range', 'min' => 0, 'max' => 90, 'step' => 1); // 'bind': {'input': 'range', 'min': 0, 'max': 90, 'step': 1}

   $aSignals[4]['name'] = 'cornerRadius'; // 'name': 'cornerRadius'
   $aSignals[4]['value'] = 0; //  'value': 0,
   $aSignals[4]['bind'] = array('input' => 'range', 'min' => 0, 'max' => 10, 'step' => 0.5); // 'bind': {'input': 'range', 'min': 0, 'max': 10, 'step': 0.5}

   $aSignals[5]['name'] = 'sort'; // 'name': 'sort'
   $aSignals[5]['value'] = false; //  'value': false,
   $aSignals[5]['bind'] = array('input' => 'checkbox'); // 'bind': {'input': 'range', 'min': 0, 'max': 10, 'step': 0.5}

   $aGrafDonutPizza['signals'] = $aSignals;
   // Fim Signals

   //Inicio data
   $aData = array();
   $aData['name'] = 'table'; // 'name': 'table'

   $aValues = array();
   $aValues[] = array('id' => 1, 'field' => 4); // {'id': 1, 'field': 4},
   $aValues[] = array('id' => 2, 'field' => 6); // {'id': 2, 'field': 6},
   $aValues[] = array('id' => 3, 'field' => 10); // {'id': 3, 'field': 10},
   $aValues[] = array('id' => 4, 'field' => 3); // {'id': 4, 'field': 3},
   $aValues[] = array('id' => 5, 'field' => 7); // {'id': 5, 'field': 7}
   $aValues[] = array('id' => 6, 'field' => 8); // {'id': 6, 'field': 8}

   $aData['values'] = $aValues; // 'values': [

   $aTransform = array();
   $aTransform['type']       = 'pie'; // 'type': 'pie',
   $aTransform['field']      = 'field'; // 'field': 'field',
   $aTransform['startAngle'] = array('signal' => 'startAngle');; // 'startAngle': {'signal': 'startAngle'},
   $aTransform['endAngle']   = array('signal' => 'endAngle'); // 'endAngle': {'signal': 'endAngle'},
   $aTransform['sort']       = array('signal' => 'sort'); // 'sort': {'signal': 'sort'}

   $aData['transform'][] = $aTransform; // 'transform': [

   $aGrafDonutPizza['data'][] = $aData; // 'data': [
   //Fim data

   //Inicio scales
   $aScales = array();
   $aScales['name'] = 'color'; // 'name': 'color',
   $aScales['type'] = 'ordinal'; // 'type': 'ordinal',
   $aScales['domain'] = array('data' => 'table', 'field' => 'id'); // 'domain': {'data': 'table', 'field': 'id'},
   $aScales['range'] = array('scheme' => 'category20'); // 'range': {'scheme': 'category20'}

   $aGrafDonutPizza['scales'][] = $aScales; // 'scales': [
   //Fim scales

   //Inicio marks
   $aMarks = array();
   $aMarks['type'] = 'arc'; // 'type': 'arc',
   $aMarks['from'] = array('data' => 'table'); // 'from': {'data': 'table'},

   $aEncode = array();
   $aEncode['enter']['fill'] = array('scale' => 'color', 'field' => 'id'); // 'fill': {'scale': 'color', 'field': 'id'},
   $aEncode['enter']['x'] = array('signal' => 'width / 2'); // 'x': {'signal': 'width / 2'},
   $aEncode['enter']['y'] = array('signal' => 'height / 2'); // 'y': {'signal': 'height / 2'}



//   $aUpdate = array();
   $aEncode['update']['startAngle'] = array('field' => 'startAngle'); // 'startAngle': {'field': 'startAngle'},
   $aEncode['update']['endAngle'] = array('field' => 'endAngle'); // 'endAngle': {'field': 'endAngle'},
   $aEncode['update']['padAngle'] = array('signal' => 'padAngle'); // 'padAngle': {'signal': 'padAngle'},
   $aEncode['update']['innerRadius'] = array('signal' => 'innerRadius'); // 'innerRadius': {'signal': 'innerRadius'},
   $aEncode['update']['outerRadius'] = array('signal' => 'width / 2'); // 'outerRadius': {'signal': 'width / 2'},
   $aEncode['update']['cornerRadius'] = array('signal' => 'cornerRadius'); // 'cornerRadius': {'signal': 'cornerRadius'}

//   $aMarks['update'] = $aUpdate; //      'update': 

   $aMarks['encode'] = $aEncode; // 'encode': 

   $aGrafDonutPizza['marks'][] = $aMarks; // 'marks': [
   //Fim marks

   $json_sRetJson = json_encode($aGrafDonutPizza,JSON_PRETTY_PRINT);
   fpc_append($sEcoTxt,$json_sRetJson);

   $sFile_Json_DonutPizza = './Graf_Json/DonutPizza_'.strtotime('now').'.json';
   fpc($sFile_Json_DonutPizza,$json_sRetJson);
//   $sFile_Json_DonutPizza = './Graf_Json/DonutPizza_1621888995.json';

   // echo $json_sRetJson;
   // FIM Grfico DonutPizza

   // Grfico BarrasStacked
   $aGrafBarrasStacked = array();
   $aGrafBarrasStacked['$schema'] = 'https://vega.github.io/schema/vega/v5.json'; // "$schema": "https://vega.github.io/schema/vega/v5.json",
   $aGrafBarrasStacked['description'] = utf8_encode('Grfico barras stacked'); // "description": "A basic donut chart example.",
   $aGrafBarrasStacked['width']   = 400; // "width": 400,
   $aGrafBarrasStacked['height']  = 200; // "height": 200,
   $aGrafBarrasStacked['padding'] = 5;   // "padding": 5,

   // Incio data
   $aData = array();
   $aData['name'] = 'table'; // "name": "table",
   
   $aValues = array();
   $aValues[] = array('x' => 0, 'y' => 28, 'c' => 0);
   $aValues[] = array('x' => 0, 'y' => 55, 'c' => 1);
   $aValues[] = array('x' => 1, 'y' => 43, 'c' => 0);
   $aValues[] = array('x' => 1, 'y' => 91, 'c' => 1);
   $aValues[] = array('x' => 2, 'y' => 81, 'c' => 0);
   $aValues[] = array('x' => 2, 'y' => 53, 'c' => 1);
   $aValues[] = array('x' => 3, 'y' => 19, 'c' => 0);
   $aValues[] = array('x' => 3, 'y' => 87, 'c' => 1);
   $aValues[] = array('x' => 4, 'y' => 52, 'c' => 0);
   $aValues[] = array('x' => 4, 'y' => 48, 'c' => 1);
   $aValues[] = array('x' => 5, 'y' => 24, 'c' => 0);
   $aValues[] = array('x' => 5, 'y' => 49, 'c' => 1);
   $aValues[] = array('x' => 6, 'y' => 87, 'c' => 0);
   $aValues[] = array('x' => 6, 'y' => 66, 'c' => 1);
   $aValues[] = array('x' => 7, 'y' => 17, 'c' => 0);
   $aValues[] = array('x' => 7, 'y' => 27, 'c' => 1);
   $aValues[] = array('x' => 8, 'y' => 68, 'c' => 0);
   $aValues[] = array('x' => 8, 'y' => 16, 'c' => 1);
   $aValues[] = array('x' => 9, 'y' => 49, 'c' => 0);
   $aValues[] = array('x' => 9, 'y' => 15, 'c' => 1);

   $aData['values'] = $aValues; // "values": [

   $aTransform = array();
   $aTransform['type'] = 'stack';   
   $aTransform['groupby'][] = "x";   
   $aTransform['sort'] = array('field' => 'c');   
   $aTransform['field'] = 'y';   

   $aData['transform'][] = $aTransform;

   $aGrafBarrasStacked['data'][] = $aData; // "data": [
   // Fim data

   // Inicio Scales
   $aScales = array();
   $aScales[0]['name']    = 'x'; // "name": "x",
   $aScales[0]['type']    = 'band';   // "type": "band",
   $aScales[0]['range']   = 'width'; // "range": "width",
   $aScales[0]['domain']  = array('data' => 'table', 'field' => 'x'); // "domain": {"data": "table", "field": "x"},

   $aScales[1]['name']    = 'y'; // "name": "y",
   $aScales[1]['range']   = 'height'; // "range": "height"
   $aScales[1]['nice']    = true; // "nice": true,
   $aScales[1]['zero']    = true; // "zero": true,
   $aScales[1]['domain']  = array('data' => 'table', 'field' => 'y1'); // "domain": {"data": "table", "field": "y1"}

   $aScales[2]['name']    = 'color'; // "name": "color",
   $aScales[2]['type']    = 'ordinal'; // "type": "ordinal",
   $aScales[2]['range']   = 'category'; // "range": "category"
   $aScales[2]['domain']  = array('data' => 'table', 'field' => 'c'); // "domain": {"data": "table", "field": "amount"},

   $aGrafBarrasStacked['scales'] = $aScales;
   // Fim Scales

   // Inicio Axes
   $aAxes = array();
   $aAxes[] = array('orient' => 'bottom', 'scale' => 'x', 'zindex' => 1); // {"orient": "bottom", "scale": "x", "zindex": 1},
   $aAxes[] = array('orient' => 'left'  , 'scale' => 'y', 'zindex' => 1); // {"orient": "left", "scale": "y", "zindex": 1}
   
   $aGrafBarrasStacked['axes'] = $aAxes;
   // Fim Axes

   // Inicio Marks
   $aMarks = array();
   // Inicio 1
   $aMarks['type'] = 'rect'; // 'type': 'rect',
   $aMarks['from'] = array('data' => 'table'); // {'data':'table'},

   $aEncode = array();
   $aEncode['enter']['x']     = array('scale' => 'x', 'field' => 'x'); // "x": {"scale": "x", "field": "x"},
   $aEncode['enter']['width'] = array('scale' => 'x', 'band'  =>  1, 'offset' => -1); // "width": {"scale": "x", "band": 1, "offset": -1},
   $aEncode['enter']['y']     = array('scale' => 'y', 'field' =>  'y0'); // "y": {"scale": "y", "field": "y0"},
   $aEncode['enter']['y2']    = array('scale' => 'y', 'field' =>  'y1'); // "y2": {"scale": "y", "field": "y1"},
   $aEncode['enter']['fill']  = array('scale' => 'color', 'field' => 'c'); // "fill": {"scale": "color", "field": "c"}

   $aEncode['update']['fillOpacity'] = array('value' => 1); // "fillOpacity": {"value": 1}
   $aEncode['hover']['fillOpacity']  = array('value' => 0.5); // "fillOpacity": {"value": 0.5}

   $aMarks['encode'] = $aEncode;
   // Fim 1

   // Inicio 2
   $aMarks2 = array();
   $aMarks2['type'] = 'text'; // 'type': 'text',

   $aEncode2 = array();
   $aEncode2['enter']['align']    = array('value' => 'center'); // 'align': {'value': 'center'},
   $aEncode2['enter']['baseline'] = array('value' => 'bottom'); // 'baseline': {'value': 'bottom'},
   $aEncode2['enter']['fill']     = array('value' => '#333');   // 'fill': {'value': '#333'}

   $aEncode2['update']['x']     = array('scale' => 'xscale', 'signal' => 'tooltip.category', 'band' => 0.5); // 'x': {'scale': 'xscale', 'signal': 'tooltip.category', 'band': 0.5},
   $aEncode2['update']['y']     = array('scale' => 'yscale', 'signal' => 'tooltip.amount', 'offset' => -2); // 'y': {'scale': 'yscale', 'signal': 'tooltip.amount', 'offset': -2},
   $aEncode2['update']['text']  = array('signal' => 'tooltip.amount'); // 'text': {'signal': 'tooltip.amount'},
   $aEncode2['update']['fillOpacity'][] = array('test' => 'isNaN(tooltip.amount)', 'value' => 0); // {'test': 'isNaN(tooltip.amount)', 'value': 0},
   $aEncode2['update']['fillOpacity'][] = array('value'=> 1); // {'value': 1}

   $aMarks2['encode'] = $aEncode2;
   // Fim 2

   $aGrafBarrasStacked['marks'] = $aMarks;
   // Fim Marks


   // Pesquisar mais sobre actions
   //actions: {
   // export: ...,
   // source: ...,
   // compiled: ...,
   // editor: ...
   //},

   $json_sRetJson = json_encode($aGrafBarrasStacked,JSON_PRETTY_PRINT);
   fpc_append($sEcoTxt,$json_sRetJson);

   $sFile_Json_BarrasStacked = './Graf_Json/BarrasStacked_'.strtotime('now').'.json';
   fpc($sFile_Json_BarrasStacked,$json_sRetJson);

   //echo $json_sRetJson;
   //FIM Grfico BarrasStacked

   echo "
<!DOCTYPE html>
<head>
   <meta charset='utf-8'>
   <script src='https://cdn.jsdelivr.net/npm/vega@5'></script>
   <script src='https://cdn.jsdelivr.net/npm/vega-embed@5'></script>
   <style>
      .container {
         display: flex;
         flex-wrap: wrap;
      }

      .box {
         flex: 0 50%;
         box-sizing:border-box;    
      }

      tbody tr:nth-child(odd) {
         background-color: #ccc;
      }

   </style>
</head>

<body> 
   <div class='container'> 
      <div class='box' id='barras'></div>
      <div class='box' id='donutpizza'></div>
      <div class='box' id='barrasstacked'></div>
      <div class='box' id='divreptable'>
         <table id='reptable'>
               <tr style='background-color: #333;'><td>Posio</td><td>Prximo cliente a inativar</td><td>Data</td></tr>
            <tr>
               <td>1</td>
               <td>CLIENTE 1</td>
               <td>28/06/2021</td>
            </tr>
            <tr>
               <td>2</td>
               <td>CLIENTE 2</td>
               <td>28/07/2021</td>
            </tr>
            <tr> 
               <td>3</td>
               <td>CLIENTE 3</td>
               <td>28/08/2021</td>
            </tr>
            <tr>
               <td>4</td>
               <td>CLIENTE 4</td>
               <td>28/08/2021</td>
            </tr>
         </table>
      </div>
   </div>

   <script>
      const spec1 = '$sFile_Json_Barras';
      vegaEmbed('#barras', spec1)
      // result.view provides access to the Vega View API
      .then(result => console.log(result))
      .catch(console.warn);

      const spec2 = '$sFile_Json_DonutPizza';
      vegaEmbed('#donutpizza', spec2)
      // result.view provides access to the Vega View API
      .then(result => console.log(result))
      .catch(console.warn);

      const spec3 = '$sFile_Json_BarrasStacked';
      vegaEmbed('#barrasstacked', spec3)
      // result.view provides access to the Vega View API
      .then(result => console.log(result))
      .catch(console.warn);

  </script>

</body>";

/*
   $sSql  = "select extract(day from tInc),count(*)
               from NFCapa
              where iVer = iVAt and lExc = 0
                and cast(tInc as date) >= '2020-07-01' and cast(tInc as date) <= '2020-07-31'
                and jIde_tpNF = 1
              group by extract(day from tInc)
              order by extract(day from tInc) asc";
   fpc_append($sEcoTxt,"sSql=$sSql");
   $aDb  = faDbSelect($hDb,$sSql);

   $sHML = "<!DOCTYPE html>
            <html lang='pt-br'>
               <head>
                  <script src='https://cdn.jsdelivr.net/npm/chart.js@2.9.3'></script>
                  <style type='text/css'>
                     body {
                        width: 1000PX;
                     }
                  
                     #chart-container {
                        width: 100%;
                        height: auto;
                     }
                  </style>
               </head>
               <body>
               <canvas id='myChart'></canvas>";

   $aData = array();
   $aQtd  = array();
   foreach ($aDb as $aLin) {
      $tInc = $aLin[0];
      $iQtd = $aLin[1];
      $aDate[] = $tInc;
      $aQtd[]  = $iQtd;
      //$aData[] = array($tInc,$iQtd);
      //$aData[] = array('tInc' => $tInc, 'iQtd' => $iQtd);

   } // foreach ($aDb as $aLin)

   //echo json_encode($aData);


   $sHML .= "<script>
                var ctx = document.getElementById('myChart').getContext('2d');
                var chart = new Chart(ctx, {
                    // The type of chart we want to create
                    type: 'line',

                    // The data for our dataset
                    data: {
                        labels: [".implode(',',$aDate)."],
                        datasets: [{
                            label: 'Qtd Notas Emitidas',
                            backgroundColor: 'rgb(0, 0, 255)',
                            borderColor: 'rgb(255, 0, 0)',
                            data: [".implode(',',$aQtd)."]
                        }]
                    },
                
                    // Configuration options go here
                    options: {}
                });
             </script>";
   $sHML .= "   </body>
             </html>";   

   echo $sHML;
*/

   flDbDisconnect($hDb);

} else {
   flPutInto_aUserLog('O arquivo de configuraes ($sFileConfig) no foi encontrado.');
   fpc_append($sEcoTxt,'O arquivo de configuraes ($sFileConfig) no foi encontrado.');
}

list($iUsec, $iSec) = explode(' ', microtime());
$tScript_End = (float) $iSec + (float) $iUsec;

$tElapsed_Time = round($tScript_End - $tScript_Start, 5);
fpc_append($sEcoTxt,"Tempo Decorrido: ".gmdate("H:i:s", $tElapsed_Time).', Secs: '.$tElapsed_Time.". Memoria usada: ".round(((memory_get_peak_usage(true) / 1024) / 1024), 2)."Mb");
