<?php
set_time_limit(300);
require_once("../pFuncoes1.php");
require_once("../pPublics1.php");

list($iUsec, $iSec) = explode(' ', microtime());
$tScript_Start = (float) $iSec + (float) $iUsec;

$aTop      = faLoadAvgServer();
$nTopIni   = $aTop[0];
$tJobStart = time();
$sProc     = basename(__FILE__);

$sEcoNome  = str_replace('.','_',$sProc).'-'.$tJobStart.'.log';
$sEcoTxt = "/qtux/www/FullPlat/processos/logs/$sEcoNome";
$sEcoTxt = fsDirEcoTxt($sEcoTxt);

$iProcID = getmypid();

fpc($sEcoTxt,'iProcID='.$iProcID);
fpc_append($sEcoTxt,'Incio em ' . date('d/m/Y H:i:s',$tJobStart));

$psCliPasta  = 'desenvolvimento';
fpc_append($sEcoTxt,"psCliPasta=$psCliPasta");

$lLigaQry = true;
$aUserLog = array();

$sFileConfig = "../../$psCliPasta/dd_files/Business.ddini";
fpc_append($sEcoTxt,'Cliente: '.$psCliPasta);
fpc_append($sEcoTxt,"Arquivo ddini ($sFileConfig)");

if (file_exists($sFileConfig)) {

   $sTxt = fsTXTFiltrar($sFileConfig);
   $aArr = explode(chr(10),$sTxt);

   $sVarsTxt = '';
   foreach ($aArr as $sLin) {
      $aLin = explode('//',$sLin);
      $sLin = trim($aLin[0]);
      $iLensLin = strlen($sLin);
      if ($iLensLin>0) {
         $aLin = explode('=',$sLin);
         $s1 = trim($aLin[0]);
         $iCountaLin = count($aLin);
         if ($iCountaLin>1) $s2 = trim($aLin[1]);
         else               $s2 = '';
         $s  = '$'.$s1." = '".$s2."';";
         eval($s);   // criando uma var
         $sVarsTxt .= $s . chr(10);
      }
   }

   $iOk       = 1;
   $lOk       = true;
   $sDSN      = "$sHost:$sPathDB/$sDB";
   $sPathFS   = $sPathFileSys;

   $hDb     = fhDbConnect($sDSN);

   $sSql  = "select extract(day from tInc),count(*)
               from NFCapa
              where iVer = iVAt and lExc = 0
                and cast(tInc as date) >= '2020-07-01' and cast(tInc as date) <= '2020-07-31'
                and jIde_tpNF = 1
              group by extract(day from tInc)
              order by extract(day from tInc) asc";
   fpc_append($sEcoTxt,"sSql=$sSql");
   $aDb  = faDbSelect($hDb,$sSql);

   $sHML = "<!DOCTYPE html>
            <html lang='pt-br'>
               <head>
                  <script src='https://cdn.jsdelivr.net/npm/chart.js@2.9.3'></script>
                  <style type='text/css'>
                     body {
                        width: 1000PX;
                     }
                  
                     #chart-container {
                        width: 100%;
                        height: auto;
                     }
                  </style>
               </head>
               <body>
               <canvas id='myChart'></canvas>";

   $aData = array();
   $aQtd  = array();
   foreach ($aDb as $aLin) {
      $tInc = $aLin[0];
      $iQtd = $aLin[1];
      $aDate[] = $tInc;
      $aQtd[]  = $iQtd;
      //$aData[] = array($tInc,$iQtd);
      //$aData[] = array('tInc' => $tInc, 'iQtd' => $iQtd);

   } // foreach ($aDb as $aLin)

   //echo json_encode($aData);


   $sHML .= "<script>
                var ctx = document.getElementById('myChart').getContext('2d');
                var chart = new Chart(ctx, {
                    // The type of chart we want to create
                    type: 'line',

                    // The data for our dataset
                    data: {
                        labels: [".implode(',',$aDate)."],
                        datasets: [{
                            label: 'Qtd Notas Emitidas',
                            backgroundColor: 'rgb(0, 0, 255)',
                            borderColor: 'rgb(255, 0, 0)',
                            data: [".implode(',',$aQtd)."]
                        }]
                    },
                
                    // Configuration options go here
                    options: {}
                });
             </script>";
   $sHML .= "   </body>
             </html>";   

   echo $sHML;

   flDbDisconnect($hDb);

} else {
   flPutInto_aUserLog('O arquivo de configuraes ($sFileConfig) no foi encontrado.');
   fpc_append($sEcoTxt,'O arquivo de configuraes ($sFileConfig) no foi encontrado.');
}

list($iUsec, $iSec) = explode(' ', microtime());
$tScript_End = (float) $iSec + (float) $iUsec;

$tElapsed_Time = round($tScript_End - $tScript_Start, 5);
fpc_append($sEcoTxt,"Tempo Decorrido: ".gmdate("H:i:s", $tElapsed_Time).', Secs: '.$tElapsed_Time.". Memoria usada: ".round(((memory_get_peak_usage(true) / 1024) / 1024), 2)."Mb");
