<?php
set_time_limit(300);
require_once("../pFuncoes1.php");
require_once("../pPublics1.php");	

$sHOST = exec('hostname');
if ($sHOST == 'qtuxap.sanol.com.br') {
   $psCliPasta = 'total';
   $sDSN   = '192.168.1.109:/qtux/database/total/gps_01.gdb';
} else if ($sHOST=='homologqtuxweb.sanol.com.br') {
   $psCliPasta = 'total';
   $sDSN   = 'localhost:/qtux/database/total/gps_01.gdb';
} else {
   $psCliPasta = 'desenvolvimento';
   $sDSN   = 'localhost:/qtux/database/tq/gps_01.gdb';
}

$hDb = fhDbConnect($sDSN);

$sSql = "select b.sCodigo,
                b.sDescricao,
                e.sSigla     sCIA,
                d.sUnidade

         from EST_RegDepositos  a,
              Itens             b,
              CUP               e,
              EST_Instancias    c,
              UnidadeMedida     d
         where  a.lExc  = 0      and a.iVer = a.iVAt
           and  a.pItem = b.pPId and b.iVer = b.iVAt
           and  a.pIns  = c.pPId and c.iVer = c.iVAt
           and  a.pUni  = d.pPId and d.iVer = d.iVAt
           and  b.pUNeg = e.pPId and e.iVer = e.iVAt
           and  a.pDep  = 21
           and  c.pPId  = 1
           and  a.pUni <> 1
         order by b.sCodigo,b.sDescricao,e.sSigla";

$aDb = faDbSelect($hDb,$sSql);
$iCountDB = count($aDb);
fpc_append($sEcoTxt,"sSqlA=$sSql");

if ($iCountDB>0) {
   require('/qtux/library/PHPExcel-1.8/Classes/PHPExcel.php');
   $oPHPExcel = new PHPExcel();

   $oPHPExcel -> setActiveSheetIndex(0)
              -> setCellValue('A1','CODIGO')
              -> setCellValue('B1','DESCRICAO')
              -> setCellValue('C1','CIA')
              -> setCellValue('D1','UNIDADE');

   $oPHPExcel -> getActiveSheet() -> getStyle('A1:D1') -> getFont() -> setBold(true);

   $oPHPExcel -> getActiveSheet() -> getColumnDimension('A')->setAutoSize(true);
   $oPHPExcel -> getActiveSheet() -> getColumnDimension('B')->setAutoSize(true);
   $oPHPExcel -> getActiveSheet() -> getColumnDimension('C')->setAutoSize(true);
   $oPHPExcel -> getActiveSheet() -> getColumnDimension('D')->setAutoSize(true);

   $i = 1;
   $iNrNotaTmp = 0;
   foreach ($aDb as $aLin) {
      ++$i;
      $sCodigo    = utf8_encode(trim(fsTiraAcento($aLin[0])));
      $sDescricao = utf8_encode(trim(fsTiraAcento($aLin[1])));
      $sCIA       = utf8_encode(trim(fsTiraAcento($aLin[2])));
      $sUnidade   = utf8_encode(trim(fsTiraAcento($aLin[3])));

      $oPHPExcel -> getActiveSheet() -> setCellValue('A'.$i, $sCodigo    );
      $oPHPExcel -> getActiveSheet() -> setCellValue('B'.$i, $sDescricao );
      $oPHPExcel -> getActiveSheet() -> setCellValue('C'.$i, $sCIA       );
      $oPHPExcel -> getActiveSheet() -> setCellValue('D'.$i, $sUnidade   );
   }

   $oPHPExcel -> getActiveSheet() -> setTitle('Itens');

   $sNomeArquivo = 'Listagem_Itens_'.time().'.xls';

   header('Content-Type: application/vnd.ms-excel');
   header("Content-Disposition: attachment; filename=\"{$sNomeArquivo}\"");
   header('Cache-Control: max-age=0');
   header('Cache-Control: max-age=1');

   $oWriter = PHPExcel_IOFactory::createWriter($oPHPExcel, 'Excel5');
   $oWriter -> save('php://output');

}

flDbDisconnect($hDb);