<?php
/*
Itens da CDI que esto na TQ a mais de 180 dias
Modelo em C:\d_doispontos\Qtux\EST_180Dias.xlsx

Insumo '13500' - Lote 002 - pLote						
			
Saldo Atual = Soma Disponveis dos Deps de RFisico e ConsumoOP						
200						
			
			
data	saldo_i(*)	entrada	 da TQ	 da CDI	saldo_f(*)	
hj	       200     	0                 			200	
ontem	    200	     10       	10		            190	
3	       190	     20                 20	      170	
4	       170	     50        50	             	120	
5	       120	     50        10    	40	       70	
6	       70	     10                 10	       60	esse saldo est a mais de '180' dias
---------------------------------------------------
7	       60	     20                 20	       40	
8	       40	     20       	20	                20	
9	       20	     30                	30     	-10	
10	      -10	     50        50	             	-60	




EST_REGDEPOSITOS_IDX01 INDEX ON EST_REGDEPOSITOS(PITEM, PDEP)
EST_REGDEPOSITOS_IDX02 INDEX ON EST_REGDEPOSITOS(PDEP, PITEM)

EST_MOVSALDOS_J180 INDEX ON EST_MOVSALDOS(J180)
EST_MOVSALDOS_PREGDEPTINC INDEX ON EST_MOVSALDOS(PREGDEP, TINC)
EST_MOVSALDOS_TIN0C INDEX ON EST_MOVSALDOS COMPUTED BY (cast(tIn0 as date))

Obs pra devolver 
-Tem que ser da CDI - j180=1
-Tem ques estar a mais de 180 dias na TQ, o que significa pelo menos 1 entrada da CDI ocorrida a mais de 180 dias (*)
-Tem que ter saldo disponvel no momento de rodar o processo

Inicialmente no h entrada alguma da CDI
Esse processo vai rodar diariamente (frequentemente), isso significa que entradas que ocorreram a mais de 180+x dias no influenciaro em nada a qtd a retornar hj.
Portanto posso limitar a busca por entradas da CDI ocorrida a mais de 180 dias (*) no perodo entre 180 e 180+x dias atrs. 
Resumindo, apenas as entradas que ocorreram entre 180 e 180+x dias atrs que so consideradas na rodada atual do processo.

--//--

Itens com mais de 180 dias devem voltar.
Com essa afirmao posso deduzir 2 coisas.

1o concluso - Os itens/lotes q devem voltar tem q possuir saldo>0 no inicio da rodada do processo. 
               Se o item no tem saldo atual, ou seja saldo=0, nem adianta procurar se estourou ou no 180 dias, pq no h saldo alguma pra devolver, qq coisa q aconteceu j foi consumido
2a concluso -  obrigatrio que esse item/lote tenha pelo menos 1 entrada da CDI a mais de 180 dias. 
               Se isso no existir, ento  bvio que nada no estourou 180 dias, pois no h entradas com + de 180 dias.
               where EST_MovSaldos(tDataAtual-tDataLcmto)>180

Sabendo a ultima vez q o processo rodou - Itens_180Capa->max(tIn0) - (iDiasDesdeUaVez = qtos dias atrs) posso deduzir.
3a concluso - Entradas a mais de (180 + iDiasDesdeUaVez) dias atrs no precisam ser considerados.
               Pois essas entradas obrigatoriamente foram consideradas na ltima rodada do processo.
               Nesse momento 2 coisas podem ter acontecido.
               Ou no tinha nada a retornar e essas entradas j foram consumidas
               Ou tinha algora pra retornar e essas entradas j forma 'atualizadas'
               iDUVez = Qtos dias desde a ltima vez q o processo rodou
               where (tDataAtual-tDataLcmto)>   180 
                 and (tDataAtual-tDataLcmto)<=180+iDiasDesdeUaVez



             
               select b.pItem,
                      a.pLote

               from EST_MovSaldos a join EST_RegDepositos b on a.pRegDep = b.pPId and b.iVer=b.iVAt
               where a.iVer=a.iVAt
                 and a.lExc=0
                 and a.j180=1
                 and a.jLcmto=1                                                 --  rec fsico, j180=1 j implica em jLcmto=1
                 and cast(a.tIn0 as date) <  (cast('now' as date)-180)          -- lcmto que ocorreram a mais de 180 dias
                 and cast(a.tIn0 as date) >= (cast('now' as date)-(180+iDUVez)) -- lcmto que ocorreram a mais de 180 dias e a menos de 180+DiasDesdeUaRodadaDoProcesso
               group by b.pItem,
                        a.pLote



*/

/*
Uma forma de saber qual o ambiente
$sHOST = exec('hostname');
if ( ($sHOST == 'qtuxap.sanol.com.br') || ($sHOST=='homologqtuxweb.sanol.com.br') ) {
   $_GET["sCliPasta"]   = 'total';
} else {
   $_GET["sCliPasta"]   = 'desenvolvimento';
}
*/

set_time_limit(300);
require_once("../pPublics1.php");
require_once("../pFuncoes1.php");

flStartPHP();

$aTop      = faLoadAvgServer();
$nTopIni   = $aTop[0];
$tJobStart = time();
$sProc     = basename(__FILE__);

$lE_Dev    = true;   // Ateno ao ambiente
$lCron     = ((isset($_GET["sId"])==false) && (isset($_POST["sId"])==false));

if ($lCron==true) {
   $_GET["sCliPasta"] = $lE_Dev ? 'desenvolvimento' : 'total';
   $_GET["sId"]       = 0;
   $_GET["iSysPOP"]   = 0;
   $_GET["sDDSFile"]  = '';
   $_GET["sDDSTag"]   = '';
   $_GET["sRoot"]     = 1;
   $_GET["sLogin"]    = 1;

   $_POST["sCliPasta"] = $lE_Dev ? 'desenvolvimento' : 'total';
   $_POST["sId"]       = 0;
   $_POST["iSysPOP"]   = 0;
   $_POST["sDDSFile"]  = '';
   $_POST["sDDSTag"]   = '';
   $_POST["sRoot"]     = 1;
   $_POST["sLogin"]    = 1;
}


$pDoc       = $_GET["sId"];
$psCliPasta = $_GET["sCliPasta"];
//$sEcoNome   = str_replace('.','_',$sProc).'-'.$tJobStart."-$pDoc.log";
$sEcoNome   = str_replace('.','_',$sProc).'-'.$tJobStart.".log";
$sEcoTxt = "/qtux/www/FullPlat/processos/logs/$sEcoNome";
$sEcoTxt = fsDirEcoTxt($sEcoTxt);
fpc($sEcoTxt,"$sProc incio em " . date('d/m/Y H:i:s',$tJobStart));
 
if ($lCron==true) {
    //
} else {
   $piSysPOP  = $_GET["iSysPOP"]>0 ? $_GET["iSysPOP"] : $_POST["iSysPOP"];
   $psDDSFile = $_GET["iSysPOP"]>0 ? $_GET["sDDSFile"]: $_POST["sDDSFile"];
   $psDDSTag  = $_GET["iSysPOP"]>0 ? $_GET["sDDSTag"] : $_POST["sDDSTag"];
   fpc_append($sEcoTxt,"piSysPOP=$piSysPOP, psDDSFile=$psDDSFile, psDDSTag=$psDDSTag");
}
fpc_append($sEcoTxt,"pDoc=$pDoc, lCron=$lCron");

$aUserLog    = array();
$sFileConfig = "../../$psCliPasta/dd_files/Business.ddini";
$sLogItem    = '';   // converso de unidades

if (file_exists($sFileConfig)) {

   $sTxt = fsTXTFiltrar($sFileConfig);
   $aArr = explode(chr(10),$sTxt);

   $sVarsTxt = '';
   foreach ($aArr as $sLin) {
      $aLin = explode('//',$sLin);
      $sLin = trim($aLin[0]);
      $iLensLin = strlen($sLin);
      if ($iLensLin>0) {
         $aLin = explode('=',$sLin);
         $s1 = trim($aLin[0]);
         $iCountaLin = count($aLin);
         if ($iCountaLin>1) $s2 = trim($aLin[1]);
         else               $s2 = '';
         $s  = '$'.$s1." = '".$s2."';";
         eval($s);   // criando uma var
         $sVarsTxt .= $s . chr(10);
      }
   }
   //
   $sDSN      = "$sHost:$sPathDB/$sDB";
   $sPathFS   = $sPathFileSys;
   //
   $lGo       = true;
   $lOk       = true;
   $lWDb      = false;   // essa var  tratada automaticamente pelas funes/mtodos padro de escrita no banco, flDbInsert, flDbUpdate, flDbDelete, fpDbInsert fpDbUpdate, flDbExecute, fpDbExecute, flDbUpdatePing
   //
   $psRoot    = $_GET["sRoot"];
   $psLogin   = $_GET["sLogin"];


   $lConnDb   = (isset($hDb)==false);
   fpc_append($sEcoTxt,"lConnDb=$lConnDb");
   if ($lConnDb==true) $hDb = fhDbConnect($sDSN);
   //

   $pInsDisp  = 1;                  // Valor matado - Instncia Disponvel lRese=1 -  onde ocorre o RFisico da TQ
   $pTQ       = $aTQUNegId['TQ'];   // Valor matado
   $sTQ       = $aTQUNeg[$pTQ]; 
   $i180      = 180;       // Pode dar uma margem
   $iDUVez    = 30;        // Qtos dias desde a ltima vez q o processo rodou - procurar max(tIn0)->Itens_180Capa
   //
   $sSql   = 'select GEN_ID(EST_180DiasCapa, 0) from RDB$DATABASE';
   fpc_append($sEcoTxt,"sSql=$sSql");
   $aDb    = faDbSelect($hDb,$sSql);
   $pMax   = $aDb[0][0];
   fpc_append($sEcoTxt,"pMax=$pMax");

   // Qry Conversoes de Unidades
   $sQry = "select pItem,pUni1,pUni2,nFator,pPId,iVAt from Conversao_UnidadeMedida where iVer=iVAt and lExc=0 order by pItem desc";
   fpc_append($sEcoTxt,"sQry=$sQry");
   $aCnv = faDbSelect($hDb,$sQry);

   // Qry Unidades Medida
   $sSql = "select pPId,sCodigo from UnidadeMedida where iVer=iVAt";
   fpc_append($sEcoTxt,"sSql=$sSql");
   $aDb  = faDbSelect($hDb,$sSql);
   $aUni = array();
   foreach ($aDb as $aLin) {
      $pUni = $aLin[0];
      $sUni = $aLin[1];
      fpc_append($sEcoTxt,"pUni=$pUni, sUni=$sUni");
      $aUni[$pUni] = $sUni;
   }

/*

   // Passo (0a) - agrupando os lotes dos itens que controlam lotes e que so j180=1 (entradas da CDI) via Recebimento Fsico (entrada em pRegDepRFis) jLcmto=1
   $sSql = "select a.pLote
            from EST_MovSaldos a
            where a.iVer=a.iVAt
              and a.lExc=0
            --and a.j180=1
              and a.jLcmto=1
              and cast(a.tIn0 as date) <  (cast('now' as date)-$i180)
              and cast(a.tIn0 as date) >= (cast('now' as date)-($i180+$iDUVez))
              and a.pLote+0>0
            group by a.pLote";
   fpc_append($sEcoTxt,"sSql=$sSql");
   $aDb1 = faDbSelect1D($hDb,$sSql);
   $sInLotes = implode(',',$aDb1);

   // Passo (0b) - agrupando os itens que no controlam lotes e que so j180=1 (entradas da CDI) via Recebimento Fsico (entrada em pRegDepRFis) jLcmto=1
   $sSql = "select b.pItem
            from EST_MovSaldos a join EST_RegDepositos b on a.pRegDep = b.pPId and b.iVer=b.iVAt
            where a.iVer=a.iVAt
              and a.lExc=0
            --and a.j180=1
              and a.jLcmto=1
              and cast(a.tIn0 as date) <  (cast('now' as date)-$i180)
              and cast(a.tIn0 as date) >= (cast('now' as date)-($i180+$iDUVez))
              and a.pLote+0=0
            group by b.pItem";
   fpc_append($sEcoTxt,"sSql=$sSql");
   $aDb1 = faDbSelect1D($hDb,$sSql);
   $sInItens = implode(',',$aDb1);

   // Passo (1) - qry do SaldoAtual em todas as instncias disponveis - de todos os Itens/Lotes da TQ c.pUNeg=$pTQ and c.lComprado=1 and c.lProd=1
   // and (e.lTrans=1 or e.lRese=1) - BOM_Consumo_Calc_TQ.php
   // Essa qy  = a do processo BOM_Consumo_Calc_TQ.php
   // Checar a mesma qry em MRP.php l tem f.lMRPII=1, and b.lNoMRP=0 and b.lImprod=0, 
   // No caso dos Itens_180Dias, como no so PAs, no movimenta na instanica de Transito (e.lTrans=1 or e.lRese=1) -> e.lRese=1
   $aItm_Sdo_Ent = array();   // $aItm_Sdo_Ent[$pItem][$pLote] = array(nSdo,nEnt,pUnEst,pUnVen)
   if (true) {
      $sSql = "select c.sCodigo,
                      b.pItem,
                      a.pLote,
                      b.pUni,
                      c.pUnEst,
                      c.pUnVen,
                     (a.nSdo-a.nRes),
                      b.pPId
               from EST_LotesSaldos a  join SP_SPLIT_STRING ('$sInLotes',',') d on a.pLote   = d.iValor
                                       join EST_RegDepositos                  b on a.pRegDep = b.pPId and b.iVer=b.iVAt and (b.nSdo-b.nRes)>0 and b.pIns=$pInsDisp
                                       join Itens                             c on b.pItem   = c.pPId and c.iVer=c.iVAt and c.pUNeg=$pTQ and c.lComprado=1 and c.lProd=1 and c.lLote=1
               where  a.lExc = 0
                 and  a.iVer = a.iVAt
                 and (a.nSdo-a.nRes)>0
   
               union
   
               select c.sCodigo,
                      a.pItem,
                      0,
                      a.pUni,
                      c.pUnEst,
                      c.pUnVen,
                     (a.nSdo-a.nRes),
                      a.pPId
               from EST_RegDepositos a join SP_SPLIT_STRING ('$sInItens',',') d on a.pItem = d.iValor
                                       join Itens                             c on a.pItem = c.pPId and c.iVer=c.iVAt and c.pUNeg=$pTQ and c.lComprado=1 and c.lProd=1 and c.lLote=0
               where a.lExc = 0
                 and a.iVer = a.iVAt
                 and (a.nSdo-a.nRes)>0
                 and a.pIns=$pInsDisp
              ";
   
   
      fpc_append($sEcoTxt,"sSql=$sSql");
      $aDb  = faDbSelect($hDb,$sSql);
   
      // Loop Passo 1
      foreach ($aDb as $aLin) {
         $sItem   = $aLin[0];
         $pItem   = $aLin[1];
         $pLote   = $aLin[2];
         $pUni    = $aLin[3];
         $pUnEst  = $aLin[4];
         $pUnVen  = $aLin[5];
         $nSdo    = $aLin[6];   // em EST_RegDepositos->pUni
         $pRegDep = $aLin[7];
         fpc_append($sEcoTxt,"sItem=$sItem, pItem=$pItem, pLote=$pLote, pUni=$pUni, pUnEst=$pUnEst, pUnVen=$pUnVen, nSdo=$nSdo, pRegDep=$pRegDep");


         if (($pUni>0)&&($pUnEst>0)&&($pUnVen>0)) {
            $sUni   = $aUni[$pUni  ];
            $sUnEst = $aUni[$pUnEst];
            fpc_append($sEcoTxt,"sUni=$sUni, sUnEst=$sUnEst");
      
            $pConv  = 0;
            $fConv  = 0;
            $nFator = ($pUni==$pUnEst) ? 1 : fnConverterUnidades($pItem,$pUni,$pUnEst,$sLogItem,$pConv,$fConv);
            fpc_append($sEcoTxt,"nFator=$nFator, pConv=$pConv, fConv=$fConv");
            if (($pConv>0)||($nFator!=0)) {
               $nSdoUnEst = $nSdo*$nFator;   // em pUnEst
               if (isset($aItm_Sdo_Ent[$pItem]        )==false) $aItm_Sdo_Ent[$pItem]         = array();
               if (isset($aItm_Sdo_Ent[$pItem][$pLote])==false) $aItm_Sdo_Ent[$pItem][$pLote] = array(0,0,$pUnEst,$pUnVen);   // [nSdo,nEnt,pUnEst,pUnVen]
               $aItm_Sdo_Ent[$pItem][$pLote][0] += $nSdoUnEst;   // nSdo em pUnEst
               fpc_append($sEcoTxt,"nSdoUnEst=$nSdoUnEst, nSdo=$nSdo, nFator=$nFator");
            } else {
               flUserLog($aUserLog,"O Item $sItem/TQ est sem fator de conversao entre a unidade do depsito ($sUni) e a unidade de estoque ($sUnEst) na ficha do item.");
               $lGo=false;
            }
         } else {
            if ($pUni  ==0) flUserLog($aUserLog,"O Item $sItem/TQ est sem unidade de medida no depsito $pRegDep");
            if ($pUnEst==0) flUserLog($aUserLog,"O Item $sItem/TQ est sem unidade de medida de estoque na ficha do item");
            if ($pUnVen==0) flUserLog($aUserLog,"O Item $sItem/TQ est sem unidade de medida de venda na ficha do item");
            $lGo=false;
         }   // (($pUni>0)&&($pUnEst>0)&&($pUnVen>0))
      }   // for
   }   // true

   // Passo (2) - qry das Entradas por RFisico, tanto da TQ qto da CDI, que ocorreram a menos de 180 dias e que podem justificar total ou parcialmente o SaldoAtual
   // Esse passo depende do aItm_Sdo_Ent ter sido carregado
   $iItm_Sdo_Ent = count($aItm_Sdo_Ent);
   fpc_append($sEcoTxt,"iItm_Sdo_Ent=$iItm_Sdo_Ent");
   if ($iItm_Sdo_Ent>0) {
      $sSql = "select c.sCodigo,
                      b.pItem,
                      a.pLote,
                      a.pUniSdo,
                      c.pUnEst,
                      sum(a.nQtSdo)
               from EST_MovSaldos a join SP_SPLIT_STRING ('$sInLotes',',') f on a.pLote   = f.iValor
                                    join EST_RegDepositos                  b on a.pRegDep = b.pPId    and b.iVer=b.iVAt
                                    join Itens                             c on b.pItem   = c.pPId    and c.iVer=c.iVAt and c.pUNeg=$pTQ and c.lComprado=1 and c.lProd=1 --and c.lLote=1
                                    join EST_LotesSaldos                   d on a.pRegDep = d.pRegDep and d.iVer=d.iVAt and a.pLote=d.pLote

                where a.iVer=a.iVAt
                  and a.lExc=0
                  and cast(a.tIn0 as date) >= (cast('now' as date)-$i180)   -- Entradas que ocorreram antes de 180 dias e que vo 'justificar' o SaldoAtual
                  and a.nQtSdo>0
                  and a.jLcmto=1
                  and a.pLote+0>0
               group by c.sCodigo,
                         b.pItem,
                         a.pLote,
                         a.pUniSdo,
                         c.pUnEst
    
               union

               select c.sCodigo,
                      b.pItem,
                      0,
                      a.pUniSdo,
                      c.pUnEst,
                      sum(a.nQtSdo)
               from EST_MovSaldos a join EST_RegDepositos                  b on a.pRegDep+0 = b.pPId and b.iVer=b.iVAt
                                    join SP_SPLIT_STRING ('$sInItens',',') d on b.pItem     = d.iValor
                                    join Itens                             c on b.pItem     = c.pPId and c.iVer=c.iVAt and c.pUNeg=$pTQ and c.lComprado=1 and c.lProd=1 --and c.lLote=0

               where a.iVer=a.iVAt
                 and a.lExc=0
                 and cast(a.tIn0 as date) >= (cast('now' as date)-$i180)
                 and a.nQtSdo>0
                 and a.jLcmto=1
                 and a.pLote+0=0
               group by c.sCodigo,
                        b.pItem,
                        a.pUniSdo,
                        c.pUnEst
              ";

                
      fpc_append($sEcoTxt,"sSql=$sSql");
      $aDb  = faDbSelect($hDb,$sSql);

      // Loop Passo 2
      foreach ($aDb as $aLin) {
         $sItem  = $aLin[0];
         $pItem  = $aLin[1];
         $pLote  = $aLin[2];
         $pUni   = $aLin[3];
         $pUnEst = $aLin[4];
         $nEnt   = $aLin[5];   // em pUni
         $sUni   = $aUni[$pUni  ];
         $sUnEst = $aUni[$pUnEst];
         fpc_append($sEcoTxt,"sItem=$sItem, pItem=$pItem, pLote=$pLote, pUni=$pUni, pUnEst=$pUnEst, nEnt=$nEnt, sUni=$sUni, sUnEst=$sUnEst");

         // Se isset()==false esse item/lote no tem saldo atual, portanto nada a justificar
         if (isset($aItm_Sdo_Ent[$pItem][$pLote])==true) {

            $pConv  = 0;
            $fConv  = 0;
            $nFator = ($pUni==$pUnEst) ? 1 : fnConverterUnidades($pItem,$pUni,$pUnEst,$sLogItem,$pConv,$fConv);
            fpc_append($sEcoTxt,"nFator=$nFator, pConv=$pConv, fConv=$fConv");
            if (($pConv>0)||($nFator!=0)) {
               $nEntUnEst = $nEnt*$nFator;   // em pUnEst
               $aItm_Sdo_Ent[$pItem][$pLote][1] +=$nEntUnEst;   // em pUnEst - [nSdo,nEnt,pUnEst,pUnVen]
               fpc_append($sEcoTxt,"nEntUnEst=$nEntUnEst, nEnt=$nEnt, nFator=$nFator");
            } else {
               flUserLog($aUserLog,"O Item $sItem/TQ est sem fator de conversao entre a unidade do lanamento [$sUni] e a unidade de estoque [$sUnEst] na ficha do item.");
               $lGo=false;
            }
         }   // isset
      }   // for
   }   // iItm_Sdo_Ent>0

   // Passo (3) - descobrir os Itens/Lotes que no tem todo o seu SaldoAtual coberto pelas Entradas que ocorreram a menos de 180 dias 
   // nDif = nSdo-nEnt >0
   // Sdo desoberto, no coberto, no justificado  tudo a mesma coisa - so sinnimos no contexto desse processo
   $aItmComSdoAtualDescoberto = array();   // [pItem][pLote] = array(nSdoNJu,nQtTQ,nQtCDI,Itens->pUnEst,Itens->pUnVen,sItem),
                                           // nQtTQ=a parte do nSdoNJu que  da TQ, nQtCDI=a parte do nSdoNJu que  da CDI e portanto tem q voltar
   $aInItem = array();
   if ($iItm_Sdo_Ent>0) {
      // Loop Passo 3
      foreach ($aItm_Sdo_Ent as $pItem => $aLin_Itm_Sdo_Ent) {
         foreach ($aLin_Itm_Sdo_Ent as $pLote => $aLin) {
            $nSdo   = $aLin[0];
            $nEnt   = $aLin[1];
            $pUnEst = $aLin[2];
            $pUnVen = $aLin[3];
            $sUnEst = $aUni[$pUnEst];
            $nDif   = $nSdo-$nEnt;   // nDif = Saldo restante aps 180 dias que no tiveram origem nas entradas dentro desse perodo - s tem relevncia qdo for maior que 0
            fpc_append($sEcoTxt,"pItem=$pItem, pLote=$pLote, nSdo=$nSdo, nEnt=$nEnt, nDif=$nDif, pUnEst=$pUnEst, sUnEst=$sUnEst");
            if ($nDif>0) {
               if (isset($aItmComSdoAtualDescoberto[$pItem])==false) {
                  $aInItem[] = $pItem;
                  $aItmComSdoAtualDescoberto[$pItem] = array();
               }
               if (isset($aItmComSdoAtualDescoberto[$pItem][$pLote])==false) {
                  $aItmComSdoAtualDescoberto[$pItem][$pLote] = array($nDif,0,0,$pUnEst,$pUnVen,'');   // [nSdoNJu,nQtTQ,nQtCDI,Itens->pUnEst,Itens->pUnVen,Itens->pUnVen,sItem]   - Saldo No_Justificado
               }
            }   // nDif
         }   // for
      }   // for
   }   // iItm_Sdo_Ent>0

   // Passo (4) - retroceder "dia a dia", Entrada por Entrada seja da CDI seja da TQ e subtrair do SaldoDescoberto at zerar.
   // Feito isso somar o q foi Entrada da CDI, se maior que 0, ento tem que devolver esse Item/Lote/Unidade/Qtd
   $iItmComSdoAtualDescoberto = count($aItmComSdoAtualDescoberto);
   fpc_append($sEcoTxt,"iItmComSdoAtualDescoberto=$iItmComSdoAtualDescoberto");
   if ($iItmComSdoAtualDescoberto>0) {
      $sIn     = implode(',',$aInItem);
      $aInItem = array();
      fpc_append($sEcoTxt,"sIn=$sIn");
      $sSql = "select c.sCodigo,
                      b.pItem,
                      a.pLote,
                      a.pUniSdo,
                      a.nQtSdo,
                      a.j180
               
               from EST_MovSaldos a join EST_RegDepositos             b on a.pRegDep+0 = b.pPId and b.iVer=b.iVAt
                                    join SP_SPLIT_STRING ('$sIn',',') d on b.pItem     = d.iValor
                                    join Itens                        c on b.pItem     = c.pPId and c.iVer=c.iVAt
               where a.iVer=a.iVAt
                 and a.lExc=0
                 and a.jLcmto=1                                             --  rec fsico
                 and cast(a.tIn0 as date) <  (cast('now' as date)-  $i180)  -- lcmto que ocorreram a mais de 180 dias
                 and cast(a.tIn0 as date) >= (cast('now' as date)-4*$i180)  -- lcmto que ocorreram de 2*180 dias para c (para limitar a busca)
                 and a.nQtSdo>0
               order by a.pPId desc";   
                
      fpc_append($sEcoTxt,"sSql=$sSql");
      $aDb  = faDbSelect($hDb,$sSql);

      // Loop Passo 4
      foreach ($aDb as $aLin) {   // 
         $sItem   = $aLin[0];
         $pItem   = $aLin[1];
         $pLote   = $aLin[2];
         $pUni    = $aLin[3];   // pUnSdo do Lcmto
         $nEnt    = $aLin[4];   // Entrada em pUnSdo
         $j180    = $aLin[5];
         if (isset($aItmComSdoAtualDescoberto[$pItem][$pLote])==false) continue;   // existe o pItem mas no o pLote
         $pUnEst  = $aItmComSdoAtualDescoberto[$pItem][$pLote][3];   // [pItem][pLote] = array(nSdoNJu,nQtTQ,nQtCDI,Itens->pUnEst,Itens->pUnVen,sItem)
         $sUni    = $aUni[$pUni  ];
         $sUnEst  = $aUni[$pUnEst];
         fpc_append($sEcoTxt,"sItem=$sItem, pItem=$pItem, pLote=$pLote, pUni=$pUni, nEnt=$nEnt, j180=$j180, pUnEst=$pUnEst, sUni=$sUni, sUnEst=$sUnEst");
         //
         $pConv   = 0;
         $fConv   = 0;
         $nFator  = ($pUni==$pUnEst) ? 1 : fnConverterUnidades($pItem,$pUni,$pUnEst,$sLogItem,$pConv,$fConv);
         fpc_append($sEcoTxt,"nFator=$nFator, pConv=$pConv, fConv=$fConv");
         if (($pConv>0)||($nFator!=0)) {
            $nEntUnEst = $nEnt*$nFator;   // Entrada em pUnEst
            $nSdoNJu   = $aItmComSdoAtualDescoberto[$pItem][$pLote][0];   // Saldo no justificado em Itens->pUnEst
            $nSdoJu    = $nEntUnEst>$nSdoNJu ? $nSdoNJu : $nEntUnEst;
            $aItmComSdoAtualDescoberto[$pItem][$pLote][0] -= $nSdoJu;
            if ($j180==1) {   //  CDI
               $aInItem[] = $pItem;
               $aItmComSdoAtualDescoberto[$pItem][$pLote][2] += $nSdoJu;
            } else {
               $aItmComSdoAtualDescoberto[$pItem][$pLote][1] += $nSdoJu;
            }
            fpc_append($sEcoTxt,"nEntUnEst=$nEntUnEst, nEnt=$nEnt, nFator=$nFator, nSdoNJu=$nSdoNJu, nSdoJu=$nSdoJu");
            $aItmComSdoAtualDescoberto[$pItem][$pLote][5] = $sItem;
         } else {
            flUserLog($aUserLog,"O Item $sItem/TQ est sem fator de conversao entre a unidade do lanamento [$sUni] e a unidade de estoque [$sUnEst] na ficha do item.");
            $lGo=false;
         }
      }   // for
   }   // iItmComSdoAtualDescoberto>0

   // Passo (5) - identificar quais os pRegDep das 'instncias disponveis' com nSdo-nRev>0 para devolver os Itens/Lotes/nQt
   // Tem Item/Lote com nQtCDI>0 para devolver - descobrir de quais depsitos retirar
   // $aItmComSdoAtualDescoberto[$pItem][$pLote] = array(nSdoNJu,nQtTQ,nQtCDI,Itens->pUnEst,Itens->pUnVen,sItem)
   // Preciso do array aItmRetCDI = array(pItem,pLote,pRegDep,nRetCDI)
   $aItmRetCDI = array();        // array(pItem,pLote,pRegDep,nRetCDI)
   $iInItem = count($aInItem);   // aInItem esse array contem o pItem que deve voltar
   if ($iInItem>0) {
      $sIn = implode(',',$aInItem);
      fpc_append($sEcoTxt,"iIn=$iIn");

      $sSql = "select b.pItem,
                      a.pLote,
                      a.pRegDep,
                      a.pPId,
                      b.pUni,
                     (a.nSdo-a.nRes)

               from EST_LotesSaldos  a join EST_RegDepositos b on  a.pRegDep      = b.pPId 
                                                              and  b.iVer         = b.iVAt 
                                                              and  b.pIns         = $pInsDisp 
                                                              and  b.pItem       in ($sIn)
                                                              and (b.nSdo-b.nRes) > 0 
               where a.lExc = 0
                 and a.iVer = a.iVAt
                 and(a.nSdo-a.nRes)>0
   
               union
   
               select a.pItem,
                      0,
                      a.pRegDep,
                      0,
                      a.pUni,
                     (a.nSdo-a.nRes)

               from EST_RegDepositos a 
               where a.lExc          = 0
                 and a.iVer          = a.iVAt
                 and a.pIns          = $pInsDisp
                 and a.pItem        in ($sIn)
                 and (a.nSdo-a.nRes) > 0
              ";
   
      fpc_append($sEcoTxt,"sSql=$sSql");
      $aDb  = faDbSelect($hDb,$sSql);
   
      // Loop Passo 5
      foreach ($aDb as $aLin) {
         $pItem   = $aLin[0];
         $pLote   = $aLin[1];
         $pRegDep = $aLin[2];
         $pELote  = $aLin[3];   // pEST_LotesSaldos
         $pUni    = $aLin[4];
         $nSdo    = $aLin[5];   // em pUnSdo = EST_RegDepositos->pUni
         if (isset($aItmComSdoAtualDescoberto[$pItem][$pLote])==false) continue;
         $pUnEst  = $aItmComSdoAtualDescoberto[$pItem][$pLote][3];   // [pItem][pLote] = array(nSdoNJu,nQtTQ,nQtCDI,Itens->pUnEst,Itens->pUnVen,sItem)
         $pUnVen  = $aItmComSdoAtualDescoberto[$pItem][$pLote][4];   
         $sItem   = $aItmComSdoAtualDescoberto[$pItem][$pLote][5];   
         $sUni    = $aUni[$pUni  ];
         $sUnEst  = $aUni[$pUnEst];
         fpc_append($sEcoTxt,"pItem=$pItem, pLote=$pLote, pRegDep=$pRegDep, pELote=$pELote, pUni=$pUni, nSdo=#nSdo, pUnEst=$pUnEst, pUnVen=$pUnVen, sItem=$sItem, sUni=$sUni, sUnEst=$sUnEst");

         //
         $pConv   = 0;
         $fConv   = 0;
         $nFator  = ($pUni==$pUnEst) ? 1 : fnConverterUnidades($pItem,$pUni,$pUnEst,$sLogItem,$pConv,$fConv);   // Nesse ponto do processo j sei que essa converso existe
         fpc_append($sEcoTxt,"nFator=$nFator, pConv=$pConv, fConv=$fConv");
         if (($pConv>0)||($nFator!=0)) {
            $nSdoUnEst  = $nSdo*$nFator;                                   // Sdo Disp em pUnEst
            $nSdoRetCDI = $aItmComSdoAtualDescoberto[$pItem][$pLote][2];   // Sdo  retornar da CDI
            fpc_append($sEcoTxt,"nSdoUnEst=$nSdoUnEst, nSdoRetCDI=$nSdoRetCDI, nSdo=$nSdo, nFator=$nFator");
            if ($nSdoRetCDI>0) {   // Existe Sdo  retornar da CDI
               if ($nSdoUnEst>$nSdoRetCDI) {   // O Sdo do Dep cobre toda a sada
                  fpc_append($sEcoTxt,"nSdoRetCDI=$nSdoRetCDI");
                  $aItmComSdoAtualDescoberto[$pItem][$pLote][2] -= $nSdoRetCDI;
                  $aItmRetCDI[] = array($pItem,$pLote,$pRegDep,$nSdoRetCDI);
               } else {                        // O Sdo do Dep no cobre toda a sada
                  fpc_append($sEcoTxt,"nSdoUnEst=$nSdoUnEst");
                  $aItmComSdoAtualDescoberto[$pItem][$pLote][2] -= $nSdoUnEst;
                  $aItmRetCDI[] = array($pItem,$pLote,$pRegDep,$nSdoUnEst );
               }
            }   // nSdoRetCDI

         } else {
            flUserLog($aUserLog,"O Item $sItem/TQ est sem fator de conversao entre a unidade do depsito ($sUni) e a unidade de estoque ($sUnEst) na ficha do item.");
            $lGo=false;
         }
      }   // for
   }   // InItem>0

   // Passo (6) - carregar as tabelas EST_180DiasCapa e EST_180Dias, converter a nQtdRetornar que est em pUnEst para pUnVen
   // Mesmo que os passos anteriores no tenham sucesso, seja pelas qrys retornarem vazias, ou por haver problemas na converso, o processo deve seguir e informar ao usurio o que aconteceu
   // Mesmo sem ter sucesso h a necessidade de inserir registros
   $pCapa180 = 0;   // ser o pDocOrigem da Sequencia qdo jDocOrigem==3
   if ($lOk==true) {
      $sSql = "insert into EST_180DiasCapa (pInc) values ($psLogin)";
      fpc_append($sEcoTxt,"sSql=$sSql");
      $lOk  = flDbInsert($hDb,$sSql);
      fpc_append($sEcoTxt,"lOk=$lOk");
      if ($lOk==true) {
         $sSql     = "select max(pPId) from EST_180DiasCapa where pPId>$pMax and pInc=$psLogin";
         fpc_append($sEcoTxt,"sSql=$sSql");
         $aDb      = faDbSelect($hDb,$sSql);
         $pCapa180 = $aDb[0][0];   // ser o pDocOrigem da Sequencia qdo jDocOrigem==3
         fpc_append($sEcoTxt,"pCapa180=$pCapa180");
      }
   }

   $iTotLin = 0;
   if ($lOk==true) {   // Nesse ponto ($lOk==true) => $pCapa180>0
      // Loop Passo 6
      foreach ($aItmRetCDI as $aLin) {   // $aItmRetCDI[] = array($pItem,$pLote,$pRegDep,$nSdoRetCDI,$pUnEst);
         $pItem   = $aLin[0];
         $pLote   = $aLin[1]; 
         $pRegDep = $aLin[2]; 
         $nRetCDI = $aLin[3]; 

         $pUnEst  = $aItmComSdoAtualDescoberto[$pItem][$pLote][3];   // [pItem][pLote] = array(nSdoNJu,nQtTQ,nQtCDI,Itens->pUnEst,Itens->pUnVen,sItem)
         $pUnVen  = $aItmComSdoAtualDescoberto[$pItem][$pLote][4];   
         $sItem   = $aItmComSdoAtualDescoberto[$pItem][$pLote][5];   
         $sUnEst  = $aUni[$pUnEst];
         $sUnVen  = $aUni[$pUnVen];
         fpc_append($sEcoTxt,"pItem=$pItem, pLote=$pLote, pRegDep=$pRegDep, nRetCDI=$nRetCDI, pUnEst=$pUnEst, pUnVen=$pUnVen, sUnEst=$sUnEst, sUnVen=$sUnVen, sItem=$sItem");

         $pConv   = 0;
         $fConv   = 0;
         $nFator  = ($pUnEst==$pUnVen) ? 1 : fnConverterUnidades($pItem,$pUnEst,$pUnVen,$sLogItem,$pConv,$fConv);
         fpc_append($sEcoTxt,"nFator=$nFator, pConv=$pConv, fConv=$fConv");

         if (($pConv>0)||($nFator!=0)) {
            $nRetCDIUnVen = $nRetCDI*$nFator;  
            fpc_append($sEcoTxt,"nRetCDIUnVen=$nRetCDIUnVen, nRetCDI=$nRetCDI, nFator=$nFator");
            if ($lOk==true) {
               $iTotLin++;
               $sSql = "insert into EST_180Dias (pInc,pCapa,pItem,pRegDep,pLote,pUni,nQt) values ($psLogin,$pCapa180,$pItem,$pRegDep,$pLote,$pUnEst,$nRetCDIUnVen)";
               fpc_append($sEcoTxt,"sSql=$sSql");
               $lOk  = flDbInsert($hDb,$sSql);
               fpc_append($sEcoTxt,"lOk=$lOk");
            }
            if ($lOk==false) break;
         } else {
            // sItem/TQ - preciso dessa var aqui
            flUserLog($aUserLog,"O Item $sItem/TQ est sem fator de conversao entre a unidade de estoque [$sUnEst] e a unidade de venda [$sUnVen] na ficha do item.");
            $lGo=false;
         }
      }   // for

      if ($lOk==true) {   // informar qtos processou, se o lGo  true e as msg pro usurio se lGo for false
          $iUserLog = count($aUserLog);   // lGo
          fpc_append($sEcoTxt,"iUserLog=$iUserLog");
          if ($iUserLog>0) {
             $sVer = implode(chr(10),$aUserLog).chr(10)."sEcoTxt=$sEcoTxt";
          } else {
             $sVer = "sEcoTxt=$sEcoTxt";
          }
          $sSql = "update EST_180DiasCapa set iTotLinhas=$iTotLin,sVer='$sVer' where pPId=$pCapa180 and iVer=iVAt";   // tratar sVer e sUserLog
          fpc_append($sEcoTxt,"sSql=$sSql");
          $lOk  = flDbUpdate($hDb,$sSql);
          fpc_append($sEcoTxt,"lOk=$lOk");
      }   // lOk

   }   // lOk

   // Passo (7) - chamar sequencia de processos
*/
   $iTotLin=1;   // *
   $pCapa180=0;   // *
   if ($iTotLin>0) {   // Tem itens vlidos para processar

      // 1a Seq
      if ($lOk==true) {
         $jDocOrigem = 3;                   // (*) 0-Recebimento Fsico CDI, 1-Aprovao Inspeo, 2-Confirmao Ordem Trnsito, 3Itens 180 Dias
         fpc_append($sEcoTxt,"include - 1a SeqProc");
         include('OEnt_Confirmar_RFisico_TQ_include_SeqProc.php');   // pSeqPreNFEnt (*)
         fpc_append($sEcoTxt,"lSeqProcCommit=$lSeqProcCommit");
         $lOk=($lSeqProcCommit==1);   //
      }
      // 2a Seq
      if ($lOk==true) {
         $jDocOrigem    = 4;
         $lGlobalConsol = 0;           // resetando
         $pRFis_2a      = $pSeqPreNFEnt;   // (*)
         fpc_append($sEcoTxt,"include - 2a SeqProc");
         include('OEnt_Confirmar_RFisico_TQ_include_SeqProc.php');
         fpc_append($sEcoTxt,"lSeqProcCommit=$lSeqProcCommit");
         $lOk=($lSeqProcCommit==1);     //
      }

   }   // (iTotLin>0)

   // Passo (8) - commit, rollback
   // Melhorar conceitos commit com lOk, lGo e lWriteDb ou lDb
   // O fato de lGo ser true ou false nem sempre determina um commit ou rollback, pois msg de erro podem ser salvas no banco
   // Se um lGo=false determinar a necessidade de um rollback, ento nesse caso o lOk deve ser false tb
   // O fato de lOk ser true ou false no  suficiente para commit ou rollback, pois o processo pode chegar ao fim com valor do lOk default=true e no ter escrito no banco
   //  necessrio uma nova var que pode ser lDb ou lWriteDb ou lWDb, que tem valor default=false e que se torna true caso haja uma escrita no banco
   if ($lWDb==true) {   // houve escrita no banco, por isso a necessidade de haver um commit ou rollback
      if ($lOk==true) {
         flDbCommit($hDb);
         fpc_append($sEcoTxt,"commit");
      } else {
         flDbRollBack($hDb);
         fpc_append($sEcoTxt,"rollback");
         flUserLog($aUserLog,'EST_180Dias_Processar.php - rollback');
      }
   }
   if ($lConnDb==true) flDbDisconnect($hDb);
} else {
   flUserLog($aUserLog,'Arquivo de configurao no foi encontrado');
}

$sUserLog = implode(chr(10),$aUserLog);
fpc_append($sEcoTxt,"--//--");
fpc_append($sEcoTxt,"Log do usurio");
fpc_append($sEcoTxt,"$sUserLog");
$tJobEnd  = time();
$iJobElap = $tJobEnd-$tJobStart;
fpc_append($sEcoTxt,'Durao do processo em milisegundos: '.$iJobElap);
fpc_append($sEcoTxt,'Mensagem do processo: '.$sUserLog);
fpc_append($sEcoTxt,'Final: '.date('d/m/Y H:i:s',$tJobEnd));
fpc_append($sEcoTxt,'----------------------------------------------------------------------------'.chr(10).chr(10));

echo strlen($sUserLog)>0 ? $sUserLog : 1;
$aTop    = faLoadAvgServer();
$nTopFin = $aTop[0];
$flSysJobs = flSysJobs($sProc,$nTopIni,$nTopFin,$tJobStart,$tJobEnd,$iJobElap,$psCliPasta,$psLogin);
flEndPHP();
