<?php


// Configuraes bsicas
$numeroCTe       = '123456'; // Nmero do CTe (6 dgitos)
$serieCTe        = '1'; // Srie do CTe
$cnpjEmitente    = '12345678000199'; // CNPJ do transportador
$ufEmitente      = '35'; // Cdigo da UF (SP = 35)
$dataHoraEmissao = date('Y-m-d\TH:i:sP'); // Data atual no padro CTe

// Chave de acesso do CTe (Cdigo + DV)
$chaveCTe = sprintf(
    'CTe%02d%02d%02d%s%02d%09d%01d',
    $ufEmitente, // UF
    date('y'), // Ano (2 dgitos)
    date('m'), // Ms
    $cnpjEmitente, // CNPJ
    $serieCTe, // Srie
    $numeroCTe, // Nmero do CTe
    1 // Dgito verificador (simplificado, na prtica deve ser calculado)
);

// Cria o documento XML
$oXML = new DOMDocument('1.0', 'UTF-8');
$oXML->formatOutput = true;

// Elemento raiz <CTe>
$oCTe = $oXML->createElement('CTe');
$oCTe->setAttribute('xmlns', 'http://www.portalfiscal.inf.br/cte');
$oCTe->setAttribute('versao', '3.00');
$oXML->appendChild($oCTe);

// Elemento <infCte> (dados do CTe)
$oInfCTe = $oXML->createElement('infCte');
$oInfCTe->setAttribute('Id', $chaveCTe);
$oCTe->appendChild($oInfCTe);

// Seo <ide> (Identificao do CTe)
$oIde = $oXML->createElement('ide');
$oInfCTe->appendChild($oIde);

// Campos dentro de <ide>
$camposIde = [
    'cUF' => $ufEmitente,
    'cCT' => $numeroCTe,
    'CFOP' => '5353', // CFOP para transporte
    'natOp' => 'PRESTACAO DE SERVICO DE TRANSPORTE',
    'mod' => '57', // Modelo do CTe (57 = Normal)
    'serie' => $serieCTe,
    'nCT' => $numeroCTe,
    'dhEmi' => $dataHoraEmissao,
    'tpImp' => '1', // Formato de impresso
    'tpEmis' => '1', // Emisso normal
    'cDV' => '1', // Dgito verificador (simplificado)
    'tpAmb' => '2', // 1=Produo | 2=Homologao
    'tpCTe' => '0', // Tipo do CTe (0=Normal)
    'procEmi' => '0', // Emisso prpria
    'verProc' => '1.0', // Verso do sistema
];

foreach ($camposIde as $tag => $valor) {
    $oIde->appendChild($oXML->createElement($tag, $valor));
}

// Seo <emit> (Emitente do CTe - Transportador)
$oEmit = $oXML->createElement('emit');
$oInfCTe->appendChild($oEmit);

$camposEmit = [
    'CNPJ' => $cnpjEmitente,
    'IE' => '123456789', // Inscrio Estadual
    'xNome' => 'TRANSPORTADORA XYZ LTDA',
    'xFant' => 'XYZ LOGISTICA',
];

foreach ($camposEmit as $tag => $valor) {
    $oEmit->appendChild($oXML->createElement($tag, $valor));
}

// Endereo do emitente (<enderEmit>)
$oEnderEmit = $oXML->createElement('enderEmit');
$oEmit->appendChild($oEnderEmit);

$camposEnderEmit = [
    'xLgr' => 'RUA EXEMPLO',
    'nro' => '100',
    'xBairro' => 'CENTRO',
    'cMun' => '3550308', // Cdigo IBGE de So Paulo
    'xMun' => 'SAO PAULO',
    'UF' => 'SP',
    'CEP' => '01001000',
    'fone' => '1122223333',
];

foreach ($camposEnderEmit as $tag => $valor) {
    $oEnderEmit->appendChild($oXML->createElement($tag, $valor));
}

// Seo <rem> (Remetente)
$oRem = $oXML->createElement('rem');
$oInfCTe->appendChild($oRem);

$camposRem = [
    'CNPJ' => '98765432000198',
    'xNome' => 'REMETENTE LTDA',
];

foreach ($camposRem as $tag => $valor) {
    $oRem->appendChild($oXML->createElement($tag, $valor));
}

// Endereo do remetente (<enderReme>)
$oEnderReme = $oXML->createElement('enderReme');
$oRem->appendChild($oEnderReme);

$camposEnderReme = [
    'xLgr' => 'AV REMETENTE',
    'nro' => '500',
    'xBairro' => 'INDUSTRIAL',
    'cMun' => '3550308',
    'xMun' => 'SAO PAULO',
    'UF' => 'SP',
];

foreach ($camposEnderReme as $tag => $valor) {
    $oEnderReme->appendChild($oXML->createElement($tag, $valor));
}

// Seo <dest> (Destinatrio)
$oDest = $oXML->createElement('dest');
$oInfCTe->appendChild($oDest);

$camposDest = [
    'CNPJ' => '11122233000199',
    'xNome' => 'DESTINATARIO LTDA',
];

foreach ($camposDest as $tag => $valor) {
    $oDest->appendChild($oXML->createElement($tag, $valor));
}

// Endereo do destinatrio (<enderDest>)
$oEnderDest = $oXML->createElement('enderDest');
$oDest->appendChild($oEnderDest);

$camposEnderDest = [
    'xLgr' => 'RUA DESTINO',
    'nro' => '200',
    'xBairro' => 'CENTRO',
    'cMun' => '4106902', // Cdigo IBGE de Curitiba
    'xMun' => 'CURITIBA',
    'UF' => 'PR',
];

foreach ($camposEnderDest as $tag => $valor) {
    $oEnderDest->appendChild($oXML->createElement($tag, $valor));
}

// Seo <vPrest> (Valores da Prestao)
$oVPrest = $oXML->createElement('vPrest');
$oInfCTe->appendChild($oVPrest);

$camposVPrest = [
    'vTPrest' => '1000.00', // Valor total
    'vRec' => '1000.00', // Valor a receber
];

foreach ($camposVPrest as $tag => $valor) {
    $oVPrest->appendChild($oXML->createElement($tag, $valor));
}

// Seo <imp> (Tributao - ICMS)
$oImp = $oXML->createElement('imp');
$oInfCTe->appendChild($oImp);

$oICMS = $oXML->createElement('ICMS');
$oImp->appendChild($oICMS);

$oICMS00 = $oXML->createElement('ICMS00');
$oICMS->appendChild($oICMS00);

$camposICMS00 = [
    'CST' => '00', // Tributao normal
    'vBC' => '1000.00', // Base de clculo
    'pICMS' => '12.00', // Alquota (%)
    'vICMS' => '120.00', // Valor do ICMS
];

foreach ($camposICMS00 as $tag => $valor) {
    $oICMS00->appendChild($oXML->createElement($tag, $valor));
}

// Salva o XML em um arquivo
$oXML->save('cte.xml');

echo "XML do CTe gerado com sucesso em: cte.xml";
