<?php
// 1. Carrega o XML assinado
$xmlFile = 'cte-assinado.xml';
$xmlContent = file_get_contents($xmlFile);

// 2. Configuraes do certificado
$certFile = 'certificado.pfx';
$certPassword = 'senha123';

// 3. Envelope SOAP para envio do CTe
$soapEnvelope = <<<XML
<soap12:Envelope xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:soap12="http://www.w3.org/2003/05/soap-envelope">
  <soap12:Body>
    <cteRecepcaoLote xmlns="http://www.portalfiscal.inf.br/cte/wsdl/CteRecepcao">
      <cteDadosMsg>{$xmlContent}</cteDadosMsg>
    </cteRecepcaoLote>
  </soap12:Body>
</soap12:Envelope>
XML;

// 4. Configura o cURL para enviar para a SEFAZ-SP (Homologao)
$url = 'https://homologacao.nfe.fazenda.sp.gov.br/cteWEB/services/CteRecepcao.asmx';
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $soapEnvelope);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/soap+xml; charset=utf-8',
    'Content-Length: ' . strlen($soapEnvelope)
]);

// 5. Configura o certificado e a chave privada
curl_setopt($ch, CURLOPT_SSLCERT, $certFile);
curl_setopt($ch, CURLOPT_SSLCERTPASSWD, $certPassword);
curl_setopt($ch, CURLOPT_SSLKEY, $certFile);
curl_setopt($ch, CURLOPT_SSLKEYPASSWD, $certPassword);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); // Desativa validao em homologao

// 6. Envia a requisio e captura a resposta
$response = curl_exec($ch);
var_dump($response);

if (curl_errno($ch)) {
    die("Erro cURL: " . curl_error($ch));
}
curl_close($ch);

// 7. Processa a resposta SOAP
$dom = new DOMDocument();
$dom->loadXML($response);

// Verifica se h erros
if ($dom->getElementsByTagName('faultstring')->length > 0) {
    $error = $dom->getElementsByTagName('faultstring')->item(0)->nodeValue;
    die("Erro no WebService: " . $error);
}

// Extrai o retorno do CTe
$retorno = $dom->getElementsByTagName('cteRecepcaoResult')->item(0)->nodeValue;
file_put_contents('retorno-sefaz.xml', $retorno);

echo "Resposta da SEFAZ salva em: retorno-sefaz.xml".chr(10);
