<?php
// 1. Carrega o XML do CTe (gerado anteriormente)
$xmlFile = 'cte.xml';
$xmlContent = file_get_contents($xmlFile);

// 2. Configuraes do certificado
$certFile = 'certificado.pfx';
$certPassword = 'senha123'; // Senha que voc definiu

// 3. Extrai a chave privada e o certificado do .pfx
if (!openssl_pkcs12_read(file_get_contents($certFile), $certInfo, $certPassword)) {
    die("Erro ao ler o certificado. Verifique o arquivo e a senha.");
}

$privateKey = $certInfo['pkey']; // Chave privada
$certificate = $certInfo['cert']; // Certificado

// 4. Prepara o XML para assinatura
$doc = new DOMDocument();
$doc->loadXML($xmlContent);

// 5. Localiza o elemento <infCte> (que ser assinado)
$infCte = $doc->getElementsByTagName('infCte')->item(0);
if (!$infCte) {
    die("Tag <infCte> no encontrada no XML.");
}

// 6. Cria a estrutura de assinatura digital
$signature = $doc->createElement('Signature');
$signature->setAttribute('xmlns', 'http://www.w3.org/2000/09/xmldsig#');
$infCte->appendChild($signature);

// 7. Gera o hash (digest) do contedo a ser assinado
$canonicalData = $infCte->C14N(true, false); // Canonicalizao (exclusive XML)
$digestValue = base64_encode(openssl_digest($canonicalData, 'sha1', true));

// 8. Monta a SignedInfo
$signedInfo = $doc->createElement('SignedInfo');
$signature->appendChild($signedInfo);

// 8.1. Algoritmo de Canonicalizao
$canonicalizationMethod = $doc->createElement('CanonicalizationMethod');
$canonicalizationMethod->setAttribute('Algorithm', 'http://www.w3.org/TR/2001/REC-xml-c14n-20010315');
$signedInfo->appendChild($canonicalizationMethod);

// 8.2. Algoritmo de Assinatura
$signatureMethod = $doc->createElement('SignatureMethod');
$signatureMethod->setAttribute('Algorithm', 'http://www.w3.org/2000/09/xmldsig#rsa-sha1');
$signedInfo->appendChild($signatureMethod);

// 8.3. Referncia (contm o digest)
$reference = $doc->createElement('Reference');
$reference->setAttribute('URI', '#' . $infCte->getAttribute('Id'));
$signedInfo->appendChild($reference);

$transforms = $doc->createElement('Transforms');
$reference->appendChild($transforms);

$transform1 = $doc->createElement('Transform');
$transform1->setAttribute('Algorithm', 'http://www.w3.org/2000/09/xmldsig#enveloped-signature');
$transforms->appendChild($transform1);

$transform2 = $doc->createElement('Transform');
$transform2->setAttribute('Algorithm', 'http://www.w3.org/TR/2001/REC-xml-c14n-20010315');
$transforms->appendChild($transform2);

$digestMethod = $doc->createElement('DigestMethod');
$digestMethod->setAttribute('Algorithm', 'http://www.w3.org/2000/09/xmldsig#sha1');
$reference->appendChild($digestMethod);

$digestValueElement = $doc->createElement('DigestValue', $digestValue);
$reference->appendChild($digestValueElement);

// 9. Canonicaliza a SignedInfo e gera a assinatura
$signedInfoCanonicalized = $signedInfo->C14N(true, false);
openssl_sign($signedInfoCanonicalized, $signatureValue, $privateKey, OPENSSL_ALGO_SHA1);
$signatureValueBase64 = base64_encode($signatureValue);

// 10. Adiciona a assinatura ao XML
$signatureValueElement = $doc->createElement('SignatureValue', $signatureValueBase64);
$signature->appendChild($signatureValueElement);

// 11. Adiciona o certificado ao XML
$keyInfo = $doc->createElement('KeyInfo');
$signature->appendChild($keyInfo);

$x509Data = $doc->createElement('X509Data');
$keyInfo->appendChild($x509Data);

$x509Certificate = $doc->createElement('X509Certificate', str_replace(
    ['-----BEGIN CERTIFICATE-----', '-----END CERTIFICATE-----', "\n", "\r"],
    '',
    $certificate
));
$x509Data->appendChild($x509Certificate);

// 12. Salva o XML assinado
$doc->save('cte-assinado.xml');

echo "XML assinado com sucesso! Salvo em: cte-assinado.xml".chr(10);