<?php

ini_set('display_errors', 0);   // Desativa TODA sada de erros do PHP (incluindo fatal errors)
//error_reporting(0);             // Garante que nenhum erro seja exibido
error_reporting(E_ALL);             // Mostra todos os erros
ob_start();                     // Inicia o buffer para capturar possveis vazamentos
set_time_limit(30);


require_once("../pFuncoes1.php");
require_once("../pPublics1.php");

$aTodosErros = array();
$startTime = microtime(true);

//
/*
         $sTab1  = 'OP';
         $aIns   = array();
         $aIns[] = 'pInc';
         $aIns[] = 'tInc';
         $aIns[] = 'jOrigem';
         $aIns[] = 'pUNeg';
         $aIns[] = 'pItem';
         $hSql1  = fpPrepareArrToInsert($hDb,$sTab1,$aIns);
   
         $sTab2  = 'MRP_OPProg';
         $aUpd   = array();
         $aUpd[] = 'pGerPor';
         $aUpd[] = 'tGerEm';
         $aUpd[] = 'pOp'; 

         $sWhere = 'pPId = ? and iVer = iVat';
         $hSql2  = fhPrepareArrToUpdate($hDb,$sTab2,$aUpd,$sWhere);
   
         foreach ($aDb as $aLin) {
            $lOk   = true;
            $pEmi  = $aLin[2];
            $pItem = $aLin[3];
         
            if ($lOk==true) {
               // inserir
               $aValues   = array();
               $aValues[] = $psLogin;
               $aValues[] = 'now';
               $aValues[] = 1; 
               $aValues[] = $pEmi;
               $aValues[] = $pItem;
               
               fpc_append($sEcoTxt,'insert aValues='.implode(',',$aValues));
               $pPIdOP = fpDBExecute($hSql1,$aValues);
               $lOk = ($pPIdOP>0);
            }   

            if ($lOk==true) {
               $aValues   = array();
               $aValues[] = $psLogin;
               $aValues[] = 'now';
               $aValues[] = $pPIdOP;
               $aValues[] = $pPId;

               fpc_append($sEcoTxt,'update aValues='.implode(',',$aValues));
               $lOk = flDBExecute($hSql2,$aValues);
            }
         }   // for
   
         ibase_free_query($hSql1);
         ibase_free_query($hSql2);


*/
$sDSN = '/qtux/database/tq/gps_01.gdb';
$hCon = fhDbCon($sDSN);

$aUp1 = array();
$aUp1[] = 'pCia';
$aUp1[] = 'tInc';

$aUp2 = array();
$aUp2[] = 'pCUP';
$aUp2[] = 'tInc';

$aUp3 = array();
$aUp3[] = 'pUO'; 
$aUp3[] = 'tInc';

$aUp4 = array();
$aUp4[] = 'iSerial';
$aUp4[] = 'tInc';


foreach ($aDb as $aLin) {
   $iWhile=0;
   while ($iWhile++<3) {
      $hDb  = fhDbTra($hCon);
      $pCUP = $aLin[0];   // suponha que seja um dado valido
      try {

         $sSql = "update CUP1 set pCia=1, tInc='now' where pPId = $pCUP and iVer = iVAt";
         flDbUpd($hDb,$sSql);
   
         $sSql = "update CUP2 set pCUP=1, tInc='now' where pPId = $pCUP and iVer = iVAt";
         flDbUpd($hDb,$sSql);
   
         $sSql = "update CUP3 set pUO =1, tInc='now' where pPId = $pCUP and iVer = iVAt";
         flDbUpd($hDb,$sSql);
   
         $sSql = "update CUP4 set iSerial = iSerial+1, tInc='now' where pPId = $pCUP and iVer = iVAt";
         flDbUpd($hDb,$sSql);
   
         flDbCom($hDb);
         break;
      } catch (Exception $e) {
         flDbRol($hDb);
         sleep(1);
      }   // try
   }   // while
}   // for

flDbDis($hCon);


// fim

function fhDbCon($psDSN) {
//////////////////////////
   $sHost = $psDSN;
   $sUser = 'sysqtux';
   $sPass = 'qtux201005';
   $hCon  = ibase_connect($sHost,$sUser,$sPass);
   return $hCon;
}

function fhDbTra($phCon) {
//////////////////////////
   $hDb   = ibase_trans(IBASE_NOWAIT,$phCon);   // fdy 03/03/2017
   return $hDb;
}

function flDbDis($phCon) {
//////////////////////////
   ibase_close($phCon);
   return true;
}

function flDbCom($phDb) {
/////////////////////////
   ibase_commit_ret($phDb);
   return true;
}

function flDbRol($phDb) {
/////////////////////////
   ibase_rollback_ret($phDb);
   return true;
}

function flDbUpd($phDb,$psSql) {
////////////////////////////////
   $lOk = ibase_query($phDb,$psSql);
   if ($lOk===false) {
      $sErro = ibase_errmsg();
      throw new RuntimeException("Falha na execuo do update: $spSql\nErro: $sErro");
   }
}

set_error_handler(function($severity, $message, $file, $line) use (&$aTodosErros) {
///////////////////////////////////////////////////////////////////////////////////
    $aTodosErros[] = compact('severity', 'message', 'file', 'line');
    return false;
});

set_exception_handler(function($e) use (&$aTodosErros) {
////////////////////////////////////////////////////////
    $aTodosErros[] = [
        'type' => 'exception',
        'message' => $e->getMessage(),
        'file' => $e->getFile(),
        'line' => $e->getLine()
    ];
});

register_shutdown_function(function() use ($startTime) {
////////////////////////////////////////////////////////
   global $aTodosErros;
   ob_end_clean();   // Descarta todo o contedo do buffer (incluindo erros fatais)
    
   $executionTime = microtime(true) - $startTime;
   $aErro = error_get_last();

   if (isset($aErro)) {
      $aTodosErros[] = $aErro;
      echo 'erro '. print_r($aTodosErros, true) . chr(10);
   } else {
      echo 'bye bye' . chr(10);
   }
});

