<?php

ini_set('display_errors', 0);   // Desativa TODA sada de erros do PHP (incluindo fatal errors)
//error_reporting(0);             // Garante que nenhum erro seja exibido
error_reporting(E_ALL);             // Mostra todos os erros
ob_start();                     // Inicia o buffer para capturar possveis vazamentos
set_time_limit(30);


require_once("../pFuncoes1.php");
require_once("../pPublics1.php");

$aTodosErros = array();
$startTime = microtime(true);

//

$sDSN = '/qtux/database/tq/gps_01.gdb';
$hCon = fhDbCon($sDSN);

foreach ($aDb as $aLin) {
   $iWhile=0;
   while ($iWhile++<3) {
      $hDb  = fhDbTra($hCon);
      $pCUP = $aLin[0];   // suponha que seja um dado valido
      try {
   
         $sSql = "update CUP1 set pCia = 1 where pPId = $pCUP and iVer = iVAt";
         flDbUpd($hDb,$sSql);
   
         $sSql = "update CUP2 set pCia = 1 where pPId = $pCUP and iVer = iVAt";
         flDbUpd($hDb,$sSql);
   
         $sSql = "update CUP3 set pCia = 1 where pPId = $pCUP and iVer = iVAt";
         flDbUpd($hDb,$sSql);
   
         $sSql = "update CUP4 set pCia = 1 where pPId = $pCUP and iVer = iVAt";
         flDbUpd($hDb,$sSql);
   
         flDbCom($hDb);
         break;
      } catch (Exception $e) {
         flDbRol($hDb);
         sleep(1);
      }   // try
   }   // while
}   // for

flDbDis($hCon);


// fim

function fhDbCon($psDSN) {
//////////////////////////
   $sHost = $psDSN;
   $sUser = 'sysqtux';
   $sPass = 'qtux201005';
   $hCon  = ibase_connect($sHost,$sUser,$sPass);
   return $hCon;
}

function fhDbTra($phCon) {
//////////////////////////
   $hDb   = ibase_trans(IBASE_NOWAIT,$phCon);   // fdy 03/03/2017
   return $hDb;
}

function flDbDis($phCon) {
//////////////////////////
   ibase_close($phCon);
   return true;
}

function flDbCom($phDb) {
/////////////////////////
   ibase_commit_ret($phDb);
   return true;
}

function flDbRol($phDb) {
/////////////////////////
   ibase_rollback_ret($phDb);
   return true;
}

function flDbUpd($phDb,$psSql) {
////////////////////////////////
   $lOk = ibase_query($phDb,$psSql);
   if ($lOk===false) {
      $sErro = ibase_errmsg();
      throw new RuntimeException("Falha na execuo do update: $spSql\nErro: $sErro");
   }
}

set_error_handler(function($severity, $message, $file, $line) use (&$aTodosErros) {
///////////////////////////////////////////////////////////////////////////////////
    $aTodosErros[] = compact('severity', 'message', 'file', 'line');
    return false;
});

set_exception_handler(function($e) use (&$aTodosErros) {
////////////////////////////////////////////////////////
    $aTodosErros[] = [
        'type' => 'exception',
        'message' => $e->getMessage(),
        'file' => $e->getFile(),
        'line' => $e->getLine()
    ];
});

register_shutdown_function(function() use ($startTime) {
////////////////////////////////////////////////////////
   global $aTodosErros;
   ob_end_clean();   // Descarta todo o contedo do buffer (incluindo erros fatais)
    
   $executionTime = microtime(true) - $startTime;
   $aErro = error_get_last();

   if (isset($aErro)) {
      $aTodosErros[] = $aErro;
      echo 'erro '. print_r($aTodosErros, true) . chr(10);
   } else {
      echo 'bye bye' . chr(10);
   }
});

