<?php
ini_set('display_errors', 1); // Garante que os erros sejam capturados pelo buffer
ob_start();

set_time_limit(2);

$startTime = microtime(true);
register_shutdown_function(function() use ($startTime) {
    $executionTime = microtime(true) - $startTime;
    $aErro = error_get_last();
    
    // Pega o contedo do buffer (incluindo o erro fatal) e limpa
    $bufferContent = ob_get_clean();
    
    // Exibe o contedo do buffer (erro fatal) + sua sada customizada
    echo "xxx-" . $bufferContent . chr(10); // Agora exibe o erro!
    
    if (isset($aErro)) {
        echo 'aa' . chr(10);
        file_put_contents(
            'PreNF_OSa_01_Cias_CRON_ERROS.log',
            'Tempo de execuo: ' . $executionTime . ' - ' . date('d/m/Y H:i:s') . chr(10) .
            'ERRO CAPTURADO NO BUFFER: ' . $bufferContent . chr(10) . // Adicione ao log se quiser
            'DETALHES DO ERRO: ' . print_r($aErro, true) . chr(10) .
            '----------------------------------' . chr(10),
            FILE_APPEND
        );
    } else {
        echo 'bb' . chr(10);
        // (...) Log de sucesso
    }
});

// Gera um erro fatal (funo inexistente)
//$s = fjdsj();

while (true) {} // Simula timeout