<?php
header('Content-Type: text/html; charset=iso-8859-1');
// Dados da etiqueta
$destinatario = [
    'nome' => 'Joo da Silva',
    'endereco' => 'Rua Exemplo, 123 - Apto 101',
    'bairro' => 'Centro',
    'cidade' => 'So Paulo/SP',
    'cep' => '01001-000'
];

$remetente = [
    'nome' => 'Empresa XYZ',
    'endereco' => 'Av. Principal, 1000',
    'bairro' => 'Industrial',
    'cidade' => 'Rio de Janeiro/RJ',
    'cep' => '20010-020'
];

$servico = 'PAC';
$codigo_rastreio = 'PN123456789BR';
$peso = '500g';
$data = date('d/m/Y');

// Gerar HTML para impresso
$html = '
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta name="robots" content="noindex, nofollow">
    <meta http-equiv="Content-type" content="text/html; charset=iso-8859-1" />
    <title>Etiqueta de Postagem</title>
    <style>
        body { font-family: Arial, sans-serif; }
        .etiqueta { 
            width: 100mm; 
            height: 100mm; 
            border: 1px dashed #ccc; 
            padding: 5mm;
            box-sizing: border-box;
            page-break-after: always;
        }
        .destinatario { font-weight: bold; font-size: 12pt; }
        .codigo-rastreio { 
            font-family: "Lucida Console", monospace;
            font-size: 14pt;
            text-align: center;
            margin: 5mm 0;
            letter-spacing: 2px;
        }
        .barcode { 
            text-align: center;
            margin: 3mm 0;
        }
        .remetente { font-size: 9pt; color: #555; }
        .detalhes { font-size: 10pt; margin-top: 3mm; }
    </style>
</head>
<body>
    <div class="etiqueta">
        <div class="remetente">
            <div>'.$remetente['nome'].'</div>
            <div>'.$remetente['endereco'].'</div>
            <div>'.$remetente['bairro'].'</div>
            <div>'.$remetente['cidade'].'</div>
            <div>CEP: '.$remetente['cep'].'</div>
        </div>
        
        <div class="barcode">
            <!-- Aqui voc pode implementar um gerador de cdigo de barras -->
            [CDIGO DE BARRAS]
        </div>
        
        <div class="codigo-rastreio">'.$codigo_rastreio.'</div>
        
        <div class="destinatario">
            <div>'.$destinatario['nome'].'</div>
            <div>'.$destinatario['endereco'].'</div>
            <div>'.$destinatario['bairro'].'</div>
            <div>'.$destinatario['cidade'].'</div>
            <div>CEP: '.$destinatario['cep'].'</div>
        </div>
        
        <div class="detalhes">
            <div>Servio: '.$servico.'</div>
            <div>Peso: '.$peso.'</div>
            <div>Data: '.$data.'</div>
        </div>
    </div>
</body>
</html>';
echo $html;
/*
// Para converter em PDF (requer biblioteca como TCPDF ou Dompdf)
require_once '/qtux/www/FullPlat/lib/autoload.php';
use Dompdf\Dompdf;

$dompdf = new Dompdf();
$dompdf->loadHtml($html);
$dompdf->setPaper(array(0, 0, 100, 100), 'portrait'); // Tamanho aproximado da etiqueta
$dompdf->render();

// Sada do PDF
$dompdf->stream("etiqueta.pdf", array("Attachment" => false));
*/