<?php
/*
require_once('/qtux/www/FullPlat/lib/autoload.php');

use Picqer\Barcode\BarcodeGeneratorPNG; // Ou use BarcodeGeneratorPNG para gerar em PNG

// Chave de acesso da NF-e (44 dgitos)
$chaveAcesso = '35240915269433000114550010003492991927945610'; // Exemplo de chave de acesso
// Instanciar o gerador de cdigo de barras
$generator = new BarcodeGeneratorPNG(); // Para HTML. Para imagem PNG, use `BarcodeGeneratorPNG`

$larguraBarra = 1;
$alturaBarra  = 50;
// Gerar o cdigo de barras no formato Code 128
$barcode = $generator->getBarcode($chaveAcesso, $generator::TYPE_CODE_128,$larguraBarra,$alturaBarra);

$sNomePNG = $chaveAcesso.'.png';
$sDirSalvar = '/qtux/www/FullPlat/processos/tmp/';
$caminhoArquivo = $sDirSalvar.$sNomePNG;
file_put_contents($caminhoArquivo, $barcode);
echo 'https://dev.qtux.com.br/FullPlat/processos/tmp/'.$sNomePNG;
// Exibir o cdigo de barras
echo '<h2>Cdigo de Barras DANFE NF-e</h2>';
echo '<img src="./tmp/'.$sNomePNG.'" alt="Cdigo de Barras">';
*/

require_once('/qtux/www/FullPlat/lib/autoload.php');

use Picqer\Barcode\BarcodeGeneratorPNG;

$sInfNFe_Id = '35240915269433000114550010003492991927945610';
$sTextoRestricao = "NF-e DENEGADA";
$sTextoRestricao = "SEM VALOR FISCAL";
//$sTextoRestricao = '';

$sNomePNG = $sInfNFe_Id.'.png';
$sDirSalvar = '/qtux/www/FullPlat/processos/tmp/';
$sDirNomeImagem = $sDirSalvar.$sNomePNG;

fimgGerarCodigoBarrasComTexto($sInfNFe_Id,$sDirNomeImagem,$sTextoRestricao);

echo '<h2>Cdigo de Barras DANFE NF-e</h2>';
echo '<img src="./tmp/'.$sNomePNG.'" alt="Cdigo de Barras">';

function fimgGerarCodigoBarrasComTexto($psInfNFe_Id,$psDirNomeImagem,$psTextoRestricao) {
/////////////////////////////////////////////////////////////////////////////////////////
    $iTamFonte = 0;
    $iPosX     = 0;
    $iPosY     = 0;
    // Criar o objeto 
    $oBarCode = new BarcodeGeneratorPNG();
    // Largura e altura do Cdigo de barras
    $iLargBarra = 1;
    $iAltBarra  = 50;
    // Gerar o cdigo de barras no formato PNG
    $imgCodBarras = $oBarCode->getBarcode($psInfNFe_Id,$oBarCode::TYPE_CODE_128,$iLargBarra,$iAltBarra);

    // Salvar o cdigo de barras em um arquivo PNG temporrio
    $sDirNomeImagemTemp = str_replace('.png','_tmp.png',$psDirNomeImagem);
    file_put_contents($sDirNomeImagemTemp,$imgCodBarras);

    // Carregar a imagem do cdigo de barras gerado
    $oImgBarras = imagecreatefrompng($sDirNomeImagemTemp);

    // Obter as dimenses da imagem de cdigo de barras
    $oLargImagem = imagesx($oImgBarras);
    $oAltImagem  = imagesy($oImgBarras);

    // Criar uma nova imagem com base no cdigo de barras (mesmo tamanho)
    $oImgFinal = imagecreatetruecolor($oLargImagem,$oAltImagem);

    // Definir a cor branca para o fundo e preencher a imagem
    $oBranco = imagecolorallocate($oImgFinal,255,255,255);
    imagefill($oImgFinal,0,0,$oBranco);

    // Copiar o cdigo de barras para a nova imagem
    imagecopy($oImgFinal,$oImgBarras,0,0,0,0,$oLargImagem,$oAltImagem);

    // Definir a cor vermelha para o texto
    $oVermelho = imagecolorallocate($oImgFinal,255,0,0);

    // Adicionar o texto sobre a imagem usando uma fonte TTF (TrueType)
    //$sDirNomeFonte = '/qtux/www/FullPlat/fontes/arial.ttf'; // Certifique-se de que o caminho da fonte TTF esteja correto
    $sDirNomeFonte = '/qtux/www/FullPlat/fontes/arialbd.ttf'; // Certifique-se de que o caminho da fonte TTF esteja correto

    // Posio do texto
    if ($psTextoRestricao=='NF-e DENEGADA') {
       $iTamFonte = 25;
       $iPosX     = 2;  // Posio X do texto
       $iPosY     = 35; // Posio Y do texto (pode ajustar conforme necessrio)
    } // if ($sTextoRestricao=='NF-e DENEGADA')

    if ($psTextoRestricao=='SEM VALOR FISCAL') {
       $iTamFonte = 21;
       $iPosX     = 1;  // Posio X do texto
       $iPosY     = 35; // Posio Y do texto (pode ajustar conforme necessrio)
    } // if ($sTextoRestricao=='NF-e DENEGADA')

    // Adicionar o texto sobre a imagem usando imagettftext
    imagettftext($oImgFinal,$iTamFonte,0,$iPosX,$iPosY,$oVermelho,$sDirNomeFonte,$psTextoRestricao);

    // Salvar a imagem final no caminho fornecido
    imagepng($oImgFinal,$psDirNomeImagem);

    // Limpar memria
    imagedestroy($oImgBarras);
    imagedestroy($oImgFinal);
    unlink($sDirNomeImagemTemp); // Remover o arquivo temporrio
} // function fimgGerarCodigoBarrasComTexto($psInfNFe_Id,$psDirNomeImagem,$psTextoRestricao)
//
