<?php
//header("Content-Type: html; charset=UTF-8");
header('Content-Type: text/html; charset=iso-8859-1');
// =====================
// DADOS (substitua por SELECTs do seu banco quando quiser)
// =====================
$metricas = [
    "A Reservar"     => 166264.00000,
    "A Liberar Log"  => 67140.00000,
    "A Carregar"     => 22176.00000,
    "A Faturar"      => 41428.00000,
    "A Entregar"     => 0.00000,
];

$jfase = [
    0 => 128,
    1 => 1,
    2 => 378,
    3 => 486,
    4 => 203,
    5 => 72,
    6 => 47,
    7 => 8125,
    8 => 58,
];

// Helpers
function fmt_num($v, $dec = 2) { return number_format($v, $dec, ',', '.'); }
$totalMetricas = array_sum($metricas);
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
<meta charset="utf-8" />
<meta name="viewport" content="width=device-width, initial-scale=1" />
<title>Dashboard Simples</title>
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700&display=swap" rel="stylesheet">
<style>
  :root{
    --bg:#0f172a;        /* slate-900 */
    --panel:#111827;     /* gray-900 */
    --card:#0b1220;      /* custom dark */
    --muted:#94a3b8;     /* slate-400 */
    --text:#e5e7eb;      /* gray-200 */
    --accent:#22d3ee;    /* cyan-400 */
    --ring:#1f2937;      /* gray-800 */
    --ok:#10b981;        /* emerald-500 */
    --warn:#f59e0b;      /* amber-500 */
    --err:#ef4444;       /* red-500 */
    --info:#60a5fa;      /* blue-400 */
  }
  *{box-sizing:border-box}
  html,body{margin:0;height:100%;background:radial-gradient(1200px 700px at 80% -10%, #1e293b 0%, #0b1020 60%, var(--bg) 100%);}
  body{font-family:Inter, system-ui, -apple-system, Segoe UI, Roboto, "Helvetica Neue", Arial; color:var(--text);}
  .wrap{max-width:1200px;margin:0 auto;padding:24px}
  header{display:flex;gap:16px;align-items:center;margin-bottom:20px}
  .logo{width:12px;height:12px;border-radius:999px;background:linear-gradient(135deg, var(--accent), #6366f1);box-shadow:0 0 24px rgba(34,211,238,.5)}
  h1{font-size:20px;margin:0}
  .muted{color:var(--muted)}
  .cards{display:grid;grid-template-columns:repeat(5,1fr);gap:12px}
  @media (max-width:1100px){.cards{grid-template-columns:repeat(3,1fr)}}
  @media (max-width:700px){.cards{grid-template-columns:repeat(2,1fr)}}
  @media (max-width:480px){.cards{grid-template-columns:1fr}}
  .card{
    background:linear-gradient(180deg, rgba(255,255,255,.04), rgba(255,255,255,.02));
    border:1px solid rgba(148,163,184,.15);
    border-radius:16px;padding:14px 14px 12px;
    box-shadow:0 10px 25px rgba(2,6,23,.35), 0 1px 0 rgba(255,255,255,.04) inset;
    transition:transform .2s ease, box-shadow .2s ease, border-color .2s ease;
  }
  .card:hover{transform:translateY(-2px);box-shadow:0 16px 40px rgba(2,6,23,.45), 0 1px 0 rgba(255,255,255,.06) inset;border-color:rgba(34,211,238,.35)}
  .card h3{margin:0 0 6px;font-size:12px;letter-spacing:.2px;color:var(--muted);font-weight:600;text-transform:uppercase}
  .value{font-size:22px;font-weight:700;line-height:1.1}
  .trend{font-size:12px;margin-top:6px;color:var(--muted)}
  .grid{
    margin-top:18px;
    display:grid;grid-template-columns:2fr 1fr;gap:16px
  }
  @media (max-width:1000px){.grid{grid-template-columns:1fr}}
  .panel{
    background:linear-gradient(180deg, rgba(255,255,255,.04), rgba(255,255,255,.02));
    border:1px solid rgba(148,163,184,.15);border-radius:16px;padding:16px;
    box-shadow:0 10px 25px rgba(2,6,23,.35), 0 1px 0 rgba(255,255,255,.04) inset;
  }
  .panel h2{font-size:14px;margin:0 0 10px;color:var(--muted);text-transform:uppercase;letter-spacing:.2px}
  canvas{width:100%;height:420px;max-height:50vh}
  table{width:100%;border-collapse:collapse;font-size:14px}
  th,td{padding:10px 8px;border-bottom:1px solid rgba(148,163,184,.12)}
  th{color:var(--muted);text-align:left;font-weight:600}
  tr:hover td{background:rgba(148,163,184,.05)}
  .pill{display:inline-block;padding:4px 8px;border-radius:999px;font-size:12px;border:1px solid rgba(148,163,184,.25);color:var(--muted)}
  .footer{margin-top:16px;color:var(--muted);font-size:12px;text-align:center}
</style>
</head>
<body>
  <div class="wrap">
    <header>
      <div class="logo"></div>
      <h1>Dashboard Operacional</h1>
      <div class="muted">Resumo atual</div>
    </header>

    <!-- Cards de Mtricas -->
    <section class="cards">
      <?php foreach ($metricas as $nome => $valor): ?>
        <div class="card">
          <h3><?= htmlspecialchars($nome) ?></h3>
          <div class="value"><?= fmt_num($valor, 2) ?></div>
          <div class="trend">
            Participao no total:
            <span class="pill">
              <?= $totalMetricas > 0 ? fmt_num(($valor / $totalMetricas) * 100, 1) : '0,0' ?>%
            </span>
          </div>
        </div>
      <?php endforeach; ?>
    </section>

    <!-- Grficos + Tabela -->
    <section class="grid">
      <div class="panel">
        <h2>Distribuio por JFASE (Barra)</h2>
        <canvas id="barJfase" aria-label="Grfico de barras por JFASE" role="img"></canvas>
      </div>
      <div class="panel">
        <h2>Status (Pizza)</h2>
        <canvas id="pieStatus" aria-label="Grfico de pizza de status" role="img"></canvas>
      </div>
    </section>

    <!-- Tabela detalhada -->
    <section class="panel" style="margin-top:16px;">
      <h2>Detalhe JFASE</h2>
      <table>
        <thead>
          <tr>
            <th>JFASE</th>
            <th>Quantidade</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach ($jfase as $fase => $qtd): ?>
            <tr>
              <td><span class="pill"><?= (int)$fase ?></span></td>
              <td><?= number_format($qtd, 0, ',', '.') ?></td>
            </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
      <div class="footer">
        Total de registros: <strong><?= number_format(array_sum($jfase), 0, ',', '.') ?></strong>
      </div>
    </section>
  </div>

  <script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.0/dist/chart.umd.min.js"></script>
  <script>
    // ========= Dados do PHP para JS =========
    const metricasLabels = <?= json_encode(array_keys($metricas), JSON_UNESCAPED_UNICODE) ?>;
    const metricasData   = <?= json_encode(array_values($metricas)) ?>;

    const jfaseLabels = <?= json_encode(array_keys($jfase)) ?>;
    const jfaseData   = <?= json_encode(array_values($jfase)) ?>;

    // ========= Grfico de Barras (JFASE) =========
    const ctxBar = document.getElementById('barJfase').getContext('2d');
    const barChart = new Chart(ctxBar, {
      type: 'bar',
      data: {
        labels: jfaseLabels,
        datasets: [{
          label: 'QUANTIDADE',
          data: jfaseData,
          borderWidth: 1
        }]
      },
      options: {
        responsive: true,
        maintainAspectRatio: false,
        scales: {
          x: {
            grid: { color: 'rgba(148,163,184,0.15)' },
            ticks: { color: '#cbd5e1' }
          },
          y: {
            beginAtZero: true,
            grid: { color: 'rgba(148,163,184,0.12)' },
            ticks: { color: '#cbd5e1' }
          }
        },
        plugins: {
          legend: { labels: { color: '#cbd5e1' } },
          tooltip: {
            callbacks: {
              label: ctx => ` ${ctx.dataset.label}: ${ctx.formattedValue}`
            }
          }
        }
      }
    });

    // ========= Grfico de Pizza (Status) =========
    const ctxPie = document.getElementById('pieStatus').getContext('2d');
    const pieChart = new Chart(ctxPie, {
      type: 'doughnut',
      data: {
        labels: metricasLabels,
        datasets: [{
          data: metricasData,
          borderWidth: 1
        }]
      },
      options: {
        responsive: true,
        maintainAspectRatio: false,
        cutout: '60%',
        plugins: {
          legend: {
            position: 'bottom',
            labels: { color: '#cbd5e1', boxWidth: 14 }
          },
          tooltip: {
            callbacks: {
              label: function(ctx){
                const total = ctx.dataset.data.reduce((a,b)=>a+Number(b),0);
                const val = Number(ctx.parsed);
                const pct = total ? (val/total*100).toFixed(1) : 0;
                return ` ${ctx.label}: ${val.toLocaleString('pt-BR')} (${pct}%)`;
              }
            }
          }
        }
      }
    });
  </script>
</body>
</html>
