<?php
set_time_limit(300);
$psDoc      = $_GET['sDoc'];
$psCliPasta = $_GET['sCliPasta'];
$psMarcados = $_GET['sMarcados'];

$psTpSaida  = isset($_GET['sTpSaida']) ? $_GET['sTpSaida'] : 'HTML';  // HTML ou EXCEL
$lbExcel    = ($psTpSaida==='EXCEL');

require_once("../pFuncoes1.php");
require_once("../pPublics1.php");

set_error_handler('fsErro');

list($iUsec, $iSec) = explode(' ', microtime());
$tScript_Start = (float) $iSec + (float) $iUsec;

$aTop      = faLoadAvgServer();
$nTopIni   = $aTop[0];
$tJobStart = time();
$sProc     = basename(__FILE__);
$iProcID   = getmypid();
$aUserLog  = array();

$sEcoNome = str_replace('.','_',$sProc).'_'.time().'.log';
$sEcoTxt  = '/qtux/www/FullPlat/processos/logs/'.$sEcoNome;
$sEcoTxt  = fsDirEcoTxt($sEcoTxt);

$sFileConfig = "../../$psCliPasta/dd_files/Business.ddini";

fpc($sEcoTxt,'Incio em ' . date('d/m/Y H:i:s',$tJobStart));
fpc_append($sEcoTxt,"psCliPasta=$psCliPasta, iProcID=$iProcID");
fpc_append($sEcoTxt,"sFileConfig=$sFileConfig");

if (file_exists($sFileConfig)) {
   $sTxt = fsTXTFiltrar($sFileConfig);
   $aArr = explode(chr(10),$sTxt);
   $sVarsTxt = '';
   foreach ($aArr as $sLin) {
      $aLin = explode('//',$sLin);
      $sLin = trim($aLin[0]);
      $iLin = strlen($sLin);
      if ($iLin>0) {
         $aLin = explode('=',$sLin);
         $s1 = trim($aLin[0]);
         $iLin = count($aLin);
         if ($iLin>1) $s2 = trim($aLin[1]);
         else         $s2 = '';
         $s  = '$'.$s1." = '".$s2."';";
         eval($s);   // criando uma var
         $sVarsTxt .= $s . chr(10);
      }
   }
   fpc_append($sEcoTxt,"psMarcados=$psMarcados");
   $iLen = strlen($psMarcados);
   $psMarcados = substr($psMarcados,1,$iLen-1);
   fpc_append($sEcoTxt,"psMarcados=$psMarcados");
   $psMarcados = substr($psMarcados,0,$iLen-2);
   fpc_append($sEcoTxt,"psMarcados=$psMarcados");
   $psMarcados = str_replace('/',',',$psMarcados);
   fpc_append($sEcoTxt,"psMarcados=$psMarcados");

   if ($psMarcados!='') {
      $sDoc = $psMarcados;
   } else {
      $sDoc = $psDoc;
   }

   $sDataIni = date('d/m/Y H:i:s');
   fpc_append($sEcoTxt,"Inicio $sDataIni");
   
   $sDSN = "$sHost:$sPathDB/$sDB";
   $hDb  = fhDbConnect($sDSN);
   $sSql = "select b.pISRegFis,
                   b.fISRegFis,
                   b.pRegFisIBS,
                   b.fRegFisIBS,
                   b.pRegFisIBSMun,
                   b.fRegFisIBSMun,
                   b.pRegFisCBS,
                   b.fRegFisCBS,

                   b.nIS_vBCIS,
                   b.nIS_pIS,
                   b.nIS_pISEspec,
                   b.sIS_uTrib,
                   b.nIS_qTrib,
                   b.nIS_vIS,

                   b.nIBSCBS_vBC,
                   b.nIBSCBS_vIBS,

                   b.nIBSUF_pIBSUF,
                   b.nIBSUF_pDif,
                   b.nIBSUF_vDif,
                   b.nIBSUF_vDevTrib,
                   b.nIBSUF_pRedAliq,
                   b.nIBSUF_pAliqEfet,
                   b.nIBSUF_vIBSUF,

                   b.nIBSMun_pIBSMun,
                   b.nIBSMun_pDif,
                   b.nIBSMun_vDif,
                   b.nIBSMun_vDevTrib,
                   b.nIBSMun_pRedAliq,
                   b.nIBSMun_pAliqEfet,
                   b.nIBSMun_vIBSMun,

                   b.nCBS_pCBS,
                   b.nCBS_pDif,
                   b.nCBS_vDif,
                   b.nCBS_vDevTrib,
                   b.nCBS_pRedAliq,
                   b.nCBS_pAliqEfet,
                   b.nCBS_vCBS,

                   b.pItem,

                   c.sCodigo     sCodItem,
                   c.sDescricao  sItem,

                   d.sCodigo sUniCod,
                   d.jDec,

                   a.pPId,

                   e.sSigla,
                   f.sCoringa sDest,
                   iif(f.jTipo=2,f.sCNPJ,f.sCPF) sDoc
   
              from Ordens a left join Ordens_Itens  b on b.pOrdem = a.pPId and b.iVer = b.iVAt and b.lExc = 0
                            left join Itens         c on b.pItem  = c.pPId and c.iVer = c.iVAt and c.lExc = 0
                            left join UnidadeMedida d on b.pUni   = d.pPId and d.iVer = d.iVAt
                            left join CUP           e on a.pEmi   = e.pPId and e.iVer = a.fEmi
                            left join CUP           f on a.pDest  = f.pPId and f.iVer = a.fDest
   
             where a.iVer = a.iVAt and a.lExc = 0 and a.pPId in ($sDoc)
             order by a.pPId";
   $aDb = faDBSelect($hDb,$sSql);
   $iDb = count($aDb);

   if ($lbExcel) {
      require('/qtux/library/PHPExcel-1.8/Classes/PHPExcel.php');

      $oPHPExcel = new PHPExcel();
      $oPHPExcel->setActiveSheetIndex(0);
      $oSheet    = $oPHPExcel->getActiveSheet();
      $oSheet->setTitle('Impostos');

      // Cabealho da planilha
      $iRowExcel = 1;
      $oSheet->setCellValue('A'.$iRowExcel, 'Ordem');
      $oSheet->setCellValue('B'.$iRowExcel, 'Item');
      $oSheet->setCellValue('C'.$iRowExcel, 'Cod. Item');
      $oSheet->setCellValue('D'.$iRowExcel, 'Descrio');
      $oSheet->setCellValue('E'.$iRowExcel, 'Unid.');
      $oSheet->setCellValue('F'.$iRowExcel, 'Qtd. Trib.');
      $oSheet->setCellValue('G'.$iRowExcel, 'vBC IS');
      $oSheet->setCellValue('H'.$iRowExcel, 'vIS');
      $oSheet->setCellValue('I'.$iRowExcel, 'vBC IBS/CBS');
      $oSheet->setCellValue('J'.$iRowExcel, 'vIBS CBS');
      $oSheet->setCellValue('K'.$iRowExcel, 'vIBS UF');
      $oSheet->setCellValue('L'.$iRowExcel, 'vIBS Mun');
      $oSheet->setCellValue('M'.$iRowExcel, 'vCBS');

      // Larguras de colunas (ajuste conforme necessrio)
      $oSheet->getColumnDimension('A')->setAutoSize(true);
      $oSheet->getColumnDimension('B')->setAutoSize(true);
      $oSheet->getColumnDimension('C')->setAutoSize(true);
      $oSheet->getColumnDimension('D')->setAutoSize(true);
      $oSheet->getColumnDimension('E')->setAutoSize(true);
      $oSheet->getColumnDimension('F')->setAutoSize(true);
      $oSheet->getColumnDimension('G')->setAutoSize(true);
      $oSheet->getColumnDimension('H')->setAutoSize(true);
      $oSheet->getColumnDimension('I')->setAutoSize(true);
      $oSheet->getColumnDimension('J')->setAutoSize(true);
      $oSheet->getColumnDimension('K')->setAutoSize(true);
      $oSheet->getColumnDimension('L')->setAutoSize(true);
      $oSheet->getColumnDimension('M')->setAutoSize(true);
   }

   $sTable = '';
   
   $pOrdemAnt = 0;
   $iLoop = 0;
   foreach ($aDb as $aLin) {
      $iLoop++;
      $pISRegFis         = $aLin[0];
      $fISRegFis         = $aLin[1];
      $pRegFisIBS        = $aLin[2];
      $fRegFisIBS        = $aLin[3];
      $pRegFisIBSMun     = $aLin[4];
      $fRegFisIBSMun     = $aLin[5];
      $pRegFisCBS        = $aLin[6];
      $fRegFisCBS        = $aLin[7];
   
      $nIS_vBCIS         = number_format($aLin[8],2,",",".");
      $nIS_pIS           = number_format($aLin[9],2,",",".");
      $nIS_pISEspec      = number_format($aLin[10],2,",",".");
      $sIS_uTrib         = $aLin[11];
      $nIS_qTrib         = number_format($aLin[12],2,",",".");
      $nIS_vIS           = number_format($aLin[13],2,",",".");
   
      $nIBSCBS_vBC       = number_format($aLin[14],2,",",".");
      $nIBSCBS_vIBS      = number_format($aLin[15],2,",",".");
   
      $nIBSUF_pIBSUF     = number_format($aLin[16],2,",",".");
      $nIBSUF_pDif       = number_format($aLin[17],2,",",".");
      $nIBSUF_vDif       = number_format($aLin[18],2,",",".");
      $nIBSUF_vDevTrib   = number_format($aLin[19],2,",",".");
      $nIBSUF_pRedAliq   = number_format($aLin[20],2,",",".");
      $nIBSUF_pAliqEfet  = number_format($aLin[21],2,",",".");
      $nIBSUF_vIBSUF     = number_format($aLin[22],2,",",".");
   
      $nIBSMun_pIBSMun   = number_format($aLin[23],2,",",".");
      $nIBSMun_pDif      = number_format($aLin[24],2,",",".");
      $nIBSMun_vDif      = number_format($aLin[25],2,",",".");
      $nIBSMun_vDevTrib  = number_format($aLin[26],2,",",".");
      $nIBSMun_pRedAliq  = number_format($aLin[27],2,",",".");
      $nIBSMun_pAliqEfet = number_format($aLin[28],2,",",".");
      $nIBSMun_vIBSMun   = number_format($aLin[29],2,",",".");
   
      $nCBS_pCBS         = number_format($aLin[30],2,",",".");
      $nCBS_pDif         = number_format($aLin[31],2,",",".");
      $nCBS_vDif         = number_format($aLin[32],2,",",".");
      $nCBS_vDevTrib     = number_format($aLin[33],2,",",".");
      $nCBS_pRedAliq     = number_format($aLin[34],2,",",".");
      $nCBS_pAliqEfet    = number_format($aLin[35],2,",",".");
      $nCBS_vCBS         = number_format($aLin[36],2,",",".");       

      $pItem             = isset($aLin[37]) ? $aLin[37] : 0;

      $sCodItem          = $aLin[38];
      $sDescItem         = $aLin[39];

      $sUniCod           = $aLin[40];
      $jDec              = $aLin[41];

      $pOrdem            = $aLin[42];
      $sEmi              = $aLin[43];
      $sDest             = $aLin[44];
      $sDoc              = $aLin[45];
   
      fpc_append($sEcoTxt, "iDb=$iDb, iLoop=$iLoop, pOrdemAnt=$pOrdemAnt, pOrdem=$pOrdem, pItem=$pItem");
   

      if ($lbExcel) {
         $iRowExcel++;
         // Usamos os valores brutos de $aLin para manter nmeros corretos
         $oSheet->setCellValue('A'.$iRowExcel, $aLin[42]); // Ordem
         $oSheet->setCellValue('B'.$iRowExcel, $aLin[37]); // Item
         $oSheet->setCellValue('C'.$iRowExcel, $aLin[38]); // Cod Item
         $oSheet->setCellValue('D'.$iRowExcel, $aLin[39]); // Descrio
         $oSheet->setCellValue('E'.$iRowExcel, $aLin[40]); // Unidade
         $oSheet->setCellValue('F'.$iRowExcel, $aLin[12]); // Quantidade tributada
         $oSheet->setCellValue('G'.$iRowExcel, $aLin[8]);  // vBC IS
         $oSheet->setCellValue('H'.$iRowExcel, $aLin[13]); // vIS
         $oSheet->setCellValue('I'.$iRowExcel, $aLin[14]); // vBC IBS/CBS
         $oSheet->setCellValue('J'.$iRowExcel, $aLin[15]); // vIBS CBS
         $oSheet->setCellValue('K'.$iRowExcel, $aLin[22]); // vIBS UF
         $oSheet->setCellValue('L'.$iRowExcel, $aLin[29]); // vIBS Mun
         $oSheet->setCellValue('M'.$iRowExcel, $aLin[36]); // vCBS
      }

      // SE MUDOU A ORDEM E NO  O PRIMEIRO REGISTRO . FECHA A TABELA ANTERIOR
      if ($pOrdemAnt>0 && $pOrdemAnt!=$pOrdem) {
         $sTable .= '</table>';
      }
   
      if ($iLoop==0 || $pOrdemAnt!=$pOrdem) {
         fpc_append($sEcoTxt, "Vai colocar o <table ....>");
         $sTable .= '<table cellspacing="0" cellpadding="0" cellmargin="1" style="margin:5pt; font-family: verdana; font-size: 10px; color: inherit; width: 100%;" class="qtux-modal-table">
             <tr>
               <td style="border-top: 1px solid #000; border-left: 1px solid #000; border-right: none; text-align: left;"><b>Ordem</b></td>
               <td style="border-top: 1px solid #000; text-align: left;">:</td>
               <td colspan="40" style="border-top: 1px solid #000; border-right: 1px solid #000; text-align: left;">'.$pOrdem.'</td>
             </tr>
             <tr>
               <td style="border-left: 1px solid #000; text-align: left;"><b>Emissor</b></td>
               <td style="text-align: left;">:</td>
               <td colspan="40" style="border-right: 1px solid #000; text-align: left;">'.$sEmi.'</td>
            </tr>
            <tr>
               <td style="border-bottom: 1px solid #000; border-left: 1px solid #000; text-align: left;"><b>Destinatario</b></td>
               <td style="border-bottom: 1px solid #000; text-align: left;">:</td>
               <td colspan="40" style="border-bottom: 1px solid #000; border-right: 1px solid #000; text-align: left;">['.$sDoc.'] - '.$sDest.'</td>
            </tr>';
      }

      if ($pItem==0) {
         $sTable .= '
            <tr>
               <td style="border-top: 1px solid #000; border-bottom: 1px solid #000; border-left: 1px solid #000; border-right: none; text-align: left;"><b>Item</b></td>
               <td style="border-top: 1px solid #000; border-bottom: 1px solid #000; border-left: none; border-right: none; text-align: left;">:</td>
               <td colspan="40" style="border-top: 1px solid #000; border-bottom: 1px solid #000; border-left: none; border-right: 1px solid #000; text-align: left;">ORDEM SEM ITEM</td>
            </tr>';

      } else {
         
         $sTable .= '
            <tr>
               <td style="border-top: 1px solid #000; border-bottom: 1px solid #000; border-left: 1px solid #000; border-right: none; text-align: left;"><b>Item</b></td>
               <td style="border-top: 1px solid #000; border-bottom: 1px solid #000; border-left: none; border-right: none; text-align: left;">:</td>
               <td colspan="40" style="border-top: 1px solid #000; border-bottom: 1px solid #000; border-left: none; border-right: 1px solid #000; text-align: left;">'.$sCodItem.'-'.$sDescItem.'</td>
            </tr>
         
            <!-- Cabealhos das duas colunas -->
            <tr>
               <td colspan="3" style="border-bottom: 1px dashed #000; border-left: 1px solid #000; text-align: left; font-size: 10px;"><b>Politicas ID</b></td>
               <td colspan="3" style="border-bottom: 1px dashed #000; text-align: left; font-size: 10px;"><b>IS Aliquotas</b></td>
               <td colspan="3" style="border-bottom: 1px dashed #000; text-align: left; font-size: 10px;"><b>IS Valores</b></td>
               <td colspan="3" style="border-bottom: 1px dashed #000; text-align: left; font-size: 10px;"><b>IBS/CBS</b></td>
               <td colspan="3" style="border-bottom: 1px dashed #000; text-align: left; font-size: 10px;"><b>IBSUF Aliquotas</b></td>
               <td colspan="3" style="border-bottom: 1px dashed #000; text-align: left; font-size: 10px;"><b>IBSUF Valores</b></td>
               <td colspan="3" style="border-bottom: 1px dashed #000; text-align: left; font-size: 10px;"><b>IBSMun Aliquotas</b></td>
               <td colspan="3" style="border-bottom: 1px dashed #000; text-align: left; font-size: 10px;"><b>IBSMun Valores</b></td>
               <td colspan="3" style="border-bottom: 1px dashed #000; text-align: left; font-size: 10px;"><b>IBSUF + IBSMun</b></td>
               <td colspan="3" style="border-bottom: 1px dashed #000; text-align: left; font-size: 10px;"><b>CBS Aliquotas</b></td>
               <td colspan="3" style="border-bottom: 1px dashed #000; border-right: 1px solid #000; text-align: left; font-size: 10px;"><b>CBS Valores</b></td>
            </tr>
         
            <!-- Linha 1 -->
            <tr>
               <!-- Ponteiros -> pRegFisIS -->
               <td style="border-left: 1px solid #000; text-align: left; width:  5px;"><b>IS</b></td>
               <td style="text-align: left; width:  5px;">&nbsp;:&nbsp;</td>
               <td style="text-align: left;">'.($pISRegFis>0 ? $pISRegFis.'/'.$fISRegFis : 0).'</td>
         
               <!-- IS Aliquotas -> %BC -->
               <td style="border-left: 1px solid #000; text-align: left; width: 60px;"><b>%BC</b></td>
               <td style="text-align: left; width:  5px;">&nbsp;:&nbsp;</td>
               <td style="text-align: left;">'.$nIS_vBCIS.'</td>
         
               <!-- IS Valores ->  Un Med Trib -->
               <td style="border-left: 1px solid #000; text-align: left; width: 70px;"><b>Un Trib</b></td>
               <td style="text-align: left; width:  5px;">&nbsp;:&nbsp;</td>
               <td style="text-align: left;">'.$sIS_uTrib.'</td>
         
               <!-- IBS/CBS ->  %BC  -->
               <td style="border-left: 1px solid #000; text-align: left; width: 10px;"><b>%BC</b></td>
               <td style="text-align: left; width: 10px;">&nbsp;:&nbsp;</td>
               <td style="text-align: left; ">'.$nIBSCBS_vBC.'</td>
         
               <!-- IBSUF Aliquotas -> Comp UF -->
               <td style="border-left: 1px solid #000; text-align: left; width: 90px;"><b>% Comp UF</b></td>
               <td style="text-align: left; width:  5px;">&nbsp;:&nbsp;</td>
               <td style="text-align: left; ">'.$nIBSUF_pIBSUF.'</td>
         
               <!-- IBSUF Valores -> Val Dif -->
               <td style="border-left: 1px solid #000; text-align: left; width: 75px;"><b>Dif</b></td>
               <td style="text-align: left; width:  5px;">&nbsp;:&nbsp;</td>
               <td style="text-align: left; ">'.$nIBSUF_vDif.'</td>
         
               <!-- IBSMun Aliquotas -> %Comp Mun-->
               <td style="border-left: 1px solid #000; text-align: left; width: 90px;"><b>%Comp Mun</b></td>
               <td style="text-align: left; width:  5px;">&nbsp;:&nbsp;</td>
               <td style="text-align: left; ">'.$nIBSMun_pIBSMun.'</td>
         
               <!-- IBSMun Valores -> Val Dif-->
               <td style="border-left: 1px solid #000; text-align: left; width: 80px;"><b>Dif</b></td>
               <td style="text-align: left; width:  5px;">&nbsp;:&nbsp;</td>
               <td style="text-align: left; ">'.$nIBSMun_vDif.'</td>
         
               <!-- IBSUF + IBSMun -> Total-->
               <td style="border-left: 1px solid #000; text-align: left; width: 25px;"><b>Total</b></td>
               <td style="text-align: left; width:  5px;">&nbsp;:&nbsp;</td>
               <td style="text-align: left; ">'.$nIBSCBS_vIBS.'</td>
         
               <!-- CBS Aliquotas -> %CBS -->
               <td style="border-left: 1px solid #000; text-align: left; width: 85px;"><b>%CBS</b></td>
               <td style="text-align: left; width:  5px;">&nbsp;:&nbsp;</td>
               <td style="text-align: left; ">'.$nCBS_pCBS.'</td>
         
               <!-- CBS Valores -> Val Dif -->
               <td style="border-left: 1px solid #000; text-align: left; width:  70px;"><b>Dif</b></td>
               <td style="text-align: left; width:  5px;">&nbsp;:&nbsp;</td>
               <td style="text-align: left; border-right: 1px solid #000;">'.$nCBS_vDif.'</td>
         
            </tr>
         
            <!-- Linha 2 -->
            <tr>
               <!-- Ponteiros -> pRegFisIBS -->
               <td style="border-left: 1px solid #000; text-align: left; width:  5px;"><b>IBS</b></td>
               <td style="text-align: left; width:  5px;">&nbsp;:&nbsp;</td>
               <td style="text-align: left;">'.($pRegFisIBS>0 ? $pRegFisIBS.'/'.$fRegFisIBS : 0).'</td>
               
               <!-- IS Aliquotas -> %IS -->
               <td style="border-left: 1px solid #000; text-align: left; width: 60px;"><b>%IS</b></td>
               <td style="text-align: left; width:  5px;">&nbsp;:&nbsp;</td>
               <td style="text-align: left;">'.$nIS_pIS.'</td>
         
               <!-- IS Valores ->  Qtde Trib-->
               <td style="border-left: 1px solid #000; text-align: left; width: 60px;"><b>Qtde Trib</b></td>
               <td style="text-align: left; width:  5px;">&nbsp;:&nbsp;</td>
               <td style="text-align: left;">'.$nIS_qTrib.'</td>
         
               <!-- IBS/CBS -> Clulas vazias na coluna  -->
               <td style="border-left: 1px solid #000;"></td>
               <td></td>
               <td></td>
         
               <!-- IBSUF Aliquotas -> % Dif -->
               <td style="border-left: 1px solid #000; text-align: left; width: 90px;"><b>% Dif</b></td>
               <td style="text-align: left; width:  5px;">&nbsp;:&nbsp;</td>
               <td style="text-align: left; ">'.$nIBSUF_pDif.'</td>
         
               <!-- IBSUF Valores -> Val Trib Dev-->
               <td style="border-left: 1px solid #000; text-align: left; width: 75px;"><b>Trib Dev</b></td>
               <td style="text-align: left; width:  5px;">&nbsp;:&nbsp;</td>
               <td style="text-align: left; ">'.$nIBSUF_vDevTrib.'</td>
         
               <!-- IBSMun Aliquotas -> %Dif-->
               <td style="border-left: 1px solid #000; text-align: left; width: 90px;"><b>%Dif</b></td>
               <td style="text-align: left; width:  5px;">&nbsp;:&nbsp;</td>
               <td style="text-align: left; ">'.$nIBSMun_pDif.'</td>
         
               <!-- IBSMun Valores -> Val Trib Dev-->
               <td style="border-left: 1px solid #000; text-align: left; width: 80px;"><b>Trib Dev</b></td>
               <td style="text-align: left; width:  5px;">&nbsp;:&nbsp;</td>
               <td style="text-align: left; ">'.$nIBSMun_vDevTrib.'</td>
         
               <!-- IBSUF + IBSMun -> Clulas vazias na coluna -->
               <td style="border-left: 1px solid #000;"></td>
               <td></td>
               <td></td>
               
               <!-- CBS Aliquotas -> %Dif -->
               <td style="border-left: 1px solid #000; text-align: left; width: 85px;"><b>%Dif</b></td>
               <td style="text-align: left; width:  5px;">&nbsp;:&nbsp;</td>
               <td style="text-align: left; ">'.$nCBS_pDif.'</td>
         
               <!-- CBS Valores -> Val Trib Dev -->
               <td style="border-left: 1px solid #000; text-align: left; width: 70px;"><b>Trib Dev</b></td>
               <td style="text-align: left; width:  5px;">&nbsp;:&nbsp;</td>
               <td style="text-align: left; border-right: 1px solid #000;">'.$nCBS_vDevTrib.'</td>
         
            </tr>
         
            <!-- Linha 3 -->
            <tr>
               <!-- Ponteiros -> pRegFisIBSMun -->
               <td style="border-left: 1px solid #000; text-align: left; width:  5px;"><b>IBSMun</b></td>
               <td style="text-align: left; width:  5px;">&nbsp;:&nbsp;</td>
               <td style="text-align: left;">'.($pRegFisIBSMun>0 ? $pRegFisIBSMun.'/'.$fRegFisIBSMun : 0).'</td>
         
               <!-- IS Aliquotas -> %Un Apro -->
               <td style="border-left: 1px solid #000; text-align: left; width: 60px;"><b>%Un Apro</b></td>
               <td style="text-align: left; width:  5px;">&nbsp;:&nbsp;</td>
               <td style="text-align: left;">'.$nIS_pISEspec.'</td>
         
               <!-- IS Valores ->  Valor -->
               <td style="border-left: 1px solid #000; text-align: left; width: 60px;"><b>Valor</b></td>
               <td style="text-align: left; width:  5px;">&nbsp;:&nbsp;</td>
               <td style="text-align: left;">'.$nIS_vIS.'</td>
         
               <!-- IBS/CBS -> Clulas vazias na coluna  -->
               <td style="border-left: 1px solid #000; text-align: left; width:  60px;">&nbsp;</td>
               <td style="text-align: left; width:  5px;">&nbsp;</td>
               <td style="text-align: left; width:  5px;">&nbsp;</td>
         
               <!-- IBSUF Aliquotas -> % Red Aliq cCT  -->
               <td style="border-left: 1px solid #000; text-align: left; width: 90px;"><b>% Red Aliq cCT</b></td>
               <td style="text-align: left; width:  5px;">&nbsp;:&nbsp;</td>
               <td style="text-align: left; ">'.$nIBSUF_pRedAliq.'</td>
         
               <!-- IBSUF Valores -> Val Comp UF -->
               <td style="border-left: 1px solid #000; text-align: left; width: 75px;"><b>Comp UF</b></td>
               <td style="text-align: left; width:  5px;">&nbsp;:&nbsp;</td>
               <td style="text-align: left; ">'.$nIBSUF_vIBSUF.'</td>
         
               <!-- IBSMun Aliquotas -> %Red Aliq cCT-->
               <td style="border-left: 1px solid #000; text-align: left; width: 90px;"><b>%Red Aliq cCT</b></td>
               <td style="text-align: left; width:  5px;">&nbsp;:&nbsp;</td>
               <td style="text-align: left; ">'.$nIBSMun_pRedAliq.'</td>
         
               <!-- IBSMun Valores -> Val Comp Mun-->
               <td style="border-left: 1px solid #000; text-align: left; width: 90px;"><b>Comp Mun</b></td>
               <td style="text-align: left; width:  5px;">&nbsp;:&nbsp;</td>
               <td style="text-align: left; ">'.$nIBSMun_vIBSMun.'</td>
         
               <!-- IBSUF + IBSMun -> Clulas vazias na coluna -->
               <td style="border-left: 1px solid #000;"></td>
               <td></td>
               <td></td>
         
               <!-- CBS Aliquotas -> %Red Aliq cCT-->
               <td style="border-left: 1px solid #000; text-align: left; width: 85px;"><b>%Red Aliq cCT</b></td>
               <td style="text-align: left; width:  5px;">&nbsp;:&nbsp;</td>
               <td style="text-align: left; ">'.$nCBS_pRedAliq.'</td>      
         
               <!-- CBS Valores -> Valor -->
               <td style="border-left: 1px solid #000; text-align: left; width: 70px;"><b>Valor</b></td>
               <td style="text-align: left; width:  5px;">&nbsp;:&nbsp;</td>
               <td style="text-align: left; border-right: 1px solid #000;">'.$nCBS_vCBS.'</td>
         
            </tr>
         
            <!-- Linha 4: pRegFisCBS  x  (sem correspondente na direita) -->
            <tr>
               <!-- Ponteiros -> pRegFisCBS -->
               <td style="border-bottom: 1px solid #000; border-left: 1px solid #000; text-align: left; width:  5px;"><b>CBS</b></td>
               <td style="border-bottom: 1px solid #000; text-align: left; width:  5px;">&nbsp;:&nbsp;</td>
               <td style="border-bottom: 1px solid #000; text-align: left;">'.($pRegFisCBS>0 ? $pRegFisCBS.'/'.$fRegFisCBS : 0).'</td>
         
               <!-- IS Aliquotas -> Clulas vazias na coluna -->
               <td style="border-bottom: 1px solid #000; border-left: 1px solid #000;"></td>
               <td style="border-bottom: 1px solid #000;"></td>
               <td style="border-bottom: 1px solid #000;"></td>
         
               <!-- IS Valores ->   Clulas vazias na coluna -->
               <td style="border-bottom: 1px solid #000; border-left: 1px solid #000;"></td>
               <td style="border-bottom: 1px solid #000;"></td>
               <td style="border-bottom: 1px solid #000;"></td>
         
               <!-- IBS/CBS -> Clulas vazias na coluna  -->
               <td style="border-bottom: 1px solid #000; border-left: 1px solid #000;"></td>
               <td style="border-bottom: 1px solid #000;"></td>
               <td style="border-bottom: 1px solid #000;"></td>
         
               <!-- IBSUF Aliquotas -> % Comp UF BC -->
               <td style="border-bottom: 1px solid #000; border-left: 1px solid #000; text-align: left; width: 90px;"><b>% Comp UF BC</b></td>
               <td style="border-bottom: 1px solid #000; text-align: left; width:  5px;">&nbsp;:&nbsp;</td>
               <td style="border-bottom: 1px solid #000; text-align: left; ">'.$nIBSUF_pAliqEfet.'</td>
         
               <!-- IBSUF Valores -> Clulas vazias na coluna -->
               <td style="border-bottom: 1px solid #000; border-left: 1px solid #000;"></td>
               <td style="border-bottom: 1px solid #000;"></td>
               <td style="border-bottom: 1px solid #000;"></td>
         
               <!-- IBSMun Aliquotas -> %Comp Mun BC-->
               <td style="border-bottom: 1px solid #000; border-left: 1px solid #000; text-align: left; width: 91px;"><b>%Comp Mun BC</b></td>
               <td style="border-bottom: 1px solid #000; text-align: left; width:  5px;">&nbsp;:&nbsp;</td>
               <td style="border-bottom: 1px solid #000; text-align: left; ">'.$nIBSMun_pAliqEfet.'</td>
         
               <!-- IBSMun Valores -> Clulas vazias na coluna -->
               <td style="border-bottom: 1px solid #000; border-left: 1px solid #000;"></td>
               <td style="border-bottom: 1px solid #000;"></td>
               <td style="border-bottom: 1px solid #000;"></td>
         
               <!-- IBSUF + IBSMun -> Clulas vazias na coluna -->
               <td style="border-bottom: 1px solid #000; border-left: 1px solid #000;"></td>
               <td style="border-bottom: 1px solid #000;"></td>
               <td style="border-bottom: 1px solid #000;"></td>
               
               <!-- CBS Aliquotas -> %CBS BC-->
               <td style="border-bottom: 1px solid #000; border-left: 1px solid #000; text-align: left; width: 85px;"><b>%CBS BC</b></td>
               <td style="border-bottom: 1px solid #000; text-align: left; width:  5px;">&nbsp;:&nbsp;</td>
               <td style="border-bottom: 1px solid #000; text-align: left; ">'.$nCBS_pAliqEfet.'</td>
         
               <!-- CBS Valores -> Clulas vazias na coluna -->
               <td style="border-bottom: 1px solid #000; border-left: 1px solid #000;"></td>
               <td style="border-bottom: 1px solid #000;"></td>
               <td style="border-bottom: 1px solid #000; border-right: 1px solid #000;"></td>
         
            </tr>';
      } //    
      // SE  O LTIMO REGISTRO . FECHA A LTIMA TABELA
      if ($iLoop==$iDb) {
         $sTable .= '</table>';
      }
   
      $pOrdemAnt = $pOrdem;

   }
   fpc_append($sEcoTxt, $sTable);
   flDbDisconnect($hDb);

   if ($lbExcel) {
      // Sada em Excel usando PHPExcel
      // Header para Excel 97-2003 (.xls)
      header('Content-Type: application/vnd.ms-excel; charset=ISO-8859-1');
      header('Content-Disposition: attachment; filename=Impostos_OrdensI.xls');
      header('Cache-Control: max-age=0');

      $oWriter = PHPExcel_IOFactory::createWriter($oPHPExcel, 'Excel5');
      $oWriter->save('php://output');
      exit;
   } else {
      // Sada HTML para o modal
      echo utf8_encode($sTable);
   }




}