<?php
set_time_limit(300);
$psDoc       = $_GET['sDoc'];
$psCliPasta  = $_GET['sCliPasta'];
$psMarcados  = $_GET['sMarcados'];
$psTpSaida   = isset($_GET['sTpSaida']) ? $_GET['sTpSaida'] : 'HTML';  // HTML ou EXCEL
$lbExcel     = ($psTpSaida==='EXCEL');

$lTodasCores    = isset($_GET['lTodasCores']) ? intval($_GET['lTodasCores']) : 0;
$lCoresImpostos = isset($_GET['lCoresImpostos']) ? intval($_GET['lCoresImpostos']) : 0;


//$lTodasCores    = false;
//$lCoresImpostos = false;

require_once("../pFuncoes1.php");
require_once("../pPublics1.php");

set_error_handler('fsErro');

list($iUsec, $iSec) = explode(' ', microtime());
$tScript_Start = (float) $iSec + (float) $iUsec;

$aTop      = faLoadAvgServer();
$nTopIni   = $aTop[0];
$tJobStart = time();
$sProc     = basename(__FILE__);
$iProcID   = getmypid();
$aUserLog  = array();

$sEcoNome = str_replace('.','_',$sProc).'_'.time().'.log';
$sEcoTxt  = '/qtux/www/FullPlat/processos/logs/'.$sEcoNome;
$sEcoTxt  = fsDirEcoTxt($sEcoTxt);

$sFileConfig = "../../$psCliPasta/dd_files/Business.ddini";

fpc($sEcoTxt,'Incio em ' . date('d/m/Y H:i:s',$tJobStart));
fpc_append($sEcoTxt,"psCliPasta=$psCliPasta, iProcID=$iProcID");
fpc_append($sEcoTxt,"sFileConfig=$sFileConfig");

if (file_exists($sFileConfig)) {
   $sTxt = fsTXTFiltrar($sFileConfig);
   $aArr = explode(chr(10),$sTxt);
   $sVarsTxt = '';
   foreach ($aArr as $sLin) {
      $aLin = explode('//',$sLin);
      $sLin = trim($aLin[0]);
      $iLin = strlen($sLin);
      if ($iLin>0) {
         $aLin = explode('=',$sLin);
         $s1 = trim($aLin[0]);
         $iLin = count($aLin);
         if ($iLin>1) $s2 = trim($aLin[1]);
         else         $s2 = '';
         $s  = '$'.$s1." = '".$s2."';";
         eval($s);   // criando uma var
         $sVarsTxt .= $s . chr(10);
      }
   }
   fpc_append($sEcoTxt,"psMarcados=$psMarcados");
   $iLen = strlen($psMarcados);
   $psMarcados = substr($psMarcados,1,$iLen-1);
   fpc_append($sEcoTxt,"psMarcados=$psMarcados");
   $psMarcados = substr($psMarcados,0,$iLen-2);
   fpc_append($sEcoTxt,"psMarcados=$psMarcados");
   $psMarcados = str_replace('/',',',$psMarcados);
   fpc_append($sEcoTxt,"psMarcados=$psMarcados");

   if ($psMarcados!='') {
      $sDoc = $psMarcados;
   } else {
      $sDoc = $psDoc;
   }

   $sDataIni = date('d/m/Y H:i:s');
   fpc_append($sEcoTxt,"Inicio $sDataIni");
   
   $sDSN = "$sHost:$sPathDB/$sDB";
   $hDb  = fhDbConnect($sDSN);
   $sSql = "select b.pISRegFis,
                   b.fISRegFis,                
                   b.pRegFisIBS,
                   b.fRegFisIBS,
                   b.pRegFisIBSMun,
                   b.fRegFisIBSMun,
                   b.pRegFisCBS,
                   b.fRegFisCBS,

                   b.nIS_vBCIS,
                   b.nIS_pIS,
                   b.nIS_pISEspec,
                   b.sIS_uTrib,
                   b.nIS_qTrib,
                   b.nIS_vIS,

                   b.nIBSCBS_vBC,
                   b.nIBSCBS_vIBS,

                   b.nIBSUF_pIBSUF,
                   b.nIBSUF_pDif,
                   b.nIBSUF_vDif,
                   b.nIBSUF_vDevTrib,
                   b.nIBSUF_pRedAliq,
                   b.nIBSUF_pAliqEfet,
                   b.nIBSUF_vIBSUF,

                   b.nIBSMun_pIBSMun,
                   b.nIBSMun_pDif,
                   b.nIBSMun_vDif,
                   b.nIBSMun_vDevTrib,
                   b.nIBSMun_pRedAliq,
                   b.nIBSMun_pAliqEfet,
                   b.nIBSMun_vIBSMun,

                   b.nCBS_pCBS,
                   b.nCBS_pDif,
                   b.nCBS_vDif,
                   b.nCBS_vDevTrib,
                   b.nCBS_pRedAliq,
                   b.nCBS_pAliqEfet,
                   b.nCBS_vCBS,

                   b.pItem,

                   c.sCodigo     sCodItem,
                   c.sDescricao  sItem,

                   d.sCodigo sUniCod,
                   d.jDec,

                   a.pPId,

                   e.sSigla,
                   f.sCoringa sDest,
                   iif(f.jTipo=2,f.sCNPJ,f.sCPF) sDoc
   
              from Ordens a left join Ordens_Itens  b on b.pOrdem = a.pPId and b.iVer = b.iVAt and b.lExc = 0
                            left join Itens         c on b.pItem  = c.pPId and c.iVer = c.iVAt and c.lExc = 0
                            left join UnidadeMedida d on b.pUni   = d.pPId and d.iVer = d.iVAt
                            left join CUP           e on a.pEmi   = e.pPId and e.iVer = a.fEmi
                            left join CUP           f on a.pDest  = f.pPId and f.iVer = a.fDest
   
             where a.iVer = a.iVAt and a.lExc = 0 and a.pPId in ($sDoc)
             order by a.pPId";
   $aDb = faDBSelect($hDb,$sSql);
   $iDb = count($aDb);

   if ($lbExcel) {
      require('/qtux/library/PHPExcel-1.8/Classes/PHPExcel.php');

      $oPHPExcel = new PHPExcel();
      $oPHPExcel->getActiveSheet()->setShowGridlines(false);
      $oPHPExcel->setActiveSheetIndex(0);
      $oSheet    = $oPHPExcel->getActiveSheet();
      $oSheet->setTitle('Impostos');
      $iRowExcel = 1;
   }

   $sTable = '';
   
   $pOrdemAnt = 0;
   $iLoop = 0;
   foreach ($aDb as $aLin) {
      $iLoop++;
      $pISRegFis         = $aLin[0];
      $fISRegFis         = $aLin[1];
      $pRegFisIBS        = $aLin[2];
      $fRegFisIBS        = $aLin[3];
      $pRegFisIBSMun     = $aLin[4];
      $fRegFisIBSMun     = $aLin[5];
      $pRegFisCBS        = $aLin[6];
      $fRegFisCBS        = $aLin[7];
   
      $nIS_vBCIS         = $aLin[8];
      $nIS_pIS           = $aLin[9];
      $nIS_pISEspec      = $aLin[10];
      $sIS_uTrib         = $aLin[11];
      $nIS_qTrib         = $aLin[12];
      $nIS_vIS           = $aLin[13];
   
      $nIBSCBS_vBC       = $aLin[14];
      $nIBSCBS_vIBS      = $aLin[15];
   
      $nIBSUF_pIBSUF     = $aLin[16];
      $nIBSUF_pDif       = $aLin[17];
      $nIBSUF_vDif       = $aLin[18];
      $nIBSUF_vDevTrib   = $aLin[19];
      $nIBSUF_pRedAliq   = $aLin[20];
      $nIBSUF_pAliqEfet  = $aLin[21];
      $nIBSUF_vIBSUF     = $aLin[22];
   
      $nIBSMun_pIBSMun   = $aLin[23];
      $nIBSMun_pDif      = $aLin[24];
      $nIBSMun_vDif      = $aLin[25];
      $nIBSMun_vDevTrib  = $aLin[26];
      $nIBSMun_pRedAliq  = $aLin[27];
      $nIBSMun_pAliqEfet = $aLin[28];
      $nIBSMun_vIBSMun   = $aLin[29];
   
      $nCBS_pCBS         = $aLin[30];
      $nCBS_pDif         = $aLin[31];
      $nCBS_vDif         = $aLin[32];
      $nCBS_vDevTrib     = $aLin[33];
      $nCBS_pRedAliq     = $aLin[34];
      $nCBS_pAliqEfet    = $aLin[35];
      $nCBS_vCBS         = $aLin[36];

      $pItem             = isset($aLin[37]) ? $aLin[37] : 0;

      $sCodItem          = $aLin[38];
      $sDescItem         = $aLin[39];

      $sUniCod           = $aLin[40];
      $jDec              = $aLin[41];

      $pOrdem            = $aLin[42];
      $sEmi              = $aLin[43];
      $sDest             = $aLin[44];
      $sDoc              = $aLin[45];
   
      fpc_append($sEcoTxt, "iDb=$iDb, iLoop=$iLoop, pOrdemAnt=$pOrdemAnt, pOrdem=$pOrdem, pItem=$pItem");
   
      if ($lbExcel && ($pOrdemAnt == 0 || $pOrdemAnt != $pOrdem)) {
   
         // Linha em branco entre ordens (a partir da 2)
         if ($iRowExcel>0) {
            $iRowExcel++;
         }
   
         // Primeira linha do header dessa ordem
         $iRowExcel++;
         $iHeaderIni = $iRowExcel; // guarda onde comeou o bloco (para aplicar borda depois)
   
         // ORDEM
         $oSheet->setCellValue('B'.$iRowExcel, 'Ordem');
         $oSheet->mergeCells('C'.$iRowExcel.':L'.$iRowExcel);
         $oSheet->setCellValue('C'.$iRowExcel, $pOrdem);
   
         // EMISSOR
         $iRowExcel++;
         $oSheet->setCellValue('B'.$iRowExcel, 'Emissor');
         $oSheet->mergeCells('C'.$iRowExcel.':L'.$iRowExcel);
         $oSheet->setCellValue('C'.$iRowExcel, $sEmi);
   
         // DESTINATRIO
         $iRowExcel++;
         $oSheet->setCellValue('B'.$iRowExcel, utf8_encode('Destinatrio'));
         $oSheet->mergeCells('C'.$iRowExcel.':L'.$iRowExcel);
         $oSheet->setCellValue('C'.$iRowExcel, '['.$sDoc.'] - '.$sDest);
   
         $oSheet->getColumnDimension('B')->setAutoSize(true);
         $oSheet->getColumnDimension('C')->setAutoSize(true);
   
         // Estilos do bloco (A..M nas 3 linhas)
         $sRangeHeader = 'B'.$iHeaderIni.':L'.$iRowExcel;
   
         // Labels em negrito
         $oSheet->getStyle('B'.$iHeaderIni.':B'.$iRowExcel)->getFont()->setBold(true);
   
         // Alinhamento  esquerda (por segurana)
         $oSheet->getStyle($sRangeHeader)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);
   
         // Borda em volta do "caixote" e internas
         $oBorder = ['borders' => ['outline' => ['style' => PHPExcel_Style_Border::BORDER_THIN]]];
         $oSheet->getStyle($sRangeHeader)->applyFromArray($oBorder);
      }

      if ($lbExcel && $pItem==0) {
         $iRowExcel++;
         $iItemIni = $iRowExcel; // incio do bloco (para aplicar borda depois)
   
         // LABEL "Item"
         $oSheet->setCellValue('B'.$iRowExcel, 'Item');
         $oSheet->mergeCells('C'.$iRowExcel.':L'.$iRowExcel);   
         $oSheet->setCellValue('C'.$iRowExcel,'ORDEM SEM ITEM');
   
         // Estilo: negrito s no "Item"
         $oSheet->getStyle('B'.$iRowExcel)->getFont()->setBold(true);
   
         // Alinhamento  esquerda
         $oSheet->getStyle('B'.$iRowExcel.':L'.$iRowExcel)
                ->getAlignment()
                ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);
   
         // Borda externa somente
         $sRangeItem = 'B'.$iItemIni.':L'.$iRowExcel;
      
         $oBorderItem = ['borders' => ['outline' => ['style' => PHPExcel_Style_Border::BORDER_THIN]]];
         $oSheet->getStyle($sRangeItem)->applyFromArray($oBorderItem);
         $oSheet->getStyle($sRangeItem)->applyFromArray([
            'fill' => ['type'  => PHPExcel_Style_Fill::FILL_SOLID,'color' => ['rgb' => 'EEEEEE']],
            'borders' => ['outline' => ['style' => PHPExcel_Style_Border::BORDER_THIN]]
         ]);

      } else if ($lbExcel) {

         // Primeira linha do bloco Item
         $iRowExcel++;
         $iItemIni = $iRowExcel; // incio do bloco (para aplicar borda depois)
   
         // LABEL "Item"
         $oSheet->setCellValue('B'.$iRowExcel, 'Item');
         $oSheet->mergeCells('C'.$iRowExcel.':L'.$iRowExcel);   
         $oSheet->setCellValue('C'.$iRowExcel, $sCodItem.' - '.utf8_encode($sDescItem));
   
         // Estilo: negrito s no "Item"
         $oSheet->getStyle('B'.$iRowExcel)->getFont()->setBold(true);
   
         // Alinhamento  esquerda
         $oSheet->getStyle('B'.$iRowExcel.':L'.$iRowExcel)
                ->getAlignment()
                ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);
   
         // Borda externa somente
         $sRangeItem = 'B'.$iItemIni.':L'.$iRowExcel;
      
         $oBorderItem = ['borders' => ['outline' => ['style' => PHPExcel_Style_Border::BORDER_THIN]]];
   
         $oSheet->getStyle($sRangeItem)->applyFromArray($oBorderItem);
         $oSheet->getStyle($sRangeItem)->applyFromArray([
            'fill' => [
               'type'  => PHPExcel_Style_Fill::FILL_SOLID,
               'color' => ['rgb' => 'EEEEEE']
            ]
         ]);

         // Avana para prxima linha abaixo do Item
         $iRowExcel++;
         $iTitRow = $iRowExcel;     // ex: 2, 6, etc.

         // Ttulos comeando em B
         $aTitulosImpostos = array(
             'B' => 'Politicas ID',
             'C' => 'IS Aliquotas',
             'D' => 'IS Valores',
             'E' => 'IBS/CBS',
             'F' => 'IBSUF Aliquotas',
             'G' => 'IBSUF Valores',
             'H' => 'IBSMun Aliquotas',
             'I' => 'IBSMun Valores',
             'J' => 'IBSUF + IBSMun',
             'K' => 'CBS Aliquotas',
             'L' => 'CBS Valores'
         );

         foreach ($aTitulosImpostos as $sCol => $sTexto) {
             // Texto do ttulo
             $oSheet->setCellValue($sCol.$iTitRow, $sTexto);
     
             // Negrito + centralizado
             $oSheet->getStyle($sCol.$iTitRow)->getFont()->setBold(true);
             $oSheet->getStyle($sCol.$iTitRow)
                    ->getAlignment()
                    ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
     
             // .. Ajuste automtico da largura (coluna, no clula)
             $oSheet->getColumnDimension($sCol)->setAutoSize(true);
             //                          ^^^^^ sem nmero da linha
         }

         // Range completo da linha de ttulos (B..L)
         $sRangeTit = 'B'.$iTitRow.':L'.$iTitRow;
      
         // 1) Zera todas as bordas desse range (opcional mas ajuda a limpar "lixo" anterior)
         $oSheet->getStyle($sRangeTit)->applyFromArray([
             'borders' => [
                 'top'    => ['style' => PHPExcel_Style_Border::BORDER_NONE],
                 'left'   => ['style' => PHPExcel_Style_Border::BORDER_NONE],
                 'right'  => ['style' => PHPExcel_Style_Border::BORDER_NONE],
                 'bottom' => ['style' => PHPExcel_Style_Border::BORDER_NONE],
             ]
         ]);
     
         // 2) Borda inferior serrilhada em toda a linha B..L
         $oSheet->getStyle($sRangeTit)->applyFromArray([
             'borders' => ['bottom' => ['style' => PHPExcel_Style_Border::BORDER_DOTTED]]
         ]);

         // 3) Borda esquerda THIN s em B
         $oSheet->getStyle('B'.$iTitRow.':B'.$iTitRow)->applyFromArray([
             'borders' => ['left' => ['style' => PHPExcel_Style_Border::BORDER_THIN]]
         ]);

         // 4) Borda direita THIN s em L
         $oSheet->getStyle('L'.$iTitRow.':L'.$iTitRow)->applyFromArray([
             'borders' => ['right' => ['style' => PHPExcel_Style_Border::BORDER_THIN]]
         ]);     

         // Primeira linha de contedo logo abaixo do ttulo
         $iBodyIni = $iRowExcel + 1;      // ex.: se ttulo est na 8, contedo comea na 9
         $iBodyEnd = $iRowExcel + 4;      // 4 linhas de contedo (9..12)

         // Range completo do bloco de resultados (B..L)
         $sRangeBody = 'B'.$iBodyIni.':L'.$iBodyEnd;

         // Bordas: contorno fino + grade interna pontilhada (ou como voc preferir)
         $oSheet->getStyle($sRangeBody)->applyFromArray([
             'borders' => ['left'  => ['style' => PHPExcel_Style_Border::BORDER_THIN],
                           'right' => ['style' => PHPExcel_Style_Border::BORDER_THIN],
                          ]
         ]);

         // Alinhamento padro:  esquerda
         $oSheet->getStyle($sRangeBody)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);
     
         // Politicas ID (4 linhas)
         $oSheet->setCellValue('B'.$iBodyIni    , 'IS  : '.($pISRegFis>0 ? $pISRegFis.'/'.$fISRegFis : 0));
         $oSheet->setCellValue('B'.($iBodyIni+1), 'IBS : '.($pRegFisIBS>0 ? $pRegFisIBS.'/'.$fRegFisIBS : 0));
         $oSheet->setCellValue('B'.($iBodyIni+2), 'IBSMun : '.($pRegFisIBSMun>0 ? $pRegFisIBSMun.'/'.$fRegFisIBSMun : 0));
         $oSheet->setCellValue('B'.($iBodyIni+3), 'CBS : '.($pRegFisCBS>0 ? $pRegFisCBS.'/'.$fRegFisCBS : 0));
         if ((($pISRegFis>0||$pRegFisIBS>0||$pRegFisIBSMun>0||$pRegFisCBS>0) && ($lCoresImpostos==true)) || ($lTodasCores==true)) $sCorCelula = 'A7D8FF';
         else                                                                                                                     $sCorCelula = 'FFFFFF';
         for ($i = $iBodyIni; $i <= $iBodyIni+3; $i++) {
            $oSheet->getStyle('B'.$i)->applyFromArray([
               'fill'    => ['type'  => PHPExcel_Style_Fill::FILL_SOLID,'color' => ['rgb' => $sCorCelula]],
               'borders' => ['right' => ['style' => PHPExcel_Style_Border::BORDER_THIN]]
            ]);
         }

         // IS Aliquotas (3 linhas)
         $oSheet->setCellValue('C'.$iBodyIni    , '%BC : '.number_format($nIS_vBCIS,2,",","."));
         $oSheet->setCellValue('C'.($iBodyIni+1), '%IS : '.number_format($nIS_pIS,2,",","."));
         $oSheet->setCellValue('C'.($iBodyIni+2), '%Un Aprox : '.number_format($nIS_pISEspec,2,",","."));
         if ((($nIS_vBCIS>0||$nIS_pIS>0||$nIS_pISEspec>0) && ($lCoresImpostos==true)) || ($lTodasCores==true)) $sCorCelula = 'B8FFE3';
         else                                                                                                  $sCorCelula = 'FFFFFF';
         for ($i = $iBodyIni; $i <= $iBodyIni+3; $i++) {
            $oSheet->getStyle('C'.$i)->applyFromArray([
               'fill'    => ['type'  => PHPExcel_Style_Fill::FILL_SOLID,'color' => ['rgb' => $sCorCelula]],
               'borders' => ['right' => ['style' => PHPExcel_Style_Border::BORDER_THIN]]
            ]);
         }
     
         // IS Valores (3 linhas)
         $oSheet->setCellValue('D'.$iBodyIni    , 'Un Trib : '.$sIS_uTrib);
         $oSheet->setCellValue('D'.($iBodyIni+1), 'Qtde Trib : '.number_format($nIS_qTrib,2,",","."));
         $oSheet->setCellValue('D'.($iBodyIni+2), 'Valor : '.number_format($nIS_vIS,2,",","."));
         if ((($sIS_uTrib!=''||$nIS_qTrib>0||$nIS_vIS>0) && ($lCoresImpostos==true)) || ($lTodasCores==true)) $sCorCelula = 'D4FF8C';
         else                                                                                                 $sCorCelula = 'FFFFFF';
         for ($i = $iBodyIni; $i <= $iBodyIni+3; $i++) {
            $oSheet->getStyle('D'.$i)->applyFromArray([
               'fill'    => ['type'  => PHPExcel_Style_Fill::FILL_SOLID,'color' => ['rgb' => $sCorCelula]],
               'borders' => ['right' => ['style' => PHPExcel_Style_Border::BORDER_THIN]]
            ]);
         }
     
         // IBS/CBS (1 linha)
         $oSheet->setCellValue('E'.$iBodyIni,'%BC : '.number_format($nIBSCBS_vBC,2,",","."));
         if ((($nIBSCBS_vBC>0) && ($lCoresImpostos==true)) || ($lTodasCores==true)) $sCorCelula = 'FFF7A1';
         else                                                                       $sCorCelula = 'FFFFFF';
         for ($i = $iBodyIni; $i <= $iBodyIni+3; $i++) {
            $oSheet->getStyle('E'.$i)->applyFromArray([
               'fill'    => ['type'  => PHPExcel_Style_Fill::FILL_SOLID,'color' => ['rgb' => $sCorCelula]],
               'borders' => ['right' => ['style' => PHPExcel_Style_Border::BORDER_THIN]]
            ]);
         }
     
         // IBSUF Aliquotas (4 linhas)
         $oSheet->setCellValue('F'.$iBodyIni    , '% Comp UF : '.number_format($nIBSUF_pIBSUF,2,",","."));    
         $oSheet->setCellValue('F'.($iBodyIni+1), '% Dif : '.number_format($nIBSUF_pDif,2,",","."));
         $oSheet->setCellValue('F'.($iBodyIni+2), '% Red Aliq cCT : '.number_format($nIBSUF_pRedAliq,2,",","."));
         $oSheet->setCellValue('F'.($iBodyIni+3), '% Comp UF BC : '.number_format($nIBSUF_pAliqEfet,2,",","."));
         if ((($nIBSUF_pIBSUF>0||$nIBSUF_pDif>0||$nIBSUF_pRedAliq>0||$nIBSUF_pAliqEfet>0) && ($lCoresImpostos==true)) || ($lTodasCores==true)) $sCorCelula = 'FFD0A8';
         else                                                                                                                                  $sCorCelula = 'FFFFFF';
         for ($i = $iBodyIni; $i <= $iBodyIni+3; $i++) {
            $oSheet->getStyle('F'.$i)->applyFromArray([
               'fill'    => ['type'  => PHPExcel_Style_Fill::FILL_SOLID,'color' => ['rgb' => $sCorCelula]],
               'borders' => ['right' => ['style' => PHPExcel_Style_Border::BORDER_THIN]]
            ]);
         }
     
         // IBSUF Valores (3 linhas)
         $oSheet->setCellValue('G'.$iBodyIni    , 'Dif : '.number_format($nIBSUF_vDif,2,",","."));    
         $oSheet->setCellValue('G'.($iBodyIni+1), 'Trib Dev : '.number_format($nIBSUF_vDevTrib,2,",","."));
         $oSheet->setCellValue('G'.($iBodyIni+2), 'Comp UF : '.number_format($nIBSUF_vIBSUF,2,",","."));
         if ((($nIBSUF_vDif>0||$nIBSUF_vDevTrib>0||$nIBSUF_vIBSUF>0) && ($lCoresImpostos==true)) || ($lTodasCores==true)) $sCorCelula = 'FFC2B3';
         else                                                                                                             $sCorCelula = 'FFFFFF';
         for ($i = $iBodyIni; $i <= $iBodyIni+3; $i++) {
            $oSheet->getStyle('G'.$i)->applyFromArray([
               'fill'    => ['type'  => PHPExcel_Style_Fill::FILL_SOLID,'color' => ['rgb' => $sCorCelula]],
               'borders' => ['right' => ['style' => PHPExcel_Style_Border::BORDER_THIN]]
            ]);
         }
     
         // IBSMun Aliquotas (4 linhas)
         $oSheet->setCellValue('H'.$iBodyIni    , '%Comp Mun : '.number_format($nIBSMun_pIBSMun,2,",","."));    
         $oSheet->setCellValue('H'.($iBodyIni+1), '%Dif : '.number_format($nIBSMun_pDif,2,",","."));
         $oSheet->setCellValue('H'.($iBodyIni+2), '%Red Aliq cCT : '.number_format($nIBSMun_pRedAliq,2,",","."));
         $oSheet->setCellValue('H'.($iBodyIni+3), '%Comp Mun BC : '.number_format($nIBSMun_pAliqEfet,2,",","."));
         if ((($nIBSMun_pIBSMun>0||$nIBSMun_pDif>0||$nIBSMun_pRedAliq>0||$nIBSMun_pAliqEfet>0) && ($lCoresImpostos==true)) || ($lTodasCores==true)) $sCorCelula = 'FFB6D5';
         else                                                                                                                                       $sCorCelula = 'FFFFFF';
         for ($i = $iBodyIni; $i <= $iBodyIni+3; $i++) {
            $oSheet->getStyle('H'.$i)->applyFromArray([
               'fill'    => ['type'  => PHPExcel_Style_Fill::FILL_SOLID,'color' => ['rgb' => $sCorCelula]],
               'borders' => ['right' => ['style' => PHPExcel_Style_Border::BORDER_THIN]]
            ]);
         }
     
         // IBSMun Valores (3 linhas)
         $oSheet->setCellValue('I'.$iBodyIni    , 'Dif : '.number_format($nIBSMun_vDif,2,",","."));
         $oSheet->setCellValue('I'.($iBodyIni+1), 'Trib Dev : '.number_format($nIBSMun_vDevTrib,2,",","."));
         $oSheet->setCellValue('I'.($iBodyIni+2), 'Comp Mun : '.number_format($nIBSMun_vIBSMun,2,",","."));
         if ((($nIBSMun_vDif>0||$nIBSMun_vDevTrib>0||$nIBSMun_vIBSMun>0) && ($lCoresImpostos==true)) || ($lTodasCores==true)) $sCorCelula = 'E3C5FF';
         else                                                                                                                 $sCorCelula = 'FFFFFF';
         for ($i = $iBodyIni; $i <= $iBodyIni+3; $i++) {
            $oSheet->getStyle('I'.$i)->applyFromArray([
               'fill'    => ['type'  => PHPExcel_Style_Fill::FILL_SOLID,'color' => ['rgb' => $sCorCelula]],
               'borders' => ['right' => ['style' => PHPExcel_Style_Border::BORDER_THIN]]
            ]);
         }
              
         // IBSUF + IBSMun (1 linha)
         $oSheet->setCellValue('J'.$iBodyIni    , 'Total : '.number_format($nIBSCBS_vIBS,2,",","."));
         if ((($nIBSCBS_vIBS>0) && ($lCoresImpostos==true)) || ($lTodasCores==true)) $sCorCelula = 'D4A9FF';
         else                                                                        $sCorCelula = 'FFFFFF';
         for ($i = $iBodyIni; $i <= $iBodyIni+3; $i++) {
            $oSheet->getStyle('J'.$i)->applyFromArray([
               'fill'    => ['type'  => PHPExcel_Style_Fill::FILL_SOLID,'color' => ['rgb' => $sCorCelula]],
               'borders' => ['right' => ['style' => PHPExcel_Style_Border::BORDER_THIN]]
            ]);
         }

         // CBS Aliquotas (4 linhas)
         $oSheet->setCellValue('K'.$iBodyIni    , '%CBS : '.number_format($nCBS_pCBS,2,",","."));    
         $oSheet->setCellValue('K'.($iBodyIni+1), '%Dif : '.number_format($nCBS_pDif,2,",","."));
         $oSheet->setCellValue('K'.($iBodyIni+2), '%Red Aliq cCT : '.number_format($nCBS_pRedAliq,2,",","."));
         $oSheet->setCellValue('K'.($iBodyIni+3), '%CBS BC : '.number_format($nCBS_pAliqEfet,2,",","."));
         if ((($nCBS_pCBS>0||$nCBS_pDif>0||$nCBS_pRedAliq>0||$nCBS_pAliqEfet>0) && ($lCoresImpostos==true)) || ($lTodasCores==true)) $sCorCelula = 'A9FFF9';
         else                                                                                                                        $sCorCelula = 'FFFFFF';
         for ($i = $iBodyIni; $i <= $iBodyIni+3; $i++) {
            $oSheet->getStyle('K'.$i)->applyFromArray([
               'fill'    => ['type'  => PHPExcel_Style_Fill::FILL_SOLID,'color' => ['rgb' => $sCorCelula]],
               'borders' => ['right' => ['style' => PHPExcel_Style_Border::BORDER_THIN]]
            ]);
         }

         // CBS Valores (3 linhas)
         $oSheet->setCellValue('L'.$iBodyIni    , 'Dif : '.number_format($nCBS_vDif,2,",","."));
         $oSheet->setCellValue('L'.($iBodyIni+1), 'Trib Dev : '.number_format($nCBS_vDevTrib,2,",","."));
         $oSheet->setCellValue('L'.($iBodyIni+2), 'Valor : '.number_format($nCBS_vCBS,2,",","."));

         if ((($nCBS_vDif>0||$nCBS_vDevTrib>0||$nCBS_vCBS>0) && ($lCoresImpostos==true)) || ($lTodasCores==true)) $sCorCelula = 'C9FFBB';
         else                                                                                                     $sCorCelula = 'FFFFFF';
         for ($i = $iBodyIni; $i <= $iBodyIni+3; $i++) {
            $oSheet->getStyle('L'.$i)->applyFromArray([
               'fill'    => ['type'  => PHPExcel_Style_Fill::FILL_SOLID,'color' => ['rgb' => $sCorCelula]],
               'borders' => ['right' => ['style' => PHPExcel_Style_Border::BORDER_THIN]]
            ]);
         }

         // Colocar borda na parte de baixo das celulas na ultima linha dos impostos
         $sRangeBody = 'B'.($iBodyIni+3).':L'.($iBodyIni+3);
         $oSheet->getStyle($sRangeBody)->applyFromArray(['borders' => ['bottom' => ['style' => PHPExcel_Style_Border::BORDER_THIN],]]);

         $iRowExcel = $iBodyEnd;

      } // 

     
      // SE MUDOU A ORDEM E NO  O PRIMEIRO REGISTRO . FECHA A TABELA ANTERIOR
      if ($pOrdemAnt>0 && $pOrdemAnt!=$pOrdem) {
         $sTable .= '</table>';
      }
   
      if ($iLoop==0 || $pOrdemAnt!=$pOrdem) {
         fpc_append($sEcoTxt, "Vai colocar o <table ....>");
         $sTable .= '<table cellspacing="0" cellpadding="0" style="margin:5pt; font-family: verdana; font-size: 10px; color: inherit; width: 100%;" class="qtux-modal-table">
             <tr>
               <td style="border-top: 1px solid #000; border-left: 1px solid #000; border-right: none; text-align: left;"><b>Ordem</b></td>
               <td style="border-top: 1px solid #000; text-align: left;">:</td>
               <td colspan="40" style="border-top: 1px solid #000; border-right: 1px solid #000; text-align: left;">'.$pOrdem.'</td>
             </tr>
             <tr>
               <td style="border-left: 1px solid #000; text-align: left;"><b>Emissor</b></td>
               <td style="text-align: left;">:</td>
               <td colspan="40" style="border-right: 1px solid #000; text-align: left;">'.$sEmi.'</td>
            </tr>
            <tr>
               <td style="border-bottom: 1px solid #000; border-left: 1px solid #000; text-align: left;"><b>Destinatario</b></td>
               <td style="border-bottom: 1px solid #000; text-align: left;">:</td>
               <td colspan="40" style="border-bottom: 1px solid #000; border-right: 1px solid #000; text-align: left;">['.$sDoc.'] - '.$sDest.'</td>
            </tr>';
      }

      if ($pItem==0) {
         $sTable .= '
            <tr>
               <td style="border-top: 1px solid #000; border-bottom: 1px solid #000; border-left: 1px solid #000; border-right: none; text-align: left;"><b>Item</b></td>
               <td style="border-top: 1px solid #000; border-bottom: 1px solid #000; border-left: none; border-right: none; text-align: left;">:</td>
               <td colspan="40" style="border-top: 1px solid #000; border-bottom: 1px solid #000; border-left: none; border-right: 1px solid #000; text-align: left;">ORDEM SEM ITEM</td>
            </tr>';

      } else {
         
         $sTable .= '
            <tr>
               <td style="border-top: 1px solid #000; border-bottom: 1px solid #000; border-left: 1px solid #000; border-right: none; text-align: left;"><b>Item</b></td>
               <td style="border-top: 1px solid #000; border-bottom: 1px solid #000; border-left: none; border-right: none; text-align: left;">:</td>
               <td colspan="40" style="border-top: 1px solid #000; border-bottom: 1px solid #000; border-left: none; border-right: 1px solid #000; text-align: left;">'.$sCodItem.'-'.$sDescItem.'</td>
            </tr>
         
            <!-- Cabealhos das duas colunas -->
            <tr>
               <td colspan="3" style="border-bottom: 1px dashed #000; border-left: 1px solid #000; text-align: left; font-size: 10px;"><b>Politicas ID</b></td>
               <td colspan="3" style="border-bottom: 1px dashed #000; text-align: left; font-size: 10px;"><b>IS Aliquotas</b></td>
               <td colspan="3" style="border-bottom: 1px dashed #000; text-align: left; font-size: 10px;"><b>IS Valores</b></td>
               <td colspan="3" style="border-bottom: 1px dashed #000; text-align: left; font-size: 10px;"><b>IBS/CBS</b></td>
               <td colspan="3" style="border-bottom: 1px dashed #000; text-align: left; font-size: 10px;"><b>IBSUF Aliquotas</b></td>
               <td colspan="3" style="border-bottom: 1px dashed #000; text-align: left; font-size: 10px;"><b>IBSUF Valores</b></td>
               <td colspan="3" style="border-bottom: 1px dashed #000; text-align: left; font-size: 10px;"><b>IBSMun Aliquotas</b></td>
               <td colspan="3" style="border-bottom: 1px dashed #000; text-align: left; font-size: 10px;"><b>IBSMun Valores</b></td>
               <td colspan="3" style="border-bottom: 1px dashed #000; text-align: left; font-size: 10px;"><b>IBSUF + IBSMun</b></td>
               <td colspan="3" style="border-bottom: 1px dashed #000; text-align: left; font-size: 10px;"><b>CBS Aliquotas</b></td>
               <td colspan="3" style="border-bottom: 1px dashed #000; border-right: 1px solid #000; text-align: left; font-size: 10px;"><b>CBS Valores</b></td>
            </tr>
         
            <!-- Linha 1 -->
            <tr>
               <!-- Ponteiros -> pRegFisIS -->
               <td style="border-left: 1px solid #000; text-align: left; width:  5px;"><b>IS</b></td>
               <td style="text-align: left; width:  5px;">&nbsp;:&nbsp;</td>
               <td style="text-align: left;">'.($pISRegFis>0 ? $pISRegFis.'/'.$fISRegFis : 0).'</td>
         
               <!-- IS Aliquotas -> %BC -->
               <td style="border-left: 1px solid #000; text-align: left; width: 60px;"><b>%BC</b></td>
               <td style="text-align: left; width:  5px;">&nbsp;:&nbsp;</td>
               <td style="text-align: left;">'.number_format($nIS_vBCIS,2,",",".").'</td>
         
               <!-- IS Valores ->  Un Med Trib -->
               <td style="border-left: 1px solid #000; text-align: left; width: 70px;"><b>Un Trib</b></td>
               <td style="text-align: left; width:  5px;">&nbsp;:&nbsp;</td>
               <td style="text-align: left;">'.$sIS_uTrib.'</td>
         
               <!-- IBS/CBS ->  %BC  -->
               <td style="border-left: 1px solid #000; text-align: left; width: 10px;"><b>%BC</b></td>
               <td style="text-align: left; width: 10px;">&nbsp;:&nbsp;</td>
               <td style="text-align: left; ">'.number_format($nIBSCBS_vBC,2,",",".").'</td>
         
               <!-- IBSUF Aliquotas -> Comp UF -->
               <td style="border-left: 1px solid #000; text-align: left; width: 90px;"><b>% Comp UF</b></td>
               <td style="text-align: left; width:  5px;">&nbsp;:&nbsp;</td>
               <td style="text-align: left; ">'.number_format($nIBSUF_pIBSUF,2,",",".").'</td>
         
               <!-- IBSUF Valores -> Val Dif -->
               <td style="border-left: 1px solid #000; text-align: left; width: 75px;"><b>Dif</b></td>
               <td style="text-align: left; width:  5px;">&nbsp;:&nbsp;</td>
               <td style="text-align: left; ">'.number_format($nIBSUF_vDif,2,",",".").'</td>
         
               <!-- IBSMun Aliquotas -> %Comp Mun-->
               <td style="border-left: 1px solid #000; text-align: left; width: 90px;"><b>%Comp Mun</b></td>
               <td style="text-align: left; width:  5px;">&nbsp;:&nbsp;</td>
               <td style="text-align: left; ">'.number_format($nIBSMun_pIBSMun,2,",",".").'</td>
         
               <!-- IBSMun Valores -> Val Dif-->
               <td style="border-left: 1px solid #000; text-align: left; width: 80px;"><b>Dif</b></td>
               <td style="text-align: left; width:  5px;">&nbsp;:&nbsp;</td>
               <td style="text-align: left; ">'.number_format($nIBSMun_vDif,2,",",".").'</td>
         
               <!-- IBSUF + IBSMun -> Total-->
               <td style="border-left: 1px solid #000; text-align: left; width: 25px;"><b>Total</b></td>
               <td style="text-align: left; width:  5px;">&nbsp;:&nbsp;</td>
               <td style="text-align: left; ">'.number_format($nIBSCBS_vIBS,2,",",".").'</td>
         
               <!-- CBS Aliquotas -> %CBS -->
               <td style="border-left: 1px solid #000; text-align: left; width: 85px;"><b>%CBS</b></td>
               <td style="text-align: left; width:  5px;">&nbsp;:&nbsp;</td>
               <td style="text-align: left; ">'.number_format($nCBS_pCBS,2,",",".").'</td>
         
               <!-- CBS Valores -> Val Dif -->
               <td style="border-left: 1px solid #000; text-align: left; width:  70px;"><b>Dif</b></td>
               <td style="text-align: left; width:  5px;">&nbsp;:&nbsp;</td>
               <td style="text-align: left; border-right: 1px solid #000;">'.number_format($nCBS_vDif,2,",",".").'</td>
         
            </tr>
         
            <!-- Linha 2 -->
            <tr>
               <!-- Ponteiros -> pRegFisIBS -->
               <td style="border-left: 1px solid #000; text-align: left; width:  5px;"><b>IBS</b></td>
               <td style="text-align: left; width:  5px;">&nbsp;:&nbsp;</td>
               <td style="text-align: left;">'.($pRegFisIBS>0 ? $pRegFisIBS.'/'.$fRegFisIBS : 0).'</td>
               
               <!-- IS Aliquotas -> %IS -->
               <td style="border-left: 1px solid #000; text-align: left; width: 60px;"><b>%IS</b></td>
               <td style="text-align: left; width:  5px;">&nbsp;:&nbsp;</td>
               <td style="text-align: left;">'.number_format($nIS_pIS,2,",",".").'</td>
         
               <!-- IS Valores ->  Qtde Trib-->
               <td style="border-left: 1px solid #000; text-align: left; width: 60px;"><b>Qtde Trib</b></td>
               <td style="text-align: left; width:  5px;">&nbsp;:&nbsp;</td>
               <td style="text-align: left;">'.number_format($nIS_qTrib,2,",",".").'</td>
         
               <!-- IBS/CBS -> Clulas vazias na coluna  -->
               <td style="border-left: 1px solid #000;"></td>
               <td></td>
               <td></td>
         
               <!-- IBSUF Aliquotas -> % Dif -->
               <td style="border-left: 1px solid #000; text-align: left; width: 90px;"><b>% Dif</b></td>
               <td style="text-align: left; width:  5px;">&nbsp;:&nbsp;</td>
               <td style="text-align: left; ">'.number_format($nIBSUF_pDif,2,",",".").'</td>
         
               <!-- IBSUF Valores -> Val Trib Dev-->
               <td style="border-left: 1px solid #000; text-align: left; width: 75px;"><b>Trib Dev</b></td>
               <td style="text-align: left; width:  5px;">&nbsp;:&nbsp;</td>
               <td style="text-align: left; ">'.number_format($nIBSUF_vDevTrib,2,",",".").'</td>
         
               <!-- IBSMun Aliquotas -> %Dif-->
               <td style="border-left: 1px solid #000; text-align: left; width: 90px;"><b>%Dif</b></td>
               <td style="text-align: left; width:  5px;">&nbsp;:&nbsp;</td>
               <td style="text-align: left; ">'.number_format($nIBSMun_pDif,2,",",".").'</td>
         
               <!-- IBSMun Valores -> Val Trib Dev-->
               <td style="border-left: 1px solid #000; text-align: left; width: 80px;"><b>Trib Dev</b></td>
               <td style="text-align: left; width:  5px;">&nbsp;:&nbsp;</td>
               <td style="text-align: left; ">'.number_format($nIBSMun_vDevTrib,2,",",".").'</td>
         
               <!-- IBSUF + IBSMun -> Clulas vazias na coluna -->
               <td style="border-left: 1px solid #000;"></td>
               <td></td>
               <td></td>
               
               <!-- CBS Aliquotas -> %Dif -->
               <td style="border-left: 1px solid #000; text-align: left; width: 85px;"><b>%Dif</b></td>
               <td style="text-align: left; width:  5px;">&nbsp;:&nbsp;</td>
               <td style="text-align: left; ">'.number_format($nCBS_pDif,2,",",".").'</td>
         
               <!-- CBS Valores -> Val Trib Dev -->
               <td style="border-left: 1px solid #000; text-align: left; width: 70px;"><b>Trib Dev</b></td>
               <td style="text-align: left; width:  5px;">&nbsp;:&nbsp;</td>
               <td style="text-align: left; border-right: 1px solid #000;">'.number_format($nCBS_vDevTrib,2,",",".").'</td>
         
            </tr>
         
            <!-- Linha 3 -->
            <tr>
               <!-- Ponteiros -> pRegFisIBSMun -->
               <td style="border-left: 1px solid #000; text-align: left; width:  5px;"><b>IBSMun</b></td>
               <td style="text-align: left; width:  5px;">&nbsp;:&nbsp;</td>
               <td style="text-align: left;">'.($pRegFisIBSMun>0 ? $pRegFisIBSMun.'/'.$fRegFisIBSMun : 0).'</td>
         
               <!-- IS Aliquotas -> %Un Apro -->
               <td style="border-left: 1px solid #000; text-align: left; width: 60px;"><b>%Un Apro</b></td>
               <td style="text-align: left; width:  5px;">&nbsp;:&nbsp;</td>
               <td style="text-align: left;">'.number_format($nIS_pISEspec,2,",",".").'</td>
         
               <!-- IS Valores ->  Valor -->
               <td style="border-left: 1px solid #000; text-align: left; width: 60px;"><b>Valor</b></td>
               <td style="text-align: left; width:  5px;">&nbsp;:&nbsp;</td>
               <td style="text-align: left;">'.number_format($nIS_vIS,2,",",".").'</td>
         
               <!-- IBS/CBS -> Clulas vazias na coluna  -->
               <td style="border-left: 1px solid #000; text-align: left; width:  60px;">&nbsp;</td>
               <td style="text-align: left; width:  5px;">&nbsp;</td>
               <td style="text-align: left; width:  5px;">&nbsp;</td>
         
               <!-- IBSUF Aliquotas -> % Red Aliq cCT  -->
               <td style="border-left: 1px solid #000; text-align: left; width: 90px;"><b>% Red Aliq cCT</b></td>
               <td style="text-align: left; width:  5px;">&nbsp;:&nbsp;</td>
               <td style="text-align: left; ">'.number_format($nIBSUF_pRedAliq,2,",",".").'</td>
         
               <!-- IBSUF Valores -> Val Comp UF -->
               <td style="border-left: 1px solid #000; text-align: left; width: 75px;"><b>Comp UF</b></td>
               <td style="text-align: left; width:  5px;">&nbsp;:&nbsp;</td>
               <td style="text-align: left; ">'.number_format($nIBSUF_vIBSUF,2,",",".").'</td>
         
               <!-- IBSMun Aliquotas -> %Red Aliq cCT-->
               <td style="border-left: 1px solid #000; text-align: left; width: 90px;"><b>%Red Aliq cCT</b></td>
               <td style="text-align: left; width:  5px;">&nbsp;:&nbsp;</td>
               <td style="text-align: left; ">'.number_format($nIBSMun_pRedAliq,2,",",".").'</td>
         
               <!-- IBSMun Valores -> Val Comp Mun-->
               <td style="border-left: 1px solid #000; text-align: left; width: 90px;"><b>Comp Mun</b></td>
               <td style="text-align: left; width:  5px;">&nbsp;:&nbsp;</td>
               <td style="text-align: left; ">'.number_format($nIBSMun_vIBSMun,2,",",".").'</td>
         
               <!-- IBSUF + IBSMun -> Clulas vazias na coluna -->
               <td style="border-left: 1px solid #000;"></td>
               <td></td>
               <td></td>
         
               <!-- CBS Aliquotas -> %Red Aliq cCT-->
               <td style="border-left: 1px solid #000; text-align: left; width: 85px;"><b>%Red Aliq cCT</b></td>
               <td style="text-align: left; width:  5px;">&nbsp;:&nbsp;</td>
               <td style="text-align: left; ">'.number_format($nCBS_pRedAliq,2,",",".").'</td>      
         
               <!-- CBS Valores -> Valor -->
               <td style="border-left: 1px solid #000; text-align: left; width: 70px;"><b>Valor</b></td>
               <td style="text-align: left; width:  5px;">&nbsp;:&nbsp;</td>
               <td style="text-align: left; border-right: 1px solid #000;">'.number_format($nCBS_vCBS,2,",",".").'</td>
         
            </tr>
         
            <!-- Linha 4: pRegFisCBS  x  (sem correspondente na direita) -->
            <tr>
               <!-- Ponteiros -> pRegFisCBS -->
               <td style="border-bottom: 1px solid #000; border-left: 1px solid #000; text-align: left; width:  5px;"><b>CBS</b></td>
               <td style="border-bottom: 1px solid #000; text-align: left; width:  5px;">&nbsp;:&nbsp;</td>
               <td style="border-bottom: 1px solid #000; text-align: left;">'.($pRegFisCBS>0 ? $pRegFisCBS.'/'.$fRegFisCBS : 0).'</td>
         
               <!-- IS Aliquotas -> Clulas vazias na coluna -->
               <td style="border-bottom: 1px solid #000; border-left: 1px solid #000;"></td>
               <td style="border-bottom: 1px solid #000;"></td>
               <td style="border-bottom: 1px solid #000;"></td>
         
               <!-- IS Valores ->   Clulas vazias na coluna -->
               <td style="border-bottom: 1px solid #000; border-left: 1px solid #000;"></td>
               <td style="border-bottom: 1px solid #000;"></td>
               <td style="border-bottom: 1px solid #000;"></td>
         
               <!-- IBS/CBS -> Clulas vazias na coluna  -->
               <td style="border-bottom: 1px solid #000; border-left: 1px solid #000;"></td>
               <td style="border-bottom: 1px solid #000;"></td>
               <td style="border-bottom: 1px solid #000;"></td>
         
               <!-- IBSUF Aliquotas -> % Comp UF BC -->
               <td style="border-bottom: 1px solid #000; border-left: 1px solid #000; text-align: left; width: 90px;"><b>% Comp UF BC</b></td>
               <td style="border-bottom: 1px solid #000; text-align: left; width:  5px;">&nbsp;:&nbsp;</td>
               <td style="border-bottom: 1px solid #000; text-align: left; ">'.number_format($nIBSUF_pAliqEfet,2,",",".").'</td>
         
               <!-- IBSUF Valores -> Clulas vazias na coluna -->
               <td style="border-bottom: 1px solid #000; border-left: 1px solid #000;"></td>
               <td style="border-bottom: 1px solid #000;"></td>
               <td style="border-bottom: 1px solid #000;"></td>
         
               <!-- IBSMun Aliquotas -> %Comp Mun BC-->
               <td style="border-bottom: 1px solid #000; border-left: 1px solid #000; text-align: left; width: 91px;"><b>%Comp Mun BC</b></td>
               <td style="border-bottom: 1px solid #000; text-align: left; width:  5px;">&nbsp;:&nbsp;</td>
               <td style="border-bottom: 1px solid #000; text-align: left; ">'.number_format($nIBSMun_pAliqEfet,2,",",".").'</td>
         
               <!-- IBSMun Valores -> Clulas vazias na coluna -->
               <td style="border-bottom: 1px solid #000; border-left: 1px solid #000;"></td>
               <td style="border-bottom: 1px solid #000;"></td>
               <td style="border-bottom: 1px solid #000;"></td>
         
               <!-- IBSUF + IBSMun -> Clulas vazias na coluna -->
               <td style="border-bottom: 1px solid #000; border-left: 1px solid #000;"></td>
               <td style="border-bottom: 1px solid #000;"></td>
               <td style="border-bottom: 1px solid #000;"></td>
               
               <!-- CBS Aliquotas -> %CBS BC-->
               <td style="border-bottom: 1px solid #000; border-left: 1px solid #000; text-align: left; width: 85px;"><b>%CBS BC</b></td>
               <td style="border-bottom: 1px solid #000; text-align: left; width:  5px;">&nbsp;:&nbsp;</td>
               <td style="border-bottom: 1px solid #000; text-align: left; ">'.number_format($nCBS_pAliqEfet,2,",",".").'</td>
         
               <!-- CBS Valores -> Clulas vazias na coluna -->
               <td style="border-bottom: 1px solid #000; border-left: 1px solid #000;"></td>
               <td style="border-bottom: 1px solid #000;"></td>
               <td style="border-bottom: 1px solid #000; border-right: 1px solid #000;"></td>
         
            </tr>';
      } //    
      // SE  O LTIMO REGISTRO . FECHA A LTIMA TABELA
      if ($iLoop==$iDb) {
         $sTable .= '</table>';
      }
   
      $pOrdemAnt = $pOrdem;

   }
   fpc_append($sEcoTxt, $sTable);
   flDbDisconnect($hDb);

   if ($lbExcel) {
      // Sada em Excel usando PHPExcel
      // Header para Excel 97-2003 (.xls)
      header('Content-Type: application/vnd.ms-excel; charset=ISO-8859-1');
      header('Content-Disposition: attachment; filename=Impostos_OrdensI.xls');
      header('Cache-Control: max-age=0');

      $oSheet->setSelectedCell('A1');
      $oWriter = PHPExcel_IOFactory::createWriter($oPHPExcel, 'Excel5');
      $oWriter->save('php://output');
      exit;
   } else {
      // Sada HTML para o modal
      echo utf8_encode($sTable);
   }

}