
const puppeteer = require('puppeteer');

var sUrl;
var sNomePDF;

// pegar os argumentos vindo na chamada do cdigo
process.argv.forEach(function (sVal, iIndex, array) {
   //console.log(iIndex + ': ' + sVal);
   if (iIndex==2) sUrl     = sVal;
   if (iIndex==3) sNomePDF = sVal;
});

(async () => {
   //const oBrowser = await puppeteer.launch();
   let oBrowser;
   try {
     oBrowser = await puppeteer.launch({});
   } catch (e) {
     console.info("Unable to launch browser mode in sandbox mode. Lauching Chrome without sandbox.");
     oBrowser = await puppeteer.launch({args:['--no-sandbox']});
   }

   const oPag = await oBrowser.newPage();
  
   await oPag.setViewport({ width: 1920, height: 1080 });
  
   await oPag.goto(sUrl, { waitUntil: 'networkidle2' });
  
   await new Promise(resolve => setTimeout(resolve, 2000));
  
   await oPag.pdf({ // gera o pdf
     path: sNomePDF, 
     format: 'A4', 
     printBackground: true,
     margin: { 
       top: '20px', 
       bottom: '20px', 
       left: '20px', 
       right: '20px' 
     },
     landscape: true
   });
  
   await oBrowser.close();
})();