////////////////////////
FUNCTION main(sCia,pTmp)
////////////////////////
FS_SET("escdelay",3)
set decimals to 6
set date to british
pCia = "0"
iError = 0

lpathTmp = .f.
if pcount()>=2
   lpathTmp = .t.
endif

uai = .t.

sDir1 = "/mnt/nemag/tmp/"
sDir2 = "/mnt/nemag/"

do case
   case sCia = "totalquimica"
      rdd_connect("192.168.1.110:/qtux/database/cias/producao/ibtotal.gdb","sysdba","masterkey")
      pCia = "Q"
      sDir1 = "/qtux/samba/nemag/cdtotal/tmp/"
      sDir2 = "/qtux/samba/nemag/cdtotal/"
      sDeposit = "TOTAL" 
   case sCia = "santarita"
      rdd_connect("192.168.1.110:/qtux/database/cias/DBSRita/ibtotal.gdb","sysdba","masterkey")
      pCia = "T"
      sDir1 = "/qtux/samba/nemag/cdpet/tmp/"
      sDir2 = "/qtux/samba/nemag/cdpet/"		// AQUI
      sDeposit = "01   " 
   case sCia = "sanpet"
      rdd_connect("192.168.1.110:/qtux/database/cias/DBSanpet/ibtotal.gdb","sysdba","masterkey")
      pCia = "P"
      sDir1 = "/qtux/samba/nemag/cdpet/tmp/"
      sDir2 = "/qtux/samba/nemag/cdpet/"
      sDeposit = "01   " 
   case sCia = "sancare"
      rdd_connect("192.168.1.110:/qtux/database/cias/DBSancare/ibsancare.gdb","sysdba","masterkey")
      pCia = "E"
      sDir1 = "/qtux/samba/nemag/cdpet/tmp/"
      sDir2 = "/qtux/samba/nemag/cdpet/"
      sDeposit = "01   " 
   case sCia = "log"
      rdd_connect("192.168.1.110:/qtux/database/cias/DBLog/iblog.gdb","sysdba","masterkey")
      pCia = "L"
      sDir1 = "/qtux/samba/nemag/cdtotal/tmp/"
      sDir2 = "/qtux/samba/nemag/cdtotal/"
      sDeposit = "TOTAL" 
   case sCia = "cdi"
      rdd_connect("192.168.1.110:/qtux/database/cias/DBCDI/ibcdi.gdb","sysdba","masterkey")
      pCia = "C"
      sDir1 = "/qtux/samba/nemag/cdtotal/tmp/"
      sDir2 = "/qtux/samba/nemag/cdtotal/"
      sDeposit = "TOTAL" 
   case sCia = "rio"
      rdd_connect("192.168.1.110:/qtux/database/cias/DBRio/ibrio.gdb","sysdba","masterkey")
      pCia = "R"
      sDir1 = "/qtux/samba/nemag/cdtotal/tmp/"
      sDir2 = "/qtux/samba/nemag/cdtotal/"
      sDeposit = "TOTAL" 
   case sCia = "arte"
      rdd_connect("192.168.1.110:/qtux/database/cias/DBArte/ibarte.gdb","sysdba","masterkey")
      pCia = "A" //A
      sDir1 = "/qtux/samba/nemag/cdpet/tmp/"
      sDir2 = "/qtux/samba/nemag/cdpet/"
      sDeposit = "01   "
   case sCia = "tgel"
      rdd_connect("192.168.1.110:/qtux/database/cias/DBTGel/ibtgel.gdb","sysdba","masterkey")
      pCia = "G"
      sDir1 = "/qtux/samba/nemag/cdtotal/tmp/"
      sDir2 = "/qtux/samba/nemag/cdtotal/"
      sDeposit = "TOTAL" 
   case sCia = "sd"
      rdd_connect("192.168.1.110:/qtux/database/cias/DBSD/ibsd.gdb","sysdba","masterkey")
      pCia = "H"
      sDir1 = "/qtux/samba/nemag/cdpet/tmp/"
      sDir2 = "/qtux/samba/nemag/cdpet/"
      sDeposit = "01   " 
   case sCia = "collie"
      rdd_connect("192.168.1.110:/qtux/database/cias/DBColie/ibcolie.gdb","sysdba","masterkey")
      pCia = "O"
      sDir1 = "/qtux/samba/nemag/cdpet/tmp/"
      sDir2 = "/qtux/samba/nemag/cdpet/"
      sDeposit = "01   " 
   case sCia = "sign"
      rdd_connect("192.168.1.110:/qtux/database/cias/DBSIgn/ibsign.gdb","sysdba","masterkey")
      pCia = "I"
      sDir1 = "/qtux/samba/nemag/cdpet/tmp/"
      sDir2 = "/qtux/samba/nemag/cdpet/"
      sDeposit = "01   " 
endcase

m->Hoje = date()+2922
local p := 0
local c := 0
local d := 0
local i := 0

uaic = .t.

sMsg = chr(10)+"jobSaiRemAutoNemag.x "+sCia+" [EXECUTANDO] em:"+UsData2(m->Hoje)+" as:"+time()+chr(10)

if uai
   uai = fJobSOTEstocagemNemag()
endif
if uai
   do case
      case sCia = "totalquimica"
         uai = fAJobOCSaida()
      case sCia = "santarita"
         uai = fBJobOCSaida()	//
      case sCia = "sanpet"
         uai = fBJobOCSaida()	//
      case sCia = "sancare"
         uai = fBJobOCSaida()	//
      case sCia = "sd"
         uai = fBJobOCSaida()	//
      case sCia = "log"
         uai = fAJobOCSaida()
      case sCia = "cdi"
         uai = fAJobOCSaida()
      case sCia = "rio"
         uai = fAJobOCSaida()
      case sCia = "arte"
         uai = fBJobOCSaida()
      case sCia = "tgel"
         uai = fAJobOCSaida()
      case sCia = "collie"
         uai = fBJobOCSaida()	//
      case sCia = "sign"
         uai = fBJobOCSaida()	//
   endcase
endif

if uai
   sMsg += "jobSaiRemAutoNemag.x "+sCia+" [EXECUTADO] em:"+UsData2(m->Hoje)+" as:"+time()
else
   sMsg += "jobSaiRemAutoNemag.x "+sCia+" [FALHOU] em:"+UsData2(m->Hoje)+" as:"+time()
endif
flBAS_GravaLog("/qtux/logs/jobs/jobSaiRemAutoNemag.log",sMsg)

RETURN(.t.)
///////////////////////////////////////////////////////////////////////////////
Fim FUNCTION main
///////////////////////////////////////////////////////////////////////////////


*********************************
FUNCTION fJobSOTEstocagemNemag()
*********************************

local i
local cSql
local k         := 0
local kk
local cHeadNF   := ""
local cHeadArq  := ""
local cDetail   := ""
local cTrailer  := ""
local nQtNF     := 0
local nQtNFs    := 0
local aArray


local uai       := .t.
local aArr

cSql  = " select a.DCONF D_EMISSAO,a.RECNO "
cSql += " from "+SetTabela("tsls120")+" a,"
cSql +=          SetTabela("titm013")+" d "
cSql += " where a.LEDI        = 0         and "
cSql += "       a.LCONF       = 1         and "
cSql += "       d.EDISTOC     = 1         and "
cSql += "       a.P2ALM       = d.RECNO       "
cSql += " order by a.RECNO "

AbreRS(cSql,"tsls120")
nCodNF = 0
sMsg += "Iniciando processo OT"+chr(10)
while !tsls120->(eof())
   // Header (Arquivo)
   if nCodNF <> tsls120->(RECNO())

      nQtNF   = 0 
      nQtNFs  = 0

      iNumeracao = tsls120->(RECNO()) 
      s = transform(iNumeracao,"9999999")
      cEDIArq = "T"+pCia+right("000000"+alltrim(s),6)+".ENT"


      local lExistePrn := file(sDir1+cEdiArq)
      if lExistePrn
         delete file &(sDir1+cEdiArq)
      endif
      handleEdiArq = fcreate(sDir1+cEdiArq)
      cHeadArq  = "0"						// Campo Indicador '0' fixo 	1-1 
      cHeadArq += space(1)					// Flag de Alteracao   X(1) 	2-2 
      cHeadArq += space(8)+chr(10)				// Referencia Anterior X(8) 	3-10 

      iError = fwrite(handleEdiArq,cHeadArq) 
      if iError <= 0
         sMsg += "jobSaiEDINemag.x iError:"+alltrim(iError)+" ARQ:"+alltrim(cEDIArq)+chr(10)
         uai = .f.
      endif
   endif

   ++k

   // Header (NF)
   cHeadNF  = "1"                                            // Campo Indicador 1            1-1
   s = transform(tsls120->(RECNO()),"999999")
   cHeadNF += right("000000"+alltrim(s),6)                   // Numero da Nota Fiscal        2-7
   cHeadNF += right(dtos(tsls120->D_EMISSAO),2)+substr(dtos(tsls120->D_EMISSAO),5,2)+left(dtos(tsls120->D_EMISSAO),4)+chr(10) // Data de Emissao              8-15 ddmmaaaa

   iError = fwrite(handleEdiArq,cHeadNF)                              // Grava cHeadNF
   if iError <= 0
      sMsg += "jobSaiEDINemag.x iError:"+alltrim(iError)+" ARQ:"+alltrim(cEDIArq)+chr(10)
      uai = .f.
   endif

   // Detail (NF)
   // rbm.06.01.2012 sem lote
   cSql  = " select  b.CODIGO PROCODIGO, a.NQT QT, b.C_MEDIO PRU, a.RECNO"
   cSql += " from "+SetTabela("tsls121")+" a,"
   cSql +=          SetTabela("titm002")+" b "
   cSql += " where a.PSO1 = "+str(tsls120->(RECNO()))
   cSql += "   and a.PPRO = b.RECNO "
   cSql += " order by a.RECNO "
   
   AbreRS(cSql,"tsls121")
   nQtNF = 0
   while !tsls121->(eof()) .and. uai
      cDetail  = "2"                                         // Campo Indicador 2            1-1
      cDetail += tsls121->PROCODIGO+space(10)          // Codigo do Produto            2-21 20pos
      s = transform(tsls121->QT*1000,"99999999999")
      cDetail += right("00000000000"+alltrim(s),11)          // Qt                           22-32
      cDetail += space(10)                                   // Lote                         33-42
      cDetail += space(3)                                    // Complemento                  43-45
      cDetail += "00000000"                                  // Data de Validade DDMMAAAA    46-53

      cDetail += sDeposit+space(10)                           // Depositante                  54-68
      s = transform(tsls121->PRU*100,"999999999")
      cDetail += right("000000000"+alltrim(s),9)             // Preo Unitrio9(7)V9(2)      69-77
      cDetail += space(1)                                    // Prdio X(01)                 78-78
      cDetail += space(3)                                    // Rua    X(03)                 79-81
      cDetail += "000"                                       // Bloco        9(03)           82-84
      cDetail += "00"                                        // Apto   9(02)                 85-86
      cDetail += "0000000000000"+chr(10)                     // PreoU +de 2 cdecimais       87-99

      iError = fwrite(handleEdiArq,cDetail)                           // Grava cDetail
      if iError <= 0
         sMsg += "jobSaiEDINemag.x iError:"+alltrim(iError)+" ARQ:"+alltrim(cEDIArq)+chr(10)
         uai = .f.
      endif

      nQtNF   += tsls121->QT
      nQtNFs  += tsls121->QT

      tsls121->(dbskip())
   end
   FechaRS("tsls121")

   // Trailer (NF)
   cTrailer  = "3"                                           // Campo Indicador 3            1-1
   s = transform(nQtNF*1000,"999999999999")
   cTrailer += right("000000000000"+alltrim(s),12)+chr(10)   // Total das Qtdes da NF        2-13

   iError = fwrite(handleEdiArq,cTrailer)                             // Grava cTrailer
   if iError <= 0
      sMsg += "jobSaiEDINemag.x iError:"+alltrim(iError)+" ARQ:"+alltrim(cEDIArq)+chr(10)
      uai = .f.
   endif

   uai = rdd_update("update "+SetTabela("tsls120")+" set LEDI=1 where RECNO = "+str(tsls120->(recno())))
   nCodNF = tsls120->(recno())
   if !uai
      sMsg += "jobSOTSaiRemAutoNemag.x SOT erro 1=Nao foi possivel gravar o numero do EDI. causa: DeadLock no DB. update "+SetTabela("tsls120")+" set LEDI=1 where RECNO = "+str(tsls120->(recno()))
   endif

   tsls120->(dbskip())

   if nCodNF <> tsls120->(RECNO()) .or. tsls120->(eof())
      // Trailer (Arquivo)
      cTrailer  = "9"                                                        // Campo Indicador 3            1-1
      s = transform(nQtNFs*1000,"999999999999")
      cTrailer += right("000000000000"+alltrim(s),12)+chr(10)             // Total das Qtdes das NF       2-13

      iError = fwrite(handleEdiArq,cTrailer)                                  // Grava cTrailer
      if iError <= 0
         sMsg += "jobSaiEDINemag.x iError:"+alltrim(iError)+" ARQ:"+alltrim(cEDIArq)+chr(10)
         uai = .f.
      endif

      uaic = fclose(handleEdiArq)
      if uaic
         if !lpathTmp
            while uai .and. frename(sDir1+cEdiArq,sDir2+cEdiArq)<>0; sleep(1); end
         endif
      endif
      sMsg += "GRAVACAO ARQUIVO: "+alltrim(cEdiArq)+" / "+if(uaic,"OK","NOK")+"."+chr(10)
   endif
end
FechaRS("tsls120")
if !uai
   sMsg += "jobSOTSaiRemAutoNemag.x [FALHOU] em:"+UsData2(m->Hoje)+" as:"+time()
   rdd_rollbck()
else
   rdd_commit()
endif
RETURN(uai)

*********************************
//////////////////////
FUNCTION fAJobOCSaida()
//////////////////////
*********************************
// p = ICodOC

local i
local cSql
local k         := 0
local kk
local cHeadNF   := ""
local cHeadArq  := ""
local cDetail   := ""
local cTrailer  := ""
local nQtNF     := 0
local nQtNFs    := 0
local aArray


local uai       := .t.
local aArr

cSql  = " select a.DT_OC D_EMISSAO,a.COD_OC,c.CODIGO MOTCOD,d.CODIGO TRACOD,a.COD_MOT,a.COD_TRA,a.RECNO  "
cSql += " from "+SetTabela("tsls111")+" a left join "+SetTabela("tsls010")+" c on a.COD_MOT = c.RECNO "
cSql +=                               "   left join "+SetTabela("tsls017")+" d on a.COD_TRA = d.RECNO,"
cSql +=          SetTabela("tsls110")+" b " 
cSql += " where a.RECNO = b.COD_111 "
cSql += "   and a.DT_IMPOC is not null "
cSql += "   and a.DT_NEMAG is null "
cSql += " group by a.DT_OC,a.COD_OC,c.CODIGO,d.CODIGO,a.COD_MOT,a.COD_TRA,a.RECNO "
AbreRS(cSql,"tsls111")
nCod111 = 0
while !tsls111->(eof())
   // Header (Arquivo)
   if nCod111 <> tsls111->COD_OC

      nQtNF   = 0 
      nQtNFs  = 0

      sTransp = space(15)
      if tsls111->COD_MOT > 0
         sTransp = tsls111->MOTCOD+space(15)
      else
         sTransp = tsls111->TRACOD+space(15)
      endif

      iNumeracao = tsls111->COD_OC
      s = transform(iNumeracao,"9999999")
      cEDIArq = "T"+pCia+right("000000"+alltrim(s),6)+".RET"

      local lExistePrn := file(sDir1+cEdiArq)
      if lExistePrn
         delete file &(sDir1+cEdiArq)
      endif
      handleEdiArq = fcreate(sDir1+cEdiArq)

      if handleEdiArq < 0
         sMsg += "jobSaiEDINemag.x erro handleEdiArq."+alltrim(handleEdiArq)+" ARQ:"+alltrim(cEDIArq)+chr(10)
         uai = .f.
      endif

      // Header (Arquivo)
      cHeadArq  = "0"                                           // Indicador    .0. (Fixo)              1-1     X
      cHeadArq += left(sTransp,15) //space(15)  //left(tmp->T_RAZAO,15)            // Cdigo da Transportadora     X(15)   2-16    X
      cHeadArq += space(1)                                      // Prioridade                   X(1)    17-17
      cHeadArq += "00"                                          // Tipo de Veculo              9(2)    18-19
      cHeadArq += "0000"                                        // Metragem Cbica         9(2)V9(2)    20-23
      cHeadArq += "00000"                                       // Peso                         9(5)    24-28
      cHeadArq += "0000"                                        // Nmero de Volumes            9(4)    29-32
      cHeadArq += "000"                                         // Estabelecimento de Sada     9(3)    33-35
      cHeadArq += "0"                                           // Tipo Transp. de Carga (*)    9(1)    36-36
      cHeadArq += "00000000"                                    // Data da Coleta           DDMMAAAA    37-44
      cHeadArq += "00000000000000"                              // CNPJ Embarcadora da NF       9(14)   45-58
      cHeadArq += "0000000"                                     // Peso c/ casas decimais V9(5)V9(2)    59-65
      cHeadArq += space(1)                                      // Flag de Alteracao            X(1)    66-66
      cHeadArq += space(8)+chr(10)                              // Referencia Anterior          X(8)    67-74

      iError = fwrite(handleEdiArq,cHeadArq)                             // Grava cHeadArq
      if iError <= 0
         sMsg += "jobSaiEDINemag.x iError:"+alltrim(iError)+" ARQ:"+alltrim(cEDIArq)+chr(10)
         uai = .f.
      endif

      nQtNFs = 0

      cHeadNF  = "1"                                            // Indicador            .1. (Fixo)      1-1     X
      s = transform(tsls111->COD_OC,"999999")
      cHeadNF += right("000000"+alltrim(s),6)                   // Nmero da Nota Fiscal        9(6)    2-7     X
      cHeadNF += space(14)                                      // CNPJ do Cliente              X(14)   8-21
      cHeadNF += space(40)                                      // Nome do Cliente              X(40)   22-61
      cHeadNF += space(40)                                      // Endereo do Cliente          X(40)   62-101
      cHeadNF += space(30)                                      // Cidade do Cliente            X(30)   102-131
      cHeadNF += space(2)                                       // Estado do Cliente            X(2)    132-133
      cHeadNF += space(8)                                       // CEP do Cliente               X(8)    134-141
      cHeadNF += space(4)                                       // Regio do Cliente            X(4)    142-145
      cHeadNF += space(18)                                      // I.E. do Cliente              X(18)   146-163
      cHeadNF += "0000"                                         // Nmero de Volumes            9(4)    164-167
      cHeadNF += "0000"                                         // Metragem Cbica      9(2)V9(2)       168-171
      cHeadNF += "00000"                                        // Peso 9(5)                            172-176
      cHeadNF += "0000000000"                                   // Valor da Nota        9(8)V9(2)       177-186
      cHeadNF += space(3)                                       // Srie da Nota Fiscal         X(3)    187-189
      cHeadNF += space(3)                                       // Estab. Faturamento           X(3)    190-192
      cHeadNF += "00000000"                                     // Data Previso Entrega DDMMAAAA       193-200
      cHeadNF += "0000000"+chr(10)                              // Peso c/ casas decimais V9(5)V9(2)    201-207

      iError = fwrite(handleEdiArq,cHeadNF)                              // Grava cHeaderNF
      if iError <= 0
         sMsg += "jobSaiEDINemag.x iError:"+alltrim(iError)+" ARQ:"+alltrim(cEDIArq)+chr(10)
         uai = .f.
      endif

      cObsNf  = "A"                                             // Indicador    .A. (Fixo)              1-1     X
      cObsNf += space(80)                                       // Observao 01                X(80)   2-81
      cObsNf += space(80)                                       // Observao 02                X(80)   82-161
      cObsNf += space(80)                                       // Observao 03                X(80)   162-241
      cObsNf += space(80)                                       // Observao 04                X(80)   242-321
      cObsNf += space(80)                                       // Observao 05                X(80)   322-401
      cObsNf += space(80)                                       // Observao 06                X(80)   402-481
      cObsNf += space(80)                                       // Observao 07                X(80)   482-561
      cObsNf += space(80)                                       // Observao 08                X(80)   562-641
      cObsNf += space(80)                                       // Observao 09                X(80)   642-721
      cObsNf += space(80)                                       // Observao 10                X(80)   722-801
      cObsNf += space(80)                                       // Observao 11                X(80)   802-881
      cObsNf += space(80)                                       // Observao 12                X(80)   882-961
      cObsNf += space(80)                                       // Observao 13                X(80)   962-1041
      cObsNf += space(80)+chr(10)                               // Observao 14                X(80)   1042-1121
      iError = fwrite(handleEdiArq,cObsNf)                               // Grava cHeaderNF
      if iError <= 0
         sMsg += "jobSaiEDINemag.x iError:"+alltrim(iError)+" ARQ:"+alltrim(cEDIArq)+chr(10)
         uai = .f.
      endif
      nQtNF = 0
   endif

   ++k

   // Detail (NF)
   cSql  = " select c.CODIGO PROCODIGO,b.QT,c.C_MEDIO PRU,a.RECNO "
   cSql += " from "+SetTabela("tsls111")+" a,"
   cSql +=          SetTabela("tsls110")+" b,"
   cSql +=          SetTabela("titm002")+" c "
   cSql += " where a.RECNO = b.COD_111 "
   cSql += "   and a.DT_IMPOC is not null "
   cSql += "   and a.DT_NEMAG is null "
   cSql += "   and b.COD_PRO = c.RECNO "
   cSql += "   and a.RECNO   = "+str(tsls111->(RECNO()))
   cSql += " order by c.CODIGO "
   AbreRS(cSql,"tsls121")
   nQtNF = 0
   while !tsls121->(eof()) .and. uai
      cDetail  = "2"                                               // Campo Indicador 2            1-1

      // HARDCODE
      cDetail += tsls121->PROCODIGO+space(10)          // Codigo do Produto            2-21 20pos
   
      s = transform(tsls121->QT*1000,"99999999999")
      cDetail += right("00000000000"+alltrim(s),11)                // Qt                           22-32
      cDetail += space(3)                                          // Complemento                  33-35
      cDetail += space(10)                                         // Lote                         36-45
      cDetail += sDeposit+space(10)+chr(10)                         // Depositante                  46-60
   
      iError = fwrite(handleEdiArq,cDetail)                                 // Grava cDetail
      if iError <= 0
         sMsg += "jobSaiEDINemag.x iError:"+alltrim(iError)+" ARQ:"+alltrim(cEDIArq)+chr(10)
         uai = .f.
      endif
   
      nQtNF   += tsls121->QT
      nQtNFs  += tsls121->QT


      tsls121->(dbskip())
   end
   FechaRS("tsls121")

   // Trailer (NF)
   // Trailer (NF)
   cTrailer  = "3"                                           // Campo Indicador 3            1-1
   s = transform(nQtNF*1000,"999999999999")
   cTrailer += right("000000000000"+alltrim(s),12)+chr(10)   // Total das Qtdes da NF        2-13

   iError = fwrite(handleEdiArq,cTrailer)                             // Grava cTrailer
   if iError <= 0
      sMsg += "jobSaiEDINemag.x iError:"+alltrim(iError)+" ARQ:"+alltrim(cEDIArq)+chr(10)
      uai = .f.
   endif

   if uai
      uai = rdd_update("update "+SetTabela("tsls111")+" set DT_NEMAG='"+UsData2(m->Hoje)+"' where RECNO = "+str(tsls111->(recno())))
   endif

   nCod111 = tsls111->(recno())
   if !uai
      sMsg += "jobSOTSaiRemAutoNemag.x SOT erro 1=Nao foi possivel gravar o numero do EDI. causa: DeadLock no DB."
   endif

   tsls111->(dbskip())

   if nCod111 <> tsls111->(RECNO()) .or. tsls111->(eof())
      // Trailer (Arquivo)
      cTrailer  = "9"                                           // Campo Indicador 3            1-1
      s = transform(nQtNFs*1000,"999999999999")
      cTrailer += right("000000000000"+alltrim(s),12) +chr(10)  // Total das Qtdes das NF       2-13

      iError = fwrite(handleEdiArq,cTrailer)                             // Grava cTrailer
      if iError <= 0
         sMsg += "jobSaiEDINemag.x iError:"+alltrim(iError)+" ARQ:"+alltrim(cEDIArq)+chr(10)
         uai = .f.
      endif

      uaic = fclose(handleEdiArq)
      if uaic
         if !lpathTmp
            while uai .and. frename(sDir1+cEdiArq,sDir2+cEdiArq)<>0; sleep(1); end
         endif
      endif
      sMsg += "GRAVACAO ARQUIVO: "+alltrim(cEdiArq)+" / "+if(uaic,"OK","NOK")+"."+chr(10)

   endif
end
FechaRS("tsls111")
if !uai
   sMsg += "jobSOTSaiRemAutoNemag.x [FALHOU] em:"+UsData2(m->Hoje)+" as:"+time()
   rdd_rollbck()
else
   rdd_commit()
endif
RETURN(uai)

//////////////////////
FUNCTION fBJobOCSaida()
//////////////////////
*********************************
// p = ICodOC

local i
local cSql
local k         := 0
local kk
local cHeadNF   := ""
local cHeadArq  := ""
local cDetail   := ""
local cTrailer  := ""
local nQtNF     := 0
local nQtNFs    := 0
local aArray

local uai       := .t.
local aArr

cSql  = " select a.DT_OC D_EMISSAO,a.COD_OC,c.CODIGO MOTCOD,d.CODIGO TRACOD,a.COD_MOT,a.COD_TRA,sum(b.QT) VOLUMES, sum(b.PB) PESO,a.RECNO  "
cSql += " from "+SetTabela("tsls111")+" a left join "+SetTabela("tsls010")+" c on a.COD_MOT = c.RECNO "
cSql +=                               "   left join "+SetTabela("tsls017")+" d on a.COD_TRA = d.RECNO,"
cSql +=          SetTabela("tsls110")+" b "
cSql += " where a.RECNO = b.COD_111 "
cSql += "   and a.DT_IMPOC is not null "
cSql += "   and a.DT_NEMAG is null "
cSql += " group by a.DT_OC,a.COD_OC,c.CODIGO,d.CODIGO,a.COD_MOT,a.COD_TRA,a.RECNO "
AbreRS(cSql,"tsls111")
nCod111 = 0
while !tsls111->(eof())
   // Header (Arquivo)
   if nCod111 <> tsls111->COD_OC

      nQtNF   = 0 
      nQtNFs  = 0

      sTransp = space(15)
      if tsls111->COD_MOT > 0
         sTransp = tsls111->MOTCOD+space(15)
      else
         sTransp = tsls111->TRACOD+space(15)
      endif

      iNumeracao = tsls111->COD_OC
      s = transform(iNumeracao,"9999999")
      if iNumeracao = 176268
         cEDIArq = "AAAAAA"+pCia+right("000000"+alltrim(s),6)+".XXXXXXXXX"
      else
         cEDIArq = "T"+pCia+right("000000"+alltrim(s),6)+".RET"
      endif

      local lExistePrn := file(sDir1+cEdiArq)
      if lExistePrn
         delete file &(sDir1+cEdiArq)
      endif
      handleEdiArq = fcreate(sDir1+cEdiArq)

      if handleEdiArq < 0
         sMsg += "jobSaiEDINemag.x erro handleEdiArq."+alltrim(handleEdiArq)+" ARQ:"+alltrim(cEDIArq)+chr(10)
         uai = .f.
      endif

      // Header (Arquivo)
      cHeadArq  = "0"                                           // Indicador    .0. (Fixo)              1-1     X      
      cHeadArq += left(sTransp,15)  //left(tmp->T_RAZAO,15)     // Cdigo da Transportadora     X(15)   2-16    X
      cHeadArq += space(1)                                      // Prioridade                   X(1)    17-17
      cHeadArq += "00"                                          // Tipo de Veculo              9(2)    18-19
      cHeadArq += "0000"                                        // Metragem Cbica         9(2)V9(2)    20-23
      cHeadArq += padl(alltrim(transform(tsls111->PESO,"@e 99999")),5,"0")		// "00000"                                       // Peso                         9(5)    24-28
      cHeadArq += padl(alltrim(transform(tsls111->VOLUMES,"@e 9999")),4,"0")		// "0000"                                        // Nmero de Volumes            9(4)    29-32
      cHeadArq += "000"                                         // Estabelecimento de Sada     9(3)    33-35
      cHeadArq += "1"                                           // Tipo Transp. de Carga (*)    9(1)    36-36
      cHeadArq += "00000000"                                    // Data da Coleta           DDMMAAAA    37-44
      cHeadArq += space(14)	                                // CNPJ Embarcadora da NF       9(14)   45-58
      cHeadArq += "0000000"                                     // Peso c/ casas decimais V9(5)V9(2)    59-65
      cHeadArq += space(1)                                      // Flag de Alteracao            X(1)    66-66
      cHeadArq += space(8)+chr(10)                              // Referencia Anterior          X(8)    67-74

      iError = fwrite(handleEdiArq,cHeadArq)                             // Grava cHeadArq
      if iError <= 0
         sMsg += "jobSaiEDINemag.x iError:"+alltrim(iError)+" ARQ:"+alltrim(cEDIArq)+chr(10)
         uai = .f.
      endif

      nQtNFs = 0

      cSql  = " select a.DT_OC D_EMISSAO,b.COD_OC,sum(b.QT) VOLUMES, sum(b.PB) PESO,d.ENDERECO,d.NR,d.BAIRRO,d.CEP,e.CIDADE,f.UF,c.CGC,c.CLIENTE,a.RECNO  "
      //cSql  = " select a.DT_OC D_EMISSAO,b.COD_OC,sum(b.QT) VOLUMES, sum(b.PB) PESO,d.ENDERECO,d.BAIRRO,d.CEP,e.CIDADE,f.UF,a.RECNO  "
      cSql += " from "+SetTabela("tsls111")+" a, "
      cSql +=   SetTabela("tsls110")+" b left join "+SetTabela("tsls021")+" d on b.COD_END = d.RECNO " 
      cSql +=                        "   left join "+SetTabela("tbas010")+" e on d.COD_CID = e.RECNO "
      cSql +=                        "   left join "+SetTabela("tbas009")+" f on e.COD_UF  = f.RECNO, "
      cSql +=   SetTabela("tsls019")+" c "
      cSql += " where a.RECNO   = b.COD_111 "
      cSql += "   and c.RECNO   = b.COD_CLI "
      cSql += "   and a.DT_IMPOC is not null "
      cSql += "   and a.DT_NEMAG is null "
      cSql += "   and a.COD_OC  = "+alltrim(tsls111->COD_OC)
      cSql += " group by a.DT_OC,b.COD_OC,d.ENDERECO,d.NR,d.BAIRRO,d.CEP,e.CIDADE,f.UF,c.CGC,c.CLIENTE,a.RECNO "
      //cSql += " group by a.DT_OC,b.COD_OC,d.ENDERECO,d.BAIRRO,d.CEP,e.CIDADE,f.UF,a.RECNO "
      AbreRS(cSql,"ttmp")
      while !ttmp->(eof()) .and. uai
         cHeadNF  = "1"                                            // Indicador            .1. (Fixo)      1-1     X
         s = transform(ttmp->COD_OC,"999999")
         cHeadNF += right("000000"+alltrim(s),6)                   // Nmero da Nota Fiscal        9(6)    2-7     X

         sTmp=fNfeClearField(ttmp->CGC)+space(14)
         cHeadNF += left(sTmp,14)                                  // CNPJ do Cliente              X(14)   8-21
         cHeadNF += left(ttmp->CLIENTE+space(40),40)               // Nome do Cliente              X(40)   22-61
         cHeadNF += left(ttmp->ENDERECO+space(40),40)              // Endereo do Cliente          X(40)   62-101
         cHeadNF += left(ttmp->CIDADE+space(30),30)                // Cidade do Cliente            X(30)   102-131
         cHeadNF += ttmp->UF                                       // Estado do Cliente            X(2)    132-133
         sTmp=fNfeClearField(ttmp->CEP)+space(14)
         cHeadNF += left(sTmp+space(8),8)                     // CEP do Cliente               X(8)    134-141
         cHeadNF += space(4)                                       // Regio do Cliente            X(4)    142-145
         cHeadNF += space(18)                                      // I.E. do Cliente              X(18)   146-163
         cHeadNF += "0000"                                         // Nmero de Volumes            9(4)    164-167
         cHeadNF += "0000"                                         // Metragem Cbica      9(2)V9(2)       168-171
         cHeadNF += "00000"                                        // Peso 9(5)                            172-176
         cHeadNF += "0000000000"                                   // Valor da Nota        9(8)V9(2)       177-186
         cHeadNF += space(3)                                       // Srie da Nota Fiscal         X(3)    187-189
         cHeadNF += space(3)                                       // Estab. Faturamento           X(3)    190-192
         cHeadNF += "00000000"                                     // Data Previso Entrega DDMMAAAA       193-200
         cHeadNF += "00000000"  	                           // Peso c/ casas decimais V9(5)V9(3)    201-208

         cHeadNF += "N"			// X(1) => S ou N	209 - 209	Magazine/Supermercado
 	 cHeadNF += "N"			// X(1) => S ou N	210 - 210	Entrega Paletizada
         cHeadNF += "0000000"		// 9(3)V9(4)		211 - 217	Metragem Cbica 2 (**)
         cHeadNF += space(10)		 // X(10)		218 - 227	Nmero do Pedido
         cHeadNF += space(20)		// X(20)		228 - 247	Bairro do Cliente
         cHeadNF += "00"		// 9(02)		248 - 249	Tipo do Cliente
         cHeadNF += space(12)		// X(12)		250 - 261	Cdigo Regio IBGE
         cHeadNF += space(30)		// X(30)		262 - 291	Descrio da Regio
         cHeadNF += "0000000000"	// 9(8)V9(2)		292 - 301	Frete: Valor Total
         cHeadNF += "0000000000"	// 9(8)V9(2)		302 - 311	Frete: Frete Peso
         cHeadNF += "0000000000"	// 9(8)V9(2)		312 - 321	Frete: Frete Valor
         cHeadNF += "0000000000"	// 9(8)V9(2)		322 - 331	Frete: Taxa p/ Entrega
         cHeadNF += "0000000000"	// 9(8)V9(2)		332 - 341	Frete: Valor do Pedgio
         cHeadNF += "0000000000"	// 9(8)V9(2)		342 - 351	Frete: Valor Dirias
         cHeadNF += "0000000000"	// 9(8)V9(2)		352 - 361	Frete: Base Clculo ICMS
         cHeadNF += "00000"		// 9(3)V9(2)		362 - 366	Frete: Alquota ICMS
         cHeadNF += "0000000000"	// 9(8)V9(2)		367 - 376	Frete: Valor do ICMS
         cHeadNF += "0000000000"	// 9(8)V9(2)		377 - 386	Frete: Valor Outros
         cHeadNF += "00000000"		// DDMMAAAA		387 - 394	Data de Emisso da NF
         cHeadNF += "000000000"		// 9(9)			395 - 403	No. NF. Eletrnica (***)
         cHeadNF += "0000"+chr(10)	// 9(4)			404 - 407	CFOP


         iError = fwrite(handleEdiArq,cHeadNF)                              // Grava cHeaderNF
         if iError <= 0
            sMsg += "jobSaiEDINemag.x iError:"+alltrim(iError)+" ARQ:"+alltrim(cEDIArq)+chr(10)
            uai = .f.
         endif
         // Detail (NF)
         cSql  = " select c.CODIGO PROCODIGO,sum(b.QT) QT,sum(c.C_MEDIO) PRU,a.RECNO "
         cSql += " from "+SetTabela("tsls111")+" a,"
         cSql +=          SetTabela("tsls110")+" b,"
         cSql +=          SetTabela("titm002")+" c "
         cSql += " where a.RECNO = b.COD_111 "
         cSql += "   and a.DT_IMPOC is not null "
         cSql += "   and a.DT_NEMAG is null "
         cSql += "   and b.COD_PRO = c.RECNO "
         cSql += "   and a.COD_OC  = "+alltrim(ttmp->COD_OC)
         cSql += "   and a.RECNO   = "+str(tsls111->(RECNO()))
         cSql += " group by c.CODIGO,a.RECNO " // nova
         cSql += " order by c.CODIGO "
         AbreRS(cSql,"tsls121")
         nQtNF = 0
         while !tsls121->(eof()) .and. uai
            cDetail  = "2"                                               // Campo Indicador 2            1-1
      
            // HARDCODE
            cDetail += tsls121->PROCODIGO+space(10)          // Codigo do Produto            2-21 20pos
         
            s = transform(tsls121->QT*1000,"99999999999")
            cDetail += right("00000000000"+alltrim(s),11)                // Qt                           22-32
            cDetail += space(3)                                          // Complemento                  33-35
            cDetail += space(10)                                         // Lote                         36-45
            cDetail += sDeposit+space(10)	                           // Depositante                  46-60
      
            cDetail += space(10)		//X(10)		61 - 70	Complemento com 10 dgitos (*)
            cDetail += "00000000"		//9(08)		71 - 78	Quantidade em Volumes (**)
            cDetail += space(20)		//X(20) 	79 - 98	Lote com 20 dgitos
            cDetail += space(12)		//X(12)		99 - 110	Nmero da Ordem
            cDetail += "0000000000000"+chr(10)//9(7)V9(6)	111-124	Preo Unitrio de Venda
         
            iError = fwrite(handleEdiArq,cDetail)                                 // Grava cDetail
            if iError <= 0
               sMsg += "jobSaiEDINemag.x iError:"+alltrim(iError)+" ARQ:"+alltrim(cEDIArq)+chr(10)
               uai = .f.
            endif
         
            nQtNF   += tsls121->QT
            nQtNFs  += tsls121->QT
      
      
            tsls121->(dbskip())
         end
         FechaRS("tsls121")

         // Trailer (NF)
         cTrailer  = "3"                                           // Campo Indicador 3            1-1
         s = transform(nQtNF*1000,"999999999999")
         cTrailer += right("000000000000"+alltrim(s),12)+chr(10)   // Total das Qtdes da NF        2-13
      
         iError = fwrite(handleEdiArq,cTrailer)                             // Grava cTrailer
         if iError <= 0
            sMsg += "jobSaiEDINemag.x iError:"+alltrim(iError)+" ARQ:"+alltrim(cEDIArq)+chr(10)
            uai = .f.
         endif
         ttmp->(dbskip())

      end
      FechaRS("ttmp")



      cObsNf  = "A"                                             // Indicador    .A. (Fixo)              1-1     X
      cObsNf += space(80)                                       // Observao 01                X(80)   2-81
      cObsNf += space(80)                                       // Observao 02                X(80)   82-161
      cObsNf += space(80)                                       // Observao 03                X(80)   162-241
      cObsNf += space(80)                                       // Observao 04                X(80)   242-321
      cObsNf += space(80)                                       // Observao 05                X(80)   322-401
      cObsNf += space(80)                                       // Observao 06                X(80)   402-481
      cObsNf += space(80)                                       // Observao 07                X(80)   482-561
      cObsNf += space(80)                                       // Observao 08                X(80)   562-641
      cObsNf += space(80)                                       // Observao 09                X(80)   642-721
      cObsNf += space(80)                                       // Observao 10                X(80)   722-801
      cObsNf += space(80)                                       // Observao 11                X(80)   802-881
      cObsNf += space(80)                                       // Observao 12                X(80)   882-961
      cObsNf += space(80)                                       // Observao 13                X(80)   962-1041
      cObsNf += space(80)+chr(10)                               // Observao 14                X(80)   1042-1121
      iError = fwrite(handleEdiArq,cObsNf)                               // Grava cHeaderNF
      if iError <= 0
         sMsg += "jobSaiEDINemag.x iError:"+alltrim(iError)+" ARQ:"+alltrim(cEDIArq)+chr(10)
         uai = .f.
      endif
      nQtNF = 0
   endif

   ++k


   // Trailer (NF)

   if uai
      uai = rdd_update("update "+SetTabela("tsls111")+" set DT_NEMAG='"+UsData2(m->Hoje)+"' where RECNO = "+str(tsls111->(recno())))
   endif

   nCod111 = tsls111->(recno())
   if !uai
      sMsg += "jobSOTSaiRemAutoNemag.x SOT erro 1=Nao foi possivel gravar o numero do EDI. causa: DeadLock no DB."
   endif

   tsls111->(dbskip())

   if nCod111 <> tsls111->(RECNO()) .or. tsls111->(eof())
      // Trailer (Arquivo)
      cTrailer  = "9"                                           // Campo Indicador 3            1-1
      s = transform(nQtNFs*1000,"999999999999")
      cTrailer += right("000000000000"+alltrim(s),12) +chr(10)  // Total das Qtdes das NF       2-13

      iError = fwrite(handleEdiArq,cTrailer)                             // Grava cTrailer
      if iError <= 0
         sMsg += "jobSaiEDINemag.x iError:"+alltrim(iError)+" ARQ:"+alltrim(cEDIArq)+chr(10)
         uai = .f.
      endif

      uaic = fclose(handleEdiArq)
      if uaic
         if !lpathTmp
            while uai .and. frename(sDir1+cEdiArq,sDir2+cEdiArq)<>0; sleep(1); end
         endif
      endif
      sMsg += "GRAVACAO ARQUIVO: "+alltrim(cEdiArq)+" / "+if(uaic,"OK","NOK")+"."+chr(10)

   endif
end
FechaRS("tsls111")
if !uai
   sMsg += "jobSOTSaiRemAutoNemag.x [FALHOU] em:"+UsData2(m->Hoje)+" as:"+time()
   rdd_rollbck()
else
   rdd_commit()
endif
RETURN(uai)