<?php
require('/qtux/www/FullPlat/pFuncoes1.php');
// Configuraes de conexo
$configA = [
    'host' => '177.153.18.154',
    'port' => 3050,
    'database' => '/qtux/database/desenvolvimento/gps_01.gdb',
    'user' => 'sysdba',
    'password' => '#@&%TG@efg'
];

$configB = [
    'host' => 'localhost',
    'port' => 3050,
    'database' => '/qtux/database/tq/gps_01.gdb',
    'user' => 'sysdba',
    'password' => '#@&%TG@efg'
];

$sTxtA = 'A_'.time().'.sql';
$sTxtB = 'B_'.time().'.sql';

fpc($sTxtA,"SET SQL dialect 3;".chr(10)."CONNECT '{$configA['host']}:{$configA['database']}';".chr(10));
fpc($sTxtB,"SET SQL dialect 3;".chr(10)."CONNECT '{$configB['host']}:{$configB['database']}';".chr(10));


$pdoA = connect($configA);
$pdoB = connect($configB);

// Extrair metadados
$metaA = getMetadata($pdoA);
$metaB = getMetadata($pdoB);

// Executar comparao
$diferencas = compareMetadata($metaA, $metaB);

fpc_append($sTxtA,'commit;');
fpc_append($sTxtB,'commit;');

// Exibir resultados
//print_r($diferencas);



////////////////////////////////////
function connect($config) {
    $dsn = "firebird:dbname={$config['host']}/{$config['port']}:{$config['database']};charset=utf8";
    $pdo = new PDO($dsn, $config['user'], $config['password'], [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION // Habilita excees
    ]);
    return $pdo;
}


// Funo para extrair metadados
function getMetadata($pdo) {
    $metadata = [
        'tables' => [],
        'procedures' => [],
        'triggers' => [],
        'indices' => [],
        'foreign_keys' => []
    ];

    try {

// Query corrigida
    $stmt = $pdo->query("
        SELECT 
            TRIM(RDB\$GENERATOR_NAME) AS \"GENERATOR_NAME\" 
        FROM RDB\$GENERATORS 
        WHERE RDB\$SYSTEM_FLAG = 0
    ");
    $generators = [];
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        if (!isset($row['GENERATOR_NAME'])) {
            continue; // Ou trate o erro
        }
        
        $generatorName = $row['GENERATOR_NAME'];
        $stmtVal = $pdo->query("SELECT gen_id($generatorName, 0) FROM RDB\$DATABASE");
        $currentValue = $stmtVal->fetchColumn();
        
        $generators[$generatorName] = $currentValue;
    }

        // Tabelas e Colunas
        $sql = "
            SELECT 
                r.RDB\$RELATION_NAME AS \"table_name\",
                rf.RDB\$FIELD_NAME AS \"column_name\",
                f.RDB\$FIELD_TYPE AS \"data_type\",
                f.RDB\$FIELD_LENGTH AS \"length\",
                rf.RDB\$NULL_FLAG AS \"is_nullable\"
            FROM RDB\$RELATIONS r
            JOIN RDB\$RELATION_FIELDS rf ON r.RDB\$RELATION_NAME = rf.RDB\$RELATION_NAME
            JOIN RDB\$FIELDS f ON rf.RDB\$FIELD_SOURCE = f.RDB\$FIELD_NAME
            WHERE r.RDB\$SYSTEM_FLAG = 0
            ORDER BY r.RDB\$RELATION_NAME, rf.RDB\$FIELD_POSITION
        ";
        $stmt = $pdo->query($sql);
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
           $table = strtoupper(trim($row['table_name'])); // Normaliza para maisculas
           $column = strtoupper(trim($row['column_name']));
           $metadata['tables'][$table][$column] = $row;

           // Associar generator  tabela (ex.: GEN_CLIENTES_ID para tabela CLIENTES)
           $generatorName = "$table";
           if (isset($generators[$generatorName])) {
              $metadata['tables'][$table]['generator_value'] = $generators[$generatorName];
           }
        }

        // Procedures
        $stmt = $pdo->query("SELECT RDB\$PROCEDURE_NAME FROM RDB\$PROCEDURES");
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
            $metadata['procedures'][] = trim($row['RDB$PROCEDURE_NAME']);
        }

        // ndices
        $stmt = $pdo->query("
            SELECT 
                RDB\$RELATION_NAME AS \"table_name\",
                RDB\$INDEX_NAME AS \"index_name\",
                RDB\$UNIQUE_FLAG AS \"is_unique\"
            FROM RDB\$INDICES
            WHERE RDB\$SYSTEM_FLAG = 0
        ");
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
            $metadata['indices'][trim($row['table_name'])][] = $row;
        }

        // Chaves Estrangeiras
        $stmt = $pdo->query("
            SELECT 
                rc.RDB\$CONSTRAINT_NAME AS \"fk_name\",
                c.RDB\$RELATION_NAME AS \"table_name\",
                s.RDB\$FIELD_NAME AS \"column_name\",
                refc.RDB\$RELATION_NAME AS \"referenced_table\",
                refs.RDB\$FIELD_NAME AS \"referenced_column\"
            FROM 
                RDB\$REF_CONSTRAINTS rc
                JOIN RDB\$RELATION_CONSTRAINTS c 
                    ON rc.RDB\$CONSTRAINT_NAME = c.RDB\$CONSTRAINT_NAME
                JOIN RDB\$INDEX_SEGMENTS s 
                    ON c.RDB\$INDEX_NAME = s.RDB\$INDEX_NAME
                JOIN RDB\$RELATION_CONSTRAINTS refc 
                    ON rc.RDB\$CONST_NAME_UQ = refc.RDB\$CONSTRAINT_NAME
                JOIN RDB\$INDEX_SEGMENTS refs 
                    ON refc.RDB\$INDEX_NAME = refs.RDB\$INDEX_NAME
            WHERE 
                c.RDB\$CONSTRAINT_TYPE = 'FOREIGN KEY'
        ");
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
            $table = trim($row['table_name']);
            $metadata['foreign_keys'][$table][] = $row;
        }


    } catch (PDOException $e) {
        die("Erro ao extrair metadados: " . $e->getMessage());
    }

    return $metadata;
}

// Funo para comparar metadados
function compareMetadata($metaA, $metaB) {
   global $sTxtA;
   global $sTxtB;

    $diff = [];

    // 1. Comparar Tabelas
    $tablesA = array_keys($metaA['tables']);
    $tablesB = array_keys($metaB['tables']);
    $diff['tables']['missing_in_b'] = array_diff($tablesA, $tablesB);
    $diff['tables']['missing_in_a'] = array_diff($tablesB, $tablesA);

    // 2. Comparar Colunas e Tipos
    foreach ($metaA['tables'] as $table => $columnsA) {
        if (!isset($metaB['tables'][$table])) continue;

        foreach ($columnsA as $colName => $colDetailsA) {
            $colDetailsB = $metaB['tables'][$table][$colName] ?? null;

            // Coluna no existe no Banco B
            if (!$colDetailsB) {
                $diff['columns'][$table]['missing_in_b'][$colName] = $colDetailsA;
                continue;
            }

            // Comparar tipo, tamanho e nulidade
            if ($colDetailsA['data_type'] != $colDetailsB['data_type'] || 
                $colDetailsA['length'] != $colDetailsB['length'] || 
                $colDetailsA['is_nullable'] != $colDetailsB['is_nullable']) {
                $diff['columns'][$table]['diferencas'][$colName] = [
                    'banco_a' => $colDetailsA, 
                    'banco_b' => $colDetailsB
                ];
            }
            $iGenerator_A = isset($metaA['tables'][$table]['generator_value']) ? $metaA['tables'][$table]['generator_value'] : 'NO TEM';
            $iGenerator_B = isset($metaB['tables'][$table]['generator_value']) ? $metaB['tables'][$table]['generator_value'] : 'NO TEM';
            if (1==0 && ($iGenerator_A<=50000) && (translateDataType($colDetailsA['data_type'])=='SMALLINT' || translateDataType($colDetailsA['data_type'])=='INTEGER' || translateDataType($colDetailsA['data_type'])=='FLOAT' || translateDataType($colDetailsA['data_type'])=='INT64') && $colDetailsA['is_nullable']!=1) {
               fpc_append($sTxtA,"ALTER TABLE $table ALTER COLUMN $colName SET NOT NULL;--".$iGenerator_A);
            }
            if (($iGenerator_B<=3000000) && (translateDataType($colDetailsB['data_type'])=='SMALLINT' || translateDataType($colDetailsB['data_type'])=='INTEGER' || translateDataType($colDetailsB['data_type'])=='FLOAT' || translateDataType($colDetailsB['data_type'])=='INT64') && $colDetailsB['is_nullable']!=1) {
               fpc_append($sTxtB,"ALTER TABLE $table ALTER COLUMN $colName SET NOT NULL;--".$iGenerator_B);
            }
        }

        // Verificar colunas faltando no Banco A
        foreach ($metaB['tables'][$table] as $colName => $colDetailsB) {
            if (!isset($columnsA[$colName])) {
                $diff['columns'][$table]['missing_in_a'][$colName] = $colDetailsB;
            }
        }
    }

    // 3. Comparar Procedures
    $diff['procedures']['missing_in_b'] = array_diff($metaA['procedures'], $metaB['procedures']);
    $diff['procedures']['missing_in_a'] = array_diff($metaB['procedures'], $metaA['procedures']);

    // 4. Comparar ndices (adicione cdigo semelhante para ndices e FKs)
    // ...

    return $diff;
}

function translateDataType($typeCode) {
    $types = [
              7   => 'SMALLINT', 
              8   => 'INTEGER', 
              37  => 'VARCHAR',
              14  => 'CHAR', 
              12  => 'DATE', 
              35  => 'TIMESTAMP',
              10  => 'FLOAT',
              261 => 'BLOB',
              40  => 'CSTRING',
              11  => 'D_FLOAT',
              27  => 'DOUBLE',
              16  => 'INT64',
              9   => 'QUAD',
              13  => 'TIME'
             ];
    return $types[$typeCode] ?? 'DESCONHECIDO';
}
//7,8,10,11,27,16,9