#!/bin/php
<?php
//   date_default_timezone_set("America/Sao_Paulo");
ini_set('memory_limit','4096M');
require_once("../pPublics1.php");
require_once("../pFuncoes1.php");

list($usec, $sec) = explode(' ', microtime());
$tScript_Start = (float) $sec + (float) $usec;

$tJobStart = time();
echo 'Inicio: '. date('d/m/Y H:i:s',$tJobStart).chr(10);
$sFileSql = "01ResultadoComparacao_$tJobStart.sql";
$sDirAProc = '/qtux/www/FullPlat/Comparador/AProcessar';
$sFileEDI = '';
if (is_dir($sDirAProc)) {
   $aDir = array_diff(scandir($sDirAProc),array(".",".."));
   $iCount = count($aDir);
   if ($iCount==0) {
      echo "Nenhum Arquivo encontrado em $sDirAProc".chr(10);
      exit();
   }
   foreach ($aDir as $sDirFile) {  // para todos os files da pasta
      if (substr($sDirFile,strlen($sDirFile)-4,4)=='.edi') {
         $sFileEDI = $sDirFile;
      }
   }
}
if (file_exists($sDirAProc.'/'.$sFileEDI)) {
   echo "Acessando o arquivo $sDirFile".chr(10);      
} else {
   echo "Arquivo $sDirAProc$sDirFile não existe".chr(10);
   exit();
}

//$sFileEDI = 'Estrutura_1487612518.edi';

$sfgc = file_get_contents($sDirAProc.'/'.$sFileEDI);
//$sfgc = file_get_contents("StructClient.txt");
$areg = explode(chr(10),$sfgc);

echo "Carregando os dados da origem...".chr(10);
// Carrega dados da Origem
$iCountReg = count($areg);
for ($i=0; $i<$iCountReg; $i++) {
   if ($areg[$i]!='') {
      $aTmp = explode(";",$areg[$i]);

      $aOrig[$i][0] = $aTmp[0]; // RELATION_NAME		
      $aOrig[$i][1] = $aTmp[1]; // FIELD_NAME
      $aOrig[$i][2] = $aTmp[2]; // FIELD_PRECISION
      $aOrig[$i][3] = $aTmp[3]; // FIELD_SCALE
      $aOrig[$i][4] = $aTmp[4]; // FIELD_LENGTH
      $aOrig[$i][5] = $aTmp[5]; // FIELD_TYPE
   }
}
$psDSN   = "localhost:/qtux/database/tq/gps_01.gdb";  // DB Destino
//$psDSN   = "192.168.1.109:/qtux/database/total/gps_01.gdb";	// DB Destino
//   $psDSN   = "192.168.1.3:/qtux/database/total/gps_01.gdb";	// DB Destino
//   $psDSN   = "eko.sanol.com.br:/qtux/database/total/gps_01.gdb";
$hDb     = fhDbConnect($psDSN);

echo "Carregando os dados do destino...".chr(10);
// Carrega os dados do Destino
$sSql = 'select r.RDB$RELATION_NAME,r.RDB$FIELD_NAME AS nome,
                f.RDB$FIELD_PRECISION, f.RDB$FIELD_SCALE,RDB$FIELD_LENGTH,f.RDB$FIELD_TYPE
         FROM RDB$RELATION_FIELDS r LEFT JOIN RDB$FIELDS f ON r.RDB$FIELD_SOURCE = f.RDB$FIELD_NAME
                ORDER BY r.RDB$RELATION_NAME,RDB$FIELD_POSITION';


$aDest  = faDbSelect($hDb,$sSql);
$iCountDest = count($aDest);
for ($j=0; $j<$iCountDest; $j++) {   // loop da query do sysdb
   
   $aDest[$j][0] = trim($aDest[$j][0]);
   $aDest[$j][1] = trim($aDest[$j][1]);
   $aDest[$j][2] = trim($aDest[$j][2]);
   $aDest[$j][3] = trim($aDest[$j][3]);
   $aDest[$j][4] = trim($aDest[$j][4]);
   if (trim($aDest[$j][5])==261) { 
      $aDest[$j][5] = 'BLOB';
   }
   if (trim($aDest[$j][5])==14) { 
      $aDest[$j][5] = 'CHAR';
   }
   if (trim($aDest[$j][5])==40) { 
      $aDest[$j][5] = 'CSTRING';
   }
   if (trim($aDest[$j][5])==11) { 
      $aDest[$j][5] = 'D_FLOAT';
   }
   if (trim($aDest[$j][5])==27) { 
      $aDest[$j][5] = 'DOUBLE';
   }
   if (trim($aDest[$j][5])==10) { 
      $aDest[$j][5] = 'FLOAT';
   }
   if (trim($aDest[$j][5])==16) { 
      $aDest[$j][5] = 'INT64';
   }
   if (trim($aDest[$j][5])==8) { 
      $aDest[$j][5] = 'INTEGER';
   }
   if (trim($aDest[$j][5])==9) { 
      $aDest[$j][5] = 'QUAD';
   }
   if (trim($aDest[$j][5])==7) { 
      $aDest[$j][5] = 'SMALLINT';
   }
   if (trim($aDest[$j][5])==12) { 
      $aDest[$j][5] = 'DATE';
   }
   if (trim($aDest[$j][5])==13) { 
      $aDest[$j][5] = 'TIME';
   }
   if (trim($aDest[$j][5])==35) { 
      $aDest[$j][5] = 'TIMESTAMP';
   }
   if (trim($aDest[$j][5])==37) { 
      $aDest[$j][5] = 'VARCHAR';
   }
}

flDbDisconnect($hDb);

echo "Fazendo a comparao da estrutura de dados entre o banco da origem e destino...".chr(10);
$lLab  = false;
$sIni  = "--------------------------------------------------------".chr(10);
$sIni .= "--Processo realizado no dia:".date('d/m/Y',$tJobStart).chr(10);
$sIni .= "--Hora que foi realizado: ".date('G:i:s',$tJobStart).chr(10);
$sIni .= "--------------------------------------------------------".chr(10);
$sIni .= 'SET SQL dialect 3;'.chr(10);
$sIni .= "CONNECT '$psDSN';".chr(10).chr(10);
$s1    = "";
$s2    = "";
$s3    = "";
$s4    = "";
$soTab = "";
$sT1   = "";
$sT2   = "";
$sT3   = "";
$lVazio = true;
fpc($sFileSql,$sIni);
$iCountOrig = count($aOrig);


for ($i=0; $i<$iCountOrig; $i++) {	// ORIGEM (DB atualizado)
   if ($soTab <> $aOrig[$i][0]) {
      $lTNew  = false;
      $lVazio = false;
   }

   if (($soTab <> $aOrig[$i][0]) && ($sT1!='')) {
      fpc_append($sFileSql,$sT1.$sT2.$sT3);
      $sT1   = "";
      $sT2   = "";
      $sT3   = "";
      $lVazio = true;
   }

   $lE = false;
   $lVazio = false;
   $iCountDest = count($aDest);
   for ($j=0; $j<$iCountDest; $j++) { // DESTINO (DB  Atualizar)
      if (($aOrig[$i][0]==$aDest[$j][0]) && ($aOrig[$i][1]==$aDest[$j][1])) {	// Se encontrou tabela+campo no destino
         // Verificar estrutura
         if (($aDest[$j][2]<>$aOrig[$i][2]) || ($aDest[$j][3]<>$aOrig[$i][3]) || ($aDest[$j][4]<>$aOrig[$i][4]) || ($aDest[$j][5]<> $aOrig[$i][5])) {	// Existe divergencia em um dos (*) campos
            // Se entrou, um dos campos abaixo est diferente.
            if ($lLab) {
               $s2 .= "--DIVERGENCIA ORIGEM ";
               $s2 .= $aOrig[$i][0].' '; 		// RELATION_NAME
               $s2 .= $aOrig[$i][1].'|'; 		// FIELD_NAME
               $s2 .= $aOrig[$i][2].'|'; 		// FIELD_PRECISION(*)
               $s2 .= $aOrig[$i][3].'|'; 		// FIELD_SCALE(*)
               $s2 .= $aOrig[$i][4].'|'; 		// FIELD_LENGTH(*)
               $s2 .= $aOrig[$i][5].chr(10); 		// FIELD_TYPE(*)
               $s2 .= "--           DESTINO ";
               $s2 .= $aDest[$j][0].' '; 		// RELATION_NAME
               $s2 .= $aDest[$j][1].'|'; 		// FIELD_NAME
               $s2 .= $aDest[$j][2].'|'; 		// FIELD_PRECISION(*)
               $s2 .= $aDest[$j][3].'|'; 		// FIELD_SCALE(*)
               $s2 .= $aDest[$j][4].'|'; 		// FIELD_LENGTH(*)
               $s2 .= $aDest[$j][5].chr(10); 	// FIELD_TYPE(*)
            }
            if ($aOrig[$i][5] <> $aDest[$j][5]) {	// Divergencia no Tipo
               $s2 .= "-------------------------- ERRO NO TIPO DO DADO ---------------------------------------".chr(10);
               $s2 .= "--Banco Origem  : Tabela ".$aOrig[$i][0]." Campo ".$aOrig[$i][1]." Tipo ".$aOrig[$i][5]." Tamanho(".$aOrig[$i][4].")".chr(10);
               $s2 .= "--Banco Destino : Tabela ".$aDest[$j][0]." Campo ".$aDest[$j][1]." Tipo ".$aDest[$j][5]." Tamanho(".$aDest[$j][4].")".chr(10);
               $s2 .= "------------------------------------------------------ --------------------------------".chr(10);
               $s2 .= "   alter table ".$aOrig[$i][0]." alter ".$aOrig[$i][1]." type ".$aOrig[$i][5]." (".$aOrig[$i][4].");".chr(10);
               $s2 .= "---------------------------------------------------------------------------------------".chr(10);
            } else {
               // Criar Campo no destino
               $sTabela = $aOrig[$i][0];
               if (strpos($sTabela,'RDB$')===false) {
                  $s2 .= "-------------------------- ERRO NO TIPO DO DADO ---------------------------------------".chr(10);
                  $s2 .= "--Banco Origem  : Tabela ".$aOrig[$i][0]." Campo ".$aOrig[$i][1]." Tipo ".$aOrig[$i][5].chr(10);
                  $s2 .= "--Banco Destino : Tabela ".$aDest[$j][0]." Campo ".$aDest[$j][1]." Tipo ".$aDest[$j][5].chr(10);
                  $s2 .= "------------------------------------------------------ --------------------------------".chr(10);
               }
               if ($aOrig[$i][5] == "BLOB") {
                  $s2 .= "-------------------------- ERRO NO TIPO DO DADO ---------------------------------------".chr(10);
                  $s2 .= "--Banco Origem  : Tabela ".$aOrig[$i][0]." Campo ".$aOrig[$i][1]." Tipo ".$aOrig[$i][5].chr(10);
                  $s2 .= "--Banco Destino : Tabela ".$aDest[$j][0]." Campo ".$aDest[$j][1]." Tipo ".$aDest[$j][5].chr(10);
                  $s2 .= "------------------------------------------------------ --------------------------------".chr(10);

               }      
               if ($aOrig[$i][5] == "CHAR") {
                  if ($aOrig[$i][4] > $aDest[$j][4]) {	// Origem  maior que o destino
                     $s2 .= "---------------------------------------------------------------------------".chr(10);
                     $s2 .= " --Banco Origem  : Tabela ".$aOrig[$i][0]." Campo ".$aOrig[$i][1]." Tipo CHAR(".$aOrig[$i][4].")".chr(10);
                     $s2 .= " --Banco Destino : Tabela ".$aDest[$j][0]." Campo ".$aDest[$j][1]." Tipo CHAR(".$aDest[$j][4].")".chr(10);
                     $s2 .= "---------------------------------------------------------------------------".chr(10);
                     $s2 .= ' alter table '.$aOrig[$i][0].' alter '.$aOrig[$i][1].' type CHAR('.$aOrig[$i][4].');'.chr(10);
                     $s2 .= "---------------------------------------------------------------------------".chr(10).chr(10);
                  } elseif ($aOrig[$i][4] < $aDest[$j][4]) {					// Origem  menor que o destino
                     $s4 .= "---------------------------------------------------------------------------".chr(10);
                     $s4 .= " --Banco Origem  : Tabela ".$aOrig[$i][0]." Campo ".$aOrig[$i][1]." Tipo CHAR".$aOrig[$i][4].chr(10);
                     $s4 .= " --Banco Destino : Tabela ".$aDest[$j][0]." Campo ".$aDest[$j][1]." Tipo CHAR".$aDest[$j][4].chr(10);
                     $s4 .= "---------------------------------------------------------------------------".chr(10);
                     $s4 .= '   alter table '.$aOrig[$i][0].' add STMP CHAR('.$aOrig[$i][4].') COLLATE PT_BR;'.chr(10);
                     $s4 .= '        update '.$aOrig[$i][0].' set STMP = '.$aOrig[$i][1].';'.chr(10); 
                     $s4 .= '   commit;'.chr(10); 
                     $s4 .= '   alter table '.$aOrig[$i][0].' drop '.$aOrig[$i][1].';'.chr(10);
                     $s4 .= '   alter table '.$aOrig[$i][0].' add  '.$aOrig[$i][1].' CHAR('.$aOrig[$i][4].') COLLATE PT_BR;'.chr(10);
                     $s4 .= '        update '.$aOrig[$i][0].' set  '.$aOrig[$i][1].' = STMP;'.chr(10); 
                     $s4 .= '   commit;'.chr(10); 
                     $s4 .= '   alter table '.$aOrig[$i][0].' drop STMP;'.chr(10);
                     $s4 .= '   commit;'.chr(10).chr(10); 
                     $s4 .= "---------------------------------------------------------------------------".chr(10);
                  }
               }
   
               if ($aOrig[$i][5] == "CSTRING") {
                  $s2 .= "-------------------------- ERRO NO TIPO DO DADO ---------------------------------------".chr(10);
                  $s2 .= "--Banco Origem  : Tabela ".$aOrig[$i][0]." Campo ".$aOrig[$i][1]." Tipo ".$aOrig[$i][5].chr(10);
                  $s2 .= "--Banco Destino : Tabela ".$aDest[$j][0]." Campo ".$aDest[$j][1]." Tipo ".$aDest[$j][5].chr(10);
                  $s2 .= "------------------------------------------------------ --------------------------------".chr(10);
               }
   
               if ($aOrig[$i][5] == "D_FLOAT") {
                  $s2 .= "-------------------------- ERRO NO TIPO DO DADO ---------------------------------------".chr(10);
                  $s2 .= "--Banco Origem  : Tabela ".$aOrig[$i][0]." Campo ".$aOrig[$i][1]." Tipo ".$aOrig[$i][5].chr(10);
                  $s2 .= "--Banco Destino : Tabela ".$aDest[$j][0]." Campo ".$aDest[$j][1]." Tipo ".$aDest[$j][5].chr(10);
                  $s2 .= "------------------------------------------------------ --------------------------------".chr(10);
               }
   
               if ($aOrig[$i][5] == "DOUBLE") {
                  $s2 .= "-------------------------- ERRO NO TIPO DO DADO ---------------------------------------".chr(10);
                  $s2 .= "--Banco Origem  : Tabela ".$aOrig[$i][0]." Campo ".$aOrig[$i][1]." Tipo ".$aOrig[$i][5].chr(10);
                  $s2 .= "--Banco Destino : Tabela ".$aDest[$j][0]." Campo ".$aDest[$j][1]." Tipo ".$aDest[$j][5].chr(10);
                  $s2 .= "------------------------------------------------------ --------------------------------".chr(10);
               }
   
               if ($aOrig[$i][5] == "FLOAT") {
                  $s2 .= "-------------------------- ERRO NO TIPO DO DADO ---------------------------------------".chr(10);
                  $s2 .= "--Banco Origem  : Tabela ".$aOrig[$i][0]." Campo ".$aOrig[$i][1]." Tipo ".$aOrig[$i][5].chr(10);
                  $s2 .= "--Banco Destino : Tabela ".$aDest[$j][0]." Campo ".$aDest[$j][1]." Tipo ".$aDest[$j][5].chr(10);
                  $s2 .= "------------------------------------------------------ --------------------------------".chr(10);
               }

               if ($aOrig[$i][5] == "INT64") {
                  if (($aOrig[$i][2] >=  $aDest[$j][2]) && (($aOrig[$i][3]*-1) >=  ($aDest[$j][3]*-1)) ) {	// Origem  maior que o destino
                     $s2 .= "---------------------------------------------------------------------------".chr(10);
                     $s2 .= " --Banco Origem  : Tabela ".$aOrig[$i][0]." Campo ".$aOrig[$i][1]." Tipo DECIMAL(".$aOrig[$i][2].",".($aOrig[$i][3]*-1).")".chr(10);
                     $s2 .= " --Banco Destino : Tabela ".$aDest[$j][0]." Campo ".$aDest[$j][1]." Tipo DECIMAL(".$aDest[$j][2].",".($aDest[$j][3]*-1).")".chr(10);
                     $s2 .= "---------------------------------------------------------------------------".chr(10);
                     $s2 .= ' alter table '.$aOrig[$i][0].' alter '.$aOrig[$i][1].' type DECIMAL('.$aOrig[$i][2].','.($aOrig[$i][3]*-1). ');'.chr(10);
                     $s2 .= "---------------------------------------------------------------------------".chr(10).chr(10);
                  } else { 
                     $s4 .= "---------------------------------------------------------------------------".chr(10);
                     $s4 .= " --Banco Origem  : Tabela ".$aOrig[$i][0]." Campo ".$aOrig[$i][1]." Tipo DECIMAL(".$aOrig[$i][2].",".($aOrig[$i][3]*-1).")".chr(10);
                     $s4 .= " --Banco Destino : Tabela ".$aDest[$j][0]." Campo ".$aDest[$j][1]." Tipo DECIMAL(".$aDest[$j][2].",".($aDest[$j][3]*-1).")".chr(10);
                     $s4 .= "---------------------------------------------------------------------------".chr(10);
                     $s4 .= ' alter table '.$aOrig[$i][0].' add NTMP DECIMAL('.$aOrig[$i][2].','.($aOrig[$i][3]*-1). ') DEFAULT 0;'.chr(10);
                     $s4 .= '      update '.$aOrig[$i][0].' set NTMP = '.$aOrig[$i][1].';'.chr(10); 
                     $s4 .= ' commit;'.chr(10); 
                     $s4 .= ' alter table '.$aOrig[$i][0].' drop '.$aOrig[$i][1].';'.chr(10);
                     $s4 .= ' alter table '.$aOrig[$i][0].' add  '.$aOrig[$i][1].' DECIMAL('.$aOrig[$i][2].','.($aOrig[$i][3]*-1). ') DEFAULT 0 not null;'.chr(10);
                     $s4 .= '      update '.$aOrig[$i][0].' set  '.$aOrig[$i][1].' = NTMP;'.chr(10); 
                     $s4 .= ' commit;'.chr(10); 
                     $s4 .= ' alter table '.$aOrig[$i][0].' drop NTMP;'.chr(10);
                     $s4 .= ' commit;'.chr(10).chr(10); 
                     $s4 .= "---------------------------------------------------------------------------".chr(10).chr(10);
                  }
               }
   
               if ($aOrig[$i][5] == "INTEGER") {
                  if (($aOrig[$i][2] >=  $aDest[$j][2]) && (($aOrig[$i][3]*-1) >=  ($aDest[$j][3]*-1)) ) {	// Origem  maior que o destino
                     $s2 .= "---------------------------------------------------------------------------".chr(10);
                     $s2 .= " --Banco Origem  : Tabela ".$aOrig[$i][0]." Campo ".$aOrig[$i][1]." Tipo DECIMAL(".$aOrig[$i][2].",".($aOrig[$i][3]*-1).")".chr(10);
                     $s2 .= " --Banco Destino : Tabela ".$aDest[$j][0]." Campo ".$aDest[$j][1]." Tipo DECIMAL(".$aDest[$j][2].",".($aDest[$j][3]*-1).")".chr(10);
                     $s2 .= "---------------------------------------------------------------------------".chr(10);
                     $s2 .= ' alter table '.$aOrig[$i][0].' alter '.$aOrig[$i][1].' type DECIMAL('.$aOrig[$i][2].','.($aOrig[$i][3]*-1). ');'.chr(10);
                     $s2 .= "---------------------------------------------------------------------------".chr(10).chr(10);
                  } else {
                     $s4 .= "---------------------------------------------------------------------------".chr(10);
                     $s4 .= " --Banco Origem  : Tabela ".$aOrig[$i][0]." Campo ".$aOrig[$i][1]." Tipo DECIMAL(".$aOrig[$i][2].",".($aOrig[$i][3]*-1).")".chr(10);
                     $s4 .= " --Banco Destino : Tabela ".$aDest[$j][0]." Campo ".$aDest[$j][1]." Tipo DECIMAL(".$aDest[$j][2].",".($aDest[$j][3]*-1).")".chr(10);
                     $s4 .= "---------------------------------------------------------------------------".chr(10);
                     $s4 .= ' alter table '.$aOrig[$i][0].' add NTMP DECIMAL('.$aOrig[$i][2].','.($aOrig[$i][3]*-1). ') DEFAULT 0;'.chr(10);
                     $s4 .= '      update '.$aOrig[$i][0].' set NTMP = '.$aOrig[$i][1].';'.chr(10); 
                     $s4 .= ' commit;'.chr(10); 
                     $s4 .= ' alter table '.$aOrig[$i][0].' drop '.$aOrig[$i][1].';'.chr(10);
                     $s4 .= ' alter table '.$aOrig[$i][0].' add  '.$aOrig[$i][1].' DECIMAL('.$aOrig[$i][2].','.($aOrig[$i][3]*-1). ') DEFAULT 0 not null;'.chr(10);
                     $s4 .= '      update '.$aOrig[$i][0].' set  '.$aOrig[$i][1].' = NTMP;'.chr(10); 
                     $s4 .= ' commit;'.chr(10); 
                     $s4 .= ' alter table '.$aOrig[$i][0].' drop NTMP;'.chr(10);
                     $s4 .= ' commit;'.chr(10).chr(10); 
                     $s4 .= "---------------------------------------------------------------------------".chr(10).chr(10);
                  } 
               }

               if ($aOrig[$i][5] == "QUAD"     ) {
                  $s2 .= "-------------------------- ERRO NO TIPO DO DADO ---------------------------------------".chr(10);
                  $s2 .= "--Banco Origem  : Tabela ".$aOrig[$i][0]." Campo ".$aOrig[$i][1]." Tipo ".$aOrig[$i][5].chr(10);
                  $s2 .= "--Banco Destino : Tabela ".$aDest[$j][0]." Campo ".$aDest[$j][1]." Tipo ".$aDest[$j][5].chr(10);
                  $s2 .= "------------------------------------------------------ --------------------------------".chr(10);
               }
   
               if ($aOrig[$i][5] == "SMALLINT") {
                  $s2 .= ' alter table '.$aOrig[$i][0].' add '.$aOrig[$i][1].' SMALLINT DEFAULT 0 not null;'.chr(10);
                  //$s2 .= '      update '.$aOrig[$i][0].' set '.$aOrig[$i][1].' = 0;'.chr(10);
                  //$s2 .= ' commit;'.chr(10).chr(10);
               }

               if ($aOrig[$i][5] == "DATE") {
                  $s2 .= "-------------------------- ERRO NO TIPO DO DADO ---------------------------------------".chr(10);
                  $s2 .= "--Banco Origem  : Tabela ".$aOrig[$i][0]." Campo ".$aOrig[$i][1]." Tipo ".$aOrig[$i][5].chr(10);
                  $s2 .= "--Banco Destino : Tabela ".$aDest[$j][0]." Campo ".$aDest[$j][1]." Tipo ".$aDest[$j][5].chr(10);
                  $s2 .= "------------------------------------------------------ --------------------------------".chr(10);
               }

               if ($aOrig[$i][5] == "TIME") {
                  $s2 .= "-------------------------- ERRO NO TIPO DO DADO ---------------------------------------".chr(10);
                  $s2 .= "--Banco Origem  : Tabela ".$aOrig[$i][0]." Campo ".$aOrig[$i][1]." Tipo ".$aOrig[$i][5].chr(10);
                  $s2 .= "--Banco Destino : Tabela ".$aDest[$j][0]." Campo ".$aDest[$j][1]." Tipo ".$aDest[$j][5].chr(10);
                  $s2 .= "------------------------------------------------------ --------------------------------".chr(10);
               }

               if ($aOrig[$i][5] == "TIMESTAMP") {
                  $s2 .= ' alter table '.$aOrig[$i][0].' add '.$aOrig[$i][1].' TIMESTAMP;'.chr(10).chr(10);
               }

               if ($aOrig[$i][5] == "VARCHAR") {
                  if ($aOrig[$i][4] >  $aDest[$j][4]) {	// Origem  maior que o destino
                     $s2 .= "---------------------------------------------------------------------------".chr(10);
                     $s2 .= " --Banco Origem  : Tabela ".$aOrig[$i][0]." Campo ".$aOrig[$i][1]." Tipo VARCHAR(".$aOrig[$i][4].")".chr(10);
                     $s2 .= " --Banco Destino : Tabela ".$aDest[$j][0]." Campo ".$aDest[$j][1]." Tipo VARCHAR(".$aDest[$j][4].")".chr(10);
                     $s2 .= "---------------------------------------------------------------------------".chr(10);
                     $s2 .= ' alter table '.$aOrig[$i][0].' alter '.$aOrig[$i][1].' type VARCHAR('.$aOrig[$i][4].');'.chr(10);
                     $s2 .= "---------------------------------------------------------------------------".chr(10).chr(10);
                  } elseif ($aOrig[$i][4] < $aDest[$j][4]) {					// Origem  menor que o destino

                     $s4 .= "---------------------------------------------------------------------------".chr(10);
                     $s4 .= " --Banco Origem  : Tabela ".$aOrig[$i][0]." Campo ".$aOrig[$i][1]." Tipo VARCHAR(".$aOrig[$i][4].")".chr(10);
                     $s4 .= " --Banco Destino : Tabela ".$aDest[$j][0]." Campo ".$aDest[$j][1]." Tipo VARCHAR(".$aDest[$j][4].")".chr(10);
                     $s4 .= "---------------------------------------------------------------------------".chr(10);
                     $s4 .= ' alter table '.$aOrig[$i][0].' add STMP VARCHAR('.$aOrig[$i][4].') COLLATE PT_BR;'.chr(10);
                     $s4 .= '      update '.$aOrig[$i][0].' set STMP = '.$aOrig[$i][1].';'.chr(10); 
                     $s4 .= ' commit;'.chr(10); 
                     $s4 .= ' alter table '.$aOrig[$i][0].' drop '.$aOrig[$i][1].';'.chr(10);
                     $s4 .= ' alter table '.$aOrig[$i][0].' add  '.$aOrig[$i][1].' VARCHAR('.$aOrig[$i][4].') COLLATE PT_BR;'.chr(10);
                     $s4 .= '      update '.$aOrig[$i][0].' set  '.$aOrig[$i][1].' = STMP;'.chr(10); 
                     $s4 .= ' commit;'.chr(10); 
                     $s4 .= ' alter table '.$aOrig[$i][0].' drop STMP;'.chr(10);
                     $s4 .= ' commit;'.chr(10); 
                     $s4 .= "---------------------------------------------------------------------------".chr(10).chr(10);

                  }
               }
            }
         }
         $lE = true;
         break;
      }
      $lVazio = true;
   }   // fim loop destino

   if ($lE==false) {	// No encontrou
      if (($aOrig[$i][1]=="PPID") || ($lTNew)) {
         $lTNew = true;
         if ($aOrig[$i][1]=="PPID") {
            $sNomeTabela = strtolower($aOrig[$i][0]);
            
            $sT1 .= '------------------------------------------------------------------------------------'.chr(10);
            $sT1 .= '----- Tabela '.$sNomeTabela.' no existe no banco de destino'.chr(10);
            $sT1 .= '------------------------------------------------------------------------------------'.chr(10);
            $sT1 .= 'DROP TABLE '.$sNomeTabela.';'.chr(10);
            $sT1 .= 'CREATE TABLE '.$sNomeTabela.' ('.chr(10);

            $sT3 .= '   primary key ( pPId , iVer )'.chr(10);
            $sT3 .= ');'.chr(10);
            $sT3 .= '--DELETE FROM rdb$generators WHERE rdb$generator_name = upper';
            $sT3 .= "('";
            $sT3 .= $sNomeTabela."');".chr(10);
            $sT3 .= 'DROP GENERATOR '.$sNomeTabela.';'.chr(10);
            $sT3 .= 'COMMIT;'.chr(10).chr(10);
            $sT3 .= 'CREATE GENERATOR '.$sNomeTabela.';'.chr(10);
            $sT3 .= 'SET GENERATOR '.$sNomeTabela.' to 0;'.chr(10).chr(10);
            $sT3 .= 'SET TERM !! ;'.chr(10);
            $sT3 .= 'CREATE TRIGGER '.$sNomeTabela.' FOR '.$sNomeTabela.chr(10);
            $sT3 .= 'BEFORE INSERT AS'.chr(10);
            $sT3 .= 'BEGIN'.chr(10);
            $sT3 .= '   if ((new.iVer>0) and (new.iVer= new.iVAt)) then new.pPId  = GEN_ID('.$sNomeTabela.', 1);'.chr(10);
            $sT3 .= '   if ((new.iVer>0) and (new.iVer= new.iVAt)) then new.pIn0  = new.pInc;'.chr(10);
            $sT3 .= '   if ((new.iVer>0) and (new.iVer= new.iVAt)) then new.tIn0  = new.tInc;'.chr(10);
            $sT3 .= '   if ((new.iVer>0) and (new.iVer<>new.iVAt)) then new.iVer  = new.iVAt;'.chr(10);
            $sT3 .= 'END !!'.chr(10);
            $sT3 .= 'SET TERM ; !!'.chr(10);
            $sT3 .= '-----------------------------------------------------------------------------------------'.chr(10);
            $sT3 .= '---------------FINAL DA TABELA '.$sNomeTabela.chr(10);
            $sT3 .= '-----------------------------------------------------------------------------------------'.chr(10).chr(10).chr(10);

          }
          if ($aOrig[$i][5] == "VARCHAR") {
             $sT2 .= '   '.$aOrig[$i][1].'   varchar('.$aOrig[$i][4].') collate PT_BR,'.chr(10);
          }
          if ($aOrig[$i][5] == "INTEGER") {
             if ( ($aOrig[$i][1] == "IVER") || ($aOrig[$i][1] == "IVAT") || ($aOrig[$i][1] == "PINC") ) {
                $sT2 .= '   '.$aOrig[$i][1].'   decimal('.$aOrig[$i][2].','.($aOrig[$i][3]*-1). ') default 1 not null,'.chr(10);
             } else { 
                $sT2 .= '   '.$aOrig[$i][1].'   decimal('.$aOrig[$i][2].','.($aOrig[$i][3]*-1). ') default 0 not null,'.chr(10);
             }
          }
          if ($aOrig[$i][5] == "TIMESTAMP") {
             if($aOrig[$i][1] == "TIN0" || $aOrig[$i][1] == "TINC"){
                $sT2 .= '   '.$aOrig[$i][1]."   timestamp default 'now',".chr(10);
             } else {
                $sT2 .= '   '.$aOrig[$i][1]."   timestamp,".chr(10);
             }
          }
          if ($aOrig[$i][5] == "SMALLINT") {
             $sT2 .= '   '.$aOrig[$i][1].'   smallint default 0 not null,'.chr(10);
          }
          if ($aOrig[$i][5] == "INT64") {
             $sT2 .= '   '.$aOrig[$i][1].'   decimal('.$aOrig[$i][2].','.($aOrig[$i][3]*-1). ') default 0 not null,'.chr(10);
          }
          if ($aOrig[$i][5] == "CHAR") {
             $sT2 .= '   '.$aOrig[$i][1].'   char('.$aOrig[$i][4].'),'.chr(10);
          }               
      }  
      if ($lTNew==false) {
         if ($lLab) {
            $s3 .= "-- CAMPO DA ORIGEM INEXISTENTE NO DESTINO...";
            $s3 .= $aOrig[$i][0].'|'    ; // RELATION_NAME
            $s3 .= $aOrig[$i][1].'|'    ; // FIELD_NAME
            $s3 .= $aOrig[$i][2].'|'    ; // FIELD_PRECISION
            $s3 .= $aOrig[$i][3].'|'    ; // FIELD_SCALE
            $s3 .= $aOrig[$i][4].'|'    ; // FIELD_LENGTH
            $s3 .= $aOrig[$i][5].chr(10); // FIELD_TYPE
         }

         // Adicionar Campo no destino
         if ($aOrig[$i][5] == 'BLOB'     ) {
            $s3 .= "-------------------------- ERRO NO TIPO DO DADO ---------------------------------------".chr(10);
            $s3 .= "--Banco Origem  : Tabela ".$aOrig[$i][0]." Campo ".$aOrig[$i][1]." Tipo ".$aOrig[$i][5]." Tamanho(".$aOrig[$i][4].")".chr(10);
            $s3 .= "--Banco Destino : Tabela ".$aDest[$j][0]." Campo ".$aDest[$j][1]." Tipo ".$aDest[$j][5]." Tamanho(".$aDest[$j][4].")".chr(10);
            $s3 .= "------------------------------------------------------ --------------------------------".chr(10);
            $s3 .= '--#ERRO sem instruoes para incluir o novo campo no destino...'.chr(10).chr(10);
         }

         if ($aOrig[$i][5] == 'CHAR'     ) {
            $s3 .= ' alter table '.$aOrig[$i][0].' add '.$aOrig[$i][1].' CHAR('.$aOrig[$i][4].') COLLATE PT_BR;'.chr(10).chr(10);
         }

         if ($aOrig[$i][5] == 'CSTRING'  ) {
            $s3 .= "-------------------------- ERRO NO TIPO DO DADO ---------------------------------------".chr(10);
            $s3 .= "--Banco Origem  : Tabela ".$aOrig[$i][0]." Campo ".$aOrig[$i][1]." Tipo ".$aOrig[$i][5]." Tamanho(".$aOrig[$i][4].")".chr(10);
            $s3 .= "--Banco Destino : Tabela ".$aDest[$j][0]." Campo ".$aDest[$j][1]." Tipo ".$aDest[$j][5]." Tamanho(".$aDest[$j][4].")".chr(10);
            $s3 .= "------------------------------------------------------ --------------------------------".chr(10);
            $s3 .= '--#ERRO sem instruoes para incluir o novo campo no destino...'.chr(10).chr(10);
         }

         if ($aOrig[$i][5] == 'D_FLOAT'  ) {
            $s3 .= "-------------------------- ERRO NO TIPO DO DADO ---------------------------------------".chr(10);
            $s3 .= "--Banco Origem  : Tabela ".$aOrig[$i][0]." Campo ".$aOrig[$i][1]." Tipo ".$aOrig[$i][5]." Tamanho(".$aOrig[$i][4].")".chr(10);
            $s3 .= "--Banco Destino : Tabela ".$aDest[$j][0]." Campo ".$aDest[$j][1]." Tipo ".$aDest[$j][5]." Tamanho(".$aDest[$j][4].")".chr(10);
            $s3 .= "------------------------------------------------------ --------------------------------".chr(10);
            $s3 .= '--#ERRO sem instruoes para incluir o novo campo no destino...'.chr(10).chr(10);
         }

         if ($aOrig[$i][5] == 'DOUBLE'   ) {
            $s3 .= "-------------------------- ERRO NO TIPO DO DADO ---------------------------------------".chr(10);
            $s3 .= "--Banco Origem  : Tabela ".$aOrig[$i][0]." Campo ".$aOrig[$i][1]." Tipo ".$aOrig[$i][5]." Tamanho(".$aOrig[$i][4].")".chr(10);
            $s3 .= "--Banco Destino : Tabela ".$aDest[$j][0]." Campo ".$aDest[$j][1]." Tipo ".$aDest[$j][5]." Tamanho(".$aDest[$j][4].")".chr(10);
            $s3 .= "------------------------------------------------------ --------------------------------".chr(10);
            $s3 .= '--#ERRO sem instruoes para incluir o novo campo no destino...'.chr(10).chr(10);
         }

         if ($aOrig[$i][5] == 'FLOAT'    ) {
            $s3 .= "-------------------------- ERRO NO TIPO DO DADO ---------------------------------------".chr(10);
            $s3 .= "--Banco Origem  : Tabela ".$aOrig[$i][0]." Campo ".$aOrig[$i][1]." Tipo ".$aOrig[$i][5]." Tamanho(".$aOrig[$i][4].")".chr(10);
            $s3 .= "--Banco Destino : Tabela ".$aDest[$j][0]." Campo ".$aDest[$j][1]." Tipo ".$aDest[$j][5]." Tamanho(".$aDest[$j][4].")".chr(10);
            $s3 .= "------------------------------------------------------ --------------------------------".chr(10);
            $s3 .= '--#ERRO sem instruoes para incluir o novo campo no destino...'.chr(10).chr(10);
         }

         if ($aOrig[$i][5] == 'INT64'    ) {
            $s3 .= ' alter table '.$aOrig[$i][0].' add '.$aOrig[$i][1].' DECIMAL('.$aOrig[$i][2].','.($aOrig[$i][3]*-1). ') DEFAULT 0 not null;'.chr(10);
//            $s3 .= '      update '.$aOrig[$i][0].' set '.$aOrig[$i][1].' = 0;'.chr(10);
//            $s3 .= ' commit;'.chr(10).chr(10);
         }

         if ($aOrig[$i][5] == 'INTEGER'  ) {
            $s3 .= ' alter table '.$aOrig[$i][0].' add '.$aOrig[$i][1].' DECIMAL('.$aOrig[$i][2].','.($aOrig[$i][3]*-1). ') DEFAULT 0 not null;'.chr(10);
//            $s3 .= '      update '.$aOrig[$i][0].' set '.$aOrig[$i][1].' = 0;'.chr(10);
//            $s3 .= ' commit;'.chr(10).chr(10);
         }

         if ($aOrig[$i][5] == 'QUAD'     ) {
            $s3 .= "-------------------------- ERRO NO TIPO DO DADO ---------------------------------------".chr(10);
            $s3 .= "--Banco Origem  : Tabela ".$aOrig[$i][0]." Campo ".$aOrig[$i][1]." Tipo ".$aOrig[$i][5]." Tamanho(".$aOrig[$i][4].")".chr(10);
            $s3 .= "--Banco Destino : Tabela ".$aDest[$j][0]." Campo ".$aDest[$j][1]." Tipo ".$aDest[$j][5]." Tamanho(".$aDest[$j][4].")".chr(10);
            $s3 .= "------------------------------------------------------ --------------------------------".chr(10);
            $s3 .= '--#ERRO sem instruoes para incluir o novo campo no destino...'.chr(10).chr(10);
         }

         if ($aOrig[$i][5] == 'SMALLINT' ) {
            $s3 .= ' alter table '.$aOrig[$i][0].' add '.$aOrig[$i][1].' SMALLINT DEFAULT 0 not null;'.chr(10);
//            $s3 .= '      update '.$aOrig[$i][0].' set '.$aOrig[$i][1].' = 0;'.chr(10);
//            $s3 .= ' commit;'.chr(10).chr(10);
         }

         if ($aOrig[$i][5] == 'DATE'     ) {
            $s3 .= "-------------------------- ERRO NO TIPO DO DADO ---------------------------------------".chr(10);
            $s3 .= "--Banco Origem  : Tabela ".$aOrig[$i][0]." Campo ".$aOrig[$i][1]." Tipo ".$aOrig[$i][5]." Tamanho(".$aOrig[$i][4].")".chr(10);
            $s3 .= "--Banco Destino : Tabela ".$aDest[$j][0]." Campo ".$aDest[$j][1]." Tipo ".$aDest[$j][5]." Tamanho(".$aDest[$j][4].")".chr(10);
            $s3 .= "------------------------------------------------------ --------------------------------".chr(10);
            $s3 .= '--#ERRO sem instruoes para incluir o novo campo no destino...'.chr(10).chr(10);
         }

         if ($aOrig[$i][5] == 'TIME'     ) {
            $s3 .= "-------------------------- ERRO NO TIPO DO DADO ---------------------------------------".chr(10);
            $s3 .= "--Banco Origem  : Tabela ".$aOrig[$i][0]." Campo ".$aOrig[$i][1]." Tipo ".$aOrig[$i][5]." Tamanho(".$aOrig[$i][4].")".chr(10);
            $s3 .= "--Banco Destino : Tabela ".$aDest[$j][0]." Campo ".$aDest[$j][1]." Tipo ".$aDest[$j][5]." Tamanho(".$aDest[$j][4].")".chr(10);
            $s3 .= "------------------------------------------------------ --------------------------------".chr(10);
            $s3 .= '--#ERRO sem instruoes para incluir o novo campo no destino...'.chr(10).chr(10);
         }

         if ($aOrig[$i][5] == 'TIMESTAMP') {
            $s3 .= ' alter table '.$aOrig[$i][0].' add '.$aOrig[$i][1].' TIMESTAMP;'.chr(10).chr(10);
         }

         if ($aOrig[$i][5] == 'VARCHAR'  ) {
            $s3 .= ' alter table '.$aOrig[$i][0].' add '.$aOrig[$i][1].' VARCHAR('.$aOrig[$i][4].') COLLATE PT_BR;'.chr(10).chr(10);
         }
      }
   }   // ($lE==false)
   $soTab = $aOrig[$i][0];
}   // fim a da query da origem
if ($sT1<>'') {
    fpc_append($sFileSql,$sT1.$sT2.$sT3);
}
fpc_append($sFileSql,chr(10).$s1.chr(10).$s3.chr(10).$s2.chr(10).$s4.chr(10));





$tJobEnd  = time();
$iJobElap = $tJobEnd-$tJobStart;
//   echo "Final: ". date('d/m/Y G:i:s',$tJobEnd).chr(10);

list($usec, $sec) = explode(' ', microtime());
$tScript_End = (float) $sec + (float) $usec;
$tElapsed_Time = round($tScript_End - $tScript_Start, 5);

$s5 = "Tempo Decorrido: ".gmdate("H:i:s", $tElapsed_Time).', Secs: '.$tElapsed_Time.". Memoria usada: ".round(((memory_get_peak_usage(true) / 1024) / 1024), 2)."Mb".chr(10);

echo $s5;

fpc_append($sFileSql,'--'.$s5.chr(10));
echo "Processo realizado com sucesso...\nVerifique o arquivo $sFileSql!".chr(10);
if (file_exists($sDirAProc.'/'.$sDirFile)) {
   rename($sDirAProc.'/'.$sDirFile,'/qtux/www/FullPlat/Comparador/processadas/edi/'.$sDirFile);
}
