SET SQL dialect 3;
CONNECT 'localhost:/qtux/database/desenvolvimento/gps_01.gdb';

SELECT 
    'ALTER TABLE ' || TRIM(r.RDB$RELATION_NAME) || 
    ' ALTER COLUMN ' || TRIM(rf.RDB$FIELD_NAME) || 
    ' SET DEFAULT 0;' AS COMANDO
FROM 
    RDB$RELATIONS r
    JOIN RDB$RELATION_FIELDS rf ON r.RDB$RELATION_NAME = rf.RDB$RELATION_NAME
    JOIN RDB$FIELDS f ON rf.RDB$FIELD_SOURCE = f.RDB$FIELD_NAME
WHERE r.RDB$SYSTEM_FLAG = 0  -- Apenas tabelas do usurio
  AND r.RDB$RELATION_TYPE = 0 --0	Tabela 1	View 2	Trigger 3	Procedure 4	Expression Index
  AND f.RDB$FIELD_TYPE in (7,8,10,11,27,16,9)  -- 16 Tipo DECIMAL
--  AND f.RDB$FIELD_PRECISION = 5  -- Preciso total (5 dgitos)
--  AND f.RDB$FIELD_SCALE = -2  -- Escala (2 casas decimais)
  AND COALESCE(rf.RDB$DEFAULT_SOURCE, '') NOT LIKE '%0%' 
  and COALESCE(rf.RDB$DEFAULT_SOURCE, '') NOT LIKE '%1%' -- Exclui campos com DEFAULT 0 e default 1
;
