#!/usr/bin/php -q
<?php
set_time_limit(300);
ini_set("memory_limit","1600M");
//ini_set("ibase.timestampformat","%Y-%m-%d");
//ini_set("ibase.timestampformat","%d-%b-%Y");

if ($argc > 1) { // parametro 1= nome do script de destino

/*
lerei as queries de um arquivo texto chamado DCQueries.ini.
a primeira linha indica o path do banco de dados no formato: hostname:/path/do/banco/com/o/nome_do_arquivo.gdb
a segunda linha indica o usuario e senha relacionados no formato: usuario:senha
a terceira linha indica o path do banco de destino no mesmo formato
todas as linhas apos a terceira serao queries que serao repassadas para o script, mas que se forem selects, retirarao os dados da tabela e criarao um insert para cada registro retornado pelo select
caso no meio da linha haja um "//", o resto da mesma sera invalidado
*/

   global $gsQueriesFile,$gsScript,$gsScriptName;
   $gsQueriesFile = $argv[1];
   $gsScript      = '';
   $gsScriptName  = str_replace('.ini','_'.date('Ymd_his').'.sql',$gsQueriesFile);

   // aqui comeca a logica da exportacao
   $sQueries = file_get_contents($gsQueriesFile);
   while (strpos($sQueries,chr(13)) !== false) {
      $sQueries = str_replace(chr(13),'',$sQueries);
   }
   $aQueries = explode(chr(10),$sQueries);
   $iCountQueries = count($aQueries);
   if ($iCountQueries >= 4) {
      global $gsDBPath,$gsDBUserName,$gsDBPassword;
      $gsDBPath     = $aQueries[0];      // 127.0.0.1:/qtux/database/...
      $gsDBDestPath = $aQueries[2];      // /qtux/database/...
      $aTMP = explode(':',$aQueries[1]); // sysqtux:qtux201005
      $iCountTMP = count($aTMP);
      if ($iCountTMP < 2) {
         $gsDBPath = '';
      } else {
         $gsDBUserName = $aTMP[0]; // sysqtux
         $gsDBPassword = $aTMP[1]; // qtux201005
      }
      $sDelete = trim($aQueries[3]); // delete - insert

      unset($aTMP);
      $iLenDBPath = strlen($gsDBPath);
      $iLenDBDestPath = strlen($gsDBDestPath);
      if ( ($iLenDBPath > 0) && ($iLenDBDestPath > 0) ) {
         $gsScript .= "SET SQL dialect 3;\n";
         $gsScript .= "connect '" . $gsDBDestPath . "';\n";
         global $ghDB;
         $ghDB = ibase_connect($gsDBPath,$gsDBUserName,$gsDBPassword);
         
         for ($i = 3; $i < $iCountQueries; $i++) {
            $sQuery = $aQueries[$i];
            $sQuery = trim($sQuery);
            if (($iPos = strpos($sQuery,"//")) !== false) {
                if ($iPos > 0) {
                   $sQuery = substr($sQuery,0,$iPos-1);
                } else continue;
            }
            $sQuery = trim($sQuery); // repeti o alltrim
            if (substr(strtoupper($sQuery),0,6) == "SELECT") {
               global $giMaxRecno;
               global $gsNomeTabela;

               $sTmp = fDCSelect2Insert($sQuery);

               if ($sDelete=='delete') {
                  $gsScript .= "\ndelete from $gsNomeTabela;\n";
                  $gsScript .= "set generator $gsNomeTabela to 0;\n\n";
               } // if ($sDelete=='delete')

               if ($sDelete!='inserir') {
                  $gsScript .= "alter trigger " . strtoupper($gsNomeTabela) . " inactive ;\n";
               } // if ($sDelete!='inserir')

               $gsScript .= $sTmp; // inserts

               if ($sDelete!='inserir') {
                  $gsScript .= "alter trigger " . strtoupper($gsNomeTabela) . " active ;\n";
               } // if ($sDelete!='inserir')

               if ( ($giMaxRecno>0) && ($sDelete!='inserir') ) {
                  $gsScript .= "set generator " . strtoupper($gsNomeTabela) . " to " . $giMaxRecno . ";\n";
               }
            } else { 
               if ( ($sDelete!='delete') && ($sDelete!='inserir') ) {
                  $gsScript .= $sQuery . "\n";
               } else {
                  $gsScript .= "\n";
               } //
            }
         }
         file_put_contents($gsScriptName,$gsScript);
      }
   }
   ibase_close($ghDB);
}
/////////////////////////////////////
function fDCSelect2Insert($psQuery) {
/////////////////////////////////////
   $sScript = '';
   global $ghDB;
   global $sDelete;
   $hResult = ibase_query($ghDB,$psQuery);
   if ($hResult === false) {
      echo "Erro executando query: " . $psQuery . "\n";
   } elseif ($hResult === true) {
      $sScript .= '';
   } else {
      $iNrColunas = ibase_num_fields($hResult);
      global $giMaxRecno;
      $giMaxRecno = 0;
      while (($aLinha = ibase_fetch_row($hResult)) !== false) {
         $sScript .= 'insert into ';
         $aTMP = explode("FROM",strtoupper($psQuery));
         $aTMP = explode(" ",trim($aTMP[1]));
         global $gsNomeTabela;
         $gsNomeTabela = $aTMP[0];
         if (substr($gsNomeTabela,-1,1) == ";") {
            $gsNomeTabela = substr($gsNomeTabela,0,strlen($gsNomeTabela)-1);
         }
         $sScript .= $gsNomeTabela." (";
         $sValores = '';
         for ($i = 0; $i < $iNrColunas; $i++) {
            $aColInfo = ibase_field_info($hResult, $i);

            if ( ($aColInfo['name']=="PPID") && ($sDelete=='inserir') ) continue;

            $sScript .= $aColInfo['name'].($i == $iNrColunas-1 ? '' : ',');
            if (gettype($aLinha[$i]) == "string") {
               $sValores .= "'".str_replace("'","''",$aLinha[$i])."'";
            } elseif (strtoupper(gettype($aLinha[$i])) == "NULL") {
               $sValores .= 'NULL';
            } else {
               $sValores .= $aLinha[$i];
            }
            $sValores .= ($i == $iNrColunas-1 ? '' : ',');
            if ($aColInfo['name'] == "RECNO" or $aColInfo['name'] == "PPID") {
               $giMaxRecno = max($giMaxRecno,$aLinha[$i]);
            }
         }
         $sScript .= ") values (".$sValores.");\n";
      } // while (($aLinha = ibase_fetch_row($hResult)) !== false)
   } // if ($hResult === false)
   return($sScript);
} // function fDCSelect2Insert($psQuery)
//