SET SQL dialect 3;
CONNECT '/qtux/database/desenvolvimento/gps_01.gdb';

DROP TABLE Opcapa;
CREATE TABLE Opcapa (
   PPID   decimal(18,0) default 0 not null,
   PPGM   decimal(18,0) default 0 not null,
   PCIA   decimal(18,0) default 0 not null,
   PIN0   decimal(18,0) default 0 not null,
   PINC   decimal(18,0) default 0 not null,
   TIN0   timestamp default 'now',
   TINC   timestamp default 'now',
   LEXC   smallint default 0 not null,
   IVER   decimal(7,0) default 1 not null,
   JVER   decimal(7,0) default 0 not null,
   SVER   varchar(5000) collate PT_BR,
   ILIDO   decimal(9,0) default 0 not null,
   TULTLIDO   timestamp,
   IVAT   decimal(7,0) default 1 not null,
   JFREV   decimal(3,0) default 0 not null,
   TPREV   timestamp,
   ISERIAL   decimal(18,0) default 0 not null,
   LRAC1   smallint default 0 not null,
   PITEM   decimal(18,0) default 0 not null,
   FITEM   decimal(7,0) default 0 not null,
   NQTPREV   decimal(18,6) default 0 not null,
   NQTREAL   decimal(18,6) default 0 not null,
   NQTPROD   decimal(18,6) default 0 not null,
   PLP   decimal(18,0) default 0 not null,
   PSCUP   decimal(18,0) default 0 not null,
   PSOOP   decimal(18,0) default 0 not null,
   ISETUP   decimal(7,0) default 0 not null,
   TCONF   timestamp,
   PRCONF   decimal(18,0) default 0 not null,
   TCONC   timestamp,
   PRCONC   decimal(18,0) default 0 not null,
   PRT   decimal(18,0) default 0 not null,
   POCUP   decimal(18,0) default 0 not null,
   PLOTE   decimal(18,0) default 0 not null,
   PREGDEPPROD   decimal(18,0) default 0 not null,
   PREGDEP   decimal(18,0) default 0 not null,
   TINI   timestamp,
   PINI   decimal(18,0) default 0 not null,
   TINU   timestamp,
   PINU   decimal(18,0) default 0 not null,
   SINU   varchar(20000) collate PT_BR,
   PEMI   decimal(18,0) default 0 not null,
   FEMI   decimal(7,0) default 0 not null,
   PCUP   decimal(18,0) default 0 not null,
   FCUP   decimal(7,0) default 0 not null,
   PUNEG   decimal(18,0) default 0 not null,
   FUNEG   decimal(7,0) default 0 not null,
   SDESLOTE   varchar(60) collate PT_BR,
   TFABLOTE   timestamp,
   TVALLOTE   timestamp,
   FLP   decimal(7,0) default 0 not null,
   ICAPAC   decimal(7,0) default 0 not null,
   LSETUP   smallint default 0 not null,
   TPREVINI   timestamp,
   TPREVFIM   timestamp,
   ITPPREV   decimal(7,0) default 0 not null,
   TREALINI   timestamp,
   TREALFIM   timestamp,
   ITPREAL   decimal(7,0) default 0 not null,
   TBAIXA   timestamp,
   PRBAIXA   decimal(18,0) default 0 not null,
   NUQTRES   decimal(18,9) default 0 not null,
   NMQTRES   decimal(18,9) default 0 not null,
   IOP   decimal(7,0) default 0 not null,
   primary key ( pPId , iVer )
);
--DELETE FROM rdb$generators WHERE rdb$generator_name = upper('Opcapa');-- ATENO ESSE COMANDO NO FUNCIONA NO FB3, USAR COMANDO DROP
DROP GENERATOR Opcapa;
COMMIT;

CREATE GENERATOR Opcapa;
SET GENERATOR Opcapa to 0;

SET TERM !! ;
CREATE TRIGGER Opcapa FOR Opcapa
BEFORE INSERT AS
BEGIN
   if ((new.iVer>0) and (new.iVer= new.iVAt)) then new.pPId  = GEN_ID(Opcapa, 1);
   if ((new.iVer>0) and (new.iVer= new.iVAt)) then new.pIn0  = new.pInc;
   if ((new.iVer>0) and (new.iVer= new.iVAt)) then new.tIn0  = new.tInc;
   if ((new.iVer>0) and (new.iVer<>new.iVAt)) then new.iVer  = new.iVAt;
END !!
SET TERM ; !!
