SET SQL dialect 3;
CONNECT '/qtux/database/desenvolvimento/gps_01.gdb';

DROP TABLE Lincros_faturas_cte;
CREATE TABLE Lincros_faturas_cte (
   PPID   decimal(18,0) default 0 not null,
   PPGM   decimal(18,0) default 0 not null,
   PCIA   decimal(18,0) default 0 not null,
   PIN0   decimal(18,0) default 0 not null,
   PINC   decimal(18,0) default 0 not null,
   TIN0   timestamp default 'now',
   TINC   timestamp default 'now',
   LEXC   smallint default 0 not null,
   IVER   decimal(7,0) default 1 not null,
   JVER   decimal(7,0) default 0 not null,
   SVER   varchar(5000) collate PT_BR,
   ILIDO   decimal(9,0) default 0 not null,
   TULTLIDO   timestamp,
   IVAT   decimal(7,0) default 1 not null,
   JFREV   decimal(3,0) default 0 not null,
   TPREV   timestamp,
   ISERIAL   decimal(18,0) default 0 not null,
   LRAC1   smallint default 0 not null,
   PFATURA   decimal(18,0) default 0 not null,
   SCNPJTRANSPORTADORA   varchar(20) collate PT_BR,
   SCNPJUNIDADE   varchar(20) collate PT_BR,
   SNUMEROCTE   varchar(20) collate PT_BR,
   ICST   decimal(7,0) default 0 not null,
   SLINKREPOSITORIO   varchar(200) collate PT_BR,
   TDATAEMISSAO   timestamp,
   ITIPOCONHECIMENTO   decimal(7,0) default 0 not null,
   NVALORDOCUMENTO   decimal(18,5) default 0 not null,
   SMENSAGEMVALIDACAO   varchar(500) collate PT_BR,
   SCNPJRESPONSAVEL   varchar(20) collate PT_BR,
   NVALORICMS   decimal(18,5) default 0 not null,
   SCNPJDESTINATARIO   varchar(20) collate PT_BR,
   NVALORTOTAL   decimal(18,5) default 0 not null,
   SUFDESTINATARIO   varchar(10) collate PT_BR,
   SCOTACAO   varchar(40) collate PT_BR,
   NALIQUOTAICMS   decimal(18,5) default 0 not null,
   SMODAL   varchar(500) collate PT_BR,
   ICODIGOCEP   decimal(7,0) default 0 not null,
   NPESOCUBADO   decimal(18,5) default 0 not null,
   SCNPJEMISSOR   varchar(20) collate PT_BR,
   SCHAVE   varchar(60) collate PT_BR,
   ISITUACAOINTEGRACAO   decimal(7,0) default 0 not null,
   ICFOP   decimal(7,0) default 0 not null,
   NBASECALCULOICMS   decimal(18,5) default 0 not null,
   SDESTINATARIO   varchar(200) collate PT_BR,
   SNOMEDESTINATARIO   varchar(200) collate PT_BR,
   ISITUACAOSEFAZ   decimal(7,0) default 0 not null,
   ISITUACAOCTE   decimal(7,0) default 0 not null,
   SNUMEROPROTOCOLO   varchar(200) collate PT_BR,
   TDATAENTREGA   timestamp,
   SSERIE   varchar(10) collate PT_BR,
   NPESOBRUTO   decimal(18,5) default 0 not null,
   NCUBAGEM   decimal(18,5) default 0 not null,
   SUFDESTINO   varchar(10) collate PT_BR,
   ITIPOCTE   decimal(7,0) default 0 not null,
   primary key ( pPId , iVer )
);
--DELETE FROM rdb$generators WHERE rdb$generator_name = upper('Lincros_faturas_cte');-- ATENO ESSE COMANDO NO FUNCIONA NO FB3, USAR COMANDO DROP
DROP GENERATOR Lincros_faturas_cte;
COMMIT;

CREATE GENERATOR Lincros_faturas_cte;
SET GENERATOR Lincros_faturas_cte to 0;

SET TERM !! ;
CREATE TRIGGER Lincros_faturas_cte FOR Lincros_faturas_cte
BEFORE INSERT AS
BEGIN
   if ((new.iVer>0) and (new.iVer= new.iVAt)) then new.pPId  = GEN_ID(Lincros_faturas_cte, 1);
   if ((new.iVer>0) and (new.iVer= new.iVAt)) then new.pIn0  = new.pInc;
   if ((new.iVer>0) and (new.iVer= new.iVAt)) then new.tIn0  = new.tInc;
   if ((new.iVer>0) and (new.iVer<>new.iVAt)) then new.iVer  = new.iVAt;
END !!
SET TERM ; !!
